/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.EnableCommonReqParams;
import com.dtyunxi.cis.pms.biz.model.GetVirtualWarehouseGroupListPageParams;
import com.dtyunxi.cis.pms.biz.model.SaveVirtualWarehouseGroupParams;
import com.dtyunxi.cis.pms.biz.model.VirtualWarehouseGroupVO;
import com.dtyunxi.cis.pms.biz.model.VirtualWarehouseVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseVirtualWarehouseGroupService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseVirtualWarehouseService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.MainWarehouseEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualGroupApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.VirtualGroupDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualGroupReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualGroupDetailRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.dto.entity.VirtualGroupPageReqDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterBaseWarehouseVirtualWarehouseGroupServiceServiceImpl
implements InventoryCenterBaseWarehouseVirtualWarehouseGroupService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCenterBaseWarehouseVirtualWarehouseGroupServiceServiceImpl.class);
    @Resource
    private IVirtualGroupApi csVirtualGroupApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private InventoryCenterBaseWarehouseVirtualWarehouseService inventoryCenterBaseWarehouseVirtualWarehouseService;

    @Override
    public RestResponse<VirtualWarehouseGroupVO> getVirtualWarehouseGroupById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5e97\u94fa\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        VirtualGroupDetailDto virtualGroupDetailDto = (VirtualGroupDetailDto)RestResponseHelper.extractData((RestResponse)this.csVirtualGroupApi.queryById(Long.valueOf(id)));
        VirtualWarehouseGroupVO vo = new VirtualWarehouseGroupVO();
        if (virtualGroupDetailDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)virtualGroupDetailDto, (Object)vo);
        vo.setWarehouseGroupId(ParamConverter.convertToString((Object)virtualGroupDetailDto.getId()));
        if (virtualGroupDetailDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)virtualGroupDetailDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (virtualGroupDetailDto.getUpdateTime() != null) {
            vo.setUpdateTime(DateUtil.format((Date)virtualGroupDetailDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setWarehouseGroupName(virtualGroupDetailDto.getName());
        vo.setVirtualWarehouseQuantity(ParamConverter.convertToBigDecimal((Object)virtualGroupDetailDto.getWarehouseNum()));
        vo.setVirtualWarehouseQuantity(BigDecimalUtils.parse((String)String.format("%s", virtualGroupDetailDto.getWarehouseNum())));
        vo.setRemark(virtualGroupDetailDto.getExtension());
        VirtualWarehouseListReqDto virtualWarehouseListReqDto = new VirtualWarehouseListReqDto();
        virtualWarehouseListReqDto.setGroupId(virtualGroupDetailDto.getId());
        String mainWarehouseName = "";
        ArrayList subWarehouseNameList = Lists.newArrayList();
        ArrayList virtualWarehouseList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)virtualGroupDetailDto.getDetailRespDtoList())) {
            for (VirtualGroupDetailRespDto o : virtualGroupDetailDto.getDetailRespDtoList()) {
                VirtualWarehouseVO virtualWarehouseVO = new VirtualWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)virtualWarehouseVO);
                virtualWarehouseVO.setWarehouseGroupId(ParamConverter.convertToString((Object)virtualGroupDetailDto.getId()));
                virtualWarehouseVO.setWarehouseType(ParamConverter.convertToString((Object)o.getWarehouseType()));
                virtualWarehouseVO.setIsMainVirtualWarehouse(StringUtils.equals((CharSequence)o.getWarehouseType(), (CharSequence)"0") ? "1" : "0");
                virtualWarehouseVO.setRemark(o.getExtension());
                if (StringUtils.equals((CharSequence)o.getWarehouseType(), (CharSequence)"0")) {
                    mainWarehouseName = o.getWarehouseName();
                } else {
                    subWarehouseNameList.add(o.getWarehouseName());
                }
                virtualWarehouseList.add(virtualWarehouseVO);
            }
            vo.setVirtualWarehouseList(virtualWarehouseList);
        }
        vo.setMainVirtualWarehouseName(mainWarehouseName);
        vo.setVirtualWarehouseName(StringUtils.join((Iterable)subWarehouseNameList, (String)","));
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<VirtualWarehouseGroupVO>> getVirtualWarehouseGroupListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualWarehouseGroupListPageParams getVirtualWarehouseGroupListPageParams) {
        VirtualGroupPageReqDto reqDto = new VirtualGroupPageReqDto();
        BeanUtils.copyProperties((Object)getVirtualWarehouseGroupListPageParams, (Object)reqDto);
        reqDto.setName(getVirtualWarehouseGroupListPageParams.getWarehouseGroupName());
        reqDto.setOverallWarehouseName(getVirtualWarehouseGroupListPageParams.getMainVirtualWarehouseName());
        reqDto.setSubWarehouseName(getVirtualWarehouseGroupListPageParams.getVirtualWarehouseName());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csVirtualGroupApi.queryByPage(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            VirtualWarehouseGroupVO vo = new VirtualWarehouseGroupVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setWarehouseGroupId(ParamConverter.convertToString((Object)o.getId()));
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setWarehouseGroupName(o.getName());
            vo.setVirtualWarehouseQuantity(ParamConverter.convertToBigDecimal((Object)o.getWarehouseNum()));
            vo.setVirtualWarehouseName(o.getSubWarehouseName());
            vo.setMainVirtualWarehouseName(o.getOverallWarehouseName());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Void> saveVirtualWarehouseGroupParams(SaveVirtualWarehouseGroupParams saveVirtualWarehouseGroupParams) {
        VirtualGroupReqDto virtualGroupReqDto = new VirtualGroupReqDto();
        virtualGroupReqDto.setId(saveVirtualWarehouseGroupParams.getId());
        virtualGroupReqDto.setName(saveVirtualWarehouseGroupParams.getWarehouseGroupName());
        virtualGroupReqDto.setRemark(saveVirtualWarehouseGroupParams.getRemark());
        virtualGroupReqDto.setStatus(saveVirtualWarehouseGroupParams.getStatus());
        ArrayList virtualWarehouseVos = saveVirtualWarehouseGroupParams.getVirtualWarehouseVos();
        if (null == virtualWarehouseVos) {
            virtualWarehouseVos = Lists.newArrayList();
        }
        ArrayList virtualWarehouseList = Lists.newArrayList();
        for (com.dtyunxi.cis.pms.biz.model.VirtualWarehouseReqDto virtualWarehouseReqDto : virtualWarehouseVos) {
            VirtualWarehouseReqDto virtualWarehouse = new VirtualWarehouseReqDto();
            virtualWarehouse.setWarehouseCode(virtualWarehouseReqDto.getWarehouseCode());
            AssertUtil.assertNotNull(virtualWarehouseReqDto.getWarehouseType(), "\u660e\u7ec6\u5305\u542b\u4ed3\u5e93\u7c7b\u578b\u4e0d\u5b58\u5728");
            virtualWarehouse.setWarehouseType(Integer.valueOf(Integer.parseInt(virtualWarehouseReqDto.getWarehouseType())));
            virtualWarehouse.setLineType(virtualWarehouseReqDto.getLineType());
            virtualWarehouseList.add(virtualWarehouse);
        }
        virtualGroupReqDto.setVirtualWarehouseList((List)virtualWarehouseList);
        log.info("=====>\u8bf7\u6c42\u5171\u4eab\u4e2d\u5fc3: {}", (Object)JSON.toJSONString((Object)virtualGroupReqDto));
        RestResponseHelper.extractData((RestResponse)this.csVirtualGroupApi.saveVirtualGroup(virtualGroupReqDto));
        return RestResponse.VOID;
    }

    private void setMain(com.dtyunxi.cis.pms.biz.model.VirtualWarehouseReqDto vo) {
        EnableCommonReqParams enableCommonReqParams = new EnableCommonReqParams();
        enableCommonReqParams.setId(vo.getId());
        enableCommonReqParams.setStatus(MainWarehouseEnum.IS_MAIN_YES.getCode());
        this.inventoryCenterBaseWarehouseVirtualWarehouseService.setMainVirtualWarehouse(enableCommonReqParams);
    }

    @Override
    public RestResponse<PageInfo<VirtualWarehouseGroupVO>> enableVirtualWarehouseGroup(EnableCommonReqParams enableVirtualWarehouseGroupParams) {
        VirtualGroupDetailDto virtualGroupRespDto = this.getVirtualGroupRespDto(enableVirtualWarehouseGroupParams.getId());
        VirtualGroupReqDto virtualGroupReqDto = (VirtualGroupReqDto)BeanUtil.copyProperties((Object)virtualGroupRespDto, VirtualGroupReqDto.class, (String[])new String[0]);
        virtualGroupReqDto.setStatus(enableVirtualWarehouseGroupParams.getStatus());
        RestResponseHelper.checkOrThrow((RestResponse)this.csVirtualGroupApi.modifyVirtualGroup(virtualGroupReqDto));
        return new RestResponse();
    }

    private VirtualGroupDetailDto getVirtualGroupRespDto(Long id) {
        VirtualGroupDetailDto virtualGroupDetailDto = (VirtualGroupDetailDto)RestResponseHelper.extractData((RestResponse)this.csVirtualGroupApi.queryById(id));
        AssertUtil.isTrue(virtualGroupDetailDto != null, "\u5206\u7ec4\u4e0d\u5b58\u5728");
        return virtualGroupDetailDto;
    }
}

