/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherInGoodDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherInGoodMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutGoodDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutGoodMsgVo;
import com.dtyunxi.cis.pms.biz.model.InventoryCheckImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.InventoryCheckImportGoodsParams;
import com.dtyunxi.cis.pms.biz.model.OtherInGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherInImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.OtherInImportGoodsParams;
import com.dtyunxi.cis.pms.biz.model.OtherOutGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutImportGoodsParams;
import com.dtyunxi.cis.pms.biz.service.ImportCenterFinishedGoodsInventoryService;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ImportCenterFinishedGoodsInventoryServiceServiceImpl
implements ImportCenterFinishedGoodsInventoryService {
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;

    @Override
    public RestResponse<InventoryCheckImportFileResultVO> importGoodsOfInventoryCheck(@ApiParam(value="") @Valid @RequestBody(required=false) InventoryCheckImportGoodsParams inventoryCheckImportGoodsParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<OtherInImportFileResultVO> importGoodsOfOtherIn(@ApiParam(value="") @Valid @RequestBody(required=false) OtherInImportGoodsParams otherInImportGoodsParams) {
        EasyPoiExportUtil.checkFileInfo(otherInImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(otherInImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportOtherInGoodDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportOtherInGoodDto.class, otherInImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        OtherInImportFileResultVO resultVO = new OtherInImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherInGoodDto.class);
        List longCodes = list.stream().map(ImportOtherInGoodDto::getLongCode).collect(Collectors.toList());
        HashMap dataMap = Maps.newHashMap();
        HashSet longCodeSet = Sets.newHashSet();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            if (dataMap.containsKey(longCode)) {
                longCodeSet.add(longCode);
            } else {
                dataMap.put(longCode, o);
            }
        });
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
        Map itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        ArrayList msgList = Lists.newArrayList();
        ArrayList goodsList = Lists.newArrayList();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            ImportOtherInGoodMsgVo msgVo = new ImportOtherInGoodMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (longCodeSet.contains(longCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            }
            OtherInGoodsVO goodsVO = new OtherInGoodsVO();
            this.checkInGoods(itemRespDtoMap, (ImportOtherInGoodDto)((Object)o), longCode, msgVo, goodsVO);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                goodsList.add(goodsVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5176\u4ed6\u5165\u5e93\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportOtherInGoodMsgVo.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void checkInGoods(Map<String, PcpItemRespDto> itemRespDtoMap, ImportOtherInGoodDto o, String longCode, ImportOtherInGoodMsgVo msgVo, OtherInGoodsVO goodsVO) {
        if (CollectionUtil.isNotEmpty(itemRespDtoMap) && itemRespDtoMap.containsKey(o.getLongCode())) {
            PcpItemRespDto pcpItemRespDto = itemRespDtoMap.get(longCode);
            BeanUtils.copyProperties((Object)pcpItemRespDto, (Object)goodsVO);
            goodsVO.setGoodsId(ParamConverter.convertToString((Object)pcpItemRespDto.getId()));
            goodsVO.setGoodsCode(pcpItemRespDto.getCode());
            goodsVO.setGoodsLongCode(pcpItemRespDto.getLongCode());
            goodsVO.setGoodsName(pcpItemRespDto.getName());
            goodsVO.setGoodsSpec(pcpItemRespDto.getSpecification());
            goodsVO.setInQuantity(ParamConverter.convertToBigDecimal((Object)o.getNum()));
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
        }
    }

    private void checkOutGoods(Map<String, PcpItemRespDto> itemRespDtoMap, ImportOtherOutGoodDto o, String longCode, ImportOtherOutGoodMsgVo msgVo, OtherOutGoodsVO goodsVO) {
        if (CollectionUtil.isEmpty(itemRespDtoMap) || !itemRespDtoMap.containsKey(o.getLongCode())) {
            if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
            } else {
                msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
            }
        }
    }

    private void checkParam(ExcelImportResult<ImportBaseModeDto> result) {
        if (result.isVerfiyFail()) {
            int index = 1;
            result.getFailList().forEach(l -> {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg()));
            });
        }
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result.getList().size() > 2000) {
            throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u51652000\u884c\u6570\u636e");
        }
    }

    @Override
    public RestResponse<OtherOutImportFileResultVO> importGoodsOfOtherOut(@ApiParam(value="") @Valid @RequestBody(required=false) OtherOutImportGoodsParams otherOutImportGoodsParams) {
        EasyPoiExportUtil.checkFileInfo(otherOutImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(otherOutImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportOtherOutGoodDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportOtherOutGoodDto.class, otherOutImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        OtherOutImportFileResultVO resultVO = new OtherOutImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherOutGoodDto.class);
        List longCodes = list.stream().map(ImportOtherOutGoodDto::getLongCode).collect(Collectors.toList());
        HashMap dataMap = Maps.newHashMap();
        HashSet longCodeSet = Sets.newHashSet();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            if (dataMap.containsKey(longCode)) {
                longCodeSet.add(longCode);
            } else {
                dataMap.put(longCode, o);
            }
        });
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
        Map itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        CsInventoryTotalQueryReqDto reqDto = new CsInventoryTotalQueryReqDto();
        reqDto.setLongCodeList(longCodes);
        Integer pageSize = 100;
        if (longCodes.size() > pageSize) {
            pageSize = longCodes.size();
        }
        reqDto.setLogicWarehouseCode(otherOutImportGoodsParams.getWarehouseCode());
        PageInfo logicInventoryTotalRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryTotalQueryApi.queryByLogicWarehouseCodePage(reqDto, Integer.valueOf(1), pageSize));
        Map inventoryTotalRespDtoMap = logicInventoryTotalRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CsLogicInventoryTotalRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        ArrayList msgList = Lists.newArrayList();
        ArrayList goodsList = Lists.newArrayList();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            ImportOtherOutGoodMsgVo msgVo = new ImportOtherOutGoodMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (longCodeSet.contains(longCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            }
            OtherOutGoodsVO goodsVO = new OtherOutGoodsVO();
            this.checkOutGoods(itemRespDtoMap, (ImportOtherOutGoodDto)((Object)o), longCode, msgVo, goodsVO);
            this.checkLogicInventoryTotal(inventoryTotalRespDtoMap, (ImportOtherOutGoodDto)((Object)o), msgVo, goodsVO);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                goodsList.add(goodsVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5176\u4ed6\u51fa\u5e93\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportOtherOutGoodMsgVo.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void checkLogicInventoryTotal(Map<String, CsLogicInventoryTotalRespDto> inventoryTotalRespDtoMap, ImportOtherOutGoodDto o, ImportOtherOutGoodMsgVo msgVo, OtherOutGoodsVO outGoodsVO) {
        if (CollectionUtil.isNotEmpty(inventoryTotalRespDtoMap) && inventoryTotalRespDtoMap.containsKey(o.getLongCode())) {
            PcpItemRespDto pcpItemRespDto;
            CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = inventoryTotalRespDtoMap.get(o.getLongCode());
            BeanUtils.copyProperties((Object)((Object)o), (Object)outGoodsVO);
            outGoodsVO.setGoodsId(ParamConverter.convertToString((Object)logicInventoryTotalRespDto.getCargoId()));
            outGoodsVO.setGoodsLongCode(logicInventoryTotalRespDto.getLongCode());
            outGoodsVO.setGoodsCode(logicInventoryTotalRespDto.getCargoCode());
            if (logicInventoryTotalRespDto.getCargoId() != null && (pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryByPrimaryKey(logicInventoryTotalRespDto.getCargoId()))) != null) {
                outGoodsVO.setGoodsName(pcpItemRespDto.getName());
                outGoodsVO.setGoodsSpec(pcpItemRespDto.getSpecification());
                outGoodsVO.setVolume(pcpItemRespDto.getVolume());
            }
            outGoodsVO.setOutQuantity(ParamConverter.convertToBigDecimal((Object)o.getNum()));
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
        }
    }
}

