/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ChannelWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.CheckChannelWarehouseCodeParams;
import com.dtyunxi.cis.pms.biz.model.CommonValidVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetChannelWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutChannelWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.SubmitChannelWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.UpdateChannelWarehouseShareRatioParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseChannelWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseItemApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IRelVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IRelWarehouseChannelApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelVirtualWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelVirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_channel_warehouse")
public class InventoryCenterBaseWarehouseChannelWarehouseServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterBaseWarehouseChannelWarehouseService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterBaseWarehouseChannelWarehouseServiceServiceImpl.class);
    @Resource
    private IChannelWarehouseApi channelWarehouseApi;
    @Resource
    private IRelWarehouseChannelApi relWarehouseChannelQueryApi;
    @Resource
    private IRelVirtualWarehouseApi relVirtualWarehouseQueryApi;
    @Resource
    private IChannelWarehouseItemApi channelWarehouseItemQueryApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private IRelWarehouseChannelApi relWarehouseChannelApi;
    @Autowired
    IRelVirtualWarehouseApi relVirtualWarehouseApi;

    @Override
    public RestResponse<ChannelWarehouseVO> addChannelWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitChannelWarehouseParams submitChannelWarehouseParams) {
        ChannelWarehouseAddReqDto reqDto = DtoExchangeUtils.createDtoBySource(submitChannelWarehouseParams, ChannelWarehouseAddReqDto.class);
        reqDto.setWarehouseType(ParamConverter.convertToInteger((Object)submitChannelWarehouseParams.getSaleType()));
        reqDto.setLineType(submitChannelWarehouseParams.getChannelType());
        ArrayList<RelVirtualWarehouseAddReqDto> relVirtualWarehouseAddReqDtos = new ArrayList<RelVirtualWarehouseAddReqDto>(2);
        if (VirtualWarehouseTypeEnum.SUB.getCode().toString().equals(submitChannelWarehouseParams.getSaleType())) {
            VirtualWarehouseListReqDto pageReqDto = new VirtualWarehouseListReqDto();
            pageReqDto.setVirtualWarehouseType(VirtualWarehouseTypeEnum.OVERALL.getCode());
            List virtualWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryByList(pageReqDto));
            logger.info("\u865a\u62df\u603b\u4ed3\u8fd4\u56de\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)virtualWarehouseRespDtos));
            if (CollectionUtils.isNotEmpty((Collection)virtualWarehouseRespDtos)) {
                virtualWarehouseRespDtos.forEach(o -> {
                    RelVirtualWarehouseAddReqDto virtualWarehouseAddReqDto = new RelVirtualWarehouseAddReqDto();
                    if (VirtualWarehouseTypeEnum.OVERALL.getCode().equals(o.getWarehouseType())) {
                        virtualWarehouseAddReqDto.setRefVirtualWarehouseCode(o.getWarehouseCode());
                        virtualWarehouseAddReqDto.setRefVirtualWarehouseName(o.getWarehouseName());
                        virtualWarehouseAddReqDto.setRefVirtualWarehouseType(VirtualWarehouseTypeEnum.OVERALL.getCode());
                        virtualWarehouseAddReqDto.setShareRatio(new BigDecimal("100"));
                        virtualWarehouseAddReqDto.setRelItemType(Integer.valueOf(1));
                        virtualWarehouseAddReqDto.setPriority(Integer.valueOf(2));
                        relVirtualWarehouseAddReqDtos.add(virtualWarehouseAddReqDto);
                        return;
                    }
                });
            }
        }
        RelVirtualWarehouseAddReqDto virtualWarehouseAddReqDto = new RelVirtualWarehouseAddReqDto();
        virtualWarehouseAddReqDto.setRefVirtualWarehouseCode(submitChannelWarehouseParams.getWarehouseCode());
        virtualWarehouseAddReqDto.setRefVirtualWarehouseName(submitChannelWarehouseParams.getWarehouseName());
        virtualWarehouseAddReqDto.setRefVirtualWarehouseType(VirtualWarehouseTypeEnum.SUB.getCode());
        virtualWarehouseAddReqDto.setShareRatio(new BigDecimal("100"));
        virtualWarehouseAddReqDto.setRelItemType(Integer.valueOf(1));
        virtualWarehouseAddReqDto.setPriority(Integer.valueOf(1));
        relVirtualWarehouseAddReqDtos.add(virtualWarehouseAddReqDto);
        reqDto.setRelVirtualWarehouseAddReqDtos(relVirtualWarehouseAddReqDtos);
        logger.info("\u521b\u5efa\u6e20\u9053\u4ed3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.add(reqDto));
        ChannelWarehouseVO vo = new ChannelWarehouseVO();
        BeanUtils.copyProperties((Object)submitChannelWarehouseParams, (Object)vo);
        vo.setId(id);
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<CommonValidVO> checkChannelWarehouseCode(@Valid CheckChannelWarehouseCodeParams checkChannelWarehouseCodeParams) {
        CommonValidVO commonValidVO = new CommonValidVO();
        commonValidVO.setIsValid((Boolean)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.checkWarehouseCode(checkChannelWarehouseCodeParams.getWarehouseCode())));
        return new RestResponse((Object)commonValidVO);
    }

    @Override
    public RestResponse<ChannelWarehouseVO> getChannelWarehouseByCode(@ApiParam(value="", required=true) @PathVariable(value="code") String code) {
        ChannelWarehouseRespDto respDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.queryByWarehouseCode(code));
        if (respDto != null) {
            ChannelWarehouseVO channelWarehouseVO = DtoExchangeUtils.createDtoBySource(respDto, ChannelWarehouseVO.class);
            channelWarehouseVO.setChannelType(respDto.getLineType());
            channelWarehouseVO.setWarehouseId(ParamConverter.convertToString((Object)respDto.getId()));
            channelWarehouseVO.setSaleType(ParamConverter.convertToString((Object)respDto.getWarehouseType()));
            if (respDto.getCreateTime() != null) {
                channelWarehouseVO.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (respDto.getUpdateTime() != null) {
                channelWarehouseVO.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return new RestResponse((Object)channelWarehouseVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<ChannelWarehouseVO>> getChannelWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelWarehouseListPageParams getChannelWarehouseListPageParams) {
        ChannelWarehouseQueryDto queryDto = new ChannelWarehouseQueryDto();
        BeanUtils.copyProperties((Object)getChannelWarehouseListPageParams, (Object)queryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.queryByPage(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                ChannelWarehouseVO vo = new ChannelWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setWarehouseId(String.valueOf(o.getId()));
                vo.setSaleType(ParamConverter.convertToString((Object)o.getWarehouseType()));
                vo.setChannelType(o.getLineType());
                vo.setWarehouseStatus(ChannelWarehouseVO.WarehouseStatusEnum.fromValue(o.getWarehouseStatus()));
                if (o.getCreateTime() != null) {
                    vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getUpdateTime() != null) {
                    vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetChannelWarehouseListPageParams params = new GetChannelWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetChannelWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetChannelWarehouseListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getChannelWarehouseListPage((GetChannelWarehouseListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutChannelWarehouseVO vo = new OutChannelWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setWarehouseStatus(String.valueOf(Optional.ofNullable(o.getWarehouseStatus().getValue()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "disable": {
                            return "\u65e0\u6548";
                        }
                        case "enable": {
                            return "\u6709\u6548";
                        }
                    }
                    return o.getWarehouseStatus();
                }).orElse((Serializable)((Object)""))));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutChannelWarehouseVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetChannelWarehouseListPageParams params = new GetChannelWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetChannelWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetChannelWarehouseListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getChannelWarehouseListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateChannelWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitChannelWarehouseParams submitChannelWarehouseParams) {
        ChannelWarehouseUpdateReqDto reqDto = DtoExchangeUtils.createDtoBySource(submitChannelWarehouseParams, ChannelWarehouseUpdateReqDto.class);
        reqDto.setWarehouseType(ParamConverter.convertToInteger((Object)submitChannelWarehouseParams.getSaleType()));
        reqDto.setWarehouseName(submitChannelWarehouseParams.getWarehouseName());
        reqDto.setWarehouseStatus(submitChannelWarehouseParams.getWarehouseStatus());
        reqDto.setRemark(submitChannelWarehouseParams.getRemark());
        reqDto.setContact(submitChannelWarehouseParams.getContact());
        reqDto.setPhone(submitChannelWarehouseParams.getPhone());
        reqDto.setLineType(submitChannelWarehouseParams.getChannelType());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.updateByWarehouseCode(submitChannelWarehouseParams.getWarehouseCode(), reqDto)));
    }

    @Override
    public RestResponse<Void> updateChannelWarehouseShareRatio(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateChannelWarehouseShareRatioParams updateChannelWarehouseShareRatioParams) {
        String virtualWarehouseCode = updateChannelWarehouseShareRatioParams.getLogicalWarehouseCode();
        AssertUtil.assertNotBlank(virtualWarehouseCode, "\u865a\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String channelWarehouseCode = updateChannelWarehouseShareRatioParams.getChannelWarehouseCode();
        AssertUtil.assertNotBlank(channelWarehouseCode, "\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal shareRatio = updateChannelWarehouseShareRatioParams.getShareRatio();
        if (BigDecimalUtils.leZero((BigDecimal)shareRatio).booleanValue()) {
            throw new CsInventoryException("\u5171\u4eab\u6bd4\u4f8b\u5c0f\u4e8e\u7b49\u4e8e0", new Object[0]);
        }
        Integer priority = updateChannelWarehouseShareRatioParams.getPriority();
        AssertUtil.assertNotNull(priority, "\u4f18\u5148\u7ea7\u4e3a\u7a7a");
        RelVirtualWarehouseReqDto relVirtualWarehouseReqDto = new RelVirtualWarehouseReqDto();
        relVirtualWarehouseReqDto.setVirtualWarehouseCode(virtualWarehouseCode);
        relVirtualWarehouseReqDto.setChannelWarehouseCode(channelWarehouseCode);
        relVirtualWarehouseReqDto.setShareRatio(shareRatio);
        relVirtualWarehouseReqDto.setPriority(priority);
        RestResponseHelper.extractData((RestResponse)this.relVirtualWarehouseApi.updateChannelWarehouseShareRatio(relVirtualWarehouseReqDto));
        return RestResponse.VOID;
    }
}

