/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInsurancePremiumVO;
import com.dtyunxi.cis.pms.biz.model.insurance.InsuranceBillReportRespVo;
import com.dtyunxi.cis.pms.biz.model.insurance.InsurancePageParams;
import com.dtyunxi.cis.pms.biz.model.insurance.InsurancePremiumReportRespVo;
import com.dtyunxi.cis.pms.biz.model.insurance.ReInsuranceBillReportReqDto;
import com.dtyunxi.cis.pms.biz.model.insurance.ReInsurancePremiumReportReqDto;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInsurancePremiumBillService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IReInsuranceBillApi;
import com.dtyunxi.tcbj.api.IReInsurancePremiumApi;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.query.IReInsuranceBillQueryApi;
import com.dtyunxi.tcbj.api.query.IReInsurancePremiumQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insurance_premium")
public class ReportCenterInsurancePremiumBillServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterInsurancePremiumBillService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterInsurancePremiumBillServiceImpl.class);
    @Resource
    private IReInsuranceBillQueryApi billQueryApi;
    @Resource
    private IReInsurancePremiumQueryApi premiumQueryApi;
    @Resource
    private IReInsurancePremiumApi premiumApi;
    @Resource
    private IReInsuranceBillApi billApi;

    @Override
    public RestResponse<PageInfo<InsurancePremiumReportRespVo>> getReInsurancePreminumListPage(InsurancePageParams insurancePageParams) {
        logger.info("\u4fdd\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)insurancePageParams));
        ReInsurancePremiumReqDto premiumReqDto = new ReInsurancePremiumReqDto();
        CubeBeanUtils.copyProperties((Object)premiumReqDto, (Object)insurancePageParams, (boolean)false, (String[])new String[0]);
        premiumReqDto.setExternalOrderNo(insurancePageParams.getEasNo());
        premiumReqDto.setOrderNo(insurancePageParams.getDocumentNo());
        premiumReqDto.setDocumentNo(null);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.premiumQueryApi.queryByPage(JSONObject.toJSONString((Object)premiumReqDto), insurancePageParams.getPageNum(), insurancePageParams.getPageSize()));
        logger.info("\u4fdd\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        PageInfo respVoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respVoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List premList = pageInfo.getList().stream().map(it -> {
            InsurancePremiumReportRespVo insurancePremiumReportRespVo = new InsurancePremiumReportRespVo();
            CubeBeanUtils.copyProperties((Object)insurancePremiumReportRespVo, (Object)it, (String[])new String[0]);
            if (it.getClaimPrice() != null) {
                insurancePremiumReportRespVo.setClaimPrice("**");
            } else {
                insurancePremiumReportRespVo.setClaimPrice(null);
            }
            if (it.getInsureUnitPrice() != null) {
                insurancePremiumReportRespVo.setInsureUnitPrice("**");
            } else {
                insurancePremiumReportRespVo.setInsureUnitPrice(null);
            }
            if (it.getInsureTotalPrice() != null) {
                insurancePremiumReportRespVo.setInsureTotalPrice("**");
            } else {
                insurancePremiumReportRespVo.setInsureTotalPrice(null);
            }
            if (null != it.getPlacedFlag()) {
                insurancePremiumReportRespVo.setPlacedFlag(it.getPlacedFlag());
            }
            return insurancePremiumReportRespVo;
        }).collect(Collectors.toList());
        respVoPageInfo.setList(premList);
        return new RestResponse((Object)respVoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<InsuranceBillReportRespVo>> getReInsuranceBillListPage(InsurancePageParams insurancePageParams) {
        ReInsuranceBillReqDto billReqDto = new ReInsuranceBillReqDto();
        CubeBeanUtils.copyProperties((Object)billReqDto, (Object)insurancePageParams, (boolean)false, (String[])new String[0]);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billQueryApi.queryByPage(JSONObject.toJSONString((Object)billReqDto), insurancePageParams.getPageNum(), insurancePageParams.getPageSize()));
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList resultList = new ArrayList();
        CubeBeanUtils.copyCollection(resultList, (Collection)pageInfo.getList(), InsuranceBillReportRespVo.class);
        resultList.forEach(e -> e.setEasNo(e.getExternalOrderNo()));
        resultPageInfo.setList(resultList);
        return new RestResponse((Object)resultPageInfo);
    }

    @Override
    public RestResponse<String> updateInsuranceExceptionReport(ReInsurancePremiumExceptionDto exceptionDto) {
        String str = (String)RestResponseHelper.extractData((RestResponse)this.premiumApi.updateInsuranceExceptionReport(exceptionDto));
        return new RestResponse((Object)str);
    }

    @Override
    public RestResponse<String> updateInsuranceByLogistics(ReInsurancePremiumReportUpdateReqDto upDto) {
        String str = (String)RestResponseHelper.extractData((RestResponse)this.premiumApi.updateInsuranceByLogistics(upDto));
        return new RestResponse((Object)str);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        InsurancePageParams params = new InsurancePageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
        }
        logger.info("\u4fdd\u8d39\u660e\u7ec6\u5bfc\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)params));
        LinkedHashMap<String, ExportInsurancePremiumVO> resultMap = new LinkedHashMap<String, ExportInsurancePremiumVO>();
        params.setPageNum(1);
        params.setPageSize(5000);
        try {
            PageInfo firstPage = (PageInfo)RestResponseHelper.extractData(this.getReInsurancePreminumListPage(params));
            if (firstPage == null || firstPage.getTotal() == 0L) {
                logger.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4fdd\u8d39\u660e\u7ec6\u6570\u636e");
                return "";
            }
            long total = firstPage.getTotal();
            long totalPages = (total + (long)params.getPageSize().intValue() - 1L) / (long)params.getPageSize().intValue();
            logger.info("\u4fdd\u8d39\u660e\u7ec6\u603b\u6570\u636e\u91cf\uff1a{}\uff0c\u603b\u9875\u6570\uff1a{}", (Object)total, (Object)totalPages);
            this.processPageData(firstPage.getList(), resultMap);
            logger.info("\u5904\u7406\u7b2c1\u9875\u6570\u636e\u5b8c\u6210\uff0c\u5f53\u524d\u7ed3\u679c\u96c6\u5927\u5c0f\uff1a{}", (Object)resultMap.size());
            int pageNum = 2;
            while ((long)pageNum <= totalPages) {
                params.setPageNum(pageNum);
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getReInsurancePreminumListPage(params));
                if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    logger.warn("\u7b2c{}\u9875\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406", (Object)pageNum);
                } else {
                    int beforeSize = resultMap.size();
                    this.processPageData(pageInfo.getList(), resultMap);
                    int afterSize = resultMap.size();
                    logger.info("\u5904\u7406\u7b2c{}\u9875\u6570\u636e\u5b8c\u6210\uff0c\u5f53\u524d\u9875\u65b0\u589e\u6570\u636e\u91cf\uff1a{}\uff0c\u7d2f\u8ba1\u7ed3\u679c\u96c6\u5927\u5c0f\uff1a{}", new Object[]{pageNum, afterSize - beforeSize, afterSize});
                }
                ++pageNum;
            }
            logger.info("\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\u5bfc\u51fa\u5b8c\u6210\uff0c\u603b\u6570\u636e\u91cf\uff1a{}", (Object)resultMap.size());
            ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
            return EasyPoiExportUtil.uploadFile(new ArrayList(resultMap.values()), anEnum.getExportTemplate(), commonReqDto.getFileName());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5bfc\u51fa\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\u5931\u8d25", e);
        }
    }

    private void processPageData(List<InsurancePremiumReportRespVo> pageData, Map<String, ExportInsurancePremiumVO> resultMap) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        for (InsurancePremiumReportRespVo item : pageData) {
            String uniqueKey = this.buildUniqueKey(item);
            if (resultMap.containsKey(uniqueKey)) {
                logger.info("\u8df3\u8fc7\u91cd\u590d\u6570\u636e\uff1a{}", (Object)uniqueKey);
                continue;
            }
            ExportInsurancePremiumVO vo = this.convertToExportVO(item);
            resultMap.put(uniqueKey, vo);
        }
    }

    private String buildUniqueKey(InsurancePremiumReportRespVo item) {
        return item.getId() + "_" + item.getLongCode() + "_" + item.getBatch();
    }

    private ExportInsurancePremiumVO convertToExportVO(InsurancePremiumReportRespVo o) {
        ExportInsurancePremiumVO vo = new ExportInsurancePremiumVO();
        try {
            BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
            if (StringUtils.isNotBlank((CharSequence)o.getExternalOrderNo())) {
                vo.setEasNo(o.getExternalOrderNo());
            }
            if (StringUtils.isBlank((CharSequence)o.getInsureUnitPrice())) {
                vo.setInsureUnitPrice("\u5f02\u5e38");
            }
            if (null == o.getUseDiscount()) {
                vo.setUseDiscount("\u5f02\u5e38");
            } else {
                vo.setUseDiscount(o.getUseDiscount().stripTrailingZeros().toPlainString());
            }
            if (null == o.getInsureTotalPrice()) {
                vo.setInsureTotalPrice("\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)o), (Object)e);
        }
        return vo;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse pageInfoRestResponse;
        PageInfo respDtoPageInfo;
        InsurancePageParams params = new InsurancePageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
        }
        if (CollectionUtils.isEmpty((Collection)(respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)(pageInfoRestResponse = this.premiumQueryApi.queryByPage(JSONObject.toJSONString((Object)params), Integer.valueOf(1), Integer.valueOf(1))))).getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public RestResponse<Void> modifyReInsurancePremium(ReInsurancePremiumReportReqDto modifyReqDto) {
        if (null == modifyReqDto.getPlacedFlag()) {
            throw new BizException("\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u5df2\u5f52\u6863");
        }
        if (modifyReqDto.getPlacedFlag() == 1) {
            throw new BizException("\u5df2\u5f52\u6863\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        ReInsurancePremiumReqDto centerReqDto = new ReInsurancePremiumReqDto();
        CubeBeanUtils.copyProperties((Object)centerReqDto, (Object)((Object)modifyReqDto), (boolean)false, (String[])new String[0]);
        return this.premiumApi.modifyReInsurancePremium(centerReqDto);
    }

    @Override
    public RestResponse<Void> modifyReInsuranceBill(ReInsuranceBillReportReqDto modifyReqDto) {
        if (null == modifyReqDto.getPlacedFlag()) {
            throw new BizException("\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u5df2\u5f52\u6863");
        }
        if (modifyReqDto.getPlacedFlag() == 1) {
            throw new BizException("\u5df2\u5f52\u6863\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        ReInsuranceBillReqDto centerReqDto = new ReInsuranceBillReqDto();
        CubeBeanUtils.copyProperties((Object)centerReqDto, (Object)((Object)modifyReqDto), (boolean)false, (String[])new String[0]);
        return this.billApi.modifyReInsuranceBill(centerReqDto);
    }

    @Override
    public RestResponse<List<String>> generateInsuranceReport(Date generateDateBegin, Date generateDateEnd) {
        ReInsurancePremiumReqDto reqDto = new ReInsurancePremiumReqDto();
        reqDto.setInOutTimeBegin(generateDateBegin);
        reqDto.setInOutTimeEnd(generateDateEnd);
        RestResponseHelper.extractData((RestResponse)this.premiumApi.generateInsuranceReport(reqDto));
        return new RestResponse(null);
    }

    @Override
    public RestResponse<ReInsuranceBillCountDto> queryFlagCount(InsurancePageParams insurancePageParams) {
        logger.info("\u4fdd\u8d39\u660e\u7ec6\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)insurancePageParams));
        ReInsurancePremiumReqDto premiumReqDto = new ReInsurancePremiumReqDto();
        CubeBeanUtils.copyProperties((Object)premiumReqDto, (Object)insurancePageParams, (boolean)false, (String[])new String[0]);
        premiumReqDto.setExternalOrderNo(insurancePageParams.getEasNo());
        premiumReqDto.setOrderNo(insurancePageParams.getDocumentNo());
        premiumReqDto.setDocumentNo(null);
        return this.premiumQueryApi.queryFlagCount(premiumReqDto);
    }
}

