/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.LineTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.BusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.service.DistributionItemService;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.DeliveryResultOrderTypeEnum;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.ShareGoodBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderDetailReqDto;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistributionItemServiceImpl
implements DistributionItemService {
    private static final Logger logger = LoggerFactory.getLogger(DistributionItemServiceImpl.class);
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailQueryApi;

    @Override
    public void distributionItemForDeliveryReceiveResult(CsDeliveryReceiveResultRespDto dto) {
        CsTransferOrderRespDto transferOrder;
        logger.info("\u6536\u53d1\u7ed3\u679c\u5206\u8d27\u8d27\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (dto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()) && ObjectUtil.isNotEmpty((Object)(transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(dto.getRelevanceNo())))) && transferOrder.getType().equals(BusinessTypeEnum.INTERNAL_DEAL.getCode()) && dto.getOrderType().equals(DeliveryResultOrderTypeEnum.RECEIVE.getKey())) {
            this.distributionItemForInternalDeal(dto);
        }
    }

    private void distributionItemForInternalDeal(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u5206\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List transferOrderDetail = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(dto.getRelevanceNo()));
        if (CollectionUtil.isEmpty((Collection)transferOrderDetail)) {
            logger.error("\u5206\u8d27\u5f02\u5e38\uff0c\u67e5\u8be2\u8c03\u62e8\u660e\u7ec6\u5f02\u5e38");
            return;
        }
        Object onlineType = this.gainForExtension(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, ((CsTransferOrderDetailRespDto)transferOrderDetail.get(0)).getExtension());
        if (ObjectUtil.isEmpty((Object)onlineType)) {
            logger.error("\u6269\u5f20\u5b57\u6bb5\u7f3a\u5c11\u4fe1\u606f");
            return;
        }
        int onlineTypeInt = Integer.parseInt(onlineType.toString());
        ShareGoodsAutoAuditReqDto reqDto = new ShareGoodsAutoAuditReqDto();
        reqDto.setOrderNo(dto.getDocumentNo());
        reqDto.setPlatformNo(dto.getRelevanceNo());
        reqDto.setSupplyWarehouseCode(dto.getReceiveLogicWarehouseCode());
        reqDto.setLineType(onlineTypeInt == 1 ? LineTypeEnum.ONLINE.getCode() : LineTypeEnum.OFFLINE.getCode());
        reqDto.setBusinessType(ShareGoodBusinessTypeEnum.PROCUREMENT.getCode());
        reqDto.setDetailList(dto.getDeliveryReceiveResultDetailRespDtoList().stream().map(detail -> {
            ShareGoodsOrderDetailReqDto detailReqDto = new ShareGoodsOrderDetailReqDto();
            detailReqDto.setQuantity(detail.getQuantity());
            detailReqDto.setSkuCode(detail.getLongCode());
            detailReqDto.setSkuName(detail.getCargoName());
            return detailReqDto;
        }).collect(Collectors.toList()));
        this.sendInventoryShareDistribution(reqDto);
    }

    private void sendInventoryShareDistribution(ShareGoodsAutoAuditReqDto reqDto) {
        logger.info("\u53d1\u9001\u5206\u8d27\u8bf7\u6c42MQ\u81f3\u5e93\u5b58\u5171\u4eab\u4e2d\u5fc3\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "SHARE_GOODS_AUTO_AUDIT", (Object)reqDto);
    }

    private Object gainForExtension(String key, String extension) {
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            Map map = (Map)JSON.parseObject((String)extension, Map.class);
            return map.get(key);
        }
        return null;
    }
}

