/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.GetOutNoticeOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutNoticeOrderVO;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillOutNoticeOrderService;
import com.dtyunxi.cis.search.api.query.delivery.EsOutNoticeOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.EsOutNoticeOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.api.query.IOutNoticeOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IConsignmentOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillOutNoticeOrderServiceServiceImpl
implements InventoryCenterBillOutNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterBillOutNoticeOrderServiceServiceImpl.class);
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    IOutNoticeOrderQueryApi outNoticeOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private EsOutNoticeOrderQueryApi esOutNoticeOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Resource
    private IConsignmentOrderQueryApi iConsignmentOrderQueryApi;
    @Resource
    private ICsWmsApi iCsWmsApi;
    @Resource
    private ICsOutNoticeOrderDetailQueryApi iCsOutNoticeOrderDetailQueryApi;

    @Override
    public RestResponse<String> outSendBack(GetOutNoticeOrderListPageParams getOutNoticeOrderListPageParams) {
        if (StringUtils.isBlank((CharSequence)getOutNoticeOrderListPageParams.getDocumentNo())) {
            throw new BizException("\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String documentNo = getOutNoticeOrderListPageParams.getDocumentNo();
        CsOutNoticeOrderRespDto respDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDocumentNo(documentNo));
        if (ObjectUtil.isEmpty((Object)respDto)) {
            throw new BizException("\u6ca1\u6709\u627e\u5230\u8be5\u5355\u53f7");
        }
        ArrayList list = Lists.newArrayList((Object[])new String[]{documentNo});
        List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.iCsOutNoticeOrderDetailQueryApi.queryByNos((List)list));
        if (StringUtils.isNotBlank((CharSequence)respDto.getOrderType()) && respDto.getOrderType().equals(ExpressBusinessTypeEnum.OUT.getBusinessType())) {
            ArrayList<CsWmsOutSendBackDetailReqDto> detailReqDtoList = new ArrayList<CsWmsOutSendBackDetailReqDto>();
            if (CollectionUtils.isNotEmpty((Collection)dtoList)) {
                for (CsOutNoticeOrderDetailRespDto detailRespDto : dtoList) {
                    CsWmsOutSendBackDetailReqDto dto = new CsWmsOutSendBackDetailReqDto();
                    dto.setBatch(detailRespDto.getBatch());
                    dto.setSkuCode(detailRespDto.getSkuCode());
                    dto.setQuantity(detailRespDto.getPlanQuantity());
                    dto.setWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                    dto.setProduceTime(detailRespDto.getProduceTime());
                    dto.setExpireTime(detailRespDto.getExpireTime());
                    detailReqDtoList.add(dto);
                }
            }
            CsWmsOutSendBackReqDto reqDto = new CsWmsOutSendBackReqDto();
            reqDto.setOutNoticeOrderNo(documentNo);
            reqDto.setDetailReqDtoList(detailReqDtoList);
            logger.info("\u6a21\u62df\u51fa\u5e93\u5e93\u56de\u4f20\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqDto));
            String data = (String)RestResponseHelper.extractData((RestResponse)this.iCsWmsApi.outSendBack(reqDto));
            return new RestResponse((Object)data);
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getOrderType()) && respDto.getOrderType().equals(ExpressBusinessTypeEnum.IN.getBusinessType())) {
            ArrayList<CsWmsInSendBackDetailReqDto> detailReqDtoList = new ArrayList<CsWmsInSendBackDetailReqDto>();
            if (CollectionUtils.isNotEmpty((Collection)dtoList)) {
                for (CsOutNoticeOrderDetailRespDto detailRespDto : dtoList) {
                    CsWmsInSendBackDetailReqDto dto = new CsWmsInSendBackDetailReqDto();
                    dto.setBatch(detailRespDto.getBatch());
                    dto.setSkuCode(detailRespDto.getSkuCode());
                    dto.setWarehouseCode(respDto.getInPhysicsWarehouseCode());
                    dto.setQuantity(detailRespDto.getPlanQuantity());
                    dto.setProduceTime(detailRespDto.getProduceTime());
                    dto.setExpireTime(detailRespDto.getExpireTime());
                    detailReqDtoList.add(dto);
                }
            }
            CsWmsInSendBackReqDto reqDto = new CsWmsInSendBackReqDto();
            reqDto.setInNoticeOrderNo(documentNo);
            reqDto.setDetailReqDtoList(detailReqDtoList);
            logger.info("\u6a21\u62df\u5165\u5e93\u56de\u4f20\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqDto));
            String data = (String)RestResponseHelper.extractData((RestResponse)this.iCsWmsApi.inSendBack(reqDto));
            return new RestResponse((Object)data);
        }
        return null;
    }

    @Override
    public RestResponse<OutNoticeOrderVO> getOutNoticeOrderDetail(@ApiParam(value="\u53d1\u8d27\u901a\u77e5\u5355\u53f7") @Valid @RequestParam(value="outNoticeNo", required=false) String outNoticeNo) {
        List respDtos;
        CsOutNoticeOrderRespDto respDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(outNoticeNo));
        OutNoticeOrderVO vo = new OutNoticeOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(outNoticeNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        this.getRelateBillInfo(respDto, vo);
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryLogicalWarehouseCode(respDto.getOutLogicWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getOutLogicWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getWarehouseCode());
        vo.setDeliveryPhysicalWarehouseName(respDto.getWarehouseName());
        vo.setReceiveLogicalWarehouseCode(respDto.getInLogicWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getInLogicWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getInWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getInWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalBoxesNum(respDto.getTotalCartons() == null ? BigDecimal.ZERO : respDto.getTotalCartons());
        vo.setMixBoxesNum(respDto.getMergeQuantity() == null ? BigDecimal.ZERO : respDto.getMergeQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        return new RestResponse((Object)vo);
    }

    private void getRelateBillInfo(CsOutNoticeOrderRespDto respDto, OutNoticeOrderVO vo) {
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(saleRefundAddrRespDto.getProvince() + saleRefundAddrRespDto.getCity() + saleRefundAddrRespDto.getCounty() + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(orderAddrRespDto.getProvince() + orderAddrRespDto.getCity() + orderAddrRespDto.getCounty() + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
    }

    @Override
    public RestResponse<PageInfo<OutNoticeOrderVO>> getOutNoticeOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOutNoticeOrderListPageParams getOutNoticeOrderListPageParams) {
        com.dtyunxi.cis.search.api.dto.request.EsOutNoticeOrderListPageParams pageQueryDto;
        PageInfo outNoticeOrderRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            pageQueryDto = new com.dtyunxi.cis.search.api.dto.request.EsOutNoticeOrderListPageParams();
            BeanUtils.copyProperties((Object)getOutNoticeOrderListPageParams, (Object)pageQueryDto);
            pageQueryDto.setInLogicWarehouseName(getOutNoticeOrderListPageParams.getReceiveLogicalWarehouseName());
            pageQueryDto.setOutLogicWarehouseName(getOutNoticeOrderListPageParams.getDeliveryLogicalWarehouseName());
            outNoticeOrderRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esOutNoticeOrderQueryApi.queryOutNoticeOrderPage(pageQueryDto));
        } else {
            logger.info("\u62a5\u8868\u4e2d\u5fc3\u67e5\u8be2");
            pageQueryDto = new EsOutNoticeOrderListPageParams();
            BeanUtils.copyProperties((Object)getOutNoticeOrderListPageParams, (Object)pageQueryDto);
            pageQueryDto.setInLogicWarehouseName(getOutNoticeOrderListPageParams.getReceiveLogicalWarehouseName());
            pageQueryDto.setOutLogicWarehouseName(getOutNoticeOrderListPageParams.getDeliveryLogicalWarehouseName());
            PageInfo outNoticeOrderRespDtoPageInfo_info = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryOutNoticeOrderPage((EsOutNoticeOrderListPageParams)pageQueryDto));
            outNoticeOrderRespDtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)outNoticeOrderRespDtoPageInfo, (Object)outNoticeOrderRespDtoPageInfo_info, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList lists = new ArrayList();
            CubeBeanUtils.copyCollection(lists, (Collection)outNoticeOrderRespDtoPageInfo_info.getList(), com.dtyunxi.cis.search.api.dto.response.OutNoticeOrderVO.class);
            outNoticeOrderRespDtoPageInfo.setList(lists);
        }
        if (CollectionUtils.isEmpty((Collection)outNoticeOrderRespDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)outNoticeOrderRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = outNoticeOrderRespDtoPageInfo.getList();
        ArrayList outNoticeOrderVOS = new ArrayList(list.size());
        list.forEach(p -> {
            OutNoticeOrderVO outNoticeOrderVO = new OutNoticeOrderVO();
            BeanUtils.copyProperties((Object)p, (Object)outNoticeOrderVO);
            outNoticeOrderVO.setDeliveryLogicalWarehouseName(p.getOutLogicWarehouseName());
            outNoticeOrderVO.setDeliveryLogicalWarehouseCode(p.getOutLogicWarehouseCode());
            outNoticeOrderVO.setReceiveLogicalWarehouseName(p.getInLogicWarehouseName());
            outNoticeOrderVO.setReceiveLogicalWarehouseCode(p.getInLogicWarehouseCode());
            outNoticeOrderVO.setDocumentStatus(p.getOrderStatus());
            outNoticeOrderVO.setBusinessOrderNo(p.getRelevanceNo());
            outNoticeOrderVO.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            outNoticeOrderVO.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            outNoticeOrderVOS.add(outNoticeOrderVO);
        });
        pageInfo.setList(outNoticeOrderVOS);
        return new RestResponse((Object)pageInfo);
    }
}

