/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditTransferOrderParams;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.CommonValidVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderAssociatedGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutTransferOrderVO;
import com.dtyunxi.cis.pms.biz.model.SubmitTransferOrderParams;
import com.dtyunxi.cis.pms.biz.model.TransferOrderGoodsVO;
import com.dtyunxi.cis.pms.biz.model.TransferOrderRelatedGoodsVO;
import com.dtyunxi.cis.pms.biz.model.TransferOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.helper.WmsAble;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalE3Api;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BsOtherCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsPcpInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsStorageAuditRecordApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IItemBlackDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WarehouseCorrespondingSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.entity.IInOutResultOrderDetailApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDetailPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistPageReqDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgTransferOrderApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderCountDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgTransferOrderPageReqDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_transfer_order")
public class FinishedGoodsInventoryTransferOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryTransferOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryTransferOrderServiceServiceImpl.class);
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailQueryApi;
    @Resource
    private ICsStorageAuditRecordApi csStorageAuditRecordQueryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IExternalE3Api externalE3Api;
    @Resource
    private ICsWmsApi csWmsApi;
    @Resource
    private WmsAble wmsAble;
    @Resource
    private ICsPcpInventoryExposedApi csPcpInventoryExposedApi;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Resource
    ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi iCsPhysicsWarehouseExposedApi;
    @Resource
    private IItemBlackDetailApi itemBlackDetailApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedApi;
    @Resource
    private IInOutResultOrderDetailApi iInOutResultOrderDetailApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Autowired
    IDgTransferOrderApi rpTransferOrderApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi shipmenetEnterpriseQueryApi;

    @Override
    public RestResponse<Object> addTransferOrder(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitTransferOrderParams submitTransferOrderParams) {
        this.checkCTransferOrderType(submitTransferOrderParams);
        this.checkBlackDtoList(submitTransferOrderParams);
        this.checkClaimTransferOrderQuantity(submitTransferOrderParams);
        CsTransferOrderComboReqDto reqDto = new CsTransferOrderComboReqDto();
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        BeanUtils.copyProperties((Object)submitTransferOrderParams, (Object)transferOrderReqDto);
        this.getTransferOrder(submitTransferOrderParams, reqDto, transferOrderReqDto);
        String shipmentEnterpriseName = submitTransferOrderParams.getShipmentEnterpriseName();
        String shipmentEnterpriseCode = submitTransferOrderParams.getShipmentEnterpriseCode();
        if (StringUtils.isBlank((CharSequence)shipmentEnterpriseName) && StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode)) {
            try {
                CsShipmenetEnterpriseRespDto shipmenetEnterprise = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.shipmenetEnterpriseQueryApi.queryByCode(shipmentEnterpriseCode));
                if (shipmenetEnterprise != null && StringUtils.isNotBlank((CharSequence)shipmenetEnterprise.getShipmentEnterpriseName())) {
                    shipmentEnterpriseName = shipmenetEnterprise.getShipmentEnterpriseName();
                    logger.info("\u901a\u8fc7\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u83b7\u53d6\u5230\u7269\u6d41\u5546\u540d\u79f0\u3010{}\u3011", (Object)shipmentEnterpriseCode, (Object)shipmentEnterpriseName);
                } else {
                    logger.warn("\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6d41\u5546\u540d\u79f0", (Object)shipmentEnterpriseCode);
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\u5931\u8d25, shipmentEnterpriseCode: {}", (Object)shipmentEnterpriseCode, (Object)e);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("shipmentEnterpriseName", (Object)shipmentEnterpriseName);
        jsonObject.put("applyclaimFile", (Object)submitTransferOrderParams.getApplyclaimFile());
        jsonObject.put("expressNo", (Object)submitTransferOrderParams.getExpressNo());
        jsonObject.put("shipmentEnterpriseCode", (Object)shipmentEnterpriseCode);
        transferOrderReqDto.setExtension(jsonObject.toJSONString());
        logger.info("\u65b0\u589e\u8c03\u62e8\u5355,\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.addTransferOrder(reqDto)));
    }

    private void checkBlackDtoList(SubmitTransferOrderParams submitTransferOrderParams) {
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.CB_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()});
        if (typeList.contains(submitTransferOrderParams.getBussinessOrderType())) {
            List<TransferOrderGoodsVO> itemDetailList = submitTransferOrderParams.getGoodsList();
            CsPhysicsWarehouseDetailRespDto warehouseDetailRespDto = (CsPhysicsWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryDetailById(Long.valueOf(submitTransferOrderParams.getInPhysicalWarehouseId())));
            ItemBlacklistPageReqDto itemBlacklistPageReqDto = new ItemBlacklistPageReqDto();
            itemBlacklistPageReqDto.setPhysicsWarehouseCode(warehouseDetailRespDto.getWarehouseCode());
            List itemBlackDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemBlackDetailApi.queryPhysicsItemBlack(itemBlacklistPageReqDto));
            if (CollectionUtils.isEmpty((Collection)itemBlackDtoList)) {
                return;
            }
            String ruleNo = ((ItemBlacklistDto)itemBlackDtoList.get(0)).getRuleNo();
            List skuCodeList = itemBlackDtoList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getBatch())).collect(Collectors.toList());
            List skuCodes = skuCodeList.stream().map(ItemBlacklistDto::getSkuCode).collect(Collectors.toList());
            List batchDtos = Optional.ofNullable(itemBlackDtoList.stream().filter(o -> Objects.equals(0, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
            List appointBatchDtos = Optional.ofNullable(itemBlackDtoList.stream().filter(o -> Objects.equals(1, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
            Map skuCodeBatchMap = batchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
            Map appointBatchDtoMap = appointBatchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
            ArrayList msgSkuCodeList = Lists.newArrayList();
            for (TransferOrderGoodsVO logicInventoryRespDto : itemDetailList) {
                String batchEnd = null;
                if (StringUtils.isNotBlank((CharSequence)logicInventoryRespDto.getBatchNo())) {
                    batchEnd = logicInventoryRespDto.getBatchNo().substring(logicInventoryRespDto.getBatchNo().length() - 1);
                }
                String skuCodeKey = logicInventoryRespDto.getGoodsLongCode() + "_" + batchEnd;
                String key = String.format("%s_%s", logicInventoryRespDto.getGoodsLongCode(), logicInventoryRespDto.getBatchNo());
                if (skuCodes.contains(logicInventoryRespDto.getGoodsLongCode())) {
                    msgSkuCodeList.add(logicInventoryRespDto.getGoodsLongCode());
                    continue;
                }
                if (appointBatchDtoMap.containsKey(key)) {
                    msgSkuCodeList.add(logicInventoryRespDto.getGoodsLongCode());
                    continue;
                }
                if (!skuCodeBatchMap.containsKey(skuCodeKey)) continue;
                msgSkuCodeList.add(logicInventoryRespDto.getGoodsLongCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)msgSkuCodeList)) {
                throw new BizException(String.format("\u521b\u5efa\u5931\u8d25,%s\u547d\u4e2d\u8c03\u5165\u4ed3\u9ed1\u540d\u5355\u89c4\u5219\u3010%s\u3011\u8bf7\u91cd\u65b0\u914d\u7f6e\u8c03\u62e8\u5546\u54c1", JSON.toJSONString((Object)msgSkuCodeList), ruleNo));
            }
        }
    }

    private void checkCTransferOrderType(SubmitTransferOrderParams params) {
        logger.info("\u53ea\u5bf9cc\u3001cb\u3001bc\u8c03\u62e8\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)params));
        if (CsPcpBusinessTypeEnum.cAllotList().contains(params.getBussinessOrderType())) {
            CsLogicWarehouseRespDto outWarehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(params.getOutLogicalWarehouseCode()));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)outWarehouse), "\u627e\u4e0d\u5230\u8c03\u62e8\u51fa\u5e93\u4ed3");
            CsLogicWarehouseRespDto inWarehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(params.getInLogicalWarehouseCode()));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)outWarehouse), "\u627e\u4e0d\u5230\u8c03\u62e8\u5165\u5e93\u4ed3");
            if (params.getBussinessOrderType().equals(CsPcpBusinessTypeEnum.CC_ALLOT.getCode()) && !outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode()) && !inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode())) {
                throw new com.dtyunxi.exceptions.BizException("-1", "\u53d1\u8d77cc\u8c03\u62e8\uff0c\u9700\u8c03\u62e8\u51fa\u5165\u4ed3\u5747\u4e3aC\u4ed3");
            }
            if (!(!params.getBussinessOrderType().equals(CsPcpBusinessTypeEnum.CB_ALLOT.getCode()) || outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()))) {
                throw new com.dtyunxi.exceptions.BizException("-1", "\u53d1\u8d77cb\u8c03\u62e8\uff0c\u9700\u8c03\u62e8\u51fa\u5e93\u4ed3\u4e3aC\u4ed3\uff0c\u5165\u5e93\u4ed3\u4e3aB\u4ed3");
            }
            if (!(!params.getBussinessOrderType().equals(CsPcpBusinessTypeEnum.BC_ALLOT.getCode()) && !params.getBussinessOrderType().equals(CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode()) || outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode()))) {
                throw new com.dtyunxi.exceptions.BizException("-1", "\u53d1\u8d77bc\u8c03\u62e8\uff0c\u9700\u8c03\u62e8\u51fa\u5e93\u4ed3\u4e3aB\u4ed3\uff0c\u5165\u5e93\u4ed3\u4e3aC\u4ed3");
            }
        }
    }

    private void checkClaimTransferOrderQuantity(SubmitTransferOrderParams params) {
        if (!CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode().equals(params.getBussinessOrderType())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)params.getPreOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u7d22\u8d54\u8c03\u62e8\u5fc5\u987b\u63d0\u4f9b\u539f\u8c03\u62e8\u5355\u53f7");
        }
        if (CollectionUtils.isEmpty(params.getGoodsList())) {
            throw new com.dtyunxi.exceptions.BizException("\u7d22\u8d54\u8c03\u62e8\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u5f00\u59cb\u6821\u9a8c\u7d22\u8d54\u8c03\u62e8\u6570\u91cf\uff0c\u539f\u8c03\u62e8\u5355\u53f7\uff1a{}", (Object)params.getPreOrderNo());
        try {
            CsTransferOrderRespDto originalOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(params.getPreOrderNo()));
            if (originalOrder == null) {
                throw new com.dtyunxi.exceptions.BizException("\u539f\u8c03\u62e8\u5355\u4e0d\u5b58\u5728\uff0c\u5355\u53f7\uff1a" + params.getPreOrderNo());
            }
            InOutResultOrderDetailPageReqDto queryDto = new InOutResultOrderDetailPageReqDto();
            queryDto.setRelevanceNo(params.getPreOrderNo());
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInOutResultOrderDetailApi.page(queryDto));
            List resultOrderDetails = pageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)resultOrderDetails)) {
                throw new com.dtyunxi.exceptions.BizException("\u539f\u8c03\u62e8\u5355\u672a\u627e\u5230\u5173\u8054\u7684\u51fa\u5e93\u7ed3\u679c\u5355\uff0c\u5355\u53f7\uff1a" + params.getPreOrderNo());
            }
            Map<String, BigDecimal> actualOutQuantityMap = resultOrderDetails.stream().filter(r -> r.getDocumentNo().startsWith("PRO")).collect(Collectors.groupingBy(detail -> detail.getSkuCode() + "_" + Optional.ofNullable(detail.getBatch()).orElse(""), Collectors.reducing(BigDecimal.ZERO, detail -> Optional.ofNullable(detail.getQuantity()).orElse(BigDecimal.ZERO), BigDecimal::add)));
            for (TransferOrderGoodsVO goods : params.getGoodsList()) {
                String key = goods.getGoodsLongCode() + "_" + Optional.ofNullable(goods.getBatchNo()).orElse("");
                BigDecimal actualOutQuantity = actualOutQuantityMap.get(key);
                if (actualOutQuantity == null || actualOutQuantity.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new com.dtyunxi.exceptions.BizException(String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u5728\u539f\u8c03\u62e8\u5355\u3010%s\u3011\u4e2d\u672a\u627e\u5230\u5b9e\u9645\u51fa\u5e93\u6570\u91cf", goods.getGoodsLongCode(), Optional.ofNullable(goods.getBatchNo()).orElse(""), params.getPreOrderNo()));
                }
                BigDecimal claimQuantity = goods.getPlanQuantity();
                if (claimQuantity == null) {
                    throw new com.dtyunxi.exceptions.BizException(String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u7684\u7d22\u8d54\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", goods.getGoodsLongCode(), Optional.ofNullable(goods.getBatchNo()).orElse("")));
                }
                if (claimQuantity.compareTo(actualOutQuantity) <= 0) continue;
                throw new com.dtyunxi.exceptions.BizException(String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u7684\u7d22\u8d54\u6570\u91cf\u3010%s\u3011\u8d85\u8fc7\u4e86\u539f\u8c03\u62e8\u5355\u3010%s\u3011\u7684\u5b9e\u9645\u51fa\u5e93\u6570\u91cf\u3010%s\u3011", goods.getGoodsLongCode(), Optional.ofNullable(goods.getBatchNo()).orElse(""), claimQuantity.toString(), params.getPreOrderNo(), actualOutQuantity.toString()));
            }
            logger.info("\u7d22\u8d54\u8c03\u62e8\u6570\u91cf\u6821\u9a8c\u901a\u8fc7\uff0c\u539f\u8c03\u62e8\u5355\u53f7\uff1a{}", (Object)params.getPreOrderNo());
        }
        catch (Exception e) {
            logger.error("\u7d22\u8d54\u8c03\u62e8\u6570\u91cf\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u8c03\u62e8\u5355\u53f7\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)params.getPreOrderNo(), (Object)e.getMessage());
            if (e instanceof com.dtyunxi.exceptions.BizException) {
                throw e;
            }
            throw new com.dtyunxi.exceptions.BizException("\u7d22\u8d54\u8c03\u62e8\u6570\u91cf\u6821\u9a8c\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void getTransferOrder(SubmitTransferOrderParams submitTransferOrderParams, CsTransferOrderComboReqDto reqDto, CsTransferOrderReqDto transferOrderReqDto) {
        transferOrderReqDto.setType(submitTransferOrderParams.getBussinessOrderType());
        transferOrderReqDto.setOutLogicWarehouseCode(submitTransferOrderParams.getOutLogicalWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(submitTransferOrderParams.getOutLogicalWarehouseName());
        transferOrderReqDto.setInLogicWarehouseCode(submitTransferOrderParams.getInLogicalWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(submitTransferOrderParams.getInLogicalWarehouseName());
        transferOrderReqDto.setOutOrganizationId(ParamConverter.convertToLong((Object)submitTransferOrderParams.getOutCargoRightId()));
        transferOrderReqDto.setOutOrganization(submitTransferOrderParams.getOutCargoRightName());
        transferOrderReqDto.setInOrganizationId(ParamConverter.convertToLong((Object)submitTransferOrderParams.getInCargoRightId()));
        transferOrderReqDto.setInOrganization(submitTransferOrderParams.getInCargoRightName());
        transferOrderReqDto.setBorrower(submitTransferOrderParams.getBorrower());
        transferOrderReqDto.setBorrowerId(ParamConverter.convertToLong((Object)submitTransferOrderParams.getBorrowerId()));
        transferOrderReqDto.setRequester(submitTransferOrderParams.getRequester());
        transferOrderReqDto.setRequesterId(ParamConverter.convertToLong((Object)submitTransferOrderParams.getRequesterId()));
        String outPhysicalWarehouseId = submitTransferOrderParams.getOutPhysicalWarehouseId();
        if (StringUtils.isNotBlank((CharSequence)outPhysicalWarehouseId)) {
            CsPhysicsWarehouseDetailRespDto warehouseDetailRespDto = this.getCsPhysicsWarehouseDetailRespDto(outPhysicalWarehouseId);
            transferOrderReqDto.setOutPhysicsWarehouseCode(warehouseDetailRespDto.getWarehouseCode());
        }
        transferOrderReqDto.setOutPhysicsWarehouseName(submitTransferOrderParams.getOutPhysicalWarehouseName());
        String inPhysicalWarehouseId = submitTransferOrderParams.getInPhysicalWarehouseId();
        if (StringUtils.isNotBlank((CharSequence)inPhysicalWarehouseId)) {
            CsPhysicsWarehouseDetailRespDto warehouseDetailRespDto = this.getCsPhysicsWarehouseDetailRespDto(inPhysicalWarehouseId);
            transferOrderReqDto.setInPhysicsWarehouseCode(warehouseDetailRespDto.getWarehouseCode());
        }
        transferOrderReqDto.setInPhysicsWarehouseName(submitTransferOrderParams.getInPhysicalWarehouseName());
        transferOrderReqDto.setPlanInTime(submitTransferOrderParams.getPlanInTime());
        transferOrderReqDto.setPlanOutTime(submitTransferOrderParams.getPlanOutTime());
        transferOrderReqDto.setShipmentEnterpriseCode(submitTransferOrderParams.getShipmentEnterpriseCode());
        transferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        if (StringUtils.isNotBlank((CharSequence)submitTransferOrderParams.getPreOrderNo())) {
            transferOrderReqDto.setPreOrderNo(submitTransferOrderParams.getPreOrderNo());
        }
        transferOrderReqDto.setProvince(submitTransferOrderParams.getProvince());
        transferOrderReqDto.setProvinceCode(submitTransferOrderParams.getProvinceCode());
        transferOrderReqDto.setCity(submitTransferOrderParams.getCity());
        transferOrderReqDto.setCityCode(submitTransferOrderParams.getCityCode());
        transferOrderReqDto.setArea(submitTransferOrderParams.getArea());
        transferOrderReqDto.setAreaCode(submitTransferOrderParams.getAreaCode());
        transferOrderReqDto.setAddress(submitTransferOrderParams.getAddress());
        transferOrderReqDto.setContact(submitTransferOrderParams.getContact());
        if (StringUtils.isNotBlank((CharSequence)submitTransferOrderParams.getContactPhone())) {
            AssertUtil.isTrue(submitTransferOrderParams.getContactPhone().length() == 11, "\u8bf7\u8f93\u516511\u4f4d\u957f\u5ea6\u7684\u7535\u8bdd\u53f7\u7801");
            transferOrderReqDto.setContactPhone(submitTransferOrderParams.getContactPhone());
        }
        reqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
        List<TransferOrderGoodsVO> goodsList = submitTransferOrderParams.getGoodsList();
        List goodsLongCodes = goodsList.stream().map(TransferOrderGoodsVO::getGoodsLongCode).collect(Collectors.toList());
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(goodsLongCodes));
        logger.info("\u65b0\u589e\u8c03\u62e8\u5355\uff0c\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)pcpItemRespDtos));
        HashMap itemRespDtoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
            Map dtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
            itemRespDtoMap.putAll(dtoMap);
        }
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List list = goodsList.stream().map(o -> {
                CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
                BeanUtils.copyProperties((Object)o, (Object)detailReqDto, (String[])new String[]{"id"});
                detailReqDto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
                detailReqDto.setCargoCode(o.getGoodsCode());
                detailReqDto.setLongCode(o.getGoodsLongCode());
                detailReqDto.setBatch(o.getBatchNo());
                detailReqDto.setCargoName(o.getGoodsName());
                detailReqDto.setSpecification(o.getGoodsSpec());
                detailReqDto.setProductDate(o.getEffectiveTime());
                detailReqDto.setDueDate(o.getInvalidTime());
                detailReqDto.setQuantity(o.getPlanQuantity());
                if (itemRespDtoMap != null && itemRespDtoMap.containsKey(o.getGoodsLongCode()) && ObjectUtil.isNotEmpty((Object)o.getPlanQuantity())) {
                    PcpItemRespDto dto = (PcpItemRespDto)itemRespDtoMap.get(o.getGoodsLongCode());
                    detailReqDto.setVolume(BigDecimalUtils.multiply((BigDecimal)dto.getVolume(), (BigDecimal)o.getPlanQuantity()).setScale(6, 1));
                    detailReqDto.setWeight(BigDecimalUtils.multiply((BigDecimal)dto.getQuantity(), (BigDecimal)o.getPlanQuantity()).setScale(6, 1));
                }
                return detailReqDto;
            }).collect(Collectors.toList());
            reqDto.setDetailList(list);
        }
    }

    private CsPhysicsWarehouseDetailRespDto getCsPhysicsWarehouseDetailRespDto(String outPhysicalWarehouseId) {
        CsPhysicsWarehouseDetailRespDto warehouseDetailRespDto = (CsPhysicsWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedQueryApi.queryDetailById(Long.valueOf(outPhysicalWarehouseId)));
        if (warehouseDetailRespDto == null) {
            throw new com.dtyunxi.exceptions.BizException("\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        }
        return warehouseDetailRespDto;
    }

    @Override
    public RestResponse<CommonValidVO> auditTransferOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AuditTransferOrderParams auditTransferOrderParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> editTransferOrder(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitTransferOrderParams submitTransferOrderParams) {
        CsTransferOrderComboReqDto reqDto = new CsTransferOrderComboReqDto();
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        BeanUtils.copyProperties((Object)submitTransferOrderParams, (Object)transferOrderReqDto);
        transferOrderReqDto.setId(submitTransferOrderParams.getId());
        transferOrderReqDto.setTransferOrderNo(submitTransferOrderParams.getBussinessOrderNo());
        this.getTransferOrder(submitTransferOrderParams, reqDto, transferOrderReqDto);
        String shipmentEnterpriseName = submitTransferOrderParams.getShipmentEnterpriseName();
        String shipmentEnterpriseCode = submitTransferOrderParams.getShipmentEnterpriseCode();
        if (StringUtils.isBlank((CharSequence)shipmentEnterpriseName) && StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode)) {
            try {
                CsShipmenetEnterpriseRespDto shipmenetEnterprise = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.shipmenetEnterpriseQueryApi.queryByCode(shipmentEnterpriseCode));
                if (shipmenetEnterprise != null && StringUtils.isNotBlank((CharSequence)shipmenetEnterprise.getShipmentEnterpriseName())) {
                    shipmentEnterpriseName = shipmenetEnterprise.getShipmentEnterpriseName();
                    logger.info("\u901a\u8fc7\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u83b7\u53d6\u5230\u7269\u6d41\u5546\u540d\u79f0\u3010{}\u3011", (Object)shipmentEnterpriseCode, (Object)shipmentEnterpriseName);
                } else {
                    logger.warn("\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6d41\u5546\u540d\u79f0", (Object)shipmentEnterpriseCode);
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\u5931\u8d25, shipmentEnterpriseCode: {}", (Object)shipmentEnterpriseCode, (Object)e);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("shipmentEnterpriseName", (Object)shipmentEnterpriseName);
        jsonObject.put("applyclaimFile", (Object)submitTransferOrderParams.getApplyclaimFile());
        jsonObject.put("expressNo", (Object)submitTransferOrderParams.getExpressNo());
        jsonObject.put("shipmentEnterpriseCode", (Object)shipmentEnterpriseCode);
        transferOrderReqDto.setExtension(jsonObject.toJSONString());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.modifyCsTransferOrder(reqDto)));
    }

    @Override
    public RestResponse<List<TransferOrderRelatedGoodsVO>> getTransferOrderAssociatedGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetTransferOrderAssociatedGoodsListPageParams getTransferOrderAssociatedGoodsListPageParams) {
        if (StringUtils.isBlank((CharSequence)getTransferOrderAssociatedGoodsListPageParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(getTransferOrderAssociatedGoodsListPageParams.getBussinessOrderNo()));
        if (CollectionUtils.isNotEmpty((Collection)respDtos)) {
            CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(getTransferOrderAssociatedGoodsListPageParams.getBussinessOrderNo()));
            String outWarehouseCode = transferOrderRespDto != null ? transferOrderRespDto.getOutLogicWarehouseCode() : null;
            HashMap<String, BigDecimal> availableInventoryMap = new HashMap<String, BigDecimal>();
            if (StringUtils.isNotBlank((CharSequence)outWarehouseCode)) {
                try {
                    List longCodeList;
                    if (CollectionUtils.isNotEmpty((Collection)respDtos) && CollectionUtils.isNotEmpty(longCodeList = respDtos.stream().map(CsTransferOrderDetailRespDto::getLongCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
                        CsLogicInventoryQueryDto queryDto = new CsLogicInventoryQueryDto();
                        queryDto.setWarehouseCode(outWarehouseCode);
                        queryDto.setLongCodes(longCodeList);
                        queryDto.setPageNum(Integer.valueOf(1));
                        queryDto.setPageSize(Integer.valueOf(1000));
                        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(queryDto));
                        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                            Map<String, BigDecimal> longCodeAvailableMap = respDtoPageInfo.getList().stream().collect(Collectors.groupingBy(CsLogicInventoryRespDto::getLongCode, Collectors.reducing(BigDecimal.ZERO, record -> record.getAvailable() != null ? record.getAvailable() : BigDecimal.ZERO, BigDecimal::add)));
                            availableInventoryMap.putAll(longCodeAvailableMap);
                            Map<String, BigDecimal> longCodeBatchAvailableMap = respDtoPageInfo.getList().stream().collect(Collectors.groupingBy(r -> r.getLongCode() + "_" + r.getBatch(), Collectors.reducing(BigDecimal.ZERO, record -> record.getAvailable() != null ? record.getAvailable() : BigDecimal.ZERO, BigDecimal::add)));
                            availableInventoryMap.putAll(longCodeBatchAvailableMap);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u6279\u91cf\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5931\u8d25\uff0c\u8c03\u62e8\u5355\u53f7\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)getTransferOrderAssociatedGoodsListPageParams.getBussinessOrderNo(), (Object)e.getMessage());
                }
            }
            List list = respDtos.stream().map(o -> {
                String inventoryKey;
                BigDecimal availableInventory;
                TransferOrderRelatedGoodsVO vo = new TransferOrderRelatedGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                Long cargoId = o.getCargoId();
                vo.setGoodsId(ParamConverter.convertToString((Object)cargoId));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setPlanQuantity(o.getQuantity());
                vo.setOutTransferQuantity(BigDecimal.ZERO);
                vo.setInTransferQuantity(BigDecimal.ZERO);
                vo.setBatchNo(o.getBatch());
                vo.setGoodsSpec(o.getSpecification());
                vo.setVolume(o.getVolume());
                vo.setEffectiveTime(o.getProductDate());
                vo.setInvalidTime(o.getDueDate());
                if (StringUtils.isNotBlank((CharSequence)o.getAvailableInventory())) {
                    BigDecimal availableInventory2 = ParamConverter.convertToBigDecimal((Object)o.getAvailableInventory());
                    vo.setAvailableInventory(ParamConverter.convertToString((Object)availableInventory2.setScale(0, 1)));
                }
                if ((availableInventory = (BigDecimal)availableInventoryMap.get(inventoryKey = StringUtils.isNotBlank((CharSequence)o.getBatch()) ? o.getLongCode() + "_" + o.getBatch() : o.getLongCode())) != null) {
                    vo.setAvailableInventory(ParamConverter.convertToString((Object)availableInventory.setScale(0, 1)));
                }
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<TransferOrderVO> getTransferOrderDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List respDtos;
        List respDtoList;
        CsPhysicsWarehousePageRespDto physicsWarehouseRespDto;
        CsPhysicsWarehousePageRespDto physicsWarehouseRespDto2;
        if (StringUtils.isBlank((CharSequence)bussinessOrderNo)) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsTransferOrderRespDto respDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(bussinessOrderNo));
        TransferOrderVO vo = new TransferOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getTransferOrderNo());
        vo.setBussinessOrderType(respDto.getType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setInCargoRightName(respDto.getInOrganization());
        vo.setInCargoRightId(ParamConverter.convertToString((Object)respDto.getInOrganizationId()));
        vo.setOutCargoRightName(respDto.getOutOrganization());
        vo.setOutCargoRightId(ParamConverter.convertToString((Object)respDto.getOutOrganizationId()));
        vo.setBorrower(respDto.getBorrower());
        vo.setBorrowerId(ParamConverter.convertToString((Object)respDto.getBorrowerId()));
        vo.setBorrowerName(respDto.getBorrower());
        vo.setRequester(respDto.getRequester());
        vo.setRequesterId(ParamConverter.convertToString((Object)respDto.getRequesterId()));
        vo.setRequesterName(respDto.getRequester());
        vo.setInLogicalWarehouseCode(respDto.getInLogicWarehouseCode());
        vo.setInLogicalWarehouseName(respDto.getInLogicWarehouseName());
        vo.setOutLogicalWarehouseCode(respDto.getOutLogicWarehouseCode());
        vo.setOutLogicalWarehouseName(respDto.getOutLogicWarehouseName());
        vo.setExternalOrderNo(respDto.getPreOrderNo());
        vo.setAddress(Optional.ofNullable(respDto.getProvince()).orElse("") + Optional.ofNullable(respDto.getCity()).orElse("") + Optional.ofNullable(respDto.getArea()).orElse("") + Optional.ofNullable(respDto.getAddress()).orElse(""));
        this.detailReadExtension(respDto, vo);
        this.orderReadExtension(respDto, vo);
        String inPhysicsWarehouseCode = respDto.getInPhysicsWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)inPhysicsWarehouseCode) && null != (physicsWarehouseRespDto2 = this.getPhysicsWarehouseRespDto(inPhysicsWarehouseCode))) {
            vo.setInPhysicalWarehouseId(ParamConverter.convertToString((Object)physicsWarehouseRespDto2.getId()));
        }
        vo.setInPhysicalWarehouseName(respDto.getInPhysicsWarehouseName());
        String outPhysicsWarehouseCode = respDto.getOutPhysicsWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)outPhysicsWarehouseCode) && null != (physicsWarehouseRespDto = this.getPhysicsWarehouseRespDto(outPhysicsWarehouseCode))) {
            vo.setOutPhysicalWarehouseId(ParamConverter.convertToString((Object)physicsWarehouseRespDto.getId()));
        }
        vo.setOutPhysicalWarehouseName(respDto.getOutPhysicsWarehouseName());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setPlanInTime(respDto.getPlanInTime());
        vo.setPlanOutTime(respDto.getPlanOutTime());
        List csStorageAuditRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csStorageAuditRecordQueryApi.queryListByOrderSrcNo(respDto.getTransferOrderNo()));
        if (CollectionUtils.isNotEmpty((Collection)csStorageAuditRecordRespDtos)) {
            List<AuditVO> list = csStorageAuditRecordRespDtos.stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryOtherStorageOrderRelevanceOrder(respDto.getTransferOrderNo(), FinishedGoodsInventoryTypeEnum.ALLOT_OUT.getCode()))))) {
            List<AssociatedDocumentVO> list = respDtoList.stream().map(o -> {
                AssociatedDocumentVO documentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                documentVO.setOrderNo(o.getDocumentNo());
                documentVO.setOrderType(o.getBusinessType());
                documentVO.setCreateTime(null != o.getCreateTime() ? DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                return documentVO;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                Collections.sort(list, (o1, o2) -> o2.getCreateTime().compareTo(o2.getCreateTime()));
            }
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(bussinessOrderNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        if (null == vo.getInPhysicalWarehouseName()) {
            CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
            queryDto.setWarehouseCode(respDto.getInLogicWarehouseCode());
            queryDto.setWarehouseClassify("logic");
            List relWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryDto));
            if (CollectionUtils.isNotEmpty((Collection)relWarehouseRespDtos)) {
                vo.setInPhysicalWarehouseName(((CsRelWarehouseRespDto)relWarehouseRespDtos.get(0)).getRefWarehouseName());
            }
        }
        vo.setOrderSrcName("OCS");
        if (StringUtils.isNotBlank((CharSequence)vo.getOrderSrc())) {
            if (StringUtils.equals((CharSequence)vo.getOrderSrc(), (CharSequence)"EAS")) {
                vo.setOrderSrcName("EAS");
            } else if (StringUtils.equals((CharSequence)vo.getOrderSrc(), (CharSequence)"PLAN")) {
                vo.setOrderSrcName("\u8c03\u62e8\u8ba1\u5212");
            }
        }
        vo.setCspPushStatus(respDto.getCspPushStatus());
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<Object> getTransferOrderWithdraw(Long id) {
        AssertUtil.isTrue(null != id, "id\u4e0d\u80fd\u4e3a\u7a7a");
        CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryById(id));
        if (ObjectUtils.isEmpty((Object)csTransferOrderRespDto)) {
            return new RestResponse();
        }
        AssertUtil.isTrue(csTransferOrderRespDto.getOrderStatus().equals(CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode()), "\u975e\u5f85\u53d1\u8d27\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u64a4\u56de");
        List csOutNoticeOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList(Collections.singletonList(csTransferOrderRespDto.getTransferOrderNo())));
        if (ObjectUtils.isEmpty((Object)csOutNoticeOrderRespDtos)) {
            return new RestResponse();
        }
        CsOutNoticeOrderRespDto csOutNoticeOrderRespDto = (CsOutNoticeOrderRespDto)csOutNoticeOrderRespDtos.get(0);
        WmsBaseRespDto wmsBaseRespDto = this.wmsAble.cancelWmsOutOrderWithdraw(csOutNoticeOrderRespDto);
        if (wmsBaseRespDto.isSuccess()) {
            logger.info("WMS\u53d6\u6d88\u6210\u529f\uff0c\u53d6\u6d88\u51fa\u5e93\u5355\u53f7.{}", (Object)csOutNoticeOrderRespDto.getDocumentNo());
            RestResponseHelper.extractData((RestResponse)this.csPcpInventoryExposedApi.cancelLogicAndTransferOrder(csTransferOrderRespDto.getTransferOrderNo(), id));
        }
        AssertUtil.isTrue(wmsBaseRespDto.isSuccess(), "\u53d6\u6d88WMS\u5355\u636e\u5931\u8d25:" + wmsBaseRespDto.getContent());
        return new RestResponse();
    }

    private void detailReadExtension(CsTransferOrderRespDto respDto, TransferOrderVO vo) {
        try {
            logger.info("\u8c03\u62e8\u8be6\u60c5\u8bfb\u53d6\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
            List detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(respDto.getTransferOrderNo()));
            if (CollectionUtils.isNotEmpty((Collection)detailRespDtoList) && StringUtils.isNotBlank((CharSequence)((CsTransferOrderDetailRespDto)detailRespDtoList.get(0)).getExtension())) {
                Map extensionMap = (Map)JSON.parseObject((String)((CsTransferOrderDetailRespDto)detailRespDtoList.get(0)).getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                vo.setProjectNo((String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code));
                String ifOnline = (String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code);
                vo.setIfOnline(StringUtils.isNotBlank((CharSequence)ifOnline) ? Integer.valueOf(ifOnline) : null);
                vo.setTrackPlan((String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code));
            }
        }
        catch (Exception e) {
            logger.info("\u8c03\u62e8\u8be6\u60c5\u8bfb\u53d6\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void orderReadExtension(CsTransferOrderRespDto respDto, TransferOrderVO vo) {
        logger.info("\u8bfb\u53d6\u5355\u636e\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)respDto.getExtension());
        if (StringUtils.isNotBlank((CharSequence)respDto.getExtension())) {
            Map map = (Map)JSON.parseObject((String)respDto.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            vo.setRouteDealTransferNo((String)map.get(EASExtendKeyEnum.ROUTE_DEAL_TRANSFER_NO.code));
            vo.setRouteDealNoticeNo((String)map.get(EASExtendKeyEnum.ROUTE_DEAL_NOTICE_NO.code));
            vo.setRouteDealNextNoticeNo((String)map.get(EASExtendKeyEnum.ROUTE_DEAL_NEXT_NOTICE_NO.code));
            vo.setShipmentEnterpriseName((String)map.get("shipmentEnterpriseName"));
            vo.setApplyclaimFile((String)map.get("applyclaimFile"));
            vo.setExpressNo((String)map.get("expressNo"));
            vo.setShipmentEnterpriseCode((String)map.get("shipmentEnterpriseCode"));
            vo.setEasOutNo((String)map.get("externalOrderNOs"));
        }
    }

    private CsPhysicsWarehousePageRespDto getPhysicsWarehouseRespDto(String inPhysicsWarehouseCode) {
        if (StringUtils.isBlank((CharSequence)inPhysicsWarehouseCode)) {
            return null;
        }
        CsPhysicsWarehouseParamQueryDto physicsWarehouseParamQueryDto = new CsPhysicsWarehouseParamQueryDto();
        ArrayList<String> physicsCodes = new ArrayList<String>(1);
        physicsCodes.add(inPhysicsWarehouseCode);
        physicsWarehouseParamQueryDto.setWarehouseCodeList(physicsCodes);
        List physicsWarehousePageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iCsPhysicsWarehouseExposedApi.queryParam(physicsWarehouseParamQueryDto));
        if (CollectionUtils.isEmpty((Collection)physicsWarehousePageRespDtoList)) {
            throw new com.dtyunxi.exceptions.BizException("\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        }
        return (CsPhysicsWarehousePageRespDto)physicsWarehousePageRespDtoList.get(0);
    }

    @Override
    public RestResponse<PageInfo<TransferOrderVO>> getTransferOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetTransferOrderListPageParams getTransferOrderListPageParams) {
        DgTransferOrderPageReqDto pageReqDto = new DgTransferOrderPageReqDto();
        BeanUtils.copyProperties((Object)getTransferOrderListPageParams, (Object)pageReqDto);
        pageReqDto.setTransferOrderNo(getTransferOrderListPageParams.getBussinessOrderNo());
        pageReqDto.setOrderStatus(getTransferOrderListPageParams.getBussinessOrderStatus());
        pageReqDto.setType(getTransferOrderListPageParams.getBussinessOrderType());
        if (StringUtils.isNotBlank((CharSequence)getTransferOrderListPageParams.getStartTime())) {
            pageReqDto.setStartCreateTime((Date)DateUtil.parseDateTime((CharSequence)(getTransferOrderListPageParams.getStartTime() + " 00:00:00")));
        }
        if (StringUtils.isNotBlank((CharSequence)getTransferOrderListPageParams.getStartTime())) {
            pageReqDto.setEndCreateTime((Date)DateUtil.parseDateTime((CharSequence)(getTransferOrderListPageParams.getEndTime() + " 23:59:59")));
        }
        pageReqDto.setInLogicWarehouseName(getTransferOrderListPageParams.getInLogicalWarehouseName());
        pageReqDto.setInLogicWarehouseCode(getTransferOrderListPageParams.getInLogicalWarehouseCode());
        pageReqDto.setOutLogicWarehouseName(getTransferOrderListPageParams.getOutLogicalWarehouseName());
        pageReqDto.setOutLogicWarehouseCode(getTransferOrderListPageParams.getOutLogicalWarehouseCode());
        pageReqDto.setTypeList(getTransferOrderListPageParams.getBussinessOrderTypeList());
        pageReqDto.setOutPhysicsWarehouseCodeList(getTransferOrderListPageParams.getOutPhysicsWarehouseCodeList());
        pageReqDto.setInPhysicsWarehouseCodeList(getTransferOrderListPageParams.getInPhysicsWarehouseCodeList());
        pageReqDto.setOrderStatusList(getTransferOrderListPageParams.getBussinessOrderStatusList());
        pageReqDto.setCspPushStatus(getTransferOrderListPageParams.getCspPushStatus());
        pageReqDto.setBorrower(getTransferOrderListPageParams.getBorrower());
        pageReqDto.setBorrowerId(ParamConverter.convertToLong((Object)getTransferOrderListPageParams.getBorrowerId()));
        pageReqDto.setRequester(getTransferOrderListPageParams.getRequester());
        pageReqDto.setRequesterId(ParamConverter.convertToLong((Object)getTransferOrderListPageParams.getRequesterId()));
        pageReqDto.setOutPhysicsWarehouseId(getTransferOrderListPageParams.getOutPhysicalWarehouseId());
        pageReqDto.setInOrganization(getTransferOrderListPageParams.getInCargoRightName());
        pageReqDto.setOutOrganization(getTransferOrderListPageParams.getOutCargoRightName());
        pageReqDto.setSearchDetails(Boolean.TRUE);
        pageReqDto.setSearchResultDetails(Boolean.TRUE);
        pageReqDto.setSplitTransferOrder(Boolean.TRUE);
        pageReqDto.setLikeTransferOrderNo(Boolean.TRUE);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.rpTransferOrderApi.page(pageReqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<TransferOrderVO> list = respDtoPageInfo.getList().stream().map(o -> {
            TransferOrderVO vo = new TransferOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setEasOutNo(o.getEasOutNo());
            vo.setBussinessOrderNo(o.getTransferOrderNo());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setBussinessOrderType(o.getType());
            vo.setExternalOrderNo(o.getPreOrderNo());
            vo.setOutCargoRightName(o.getOutOrganization());
            vo.setInCargoRightName(o.getInOrganization());
            vo.setBorrower(o.getBorrower());
            vo.setBorrowerId(ParamConverter.convertToString((Object)o.getBorrowerId()));
            vo.setBorrowerName(o.getBorrower());
            vo.setRequester(o.getRequester());
            vo.setRequesterId(ParamConverter.convertToString((Object)o.getRequesterId()));
            vo.setRequesterName(o.getRequester());
            vo.setInLogicalWarehouseName(o.getInLogicWarehouseName());
            vo.setInLogicalWarehouseCode(o.getInLogicWarehouseCode());
            vo.setOutLogicalWarehouseCode(o.getOutLogicWarehouseCode());
            vo.setOutLogicalWarehouseName(o.getOutLogicWarehouseName());
            vo.setPlanTransferQuantity(o.getTotalQuantity());
            vo.setExternalPurchaseOrderNo(o.getExternalPurchaseOrderNo());
            vo.setExternalSaleOrderNo(o.getExternalSaleOrderNo());
            vo.setPreOrderNo(o.getPreOrderNo());
            vo.setParentOrderNo(o.getParentOrderNo());
            vo.setConsignmentNo(o.getConsignmentNo());
            vo.setShippingCompany(o.getShippingCompany());
            vo.setShipmentEnterpriseCode(o.getShippingCompanyCode());
            vo.setShipmentEnterpriseName(o.getShippingCompany());
            vo.setShippingCode(o.getShippingCode());
            vo.setExpressNo(o.getShippingCode());
            vo.setShippingType(o.getShippingType());
            vo.setOutNoticeNo(o.getOutNoticeNo());
            vo.setBizDate(o.getBizDate());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getDoneOutQuantity() != null) {
                vo.setOutWarehouseQuantity(ParamConverter.convertToString((Object)o.getDoneOutQuantity().setScale(0, 1)));
            }
            if (o.getDoneInQuantity() != null) {
                vo.setInWarehouseQuantity(ParamConverter.convertToString((Object)o.getDoneInQuantity().setScale(0, 1)));
            }
            if (o.getTotalCartons() != null) {
                vo.setTotalCartons(o.getTotalCartons().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalCartons());
            }
            if (o.getMergeQuantity() != null) {
                vo.setMergeQuantity(o.getMergeQuantity().compareTo(BigDecimal.ZERO) == 0 ? null : o.getMergeQuantity());
            }
            if (o.getTotalWeight() != null) {
                vo.setTotalWeight(o.getTotalWeight().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalWeight());
            }
            if (o.getTotalVolume() != null) {
                vo.setTotalVolume(o.getTotalVolume().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalVolume());
            }
            if (o.getExtension() != null) {
                JSONObject extensionJson = JSON.parseObject((String)o.getExtension());
                vo.setSaleOrderNo(extensionJson.getString("saleOrderNo"));
                vo.setPurchaseOrderNo(extensionJson.getString("purchaseOrderNo"));
                vo.setSaleReturnNo(extensionJson.getString("saleReturnNo"));
                vo.setPurReturnNo(extensionJson.getString("purReturnNo"));
            }
            vo.setCspPushStatus(o.getCspPushStatus());
            return vo;
        }).collect(Collectors.toList());
        this.joinOutInNotice(list);
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgTransferOrderCountDto>> tranferOrderCount(GetTransferOrderListPageParams getTransferOrderListPageParams) {
        DgTransferOrderPageReqDto pageReqDto = new DgTransferOrderPageReqDto();
        BeanUtils.copyProperties((Object)getTransferOrderListPageParams, (Object)pageReqDto);
        pageReqDto.setTransferOrderNo(getTransferOrderListPageParams.getBussinessOrderNo());
        pageReqDto.setOrderStatus(getTransferOrderListPageParams.getBussinessOrderStatus());
        pageReqDto.setType(getTransferOrderListPageParams.getBussinessOrderType());
        if (StringUtils.isNotBlank((CharSequence)getTransferOrderListPageParams.getStartTime())) {
            pageReqDto.setStartCreateTime((Date)DateUtil.parseDateTime((CharSequence)(getTransferOrderListPageParams.getStartTime() + " 00:00:00")));
        }
        if (StringUtils.isNotBlank((CharSequence)getTransferOrderListPageParams.getStartTime())) {
            pageReqDto.setEndCreateTime((Date)DateUtil.parseDateTime((CharSequence)(getTransferOrderListPageParams.getEndTime() + " 23:59:59")));
        }
        pageReqDto.setInLogicWarehouseName(getTransferOrderListPageParams.getInLogicalWarehouseName());
        pageReqDto.setInLogicWarehouseCode(getTransferOrderListPageParams.getInLogicalWarehouseCode());
        pageReqDto.setOutLogicWarehouseName(getTransferOrderListPageParams.getOutLogicalWarehouseName());
        pageReqDto.setOutLogicWarehouseCode(getTransferOrderListPageParams.getOutLogicalWarehouseCode());
        pageReqDto.setTypeList(getTransferOrderListPageParams.getBussinessOrderTypeList());
        pageReqDto.setOutPhysicsWarehouseCodeList(getTransferOrderListPageParams.getOutPhysicsWarehouseCodeList());
        pageReqDto.setOrderStatusList(getTransferOrderListPageParams.getBussinessOrderStatusList());
        pageReqDto.setCspPushStatus(getTransferOrderListPageParams.getCspPushStatus());
        pageReqDto.setBorrower(getTransferOrderListPageParams.getBorrower());
        pageReqDto.setBorrowerId(ParamConverter.convertToLong((Object)getTransferOrderListPageParams.getBorrowerId()));
        pageReqDto.setRequester(getTransferOrderListPageParams.getRequester());
        pageReqDto.setRequesterId(ParamConverter.convertToLong((Object)getTransferOrderListPageParams.getRequesterId()));
        pageReqDto.setSearchDetails(Boolean.TRUE);
        pageReqDto.setSearchResultDetails(Boolean.TRUE);
        pageReqDto.setSplitTransferOrder(Boolean.TRUE);
        pageReqDto.setLikeTransferOrderNo(Boolean.TRUE);
        return new RestResponse((Object)Lists.newArrayList((Object[])new DgTransferOrderCountDto[]{(DgTransferOrderCountDto)RestResponseHelper.extractData((RestResponse)this.rpTransferOrderApi.transferOrderCount(pageReqDto))}));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getTransferOrderListPage((GetTransferOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutTransferOrderVO vo = new OutTransferOrderVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setTotalCartons(o.getTotalCartons() == null ? "" : o.getTotalCartons().stripTrailingZeros().toPlainString());
                vo.setMergeQuantity(o.getMergeQuantity() == null ? "" : o.getMergeQuantity().stripTrailingZeros().toPlainString());
                vo.setTotalWeight(o.getTotalWeight() == null ? "" : o.getTotalWeight().stripTrailingZeros().toPlainString());
                vo.setTotalVolume(o.getTotalVolume() == null ? "" : o.getTotalVolume().stripTrailingZeros().toPlainString());
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_delivery": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "wait_receive": {
                            return "\u5f85\u6536\u8d27";
                        }
                        case "delivery": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "canceled": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setBussinessOrderType(Optional.ofNullable(o.getBussinessOrderType()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "allot_in_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u5165\u5e93)";
                        }
                        case "allot_logic_out": {
                            return "\u903b\u8f91\u8c03\u62e8";
                        }
                        case "allot_lose_efficacy": {
                            return "\u8fd1\u6548\u671f\u5546\u54c1\u8c03\u62e8";
                        }
                        case "allot_out": {
                            return "\u666e\u901a\u8c03\u62e8";
                        }
                        case "allot_out_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u51fa\u5e93)";
                        }
                        case "bc_allot": {
                            return "bc\u8c03\u62e8";
                        }
                        case "cb_allot": {
                            return "cb\u8c03\u62e8";
                        }
                        case "cc_allot": {
                            return "cc\u8c03\u62e8";
                        }
                        case "inspection_qualified": {
                            return "\u5f85\u68c0\u8f6c\u5408\u683c";
                        }
                        case "allot_sale": {
                            return "\u9500\u552e\u8c03\u62e8";
                        }
                        case "allot_sale_bh": {
                            return "\u9500\u552e\u8865\u8d27\u8c03\u62e8";
                        }
                    }
                    return o.getBussinessOrderType();
                }).orElse(""));
                vo.setPlanTransferQuantity(Optional.ofNullable(o.getPlanTransferQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setOutWarehouseQuantity(new BigDecimal(this.getVal(o.getOutWarehouseQuantity())).intValue());
                vo.setInWarehouseQuantity(new BigDecimal(this.getVal(o.getInWarehouseQuantity())).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutTransferOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    private String getVal(String o) {
        return Optional.ofNullable(o).orElse("0");
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getTransferOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    private void joinOutInNotice(List<TransferOrderVO> list) {
        List transferNoList = list.stream().map(TransferOrderVO::getBussinessOrderNo).collect(Collectors.toList());
        List noticeOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList(transferNoList));
        if (CollectionUtils.isEmpty((Collection)noticeOrderRespDtoList)) {
            return;
        }
        HashMap<String, List> outNoticeMap = new HashMap<String, List>();
        HashMap<String, List> inNoticeMap = new HashMap<String, List>();
        for (CsOutNoticeOrderRespDto csOutNoticeOrderRespDto : noticeOrderRespDtoList) {
            if ("out".equals(csOutNoticeOrderRespDto.getOrderType())) {
                List outNoticeList = (List)outNoticeMap.get(csOutNoticeOrderRespDto.getRelevanceNo());
                outNoticeList = CollectionUtils.isNotEmpty((Collection)outNoticeList) ? outNoticeList : new ArrayList();
                outNoticeList.add(csOutNoticeOrderRespDto.getDocumentNo());
                outNoticeMap.put(csOutNoticeOrderRespDto.getRelevanceNo(), outNoticeList);
                continue;
            }
            List inNoticeList = (List)inNoticeMap.get(csOutNoticeOrderRespDto.getRelevanceNo());
            inNoticeList = CollectionUtils.isNotEmpty((Collection)inNoticeList) ? inNoticeList : new ArrayList();
            inNoticeList.add(csOutNoticeOrderRespDto.getDocumentNo());
            inNoticeMap.put(csOutNoticeOrderRespDto.getRelevanceNo(), inNoticeList);
        }
        for (TransferOrderVO transferOrderVO : list) {
            List outNotice = (List)outNoticeMap.get(transferOrderVO.getBussinessOrderNo());
            List inNotice = (List)inNoticeMap.get(transferOrderVO.getBussinessOrderNo());
            transferOrderVO.setOutNoticeNo(CollectionUtils.isNotEmpty((Collection)outNotice) ? Joiner.on((String)",").join((Iterable)outNotice) : null);
            transferOrderVO.setInNoticeNo(CollectionUtils.isNotEmpty((Collection)inNotice) ? Joiner.on((String)",").join((Iterable)inNotice) : null);
        }
    }

    @Override
    public RestResponse<Void> intercept(String documentNo) {
        return null;
    }

    @Override
    public RestResponse<Void> cancelTransferOrder(CsTransferOrderReqDto reqDto) {
        logger.info(" \u53d6\u6d88\u8c03\u62e8\u5355\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)reqDto.getId()), "ID\u4e0d\u80fd\u4e3a\u7a7a");
        CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryById(reqDto.getId()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrderRespDto), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        List csOutNoticeOrderList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList((List)Lists.newArrayList((Object[])new String[]{transferOrderRespDto.getTransferOrderNo()})));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)csOutNoticeOrderList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u901a\u77e5\u5355");
        AssertUtil.isFalse(csOutNoticeOrderList.size() > 1, "\u901a\u77e5\u5355\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u4e2a\u51fa\u5e93\u901a\u77e5\u5355");
        if (!transferOrderRespDto.getType().equals(CsPcpBusinessTypeEnum.CC_ALLOT.getCode()) && !transferOrderRespDto.getType().equals(CsPcpBusinessTypeEnum.CB_ALLOT.getCode())) {
            throw new com.dtyunxi.exceptions.BizException("-1", "\u53ea\u6709cc\u3001cb\u8c03\u62e8\u624d\u5141\u8bb8\u53d6\u6d88");
        }
        if (!transferOrderRespDto.getOrderStatus().equals(CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode())) {
            throw new com.dtyunxi.exceptions.BizException("-1", "\u975e\u5f85\u53d1\u8d27\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88");
        }
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(transferOrderRespDto.getOutLogicWarehouseCode()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)warehouseRespDto), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f");
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)warehouseRespDto.getWarehouseCorrespondingSystem()), "\u8c03\u62e8\u51fa\u5e93\u903b\u8f91\u4ed3\u672a\u6807\u8bc6\u5bf9\u5e94\u7684E3\u7cfb\u7edf");
        WarehouseCorrespondingSystemEnum byCode = WarehouseCorrespondingSystemEnum.getByCode((String)warehouseRespDto.getWarehouseCorrespondingSystem());
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)warehouseRespDto), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f");
        E3BsOtherCancelReqDto cancelReqDto = new E3BsOtherCancelReqDto();
        cancelReqDto.setOrderNo(transferOrderRespDto.getTransferOrderNo());
        cancelReqDto.setBusinessOrderNo(transferOrderRespDto.getTransferOrderNo());
        switch (WarehouseCorrespondingSystemEnum.getByCode((String)warehouseRespDto.getWarehouseCorrespondingSystem())) {
            case E3_MY: {
                logger.info("\u8bf7\u6c42\u9ea6\u4f18\u51fa\u5e93\u53d6\u6d88");
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.myOtherOutCancel(cancelReqDto));
                break;
            }
            case E3_BS: {
                logger.info("\u8bf7\u6c42\u767e\u80dc\u51fa\u5e93\u53d6\u6d88");
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.bsOtherOutCancel(cancelReqDto));
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("-1", "\u903b\u8f91\u51fa\u5e93\u4ed3\u975eE3\u4ed3");
            }
        }
        CsWmsCancelReqDto csWmsCancelReqDto = new CsWmsCancelReqDto();
        csWmsCancelReqDto.setNoticeOrderNo(((CsOutNoticeOrderRespDto)csOutNoticeOrderList.get(0)).getDocumentNo());
        csWmsCancelReqDto.setRemark(reqDto.getRemark());
        RestResponseHelper.extractData((RestResponse)this.csWmsApi.cancelInstruct(csWmsCancelReqDto));
        return RestResponse.VOID;
    }
}

