/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.constant.Constants;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.model.BdImportExportTaskVo;
import com.dtyunxi.cis.pms.biz.model.ExportItemVO;
import com.dtyunxi.cis.pms.biz.model.GetExportListPageParams;
import com.dtyunxi.cis.pms.biz.service.IBdImportExportTaskService;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BdImportExportTaskServiceImpl
implements IBdImportExportTaskService {
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;

    @Override
    public PageInfo<ExportItemVO> queryByPage(GetExportListPageParams queryDto) {
        this.exportFileBeOverdue();
        ExtQueryChainWrapper filter1 = this.bdImportExportTaskDas.filter();
        if (queryDto != null && StringUtils.isNotBlank((CharSequence)queryDto.getFileName())) {
            filter1.like((Object)"file_name", (Object)("%" + queryDto.getFileName() + "%"));
        }
        if (queryDto != null && StringUtils.isNotBlank((CharSequence)queryDto.getCreatePerson())) {
            filter1.like((Object)"create_person", (Object)("%" + queryDto.getCreatePerson() + "%"));
        }
        if (queryDto != null && StringUtils.isNotBlank((CharSequence)queryDto.getFileSource())) {
            filter1.eq((Object)"source", (Object)queryDto.getFileSource());
        }
        if (queryDto != null && StringUtils.isNotBlank((CharSequence)queryDto.getCreateTimeStart())) {
            filter1.ge((Object)"create_time", (Object)queryDto.getCreateTimeStart());
        }
        if (queryDto != null && StringUtils.isNotBlank((CharSequence)queryDto.getCreateTimeEnd())) {
            filter1.le((Object)"create_time", (Object)queryDto.getCreateTimeEnd());
        }
        filter1.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = filter1.page(queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> dtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) {
            dtoList = eoPageInfo.getList().stream().map(i -> {
                ExportItemVO vo = new ExportItemVO();
                vo.setId(i.getId());
                vo.setCreatePerson(i.getCreatePerson());
                vo.setUpdatePerson(i.getUpdatePerson());
                vo.setCreateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)i.getCreateTime()));
                vo.setUpdateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)i.getUpdateTime()));
                vo.setGenerateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)i.getCompleteTime()));
                vo.setFileName(i.getFileName());
                vo.setFileUrl(i.getFileUrl());
                vo.setFileSource(i.getSource());
                vo.setTaskNo(i.getTaskCode());
                vo.setFileSize(i.getSize());
                vo.setStatus(i.getStatus());
                vo.setTaskType(i.getType() + "");
                vo.setErrorFileUrl(i.getErrorMsgUrl());
                return vo;
            }).collect(Collectors.toList());
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BdImportExportTaskVo queryById(Long id) {
        BdImportExportTaskEo bdImportExportTaskEo = (BdImportExportTaskEo)this.bdImportExportTaskDas.selectByPrimaryKey(id);
        BdImportExportTaskVo bdImportExportTaskRespDto = new BdImportExportTaskVo();
        DtoHelper.eo2Dto((BaseEo)bdImportExportTaskEo, (BaseVo)bdImportExportTaskRespDto);
        return bdImportExportTaskRespDto;
    }

    @Override
    public void exportFileBeOverdue() {
        PageInfo page;
        Date time = new Date(System.currentTimeMillis() - 7L * Constants.DAY_IN_MS);
        ExtQueryChainWrapper filter = this.bdImportExportTaskDas.filter();
        filter.lt((Object)"complete_time", (Object)time);
        filter.eq((Object)"type", (Object)2);
        filter.eq((Object)"status", (Object)ImportExportStatusEnum.SUCCESS.getCode());
        Integer pageNum = 1;
        Integer pageSize = 1000;
        ArrayList list = Lists.newArrayList();
        while (true) {
            if ((page = filter.page(pageNum, pageSize)).getList().size() < 1000) break;
            list.addAll(page.getList());
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        list.addAll(page.getList());
        this.updateStatus(list);
    }

    @Override
    public ExportItemVO getLastImportData(String key) {
        BdImportExportTaskEo eo = (BdImportExportTaskEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.bdImportExportTaskDas.filter().eq((Object)"module_key", (Object)key)).eq((Object)"type", (Object)1)).in((Object)"status", (Collection)Lists.newArrayList((Object[])new Integer[]{3, 4}))).orderByDesc((Object)"complete_time")).last("limit 1")).one();
        if (eo != null) {
            ExportItemVO vo = new ExportItemVO();
            vo.setId(eo.getId());
            vo.setCreatePerson(eo.getCreatePerson());
            vo.setUpdatePerson(eo.getUpdatePerson());
            vo.setCreateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)eo.getCreateTime()));
            vo.setUpdateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)eo.getUpdateTime()));
            vo.setGenerateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)eo.getCompleteTime()));
            vo.setFileName(eo.getFileName());
            vo.setFileUrl(eo.getFileUrl());
            vo.setFileSource(eo.getSource());
            vo.setTaskNo(eo.getTaskCode());
            vo.setFileSize(eo.getSize());
            vo.setStatus(eo.getStatus());
            return vo;
        }
        return null;
    }

    private void updateStatus(List<BdImportExportTaskEo> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        list.forEach(i -> {
            i.setStatus(ImportExportStatusEnum.BE_OVERDUE.getCode());
            this.bdImportExportTaskDas.updateSelective((BaseEo)i);
        });
    }
}

