/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.enums.RefundTypeEnum;
import com.dtyunxi.cis.pms.biz.model.AddSaleReturnOrderParams;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ChangeSaleReturnOrderLogicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSaleReturnOrderVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleReturnOrderGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.OrderOperationVO;
import com.dtyunxi.cis.pms.biz.model.RelationBillVO;
import com.dtyunxi.cis.pms.biz.model.SaleReturnGoodsVO;
import com.dtyunxi.cis.pms.biz.model.SaleReturnOrderCountVO;
import com.dtyunxi.cis.pms.biz.model.SaleReturnOrderVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleReturnOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.search.api.dto.response.EsSaleRefundCountVO;
import com.dtyunxi.cis.search.api.dto.response.SaleRefundRespVo;
import com.dtyunxi.cis.search.api.query.trade.EsSaleRefundQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.EsSaleReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.IBasicsOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyWarehouseCodeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.SaleRefundSourceTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_sale_return_order")
public class OrderCenterSaleReturnOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements OrderCenterSaleReturnOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderCenterSaleReturnOrderServiceServiceImpl.class);
    @Value(value="${saleRefundOrderEsQuery:true}")
    private Boolean saleRefundOrderEsQuery;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private ISaleRefundItemQueryApi saleRefundItemQueryApi;
    @Resource
    private EsSaleRefundQueryApi esSaleRefundQueryApi;
    @Resource
    private ISaleRefundOptApi saleRefundOptApi;
    @Resource
    private IBasicsOrderQueryApi iBasicsOrderQueryApi;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private ISaleRefundApi saleRefundApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Override
    public RestResponse<Object> cancelSaleReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u9500\u552e\u9000\u8d27id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List refundIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleRefundOptApi.batchCancel(refundIdList)));
    }

    @Override
    public RestResponse<Object> changeSaleReturnOrderLogicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) ChangeSaleReturnOrderLogicalWarehouseParams changeSaleReturnOrderLogicalWarehouseParams) {
        ModifyWarehouseCodeReqDto reqDto = new ModifyWarehouseCodeReqDto();
        reqDto.setSaleRefundOrderId(ParamConverter.convertToLong((Object)changeSaleReturnOrderLogicalWarehouseParams.getSaleReturnOrderId()));
        reqDto.setSaleRefundOrderNo(changeSaleReturnOrderLogicalWarehouseParams.getSaleReturnOrderNo());
        List<SaleReturnGoodsVO> goodsList = changeSaleReturnOrderLogicalWarehouseParams.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List itemReqDtos = goodsList.stream().map(o -> {
                SaleRefundItemReqDto itemReqDto = new SaleRefundItemReqDto();
                BeanUtils.copyProperties((Object)o, (Object)itemReqDto);
                itemReqDto.setItemId(ParamConverter.convertToLong((Object)o.getGoodsId()));
                itemReqDto.setItemCode(o.getGoodsCode());
                itemReqDto.setSkuCode(o.getGoodsSku());
                itemReqDto.setItemName(o.getGoodsName());
                itemReqDto.setBatchNo(o.getBatchNo());
                itemReqDto.setRefundWarehouseCode(o.getActualLogicalWarehouseCode());
                itemReqDto.setRefundWarehouseName(o.getActualLogicalWarehouseName());
                itemReqDto.setItemNum(o.getGoodsNum());
                return itemReqDto;
            }).collect(Collectors.toList());
            reqDto.setGoodsList(itemReqDtos);
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleRefundOptApi.modifyWarehouseCode(reqDto)));
    }

    @Override
    public RestResponse<Object> confirmSaleReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u9500\u552e\u9000\u8d27id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List refundIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleRefundOptApi.batchConfirmOrder(refundIdList)));
    }

    @Override
    public RestResponse<SaleReturnOrderCountVO> getSaleReturnOrderCount(@ApiParam(value="") @RequestBody(required=false) com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams getSaleReturnOrderCountParams) {
        LOGGER.info("\u9500\u552e\u9000\u8d27\u5355\u5404\u72b6\u6001\u7684\u5355\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)getSaleReturnOrderCountParams));
        EsSaleRefundCountVO saleRefundCountVO = new EsSaleRefundCountVO();
        if (this.saleRefundOrderEsQuery.booleanValue()) {
            saleRefundCountVO = (EsSaleRefundCountVO)RestResponseHelper.extractData((RestResponse)this.esSaleRefundQueryApi.queryByCount(getSaleReturnOrderCountParams));
        } else {
            LOGGER.info("\u8d70\u62a5\u8868\u67e5\u8be2");
            EsSaleReturnOrderListPageParams params = new EsSaleReturnOrderListPageParams();
            BeanUtils.copyProperties((Object)getSaleReturnOrderCountParams, (Object)params);
            com.dtyunxi.tcbj.api.dto.response.es.SaleReturnOrderCountVO saleReturnOrderCountVO = (com.dtyunxi.tcbj.api.dto.response.es.SaleReturnOrderCountVO)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleRefundOrderCount(params));
            CubeBeanUtils.copyProperties((Object)saleRefundCountVO, (Object)saleReturnOrderCountVO, (String[])new String[0]);
        }
        SaleReturnOrderCountVO vo = new SaleReturnOrderCountVO();
        CubeBeanUtils.copyProperties((Object)vo, (Object)saleRefundCountVO, (String[])new String[0]);
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<SaleReturnOrderVO> getSaleReturnOrderDetail(@ApiParam(value="\u5355\u53f7") @Valid @RequestParam(value="orderNo", required=false) String orderNo, @ApiParam(value="\u9500\u552e\u9000\u8d27\u5355id") @Valid @RequestParam(value="id", required=false) String id) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            throw new BizException("\u9500\u552e\u9000\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BizSaleRefundRespDto respDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(orderNo));
        SaleReturnOrderVO vo = new SaleReturnOrderVO();
        if (vo == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setSaleReturnOrderNo(respDto.getSaleRefundNo());
        vo.setOutBizOrderNo(respDto.getPlatformRefundNo());
        SaleRefundAddrRespDto orderAddrRespDto = respDto.getSaleRefundAddrRespDto();
        if (orderAddrRespDto != null) {
            this.getSaleRefundAddrRespDto(vo, orderAddrRespDto);
        }
        if (respDto.getActualRefundTime() != null) {
            vo.setActualReturnTime(DateUtil.format((Date)respDto.getActualRefundTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setContactPerson(respDto.getContactPersonName());
        vo.setContactPhone(respDto.getContactPhone());
        vo.setOrderStatus(respDto.getRefundStatus());
        vo.setReturnCustomerName(respDto.getCustomerName());
        vo.setReturnCustomerId(ParamConverter.convertToString((Object)respDto.getCustomerId()));
        vo.setSaleOrganizationName(respDto.getOrganizationName());
        vo.setSaleOrganizationCode(respDto.getOrganizationCode());
        vo.setSaleOrganizationId(respDto.getOrganizationId().toString());
        vo.setReturnType(respDto.getRefundType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (respDto.getPlatformRefundApplyTime() != null) {
            vo.setBizOrderCreateTime(DateUtil.format((Date)respDto.getPlatformRefundApplyTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setReturnAmount(respDto.getRefundTotalAmount());
        this.getSaleReturnPreRespDtoList(respDto, vo);
        return new RestResponse((Object)vo);
    }

    private void getSaleReturnPreRespDtoList(BizSaleRefundRespDto respDto, SaleReturnOrderVO vo) {
        List relOrderInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iBasicsOrderQueryApi.queryAllByRelevanceNo(respDto.getSaleRefundNo()));
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoRespDtoList)) {
            List<RelationBillVO> relationOrderVOList = relOrderInfoRespDtoList.stream().map(o -> {
                RelationBillVO relationOrderVO = new RelationBillVO();
                relationOrderVO.setBillNo(o.getDocumentNo());
                relationOrderVO.setBillType(o.getOrderType());
                relationOrderVO.setBillStatus(o.getOrderStatus());
                relationOrderVO.setCreateTime(o.getCreateTime());
                return relationOrderVO;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(relationOrderVOList)) {
                Collections.sort(relationOrderVOList, (o2, o1) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
            }
            vo.setRelationBillList(relationOrderVOList);
        }
    }

    private void getSaleRefundAddrRespDto(SaleReturnOrderVO vo, SaleRefundAddrRespDto addrRespDto) {
        AddressVO addressVO = DtoExchangeUtils.createDtoBySource(addrRespDto, AddressVO.class);
        addressVO.setDistrict(addrRespDto.getCounty());
        addressVO.setDistrictCode(addrRespDto.getCountyCode());
        addressVO.setDetailAddress(addrRespDto.getReceiveAddress());
        vo.setOrderAddress(addressVO);
    }

    @Override
    public RestResponse<PageInfo<SaleReturnGoodsVO>> getSaleReturnOrderGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleReturnOrderGoodsListPageParams getSaleReturnOrderGoodsListPageParams) {
        if (StringUtils.isEmpty((CharSequence)getSaleReturnOrderGoodsListPageParams.getOrderId())) {
            throw new BizException("\u9500\u552e\u9000\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleRefundItemQueryApi.queryByPage(Long.valueOf(getSaleReturnOrderGoodsListPageParams.getOrderId()), getSaleReturnOrderGoodsListPageParams.getPageNum(), getSaleReturnOrderGoodsListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SaleReturnGoodsVO vo = new SaleReturnGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsCode(o.getItemCode());
            vo.setGoodsSku(o.getSkuCode());
            vo.setGoodsName(o.getItemName());
            vo.setGoodsNum(o.getItemNum());
            vo.setPlanLogicalWarehouseCode(o.getApplyRefundWarehouseCode());
            vo.setPlanLogicalWarehouseName(o.getApplyRefundWarehouseName());
            vo.setActualLogicalWarehouseCode(o.getRefundWarehouseCode());
            vo.setActualLogicalWarehouseName(o.getRefundWarehouseName());
            vo.setGiftFlag(ParamConverter.convertToString((Object)o.getGift()));
            vo.setUnitName(o.getItemUnit());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleReturnOrderVO>> getSaleReturnOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams getSaleReturnOrderListPageParams) {
        LOGGER.info("\u9500\u552e\u9000\u8d27\u5355\u5206\u9875\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)getSaleReturnOrderListPageParams));
        PageInfo saleRefundRespVoPageInfo = new PageInfo();
        if (this.saleRefundOrderEsQuery.booleanValue()) {
            saleRefundRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esSaleRefundQueryApi.querySaleRefundListPage(getSaleReturnOrderListPageParams));
        } else {
            LOGGER.info("\u62a5\u8868\u67e5\u8be2");
            EsSaleReturnOrderListPageParams pageParams = new EsSaleReturnOrderListPageParams();
            BeanUtils.copyProperties((Object)getSaleReturnOrderListPageParams, (Object)pageParams);
            PageInfo refundRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleRefundOrderListPage(pageParams));
            CubeBeanUtils.copyProperties((Object)saleRefundRespVoPageInfo, (Object)refundRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)refundRespVoPageInfo.getList())) {
                CubeBeanUtils.copyCollection(list, (Collection)refundRespVoPageInfo.getList(), SaleRefundRespVo.class);
            }
            saleRefundRespVoPageInfo.setList(list);
        }
        if (CollectionUtils.isEmpty((Collection)saleRefundRespVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)saleRefundRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = saleRefundRespVoPageInfo.getList().stream().map(p -> {
            SaleReturnOrderVO vo = new SaleReturnOrderVO();
            CubeBeanUtils.copyProperties((Object)vo, (Object)p, (String[])new String[0]);
            vo.setSaleReturnOrderNo(p.getSaleRefundNo());
            vo.setOrderStatus(p.getRefundStatus());
            vo.setReturnType(p.getRefundType());
            vo.setOutBizOrderNo(p.getPlatformRefundNo());
            if (Objects.nonNull(p.getPlatformRefundCreateTime())) {
                vo.setBizOrderCreateTime(DateUtil.format((Date)p.getPlatformRefundCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (Objects.nonNull(p.getBizDate())) {
                vo.setBizDateStr(DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setReturnCustomerName(p.getCustomerName());
            vo.setPlanLogicalWarehouseName(p.getApplyRefundWarehouseName());
            vo.setActualLogicalWarehouseName(p.getRefundWarehouseName());
            AddressVO addressVO = new AddressVO();
            addressVO.setProvince(p.getProvince());
            addressVO.setProvinceCode(p.getProvinceCode());
            addressVO.setCity(p.getCity());
            addressVO.setCityCode(p.getCityCode());
            addressVO.setDistrict(p.getCounty());
            addressVO.setDistrictCode(p.getCountyCode());
            addressVO.setDetailAddress(p.getReceiveAddress());
            vo.setOrderAddress(addressVO);
            vo.setReturnAddress(p.getReceiveAddress());
            vo.setContactPerson(p.getReceiveName());
            vo.setContactPhone(p.getReceivePhone());
            vo.setReturnAmount(StringUtils.isEmpty((CharSequence)p.getRefundTotalAmount()) ? null : new BigDecimal(p.getRefundTotalAmount()));
            if (Objects.nonNull(p.getActualRefundTime())) {
                vo.setActualReturnTime(DateUtil.format((Date)p.getActualRefundTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (Objects.nonNull(p.getCreateTime())) {
                vo.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setSaleOrganizationName(p.getSaleOrgName());
            vo.setGoodsTotalNum(p.getGoodsTotalNum());
            vo.setGoodsSkuTotalNum(p.getGoodsSkuTotalNum());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> addSaleReturnOrder(AddSaleReturnOrderParams addSaleReturnOrderParams) {
        LOGGER.info("\u65b0\u589e\u9500\u552e\u552e\u540e\u5355\uff1a{}", (Object)JSON.toJSONString((Object)addSaleReturnOrderParams));
        if (Objects.isNull(addSaleReturnOrderParams.getBizDate())) {
            addSaleReturnOrderParams.setBizDate(new Date());
        }
        BizSaleRefundReqDto bizSaleRefundRespDto = (BizSaleRefundReqDto)JSON.parseObject((String)JSONObject.toJSONString((Object)addSaleReturnOrderParams), BizSaleRefundReqDto.class);
        bizSaleRefundRespDto.setSaleRefundAddrReqDto((SaleRefundAddrReqDto)JSON.parseObject((String)JSONObject.toJSONString((Object)addSaleReturnOrderParams.getSaleRefundAddrReqDto()), SaleRefundAddrReqDto.class));
        bizSaleRefundRespDto.setSaleRefundOrderItemReqDtoList(JSONObject.parseArray((String)JSONObject.toJSONString(addSaleReturnOrderParams.getSaleRefundOrderItemReqDtoList()), SaleRefundItemReqDto.class));
        bizSaleRefundRespDto.setSourceType(SaleRefundSourceTypeEnum.MANUAL.getCode());
        bizSaleRefundRespDto.setPlatformRefundNo(String.valueOf(new Date().getTime()));
        bizSaleRefundRespDto.setPlatformRefundCreateTime(addSaleReturnOrderParams.getActualRefundTime());
        bizSaleRefundRespDto.setEasOrgId(bizSaleRefundRespDto.getOrganizationCode());
        CustomerRespDto customer = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(bizSaleRefundRespDto.getCustomerCode()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)customer), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f");
        bizSaleRefundRespDto.setEasCode(customer.getEasCode());
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("contactPersonName", bizSaleRefundRespDto.getContactPersonName());
        extMap.put("contactPhone", bizSaleRefundRespDto.getContactPhone());
        bizSaleRefundRespDto.setExtFields(extMap);
        BigDecimal totalNum = bizSaleRefundRespDto.getSaleRefundOrderItemReqDtoList().stream().map(SaleRefundItemReqDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        bizSaleRefundRespDto.setGoodsSkuTotalNum(totalNum);
        bizSaleRefundRespDto.setGoodsTotalNum(totalNum);
        bizSaleRefundRespDto.getSaleRefundOrderItemReqDtoList().forEach(item -> {
            item.setRefundWarehouseId(item.getApplyRefundWarehouseId());
            item.setRefundWarehouseCode(item.getApplyRefundWarehouseCode());
            item.setRefundWarehouseName(item.getApplyRefundWarehouseName());
            item.setOrganizationId(bizSaleRefundRespDto.getOrganizationId());
            item.setOrganizationCode(bizSaleRefundRespDto.getOrganizationCode());
        });
        bizSaleRefundRespDto.setApplyRefundWarehouseId(((SaleRefundItemReqDto)bizSaleRefundRespDto.getSaleRefundOrderItemReqDtoList().get(0)).getApplyRefundWarehouseId());
        bizSaleRefundRespDto.setApplyRefundWarehouseCode(((SaleRefundItemReqDto)bizSaleRefundRespDto.getSaleRefundOrderItemReqDtoList().get(0)).getApplyRefundWarehouseCode());
        bizSaleRefundRespDto.setApplyRefundWarehouseName(((SaleRefundItemReqDto)bizSaleRefundRespDto.getSaleRefundOrderItemReqDtoList().get(0)).getApplyRefundWarehouseName());
        RestResponseHelper.extractData((RestResponse)this.saleRefundApi.addSaleRefund(bizSaleRefundRespDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> invalidSaleReturnOrder(OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u9500\u552e\u9000\u8d27id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List refundIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        RestResponseHelper.extractData((RestResponse)this.saleRefundOptApi.batchInvalid(refundIdList));
        return RestResponse.VOID;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams params = new com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams.class);
        }
        params.setPageSize(commonReqDto.getPageSize());
        params.setPageNum(commonReqDto.getPageNum());
        RestResponse<PageInfo<SaleReturnOrderVO>> pageInfoRestResponse = this.getSaleReturnOrderListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(p -> {
                ExportSaleReturnOrderVO vo = new ExportSaleReturnOrderVO();
                CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)p, (String[])new String[0]);
                vo.setOrderStatus(SaleRefundStatusEnum.forCode((String)p.getOrderStatus()).getDesc());
                vo.setReturnType(RefundTypeEnum.getDescByCode(p.getReturnType()));
                if (Objects.nonNull(p.getBizOrderCreateTime())) {
                    vo.setBizOrderCreateTime(p.getBizOrderCreateTime());
                }
                vo.setGoodsTotalNum(Optional.ofNullable(p.getGoodsTotalNum()).orElse(BigDecimal.ZERO).intValue());
                vo.setReturnAmount(p.getReturnAmount().setScale(2, 4).doubleValue());
                if (Objects.nonNull(p.getActualReturnTime())) {
                    vo.setActualReturnTime(p.getActualReturnTime());
                }
                if (Objects.nonNull(p.getCreateTime())) {
                    vo.setCreateTime(p.getCreateTime());
                }
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams params = new com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), com.dtyunxi.cis.search.api.dto.request.EsSaleReturnOrderListPageParams.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        RestResponse<PageInfo<SaleReturnOrderVO>> pageInfoRestResponse = this.getSaleReturnOrderListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (null == respDtoPageInfo || CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

