/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportpurchaseReturnDetailReportVo;
import com.dtyunxi.cis.pms.biz.service.IReportCenterService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutOtherDetailReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapStatusCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutOtherDetailReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReportTabCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.OutPlannedOrderVO;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicInventorySnapQueryApi;
import com.dtyunxi.tcbj.api.query.ITransferOrderReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_purchase_return_detail_report")
public class ReportCenterServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements IReportCenterService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterServiceImpl.class);
    @Resource
    private ITransferOrderReportQueryApi transferOrderReportQueryApi;
    @Resource
    private IInventoryReportQueryApi inventoryReportQueryApi;
    @Resource
    private ILogicInventorySnapQueryApi logicInventorySnapQueryApi;

    @Override
    public RestResponse<PageInfo<TransferOrderReportRespDto>> internalDealReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isNotEmpty((Object)reqDto.getIfDelivery()) && reqDto.getIfDelivery() == 1) {
            return this.transferOrderReportQueryApi.internalDealOutReportPage(reqDto);
        }
        return this.transferOrderReportQueryApi.internalDealReportPage(reqDto);
    }

    @Override
    public RestResponse<ReportTabCountRespDto> internalDealReportCount(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868tab\u6570\u91cf\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.transferOrderReportQueryApi.internalDealReportCount(reqDto);
    }

    @Override
    public RestResponse<PageInfo<TransferOrderReportRespDto>> transferOrderDetailReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isNotEmpty((Object)reqDto.getIfDelivery()) && reqDto.getIfDelivery() == 1) {
            return this.transferOrderReportQueryApi.transferOrderDetailOutReportPage(reqDto);
        }
        return this.transferOrderReportQueryApi.transferOrderDetailReportPage(reqDto);
    }

    @Override
    public RestResponse<ReportTabCountRespDto> transferOrderDetailReportCount(TransferOrderReportReqDto reqDto) {
        return this.transferOrderReportQueryApi.transferOrderDetailReportCount(reqDto);
    }

    @Override
    public RestResponse<PageInfo<OutOtherDetailReportRespDto>> queryOutOtherDetailReportPage(OutOtherDetailReportQueryDto reqDto) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.inventoryReportQueryApi.queryOutOtherDetailReportPage(reqDto);
    }

    @Override
    public RestResponse<PageInfo<LogicInventorySnapRespDto>> queryLogicInventorySnapPage(LogicInventorySnapReqDto reqDto) {
        List inventoryList;
        RestResponse respPage = this.logicInventorySnapQueryApi.queryByPage(reqDto);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)respPage);
        StringJoiner sj = new StringJoiner("");
        if (ObjectUtil.isNotNull((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)(inventoryList = pageInfo.getList()))) {
            inventoryList.forEach(inventory -> {
                Long trayNum = inventory.getTrayNum();
                Integer bigBox = inventory.getBigBox();
                Integer boardNum = inventory.getBoardNum();
                if (ObjectUtil.equal((Object)0, (Object)trayNum)) {
                    sj.add("\u7801\u6258\u6570\u4e3a\u7a7a\uff1b");
                }
                if (ObjectUtil.equal((Object)0, (Object)bigBox)) {
                    sj.add("\u88c5\u7bb1\u6570\u4e3a\u7a7a\uff1b");
                }
                inventory.setErrorMsg(sj.toString());
            });
        }
        return respPage;
    }

    @Override
    public RestResponse<PageInfo<OutPlannedOrderVO>> purchaseReturnDetailReportPage(GetPurchaseReturnOrderListPageParams req) {
        logger.info("\u91c7\u8d2d\u9000\u8d27\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)req));
        req.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
        return this.transferOrderReportQueryApi.purchaseReturnDetailReportPage(req);
    }

    @Override
    public RestResponse<LogicInventorySnapStatusCountRespDto> queryLogicInventorySnapCount(LogicInventorySnapReqDto reqDto) {
        return this.logicInventorySnapQueryApi.count(reqDto);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetPurchaseReturnOrderListPageParams params = new GetPurchaseReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPurchaseReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPurchaseReturnOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.purchaseReturnDetailReportPage((GetPurchaseReturnOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportpurchaseReturnDetailReportVo vo = new ExportpurchaseReturnDetailReportVo();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setOrderStatus(Optional.ofNullable(item.getOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return item.getOrderStatus();
                }).orElse(""));
                vo.setOrderType("\u91c7\u8d2d\u4fc3\u9500\u7269\u6599\u9000\u8d27");
                vo.setPlanQuantity(item.getPlanQuantity().intValue());
                vo.setDoneQuantity(item.getDoneQuantity().intValue());
                vo.setWaitQuantity(item.getWaitQuantity().intValue());
                vo.setCreateTime(DateUtil.format((Date)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportpurchaseReturnDetailReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

