/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.constant.DischargedStatusEnum;
import com.dtyunxi.cis.pms.biz.dto.request.InspectionOptLogReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.InspectionRemarkTagQueryReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.InspectionRemarkTagReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.InspectionOptLogRespDto;
import com.dtyunxi.cis.pms.biz.dto.response.InspectionRemarkTagRespDto;
import com.dtyunxi.cis.pms.biz.enums.ReportResultEnum;
import com.dtyunxi.cis.pms.biz.enums.StatusEnum;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.AddInspectionToRegularRemarkParams;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetInspectionToRegularListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetOutQuantityOrderParams;
import com.dtyunxi.cis.pms.biz.model.GetSameWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportInspectionToRegularDto;
import com.dtyunxi.cis.pms.biz.model.ImportInspectionToRegularMsgVo;
import com.dtyunxi.cis.pms.biz.model.InspectionToRegularExportVO;
import com.dtyunxi.cis.pms.biz.model.InspectionToRegularOutQuantityOrderVO;
import com.dtyunxi.cis.pms.biz.model.InspectionToRegularVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.SubmitInspectionToRegularPassParams;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryInspectionToRegularService;
import com.dtyunxi.cis.pms.biz.service.IInspectionOptLogService;
import com.dtyunxi.cis.pms.biz.service.IInspectionRegularService;
import com.dtyunxi.cis.pms.biz.service.IInspectionRemarkTagService;
import com.dtyunxi.cis.pms.biz.service.ITransitHandlerService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QualityInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.RpInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInfoDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.dto.response.RpInventoryPreemptionRespDto;
import com.dtyunxi.tcbj.api.query.ICsInventoryPreemptionQueryApi;
import com.dtyunxi.tcbj.api.query.IQualityInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IQualityInspectionDataQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsQualityInfoDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsQualityInfoDetailQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderDetailQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsDeliveryNumDetailsQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.ReleaseOrderErrorRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_inspection_to_regular")
public class FinishedGoodsInventoryInspectionToRegularServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryInspectionToRegularService {
    private static final Logger log = LoggerFactory.getLogger(FinishedGoodsInventoryInspectionToRegularServiceServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryInspectionToRegularServiceServiceImpl.class);
    private static final String DEP_KEY = "finished_goodsinventory_inspection";
    private static final String PASS = "\u5408\u683c";
    private static final String UN_PASSED = "unPassed";
    private static final String BEFORE_PASS = "beforePass";
    @Resource
    private IQualityInfoQueryApi qualityInfoQueryApi;
    @Resource
    private ICsQualityInfoDetailApi csQualityInfoDetailApi;
    @Resource
    private ICsQualityInfoDetailQueryApi csQualityInfoDetailQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IInspectionRegularService iInspectionRegularService;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private ITransitHandlerService transitHandlerService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IInspectionOptLogService inspectionOptLogService;
    @Resource
    private IInspectionRemarkTagService inspectionRemarkTagService;
    @Resource
    private ICsInventoryPreemptionQueryApi csInventoryPreemptionQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsInPlannedOrderDetailQueryApi csInPlannedOrderDetailQueryApi;
    @Autowired
    IQualityInspectionDataQueryApi qualityInspectionDataQueryApi;
    @Autowired
    IInspectionReleaseOrderApi inspectionReleaseOrderApi;
    String msgTemp = "%s\u5f02\u5e38: \u4ed3\u5e93 %s, \u54c1 %s, \u6279\u6b21 %s, \u5931\u8d25\u539f\u56e0 %s";
    String msgTemp2 = "\u653e\u884c\u5f02\u5e38: \u54c1 %s, \u6279\u6b21 %s, \u5931\u8d25\u539f\u56e0:%s";
    private final FetchDataService<QualityInfoReqDto, QualityInfoDetailReqDto> qualityFetchDataService = req -> (PageInfo)this.qualityInfoQueryApi.infoDetailPage(req).getData();

    @Override
    public RestResponse<Void> addInspectionToRegularRemark(@ApiParam @Valid @RequestBody(required=false) List<AddInspectionToRegularRemarkParams> addInspectionToRegularRemarkParams) {
        ArrayList addList = Lists.newArrayList();
        AssertUtil.assertNotCollection(addInspectionToRegularRemarkParams, "id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        String userCode = ServiceContext.getContext().getRequestUserCode();
        for (AddInspectionToRegularRemarkParams addInspectionToRegularRemarkParam : addInspectionToRegularRemarkParams) {
            InspectionRemarkTagReqDto inspectionRemarkTagReqDto = new InspectionRemarkTagReqDto();
            inspectionRemarkTagReqDto.setBatchNo(addInspectionToRegularRemarkParam.getBatchNo());
            inspectionRemarkTagReqDto.setWarehouseCode(addInspectionToRegularRemarkParam.getWarehouseCode());
            inspectionRemarkTagReqDto.setSkuCode(addInspectionToRegularRemarkParam.getSkuCode());
            inspectionRemarkTagReqDto.setTagColour(addInspectionToRegularRemarkParam.getTagColour());
            inspectionRemarkTagReqDto.setRemark(addInspectionToRegularRemarkParam.getRemark());
            inspectionRemarkTagReqDto.setCreatePerson(userCode);
            inspectionRemarkTagReqDto.setUpdatePerson(userCode);
            inspectionRemarkTagReqDto.setId(addInspectionToRegularRemarkParam.getColourId());
            addList.add(inspectionRemarkTagReqDto);
        }
        this.inspectionRemarkTagService.addInspectionRemarkTagBatch(addList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> delInspectionToRegularRemark(@ApiParam @Valid @RequestBody(required=false) List<String> idList) {
        AssertUtil.assertNotCollection(idList, "id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> delIdList = idList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
        this.inspectionRemarkTagService.delInspectionRemarkTagBatch(delIdList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<InspectionRemarkTagRespDto> queryById(Long id) {
        InspectionOptLogRespDto inspectionOptLogRespDto = this.inspectionOptLogService.queryById(id);
        InspectionRemarkTagRespDto inspectionRemarkTagRespDto = new InspectionRemarkTagRespDto();
        BeanUtil.copyProperties((Object)((Object)inspectionOptLogRespDto), (Object)((Object)inspectionOptLogRespDto), (String[])new String[0]);
        return new RestResponse((Object)inspectionRemarkTagRespDto);
    }

    @Override
    public RestResponse<PageInfo<InspectionToRegularVO>> getInspectionToRegularListPage(@ApiParam @Valid @RequestBody(required=false) GetInspectionToRegularListPageParams getInspectionToRegularListPageParams) {
        QualityInfoReqDto reqDto = this.buildQuery(getInspectionToRegularListPageParams);
        if (Objects.equals(getInspectionToRegularListPageParams.getInspectionStatus(), BEFORE_PASS) && CollectionUtils.isEmpty((Collection)reqDto.getInventoryIds())) {
            return new RestResponse();
        }
        logger.info("reqDto,\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        if ((getInspectionToRegularListPageParams.getInspectionStatus().equals(BEFORE_PASS) || getInspectionToRegularListPageParams.getInspectionStatus().equals(UN_PASSED)) && StringUtils.isNotEmpty((CharSequence)getInspectionToRegularListPageParams.getWmsStatus())) {
            return new RestResponse();
        }
        PageInfo extractData = (PageInfo)RestResponseHelper.extractData((RestResponse)this.qualityInfoQueryApi.infoDetailPage(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)extractData.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        List list = extractData.getList();
        block16: for (QualityInfoDetailReqDto wms : list) {
            String wmsStatus = wms.getWmsStatus();
            if (!StringUtils.isNotEmpty((CharSequence)wmsStatus)) continue;
            switch (wmsStatus) {
                case "delivered": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
                case "wait_receive": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
                case "finish": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
                case "portion_receive": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
                case "portion_delivery": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
                case "hang_up": {
                    wms.setWmsStatus("\u6210\u529f");
                    continue block16;
                }
            }
            wms.setWmsStatus("-");
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)extractData, (String[])new String[]{"list", "navigatepageNums"});
        AtomicBoolean checkFlag = new AtomicBoolean(false);
        Set beforeInspectIds = null;
        if (reqDto.getDischargedStatus() != null) {
            beforeInspectIds = Optional.of(reqDto.getDischargedStatus()).filter(UN_PASSED::equals).map(s -> {
                checkFlag.set(true);
                return this.iInspectionRegularService.getBeforeInspectByIds(extractData.getList().stream().map(QualityInfoDetailReqDto::getId).collect(Collectors.toList()));
            }).orElse(Sets.newHashSet());
        }
        HashMap<Long, TwoTuple<Date, String>> tupleMap = new HashMap<Long, TwoTuple<Date, String>>(10);
        if (Objects.equals(getInspectionToRegularListPageParams.getInspectionStatus(), BEFORE_PASS)) {
            tupleMap.putAll(Optional.ofNullable(this.iInspectionRegularService.getAllBeforeInspect()).filter(CollectionUtils::isNotEmpty).map(ArrayList::new).map(this.iInspectionRegularService::getPersons).orElse(new HashMap(0)));
        }
        Set warehouseSet = extractData.getList().stream().map(QualityInfoDetailReqDto::getWarehouseCode).collect(Collectors.toSet());
        Set batchSet = extractData.getList().stream().map(QualityInfoDetailReqDto::getBatch).collect(Collectors.toSet());
        Set skuCodeSet = extractData.getList().stream().map(QualityInfoDetailReqDto::getLongCode).collect(Collectors.toSet());
        Map<String, InspectionRemarkTagRespDto> remarkTagMap = new HashMap<String, InspectionRemarkTagRespDto>();
        if (CollectionUtils.isNotEmpty(warehouseSet) || CollectionUtils.isNotEmpty(batchSet) || CollectionUtils.isNotEmpty(skuCodeSet)) {
            InspectionRemarkTagQueryReqDto queryReqDto = new InspectionRemarkTagQueryReqDto();
            queryReqDto.setBatchNoList(new ArrayList<String>(batchSet));
            queryReqDto.setWarehouseCodeList(new ArrayList<String>(warehouseSet));
            queryReqDto.setSkuCodeList(new ArrayList<String>(skuCodeSet));
            List<InspectionRemarkTagRespDto> remarkTagRespDtos = this.inspectionRemarkTagService.queryByParam(queryReqDto);
            if (CollectionUtils.isNotEmpty(remarkTagRespDtos)) {
                remarkTagMap = remarkTagRespDtos.stream().collect(Collectors.toMap(dto -> dto.getWarehouseCode() + "_" + dto.getSkuCode() + "_" + dto.getBatchNo(), Function.identity(), (k1, k2) -> k1));
            }
        }
        this.resultWrapper((PageInfo<QualityInfoDetailReqDto>)extractData, (PageInfo<InspectionToRegularVO>)pageInfo, checkFlag, beforeInspectIds, tupleMap, remarkTagMap);
        return new RestResponse((Object)pageInfo);
    }

    private void resultWrapper(PageInfo<QualityInfoDetailReqDto> extractData, PageInfo<InspectionToRegularVO> pageInfo, AtomicBoolean checkFlag, Set<Long> beforeInspectIds, Map<Long, TwoTuple<Date, String>> tupleMap, Map<String, InspectionRemarkTagRespDto> remarkTagMap) {
        List list = extractData.getList().stream().map(o -> this.buildVo(checkFlag, beforeInspectIds, tupleMap, (QualityInfoDetailReqDto)o, remarkTagMap)).collect(Collectors.toList());
        pageInfo.setList(list);
    }

    private InspectionToRegularVO buildVo(AtomicBoolean checkFlag, Set<Long> beforeInspectIds, Map<Long, TwoTuple<Date, String>> tupleMap, QualityInfoDetailReqDto o, Map<String, InspectionRemarkTagRespDto> remarkTagMap) {
        InspectionToRegularVO vo = new InspectionToRegularVO();
        BeanUtils.copyProperties((Object)o, (Object)vo);
        vo.setUpdateTime(Optional.ofNullable(o.getUpdateTime()).map(r -> DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)r)).orElse(""));
        Optional.ofNullable(tupleMap.get(o.getId())).ifPresent(t -> {
            vo.setUpdateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)((Date)t.getFirst())));
            vo.setUpdatePerson((String)t.getSecond());
        });
        vo.setPlanNo(o.getPlannedOrderNo());
        vo.setTransferOrderNo(o.getPlatformOrderNo());
        vo.setBatchNo(o.getBatch());
        vo.setGoodsLongCode(o.getLongCode());
        vo.setGoodsName(o.getCargoName());
        vo.setGoodsCode(o.getCargoCode());
        vo.setPlanQuantity(o.getQuantity() != null ? Integer.parseInt(o.getQuantity().setScale(0, RoundingMode.DOWN).toString()) : 0);
        vo.setOutQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, RoundingMode.DOWN).toString()) : 0);
        vo.setReportResult(o.getReportResult());
        vo.setReceiveReportTime(o.getReportTime());
        vo.setInspectionReport(o.getReportResultUrl());
        if (beforeInspectIds != null && checkFlag.get()) {
            vo.setInspectionStatus(beforeInspectIds.contains(o.getId()) ? BEFORE_PASS : o.getDischargedStatus());
        } else {
            vo.setInspectionStatus(o.getDischargedStatus());
        }
        String s = "1";
        String fail = "0";
        if (o.getPushWmsStatus() != null && s.equals(o.getPushWmsStatus())) {
            vo.setNotifyWmsStatus(s);
        } else if (o.getPushWmsStatus() != null && fail.equals(o.getPushWmsStatus())) {
            vo.setNotifyWmsStatus(fail);
        }
        vo.setIsPass(YesOrNoEnum.getDescByCode(o.getDischargedFlag()));
        vo.setDischargedReport(YesOrNoEnum.getDescByCode(o.getDischargedReport()));
        vo.setIsBatchUpsideDown(YesOrNoEnum.getDescByCode(o.getBatchUpsideFlag()));
        vo.setLogicalWarehouseName(o.getWarehouseName());
        vo.setLogicalWarehouseCode(o.getWarehouseCode());
        vo.setSpecifications(o.getSpecification());
        vo.setWarehousingTime(o.getProduceTime());
        String key = o.getWarehouseCode() + "_" + o.getLongCode() + "_" + o.getBatch();
        if (remarkTagMap.containsKey(key)) {
            InspectionRemarkTagRespDto remarkTagRespDto = remarkTagMap.get(key);
            vo.setTaglevel(remarkTagRespDto.getTagColour());
            vo.setRemark(remarkTagRespDto.getRemark());
            vo.setRemarkTagId(remarkTagRespDto.getId());
        }
        return vo;
    }

    private QualityInfoReqDto buildQuery(GetInspectionToRegularListPageParams getInspectionToRegularListPageParams) {
        QualityInfoReqDto reqDto = new QualityInfoReqDto();
        BeanUtils.copyProperties((Object)getInspectionToRegularListPageParams, (Object)reqDto);
        reqDto.setPlannedOrderNo(getInspectionToRegularListPageParams.getPlanNo());
        reqDto.setBatch(getInspectionToRegularListPageParams.getBatchNo());
        reqDto.setLongCode(getInspectionToRegularListPageParams.getGoodsLongCode());
        reqDto.setReportStatus(getInspectionToRegularListPageParams.getReportResult());
        reqDto.setCargoName(getInspectionToRegularListPageParams.getGoodsName());
        reqDto.setWarehouseCode(getInspectionToRegularListPageParams.getWarehouseCode());
        reqDto.setDischargedStatus(Optional.ofNullable(getInspectionToRegularListPageParams.getInspectionStatus()).filter(StringUtils::isNotBlank).orElse(UN_PASSED));
        String receiveReportTime = getInspectionToRegularListPageParams.getReceiveReportTime();
        if (receiveReportTime != null) {
            reqDto.setStartTime(receiveReportTime + " 00:00:00");
        }
        if (receiveReportTime != null) {
            reqDto.setEndTime(receiveReportTime + " 23:59:59");
        }
        reqDto.setWmsStatus(getInspectionToRegularListPageParams.getWmsStatus());
        if (UN_PASSED.equals(reqDto.getDischargedStatus()) && StringUtils.isNotEmpty((CharSequence)reqDto.getDischargedStatus())) {
            reqDto.setNotInventoryIds(this.iInspectionRegularService.getAllBeforeInspect());
        }
        if (Objects.equals(reqDto.getDischargedStatus(), BEFORE_PASS)) {
            reqDto.setInventoryIds(this.iInspectionRegularService.getAllBeforeInspect());
            reqDto.setDischargedStatus(UN_PASSED);
        }
        return reqDto;
    }

    @Override
    public RestResponse<PageInfo<InspectionToRegularOutQuantityOrderVO>> getInspectionToRegularOutQuantityOrder(@ApiParam @Valid @RequestBody(required=false) GetOutQuantityOrderParams getOutQuantityOrderParams) {
        CsDeliveryNumDetailsQueryDto queryDto = new CsDeliveryNumDetailsQueryDto();
        BeanUtils.copyProperties((Object)getOutQuantityOrderParams, (Object)queryDto);
        queryDto.setOrderNo(getOutQuantityOrderParams.getPlanNo());
        queryDto.setPageNum(getOutQuantityOrderParams.getPageNum());
        queryDto.setPageNum(getOutQuantityOrderParams.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csQualityInfoDetailQueryApi.getDeliveryNumDetails(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InspectionToRegularOutQuantityOrderVO vo = new InspectionToRegularOutQuantityOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBusinessOrderNo(o.getOrderNo());
            vo.setOutQuantity(ParamConverter.convertToInteger((Object)o.getDoneQuantity()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<ReleaseOrderErrorRespDto>> getInspectionToRegularPass(@ApiParam @Valid @RequestBody(required=false) SubmitInspectionToRegularPassParams submitInspectionToRegularPassParams) {
        ArrayList queryDtoList = Lists.newArrayList();
        for (InspectionToRegularVO inspectionToRegularVO : submitInspectionToRegularPassParams.getPlanIds()) {
            QualityInspectionDataReqDto queryDto = new QualityInspectionDataReqDto();
            queryDto.setLongCode(inspectionToRegularVO.getGoodsLongCode());
            queryDto.setBatch(inspectionToRegularVO.getBatchNo());
            queryDtoList.add(queryDto);
        }
        List qualityInspectionDataRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataQueryApi.queryByList((List)queryDtoList));
        ArrayList addDtoList = Lists.newArrayList();
        for (InspectionToRegularVO inspectionToRegularVO : submitInspectionToRegularPassParams.getPlanIds()) {
            InspectionReleaseOrderReqDto reqDto = new InspectionReleaseOrderReqDto();
            QualityInspectionDataRespDto qualityInspectionDataRespDto = qualityInspectionDataRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getLongCode(), (CharSequence)inspectionToRegularVO.getGoodsLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)inspectionToRegularVO.getBatchNo())).findFirst().orElse(null);
            if (null != qualityInspectionDataRespDto) {
                reqDto.setQualityInspectionNo(qualityInspectionDataRespDto.getExternalId());
                reqDto.setReportResult(qualityInspectionDataRespDto.getReportResult());
                reqDto.setQualityInspectionDate((Date)cn.hutool.core.date.DateUtil.parse((CharSequence)qualityInspectionDataRespDto.getReportTime()));
            }
            reqDto.setSkuCode(inspectionToRegularVO.getGoodsLongCode());
            reqDto.setSkuName(inspectionToRegularVO.getGoodsName());
            reqDto.setSkuSpec(inspectionToRegularVO.getSpecifications());
            reqDto.setBatch(inspectionToRegularVO.getBatchNo());
            addDtoList.add(reqDto);
        }
        List releaseOrderErrorRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderApi.batchAddInspectionReleaseOrder((List)addDtoList));
        return new RestResponse((Object)releaseOrderErrorRespDtoList);
    }

    @Override
    public RestResponse<List<ReleaseOrderErrorRespDto>> getInspectionToRegularPassExt(@ApiParam @Valid @RequestBody(required=false) SubmitInspectionToRegularPassParams submitInspectionToRegularPassParams) {
        ArrayList queryDtoList = Lists.newArrayList();
        for (InspectionToRegularVO inspectionToRegularVO : submitInspectionToRegularPassParams.getPlanIds()) {
            QualityInspectionDataReqDto queryDto = new QualityInspectionDataReqDto();
            queryDto.setLongCode(inspectionToRegularVO.getGoodsLongCode());
            queryDto.setBatch(inspectionToRegularVO.getBatchNo());
            queryDtoList.add(queryDto);
        }
        List qualityInspectionDataRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataQueryApi.queryByList((List)queryDtoList));
        List longCodeList = submitInspectionToRegularPassParams.getPlanIds().stream().map(InspectionToRegularVO::getGoodsLongCode).collect(Collectors.toList());
        List batchList = submitInspectionToRegularPassParams.getPlanIds().stream().map(InspectionToRegularVO::getBatchNo).collect(Collectors.toList());
        CsInPlannedOrderDetailQueryDto queryDto = new CsInPlannedOrderDetailQueryDto();
        queryDto.setLongCodeList(longCodeList);
        queryDto.setBatchList(batchList);
        log.info("\u67e5\u8be2\u8ba1\u5212\u6570\u91cf\u53d6\u8ba1\u5212\u7c7b\u6b63\u5411\u5165\u5e93\u5355\u636e\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        List csInPlannedOrderDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderDetailQueryApi.releaseQueryList(queryDto));
        Map csInPlannedOrderDetailRespDtoMap = Optional.ofNullable(csInPlannedOrderDetailRespDtoList).map(m -> {
            log.info("\u67e5\u8be2\u8ba1\u5212\u6570\u91cf\u53d6\u8ba1\u5212\u7c7b\u6b63\u5411\u5165\u5e93\u5355\u636e\u7684\u6570\u91cf\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)m));
            return m.stream().collect(Collectors.groupingBy(g -> g.getLongCode() + "_" + g.getBatch()));
        }).orElse(new HashMap());
        ArrayList addDtoList = Lists.newArrayList();
        for (InspectionToRegularVO inspectionToRegularVO : submitInspectionToRegularPassParams.getPlanIds()) {
            InspectionReleaseOrderReqDto reqDto = new InspectionReleaseOrderReqDto();
            QualityInspectionDataRespDto qualityInspectionDataRespDto = qualityInspectionDataRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getLongCode(), (CharSequence)inspectionToRegularVO.getGoodsLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)inspectionToRegularVO.getBatchNo())).findFirst().orElse(null);
            if (null != qualityInspectionDataRespDto) {
                reqDto.setQualityInspectionNo(qualityInspectionDataRespDto.getExternalId());
                reqDto.setReportResult(qualityInspectionDataRespDto.getReportResult());
                reqDto.setQualityInspectionDate((Date)cn.hutool.core.date.DateUtil.parse((CharSequence)qualityInspectionDataRespDto.getReportTime()));
            }
            reqDto.setSkuCode(inspectionToRegularVO.getGoodsLongCode());
            reqDto.setSkuName(inspectionToRegularVO.getGoodsName());
            reqDto.setSkuSpec(inspectionToRegularVO.getSpecifications());
            reqDto.setBatch(inspectionToRegularVO.getBatchNo());
            reqDto.setPlanReleaseNum(BigDecimal.ZERO);
            List plannedOrderDetailList = (List)csInPlannedOrderDetailRespDtoMap.get(reqDto.getSkuCode() + "_" + reqDto.getBatch());
            if (CollectionUtils.isNotEmpty((Collection)plannedOrderDetailList)) {
                List detailRespDtoList = plannedOrderDetailList.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getClosedFlag()) || f.getClosedFlag().equals("0")).collect(Collectors.toList());
                AssertUtil.isFalse(CollectionUtils.isNotEmpty(detailRespDtoList), "\u5b58\u5728\u5355\u636e\u672a\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
                BigDecimal reduce = plannedOrderDetailList.stream().map(CsInPlannedOrderDetailRespDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                reqDto.setPlanReleaseNum(reduce);
            }
            addDtoList.add(reqDto);
        }
        List releaseOrderErrorRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderApi.batchAddInspectionReleaseOrder((List)addDtoList));
        return new RestResponse((Object)releaseOrderErrorRespDtoList);
    }

    private String getResult(AtomicInteger counter, List<ITransitHandlerService.HandlerResult> results) {
        long count = results.stream().filter(ITransitHandlerService.HandlerResult::isSuccess).count();
        if (results.stream().allMatch(ITransitHandlerService.HandlerResult::isSuccess)) {
            String hint = "\u653e\u884c\u6210\u529f%s\u6761, \u9884\u653e\u884c\u6210\u529f%s\u6761";
            return String.format(hint, count, counter.get());
        }
        String failMsg = results.stream().map(ITransitHandlerService.HandlerResult::getMsg).filter(StringUtils::isNotBlank).collect(Collectors.joining(";\n"));
        int failCount = results.stream().map(ITransitHandlerService.HandlerResult::getMsg).filter(StringUtils::isNotBlank).collect(Collectors.toList()).size();
        String warning = "\u653e\u884c\u6210\u529f%s\u6761, \u9884\u653e\u884c\u6210\u529f%s\u6761, \u653e\u884c\u5931\u8d25%s\u6761 \n%s;";
        return String.format(warning, count, counter.get(), failCount, failMsg);
    }

    private List<ITransitHandlerService.HandlerResult> batchHandler(SubmitInspectionToRegularPassParams submitInspectionToRegularPassParams, AtomicInteger counter) {
        String userCode = ServiceContext.getContext().getRequestUserCode();
        ArrayList errorList = new ArrayList();
        return Optional.of(submitInspectionToRegularPassParams.getPlanIds().stream().filter(plan -> {
            plan.setUpdatePerson(userCode);
            if (StringUtils.isEmpty((CharSequence)plan.getInWarehouseCode())) {
                plan.setFailMsg("\u5f85\u68c0\u4ed3\u5e93\u5bf9\u5e94\u8f6c\u5408\u683c\u4ed3\u672a\u914d\u7f6e");
                errorList.add(plan);
                this.addInspectionToRegularOptLog((InspectionToRegularVO)plan, DischargedStatusEnum.UN_PASSED.getCode());
                return false;
            }
            if (StringUtils.isBlank((CharSequence)plan.getReportResult())) {
                boolean b = this.iInspectionRegularService.saveBeforeInspectId(plan.getId());
                if (b) {
                    counter.incrementAndGet();
                    this.addInspectionToRegularOptLog((InspectionToRegularVO)plan, DischargedStatusEnum.BEFORE_PASS.getCode());
                } else {
                    plan.setFailMsg("\u672a\u51fa\u62a5\u544a");
                    errorList.add(plan);
                    this.addInspectionToRegularOptLog((InspectionToRegularVO)plan, DischargedStatusEnum.UN_PASSED.getCode());
                }
                return false;
            }
            if (!PASS.equals(plan.getReportResult())) {
                plan.setFailMsg("\u8d28\u68c0\u62a5\u544a\u4e0d\u901a\u8fc7");
                errorList.add(plan);
                this.addInspectionToRegularOptLog((InspectionToRegularVO)plan, DischargedStatusEnum.UN_PASSED.getCode());
                return false;
            }
            Boolean flag = this.cacheService.setIfAbsent("finished_goodsinventory_inspection:" + plan.getId(), (Object)1, 60);
            if (!flag.booleanValue()) {
                plan.setFailMsg("\u64cd\u4f5c\u9891\u7e41");
                errorList.add(plan);
                this.addInspectionToRegularOptLog((InspectionToRegularVO)plan, DischargedStatusEnum.UN_PASSED.getCode());
            }
            return flag;
        }).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).map(plans -> {
            List<Long> dataIds = plans.stream().map(InspectionToRegularVO::getId).collect(Collectors.toList());
            List<QualityInfoDetailReqDto> qualityInfoDetailResp = this.loadQualityInfoDetails(dataIds);
            Set filterIdSet = qualityInfoDetailResp.stream().map(QualityInfoDetailReqDto::getId).collect(Collectors.toSet());
            List results = plans.stream().filter(r -> !filterIdSet.contains(r.getId())).map(this::buildResult).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                results.addAll(errorList.stream().map(this::buildResultError).collect(Collectors.toList()));
            }
            results.addAll(qualityInfoDetailResp.stream().map(this::buildInspectionToRegularVO).map(this::handler).collect(Collectors.toList()));
            return results;
        }).orElse(errorList.stream().map(this::buildResultError).collect(Collectors.toList()));
    }

    private void addInspectionToRegularOptLog(InspectionToRegularVO qualityInfo, String dischargedStatus) {
        logger.info("addInspectionToRegularOptLog==>{}", (Object)JSON.toJSONString((Object)qualityInfo));
        String transferOrderNo = qualityInfo.getTransferOrderNo();
        if (StringUtils.isNotEmpty((CharSequence)transferOrderNo) && transferOrderNo.contains("DBDJ")) {
            CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
            csTransferOrderReqDto.setPreOrderNo(transferOrderNo);
            logger.info("\u6839\u636e\u8ba1\u5212\u5355\u53f7\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f");
            try {
                List csTransferOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryTransferOrderList(csTransferOrderReqDto));
                if (CollectionUtils.isNotEmpty((Collection)csTransferOrderRespDtos)) {
                    transferOrderNo = ((CsTransferOrderRespDto)csTransferOrderRespDtos.get(0)).getTransferOrderNo();
                }
            }
            catch (Exception e) {
                logger.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
        InspectionOptLogReqDto addLogDto = new InspectionOptLogReqDto();
        addLogDto.setBatchNo(qualityInfo.getBatchNo());
        addLogDto.setItemName(qualityInfo.getGoodsName());
        addLogDto.setSkuCode(qualityInfo.getGoodsLongCode());
        addLogDto.setInspectionStatus(dischargedStatus);
        addLogDto.setTransferOrderNo(transferOrderNo);
        addLogDto.setOptPerson(qualityInfo.getUpdatePerson());
        addLogDto.setOptTime(new Date());
        addLogDto.setFailMsg(qualityInfo.getFailMsg());
        addLogDto.setNum(qualityInfo.getPlanQuantity());
        this.inspectionOptLogService.addInspectionOptLog(addLogDto);
    }

    private ITransitHandlerService.HandlerResult buildResult(InspectionToRegularVO inspectionToRegularVO) {
        String preemptionOrderNo = "";
        try {
            RpInventoryPreemptionQueryDto preemptionQueryDto = new RpInventoryPreemptionQueryDto();
            preemptionQueryDto.setBatch(inspectionToRegularVO.getBatchNo());
            preemptionQueryDto.setCargoCode(inspectionToRegularVO.getGoodsLongCode());
            preemptionQueryDto.setValid(StatusEnum.ENABLE.getDesc());
            preemptionQueryDto.setPageNum(Integer.valueOf(1));
            preemptionQueryDto.setPageSize(Integer.valueOf(200));
            logger.info("\u653e\u884c\u67e5\u8be2\u9884\u5360\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)preemptionQueryDto));
            PageInfo preemptionRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryPreemptionQueryApi.queryPage(preemptionQueryDto));
            if (CollectionUtils.isNotEmpty((Collection)preemptionRespDtoPageInfo.getList())) {
                preemptionOrderNo = preemptionRespDtoPageInfo.getList().stream().map(RpInventoryPreemptionRespDto::getSourceNo).collect(Collectors.joining(","));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String errorMsg = "\u5b58\u5728\u9884\u5360";
        if (StringUtils.isNotEmpty((CharSequence)preemptionOrderNo)) {
            errorMsg = errorMsg + ":" + preemptionOrderNo;
        }
        String failMsg = String.format(this.msgTemp2, inspectionToRegularVO.getGoodsLongCode(), inspectionToRegularVO.getBatchNo(), errorMsg);
        inspectionToRegularVO.setFailMsg(errorMsg);
        this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.UN_PASSED.getCode());
        return new ITransitHandlerService.HandlerResult(failMsg, false);
    }

    private ITransitHandlerService.HandlerResult buildResultError(InspectionToRegularVO inspectionToRegularVO) {
        String failMsg = String.format(this.msgTemp2, inspectionToRegularVO.getGoodsLongCode(), inspectionToRegularVO.getBatchNo(), inspectionToRegularVO.getFailMsg());
        return new ITransitHandlerService.HandlerResult(failMsg, false);
    }

    @Override
    public ITransitHandlerService.HandlerResult handler(InspectionToRegularVO inspectionToRegularVO) {
        logger.info("\u653e\u884c\u8bb0\u5f55:{}", (Object)inspectionToRegularVO.getId());
        LogicWarehouseRespDto logicWarehouseRespDto = this.inventoryTransferHelper.getLogicWarehouseByCode(inspectionToRegularVO.getLogicalWarehouseCode());
        AssertUtil.isTrue(logicWarehouseRespDto != null, "\u7528\u6237\u4e0d\u5b58\u5728\u6539\u8c03\u5165\u4ed3\u5e93\u6570\u636e\u6743\u9650");
        if (inspectionToRegularVO.getPreempt() != null && inspectionToRegularVO.getPreempt().compareTo(BigDecimal.ZERO) > 0) {
            String failMsg = String.format(this.msgTemp, "\u653e\u884c", inspectionToRegularVO.getLogicalWarehouseCode(), inspectionToRegularVO.getGoodsLongCode(), inspectionToRegularVO.getBatchNo(), "\u5b58\u5728\u9884\u5360\u6570");
            inspectionToRegularVO.setFailMsg("\u5b58\u5728\u9884\u5360\u6570");
            this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.UN_PASSED.getCode());
            return new ITransitHandlerService.HandlerResult(failMsg, false);
        }
        if (Objects.equals(CsWarehouseClassifyEnum.IN_TRANSIT.getCode(), logicWarehouseRespDto.getWarehouseClassify())) {
            return this.transitHandler(inspectionToRegularVO, logicWarehouseRespDto);
        }
        return this.inspectionHandler(inspectionToRegularVO);
    }

    private ITransitHandlerService.HandlerResult inspectionHandler(InspectionToRegularVO inspectionToRegularVO) {
        try {
            this.inventoryTransferHelper.addTransferThrow(inspectionToRegularVO, CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED, false, true);
            this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.PASSED.getCode());
            return ITransitHandlerService.HandlerResult.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = String.format(this.msgTemp, "\u5f85\u68c0\u8f6c\u5408\u683c\u653e\u884c", inspectionToRegularVO.getLogicalWarehouseCode(), inspectionToRegularVO.getGoodsLongCode(), inspectionToRegularVO.getBatchNo(), e.getMessage());
            log.error(msg);
            inspectionToRegularVO.setFailMsg(e.getMessage());
            this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.UN_PASSED.getCode());
            return new ITransitHandlerService.HandlerResult(msg, false);
        }
    }

    private ITransitHandlerService.HandlerResult transitHandler(InspectionToRegularVO inspectionToRegularVO, LogicWarehouseRespDto logicWarehouseRespDto) {
        try {
            this.transitHandlerService.inTransitHandler(inspectionToRegularVO, logicWarehouseRespDto);
            this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.PASSED.getCode());
            return ITransitHandlerService.HandlerResult.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = String.format(this.msgTemp, "\u653e\u884c\u5728\u9014", inspectionToRegularVO.getLogicalWarehouseCode(), inspectionToRegularVO.getGoodsLongCode(), inspectionToRegularVO.getBatchNo(), e.getMessage());
            log.error(msg);
            inspectionToRegularVO.setFailMsg(e.getMessage());
            this.addInspectionToRegularOptLog(inspectionToRegularVO, DischargedStatusEnum.UN_PASSED.getCode());
            return new ITransitHandlerService.HandlerResult(msg, false);
        }
    }

    @Override
    public RestResponse<List<PhysicalWarehouseVO>> getInspectionToRegularWarehouse(@ApiParam @Valid @RequestBody(required=false) GetSameWarehouseListPageParams getSameWarehouseListPageParams) {
        List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csQualityInfoDetailQueryApi.queryReleaseWarehouse(getSameWarehouseListPageParams.getPlanNo()));
        if (CollectionUtils.isNotEmpty((Collection)warehouseRespDtoList)) {
            List list = warehouseRespDtoList.stream().map(o -> {
                PhysicalWarehouseVO vo = new PhysicalWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setWarehouseId(ParamConverter.convertToString((Object)o.getWarehouseId()));
                vo.setWarehouseName(o.getWarehouseName());
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportInspectionToRegularDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet longCodeSet = Sets.newHashSet();
        list.forEach(o -> {
            o.setLongCode(o.getLongCode().replace(" ", ""));
            o.setBatchNo(o.getBatchNo().replace(" ", ""));
            String longCode = o.getLongCode();
            if (dataMap.containsKey(longCode)) {
                longCodeSet.add(longCode);
            } else {
                dataMap.put(longCode, o);
            }
        });
        Map<String, PcpItemRespDto> itemRespDtoMap = this.getStringPcpItemRespDtoMap(list);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            ImportInspectionToRegularMsgVo msgVo = new ImportInspectionToRegularMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (longCodeSet.contains(longCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            }
            CsQualityInfoDetailReqDto qualityInfoDetailReqDto = new CsQualityInfoDetailReqDto();
            this.checkInspectionToRegularItem(itemRespDtoMap, (ImportInspectionToRegularDto)((Object)o), msgVo, qualityInfoDetailReqDto);
            QualityInfoReqDto reqDto = new QualityInfoReqDto();
            reqDto.setBatch(o.getBatchNo());
            reqDto.setLongCode(o.getLongCode());
            PageInfo extractData = (PageInfo)RestResponseHelper.extractData((RestResponse)this.qualityInfoQueryApi.infoDetailPage(reqDto));
            this.checkInspectionToRegularItemAndBatch((PageInfo<QualityInfoDetailReqDto>)extractData, (ImportInspectionToRegularDto)((Object)o), msgVo, qualityInfoDetailReqDto);
            if (Objects.isNull(ReportResultEnum.getDescByCode(o.getReportResult()))) {
                if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                    msgVo.setMsg("\u62a5\u544a\u7ed3\u679c\u683c\u5f0f\u9519\u8bef");
                } else {
                    msgVo.setMsg(msgVo.getMsg() + ";\u62a5\u544a\u7ed3\u679c\u683c\u5f0f\u9519\u8bef");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                saveList.add(qualityInfoDetailReqDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private Map<String, PcpItemRespDto> getStringPcpItemRespDtoMap(List<ImportInspectionToRegularDto> list) {
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(list.stream().map(ImportInspectionToRegularDto::getLongCode).collect(Collectors.toList())));
        return pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
    }

    private void checkInspectionToRegularItemAndBatch(PageInfo<QualityInfoDetailReqDto> extractData, ImportInspectionToRegularDto o, ImportInspectionToRegularMsgVo msgVo, CsQualityInfoDetailReqDto qualityInfoDetailReqDto) {
        if (CollectionUtil.isNotEmpty((Collection)extractData.getList())) {
            qualityInfoDetailReqDto.setBatch(o.getBatchNo());
            qualityInfoDetailReqDto.setLongCode(o.getLongCode());
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    private void checkInspectionToRegularItem(Map<String, PcpItemRespDto> itemRespDtoMap, ImportInspectionToRegularDto o, ImportInspectionToRegularMsgVo msgVo, CsQualityInfoDetailReqDto qualityInfoDetailReqDto) {
        if (CollectionUtil.isNotEmpty(itemRespDtoMap) && itemRespDtoMap.containsKey(o.getLongCode())) {
            qualityInfoDetailReqDto.setLongCode(o.getLongCode());
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            saveList.forEach(o -> RestResponseHelper.extractData((RestResponse)this.csQualityInfoDetailApi.modifyCsQualityInfoDetail(o)));
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5f85\u68c0\u8f6c\u5408\u683c\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportInspectionToRegularMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetInspectionToRegularListPageParams params = new GetInspectionToRegularListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInspectionToRegularListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInspectionToRegularListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo data = (PageInfo)this.getInspectionToRegularListPage((GetInspectionToRegularListPageParams)re).getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)data, (Object)im);
            im.setList(data.getList().stream().map(in -> {
                InspectionToRegularExportVO regularExportVO = (InspectionToRegularExportVO)((Object)((Object)((Object)BeanUtil.copyProperties((Object)in, InspectionToRegularExportVO.class, (String[])new String[0]))));
                regularExportVO.setInspectionStatus(Optional.ofNullable(in.getInspectionStatus()).filter(StringUtils::isNotBlank).map(type -> {
                    switch (type) {
                        case "unPassed": {
                            return "\u5f85\u653e\u884c";
                        }
                        case "beforePass": {
                            return "\u9884\u653e\u884c";
                        }
                        case "passed": {
                            return "\u5df2\u653e\u884c";
                        }
                    }
                    return "";
                }).orElse(""));
                regularExportVO.setInQuantity(String.valueOf(Optional.ofNullable(in.getOutQuantity()).orElse(0)));
                regularExportVO.setNotifyWmsStatus(Optional.ofNullable(in.getWmsStatus()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "1": {
                            return "\u6210\u529f";
                        }
                        case "0": {
                            return "\u5931\u8d25";
                        }
                    }
                    return r;
                }).orElse(""));
                return regularExportVO;
            }).collect(Collectors.toList()));
            return im;
        }, params, InspectionToRegularExportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetInspectionToRegularListPageParams params = new GetInspectionToRegularListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInspectionToRegularListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInspectionToRegularListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getInspectionToRegularListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public List<QualityInfoDetailReqDto> loadQualityInfoDetails(List<Long> allBeforeInspect) {
        QualityInfoReqDto qualityInfoReqDto = new QualityInfoReqDto();
        qualityInfoReqDto.setInventoryIds(allBeforeInspect);
        return Optional.of(this.qualityFetchDataService.fetchAll(qualityInfoReqDto)).filter(CollectionUtils::isNotEmpty).map(r -> r.stream().collect(Collectors.groupingBy(QualityInfoDetailReqDto::getId)).values().stream().flatMap(Collection::stream).collect(Collectors.toList())).map(qualityInfoDetailReqDtos -> {
            QualityInfoReqDto appendReqDto = new QualityInfoReqDto();
            Set uniKeySet = qualityInfoDetailReqDtos.stream().map(this::getGroupKey).collect(Collectors.toSet());
            appendReqDto.setLongCodes(qualityInfoDetailReqDtos.stream().map(QualityInfoDetailReqDto::getLongCode).distinct().collect(Collectors.toList()));
            appendReqDto.setBatchs(qualityInfoDetailReqDtos.stream().map(QualityInfoDetailReqDto::getBatch).distinct().collect(Collectors.toList()));
            appendReqDto.setNotInventoryIds(allBeforeInspect);
            List appendData = this.qualityFetchDataService.fetchAll(appendReqDto).stream().filter(r -> uniKeySet.contains(this.getGroupKey((QualityInfoDetailReqDto)r))).collect(Collectors.toList());
            qualityInfoDetailReqDtos.addAll(appendData);
            return this.filterQualityData((List<QualityInfoDetailReqDto>)qualityInfoDetailReqDtos);
        }).orElse(Lists.newArrayList());
    }

    private List<QualityInfoDetailReqDto> filterQualityData(List<QualityInfoDetailReqDto> qualityInfoDetailReqDtos) {
        Set filterIdSet = qualityInfoDetailReqDtos.stream().collect(Collectors.groupingBy(this::getGroupKey)).entrySet().stream().filter(r -> ((List)r.getValue()).stream().anyMatch(inspectionToRegularVO -> inspectionToRegularVO.getPreempt() != null && inspectionToRegularVO.getPreempt().compareTo(BigDecimal.ZERO) > 0)).flatMap(r -> ((List)r.getValue()).stream().map(QualityInfoDetailReqDto::getId)).collect(Collectors.toSet());
        return new ArrayList<QualityInfoDetailReqDto>(qualityInfoDetailReqDtos.stream().filter(r -> !filterIdSet.contains(r.getId())).collect(Collectors.toList()).stream().collect(Collectors.toMap(QualityInfoDetailReqDto::getId, Function.identity(), (o, o1) -> o)).values());
    }

    private String getGroupKey(QualityInfoDetailReqDto r) {
        return r.getLongCode() + "_" + r.getBatch();
    }

    @Override
    public InspectionToRegularVO buildInspectionToRegularVO(QualityInfoDetailReqDto p) {
        InspectionToRegularVO inspectionToRegularVo = (InspectionToRegularVO)BeanUtil.copyProperties((Object)p, InspectionToRegularVO.class, (String[])new String[0]);
        inspectionToRegularVo.setBatchNo(p.getBatch());
        inspectionToRegularVo.setPreempt(p.getPreempt());
        inspectionToRegularVo.setGoodsLongCode(p.getLongCode());
        inspectionToRegularVo.setGoodsCode(p.getLongCode());
        inspectionToRegularVo.setInQuantity(p.getQuantity().intValue());
        inspectionToRegularVo.setPlanQuantity(p.getQuantity().intValue());
        inspectionToRegularVo.setGoodsName(p.getCargoName());
        inspectionToRegularVo.setLogicalWarehouseCode(p.getWarehouseCode());
        return inspectionToRegularVo;
    }

    @Override
    public void handlerAll(List<Long> allBeforeInspect) {
        this.loadQualityInfoDetails(allBeforeInspect).stream().filter(p -> PASS.equals(p.getReportResult()) && this.cacheService.setIfAbsent("finished_goodsinventory_inspection:" + p, (Object)1, 60) != false).forEach(this::doSave);
    }

    @Override
    public RestResponse<String> rollback(List<InspectionToRegularVO> planIds) {
        RestResponse response = new RestResponse();
        ArrayList errorList = Lists.newArrayList();
        for (InspectionToRegularVO inspectionToRegularVO : planIds) {
            try {
                RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderApi.cancel(inspectionToRegularVO.getId()));
            }
            catch (Exception e) {
                errorList.add(e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            response.setResultCode("100000");
            response.setResultMsg(StringUtils.join((Iterable)errorList, (String)";"));
        }
        return response;
    }

    private void doSave(QualityInfoDetailReqDto p) {
        log.info("\u6210\u529f\u653e\u884c\u8bb0\u5f55:{}", (Object)p.getId());
        this.iInspectionRegularService.removeByIds(Collections.singletonList(p.getId()));
        this.iInspectionRegularService.removeUpdateByIds(Collections.singletonList(p.getId()));
        try {
            this.handler(this.buildInspectionToRegularVO(p));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u653e\u884c\u8bb0\u5f55\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

