/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.BusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.OperationalTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.OrderSrcEnum;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOtherInVO;
import com.dtyunxi.cis.pms.biz.model.GetOtherInListBody;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherInVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OtherInGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherInVO;
import com.dtyunxi.cis.pms.biz.model.SubmitOtherInBody;
import com.dtyunxi.cis.pms.biz.model.SubmitOtherInBodyGoodsList;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryOtherInService;
import com.dtyunxi.cis.pms.biz.service.helper.DataCheckHelper;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryOtherHelper;
import com.dtyunxi.cis.pms.biz.service.helper.meta.InventoryOtherMetaVo;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.EsOtherStorageOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.CsOtherStorageOrderRespVo;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsStorageAuditRecordApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.commons.utils.LogUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_other_in_warehousing")
public class FinishedGoodsInventoryOtherInServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryOtherInService {
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryOtherInServiceServiceImpl.class);
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ICsStorageAuditRecordApi csStorageAuditRecordQueryApi;
    @Resource
    private ICsOtherStorageOrderDetailApi csOtherStorageOrderDetailQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private InventoryOtherHelper inventoryOtherHelper;
    @Resource
    private DataCheckHelper dataCheckHelper;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherInVO.class);
        return this.executorImport(list, this.getInventoryOtherMetaVo(list));
    }

    private InventoryOtherMetaVo getInventoryOtherMetaVo(List<ImportOtherInVO> list) {
        HashSet whCodes = Sets.newHashSet();
        HashSet itemCodes = Sets.newHashSet();
        HashSet costCenterCodes = Sets.newHashSet();
        list.forEach(i -> {
            whCodes.add(i.getWarehouseCode());
            itemCodes.add(i.getItemCode());
            costCenterCodes.add(i.getCostCode());
        });
        return this.inventoryOtherHelper.getInventoryOtherMetaVo(whCodes, itemCodes, null, costCenterCodes, "other_in", null);
    }

    private Map<String, CsLogicWarehousePageRespDto> getLogicWarehouseMap(Set<String> whCodes) {
        CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
        csLogicWarehouseParamQueryDto.setWarehouseCodeList(new ArrayList<String>(whCodes));
        List csLogicWarehousePageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(csLogicWarehouseParamQueryDto));
        if (CollectionUtil.isEmpty((Collection)csLogicWarehousePageRespDtoList)) {
            return null;
        }
        return csLogicWarehousePageRespDtoList.stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private TwoTuple<List<CsOtherStorageOrderComboReqDto>, List<ImportOtherInVO>> executorImport(List<ImportOtherInVO> list, InventoryOtherMetaVo inventoryOtherMetaVo) {
        ArrayList saveList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        Map<String, List<ImportOtherInVO>> grounp = list.stream().collect(Collectors.groupingBy(importOtherInVO -> StringUtils.isNotBlank((CharSequence)importOtherInVO.getPlatformOrderCode()) ? importOtherInVO.getPlatformOrderCode() : "DEFUALT_CODE_2022111652_" + importOtherInVO.getWarehouseCode()));
        grounp.forEach((k, v) -> {
            if (this.isVaild(inventoryOtherMetaVo, msgList, (String)k, (List<ImportOtherInVO>)v)) {
                msgList.addAll(v);
                return;
            }
            saveList.add(this.transferOrder(inventoryOtherMetaVo, (String)k, (List<ImportOtherInVO>)v));
        });
        return new TwoTuple((Object)saveList, (Object)msgList);
    }

    private CsOtherStorageOrderComboReqDto transferOrder(InventoryOtherMetaVo inventoryOtherMetaVo, String k, List<ImportOtherInVO> v) {
        ImportOtherInVO importOtherInVO = v.get(0);
        logger.info("\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u53c2\u6570\u7ec4\u88c5\uff1a{}", (Object)JSON.toJSONString((Object)((Object)importOtherInVO)));
        CsOtherStorageOrderComboReqDto orderComboReqDto = new CsOtherStorageOrderComboReqDto();
        CsOtherStorageOrderReqDto orderReqDto = new CsOtherStorageOrderReqDto();
        BeanUtil.copyProperties((Object)((Object)importOtherInVO), (Object)orderReqDto, (String[])new String[]{"businessType"});
        CsBusinessTypeRespDto typeRespDto = inventoryOtherMetaVo.getTypeMap().get(importOtherInVO.getTypeName());
        orderReqDto.setBusinessType(typeRespDto.getId());
        orderReqDto.setBusinessTypeName(typeRespDto.getBusinessTypeName());
        orderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_IN.getCode());
        orderReqDto.setOrderSrc(OrderSrcEnum.PCP.getDesc());
        orderReqDto.setCostCenterCode(importOtherInVO.getCostCode());
        orderReqDto.setSourceSystem(OrderSrcEnum.PCP.getCode());
        orderReqDto.setExternalOrderNo(importOtherInVO.getPlatformOrderCode());
        orderReqDto.setBusinessTypeName(importOtherInVO.getTypeName());
        orderReqDto.setIsSendEas(Integer.valueOf("\u662f".equals(importOtherInVO.getEasPush()) ? 1 : 0));
        if (k.startsWith("DEFUALT_CODE_2022111652")) {
            orderReqDto.setPreOrderNo(this.inventoryOtherHelper.codeGenerate("OTI"));
        } else {
            orderReqDto.setPreOrderNo(k);
        }
        LogicWarehouseRespDto warehouseRespDto = inventoryOtherMetaVo.getWarehouseCodeMap().get(importOtherInVO.getWarehouseCode());
        orderReqDto.setWarehouseName(warehouseRespDto.getWarehouseName());
        orderReqDto.setWarehouseId(warehouseRespDto.getId());
        orderReqDto.setBizDate(importOtherInVO.getBizDate());
        orderComboReqDto.setCsOtherStorageOrderReqDto(orderReqDto);
        orderComboReqDto.setDetailList(v.stream().map(item -> {
            CsOtherStorageOrderDetailReqDto detail = new CsOtherStorageOrderDetailReqDto();
            detail.setLongCode(item.getItemCode());
            detail.setQuantity(item.getNum());
            PcpItemRespDto pcpItemRespDto = inventoryOtherMetaVo.getItemMap().get(item.getItemCode());
            detail.setCargoName(pcpItemRespDto.getName());
            detail.setVolume(pcpItemRespDto.getVolume());
            detail.setSpecification(pcpItemRespDto.getSpecification());
            detail.setCargoName(pcpItemRespDto.getName());
            detail.setCreatePerson(pcpItemRespDto.getCreatePerson());
            detail.setCreateTime(pcpItemRespDto.getCreateTime());
            return detail;
        }).collect(Collectors.toList()));
        return orderComboReqDto;
    }

    private boolean isVaild(InventoryOtherMetaVo inventoryOtherMetaVo, List<ImportOtherInVO> msgList, String k, List<ImportOtherInVO> v) {
        try {
            return !this.vaildCheck(k, v, inventoryOtherMetaVo);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean vaildCheck(String k, List<ImportOtherInVO> list, InventoryOtherMetaVo inventoryOtherMetaVo) throws IllegalAccessException {
        ImportOtherInVO importOtherOutVO = list.get(0);
        logger.info("\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u9a8c\u8bc1\uff1a{}", (Object)JSON.toJSONString((Object)((Object)importOtherOutVO)));
        if (!this.checkNullField(list, importOtherOutVO)) {
            return false;
        }
        if (!this.compareListData(list, importOtherOutVO, Lists.newArrayList((Object[])new String[]{"quantity", "itemCode"}))) {
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getItemMap().get(importOtherOutVO.getItemCode()))) {
            this.setErrMsg(list, "\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getWarehouseCodeMap().get(importOtherOutVO.getWarehouseCode()))) {
            this.setErrMsg(list, "\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getTypeMap().get(importOtherOutVO.getTypeName()))) {
            this.setErrMsg(list, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return false;
        }
        if (!this.vaildBizDate(importOtherOutVO)) {
            this.setErrMsg(list, "\u5176\u4ed6\u5165\u5e93\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)importOtherOutVO.getCostCode())) {
            return true;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getCostCenterMap().get(importOtherOutVO.getCostCode()))) {
            this.setErrMsg(list, "\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.equals(inventoryOtherMetaVo.getCostCenterMap().get(importOtherOutVO.getCostCode()).getWarehouseCode(), importOtherOutVO.getCostCode())) {
            this.setErrMsg(list, "\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3");
            return false;
        }
        return true;
    }

    private boolean vaildBizDate(ImportOtherInVO vo) {
        logger.info("\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u8d4b\u503c\u4e1a\u52a1\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getBizDateStr())) {
                vo.setBizDate(DateUtil.parse((String)vo.getBizDateStr(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean checkNullField(List<ImportOtherInVO> list, ImportOtherInVO importOtherOutVO) throws IllegalAccessException {
        for (ImportOtherInVO otherOutVO : list) {
            DataCheckHelper.CheckResultVo checkResultVo = this.dataCheckHelper.checkNullField(otherOutVO);
            if (checkResultVo.isSuccess()) continue;
            list.forEach(d -> d.setMsg(checkResultVo.getErrorMsg()));
            return false;
        }
        return true;
    }

    public boolean compareListData(List<ImportOtherInVO> list, ImportOtherInVO importOtherOutVO, List<String> writeList) throws IllegalAccessException {
        DataCheckHelper.CheckResultVo checkResultVo = this.dataCheckHelper.compareListData(ImportOtherInVO.class, list, writeList);
        if (checkResultVo.isSuccess()) {
            return true;
        }
        list.forEach(d -> d.setMsg(checkResultVo.getErrorMsg()));
        return false;
    }

    private void setErrMsg(List<ImportOtherInVO> list, String msg) {
        list.forEach(data -> data.setMsg(msg));
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        TwoTuple twoTuple = (TwoTuple)obj;
        Optional.ofNullable(twoTuple.getFirst()).filter(CollUtil::isNotEmpty).ifPresent(list -> RestResponseHelper.checkOrThrow((RestResponse)this.csOtherStorageOrderApi.batchCreateCsOtherStorageOrder(list)));
        return Optional.ofNullable(twoTuple.getSecond()).filter(CollUtil::isNotEmpty).map(msgList -> ExcelUtils.getExportUrl(msgList, ImportOtherInVO.class, "\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", String.format("%s%s", "\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode()))).orElse(null);
    }

    @Override
    public RestResponse<Object> addOtherIn(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherInBody submitOtherInBody) {
        if (StringUtils.isBlank((CharSequence)submitOtherInBody.getOperationalType())) {
            throw new BizException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        CsOtherStorageOrderComboReqDto reqDto = new CsOtherStorageOrderComboReqDto();
        this.getOtherIn(submitOtherInBody, reqDto);
        if (OperationalTypeEnum.SAVE.getCode().equals(submitOtherInBody.getOperationalType())) {
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.saveCsOtherStorageOrder(reqDto)));
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.addCsOtherStorageOrder(reqDto)));
    }

    private void getOtherIn(SubmitOtherInBody submitOtherInBody, CsOtherStorageOrderComboReqDto reqDto) {
        CsOtherStorageOrderReqDto csOtherStorageOrderReqDto = new CsOtherStorageOrderReqDto();
        BeanUtils.copyProperties((Object)submitOtherInBody, (Object)csOtherStorageOrderReqDto);
        csOtherStorageOrderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_IN.getCode());
        csOtherStorageOrderReqDto.setBusinessType(ParamConverter.convertToLong((Object)submitOtherInBody.getBussinessOrderType()));
        csOtherStorageOrderReqDto.setBusinessTypeName(submitOtherInBody.getBussinessOrderTypeName());
        csOtherStorageOrderReqDto.setWarehouseCode(submitOtherInBody.getLogicalWarehouseCode());
        csOtherStorageOrderReqDto.setWarehouseName(submitOtherInBody.getLogicalWarehouseName());
        csOtherStorageOrderReqDto.setOrganizationId(ParamConverter.convertToLong((Object)submitOtherInBody.getCargoRightId()));
        csOtherStorageOrderReqDto.setOrganization(submitOtherInBody.getCargoRightName());
        csOtherStorageOrderReqDto.setMessage(submitOtherInBody.getSummary());
        csOtherStorageOrderReqDto.setCostCenterCode(submitOtherInBody.getCostCenterCode());
        csOtherStorageOrderReqDto.setOrderSrc(OrderSrcEnum.PCP.getDesc());
        csOtherStorageOrderReqDto.setIsSendEas(submitOtherInBody.getIsSendEas());
        csOtherStorageOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        csOtherStorageOrderReqDto.setBizDate(submitOtherInBody.getBizDate());
        reqDto.setCsOtherStorageOrderReqDto(csOtherStorageOrderReqDto);
        List<SubmitOtherInBodyGoodsList> goodsList = submitOtherInBody.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List list = goodsList.stream().map(o -> {
                CsOtherStorageOrderDetailReqDto dto = new CsOtherStorageOrderDetailReqDto();
                BeanUtils.copyProperties((Object)o, (Object)dto);
                dto.setLongCode(o.getGoodsLongCode());
                dto.setCargoName(o.getGoodsName());
                dto.setSpecification(o.getGoodsSpec());
                dto.setVolume(o.getVolume() != null ? ParamConverter.convertToBigDecimal((Object)o.getVolume()) : BigDecimal.ZERO);
                dto.setQuantity(o.getInQuantity() != null ? ParamConverter.convertToBigDecimal((Object)o.getInQuantity()) : BigDecimal.ZERO);
                return dto;
            }).collect(Collectors.toList());
            reqDto.setDetailList(list);
        }
    }

    @Override
    public RestResponse<Object> auditOtherIn(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherInBody submitOtherInBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        submitOtherInBody.setId(Long.valueOf(id));
        CsOtherStorageOrderAuditReqDto reqDto = new CsOtherStorageOrderAuditReqDto();
        reqDto.setOtherStorageOrderNoId(Long.valueOf(id));
        reqDto.setAuditResult(submitOtherInBody.getAuditResult());
        reqDto.setRemark(submitOtherInBody.getAuditReason());
        CsOtherStorageOrderComboReqDto comboReqDto = new CsOtherStorageOrderComboReqDto();
        this.getOtherIn(submitOtherInBody, comboReqDto);
        reqDto.setCsOtherStorageOrderComboReqDto(comboReqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.auditCsOtherStorageOrder(reqDto)));
    }

    @Override
    public RestResponse<Object> deleteOtherIn(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.deleteById(Long.valueOf(id))));
    }

    @Override
    public RestResponse<OtherInVO> getOtherInDetail(@ApiParam(value="", required=true) @PathVariable(value="bussinessOrderNo") String bussinessOrderNo) {
        List respDtoList;
        if (StringUtils.isBlank((CharSequence)bussinessOrderNo)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsOtherStorageOrderRespDto respDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryByOtherStorageNo(bussinessOrderNo));
        OtherInVO vo = new OtherInVO();
        if (Objects.isNull(respDto)) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getStorageOrderNo());
        vo.setBussinessOrderType(ParamConverter.convertToString((Object)respDto.getBusinessType()));
        vo.setBussinessOrderTypeName(respDto.getBusinessTypeName());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setBussinessOrderStatus(ParamConverter.convertToString((Object)respDto.getOrderStatus()));
        LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
        logicalWarehouseVO.setWarehouseName(respDto.getWarehouseName());
        logicalWarehouseVO.setWarehouseCode(respDto.getWarehouseCode());
        vo.setCargoRightName(respDto.getOrganization());
        vo.setCargoRightId(ParamConverter.convertToString((Object)respDto.getOrganizationId()));
        vo.setLogicalWarehouse(logicalWarehouseVO);
        vo.setSummary(respDto.getMessage());
        Optional.ofNullable(respDto.getCostCenterCode()).filter(StringUtils::isNotEmpty).ifPresent(costCode -> {
            vo.setCostCenterCode(respDto.getCostCenterCode());
            Map<String, CostCenterRespDto> centerByCodes = this.inventoryOtherHelper.getCostCenterByCodes(Sets.newHashSet((Object[])new String[]{respDto.getCostCenterCode()}));
            vo.setCostCenterName(centerByCodes.getOrDefault(respDto.getCostCenterCode(), new CostCenterRespDto()).getCostCenterName());
        });
        vo.setIsSendEas(respDto.getIsSendEas());
        List csStorageAuditRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csStorageAuditRecordQueryApi.queryListByOrderSrcNo(respDto.getStorageOrderNo()));
        if (CollectionUtils.isNotEmpty((Collection)csStorageAuditRecordRespDtos)) {
            List<AuditVO> list = csStorageAuditRecordRespDtos.stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryOtherStorageOrderRelevanceOrder(respDto.getStorageOrderNo(), CsOtherStorageOrderEnum.InOrOut.IN.getCode()))))) {
            List<AssociatedDocumentVO> list = respDtoList.stream().map(o -> {
                AssociatedDocumentVO documentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getCreateTime() != null) {
                    documentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                documentVO.setOrderNo(o.getDocumentNo());
                documentVO.setOrderType(o.getBusinessType());
                return documentVO;
            }).collect(Collectors.toList());
            vo.setAssociatedDocumentList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<List<OtherInGoodsVO>> getOtherInGoodsList(@ApiParam(value="", required=true) @PathVariable(value="bussinessOrderNo") String bussinessOrderNo) {
        if (StringUtils.isBlank((CharSequence)bussinessOrderNo)) {
            throw new BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderDetailQueryApi.queryListByOtherOrderNo(bussinessOrderNo));
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            return new RestResponse();
        }
        List list = respDtos.stream().map(o -> {
            OtherInGoodsVO vo = new OtherInGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setGoodsSpec(o.getSpecification());
            vo.setVolume(o.getVolume());
            vo.setInQuantity(o.getQuantity());
            return vo;
        }).collect(Collectors.toList());
        return new RestResponse(list);
    }

    @Override
    public RestResponse<PageInfo<OtherInVO>> getOtherInList(@ApiParam(value="") @Valid @RequestBody(required=false) GetOtherInListBody getOtherInListBody) {
        logger.info("getOtherInList: {}", (Object)LogUtils.buildLogContent((Object)getOtherInListBody));
        EsOtherStorageOrderListPageParams queryDto = new EsOtherStorageOrderListPageParams();
        BeanUtils.copyProperties((Object)getOtherInListBody, (Object)queryDto);
        queryDto.setStorageOrderNo(getOtherInListBody.getBussinessOrderNo());
        queryDto.setBusinessType(getOtherInListBody.getBussinessOrderType());
        queryDto.setPreOrderNo(ObjectUtil.isNotEmpty((Object)getOtherInListBody.getPreOrderNo()) ? getOtherInListBody.getPreOrderNo() : getOtherInListBody.getRelationBussinessOrderNo());
        queryDto.setExternalOrderNo(getOtherInListBody.getExternalOrderNo());
        queryDto.setOrganization(getOtherInListBody.getCargoRightName());
        queryDto.setOrderStatus(getOtherInListBody.getBussinessOrderStatus());
        queryDto.setWarehouseName(getOtherInListBody.getLogicalWarehouseName());
        queryDto.setCreateBeginTime(getOtherInListBody.getCreateStartTime());
        queryDto.setCreateEndTime(getOtherInListBody.getCreateEndTime());
        queryDto.setOrderSrc(getOtherInListBody.getSource() != null ? OrderSrcEnum.getDescByCode(getOtherInListBody.getSource()) : null);
        queryDto.setType(BusinessTypeEnum.OTHER_IN.getCode());
        PageInfo respVoPageInfo = new PageInfo();
        PageInfo csOtherStorageOrderRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.getOtherOutList(queryDto));
        CubeBeanUtils.copyProperties((Object)respVoPageInfo, (Object)csOtherStorageOrderRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList lists = new ArrayList();
        CubeBeanUtils.copyCollection(lists, (Collection)csOtherStorageOrderRespVoPageInfo.getList(), CsOtherStorageOrderRespVo.class);
        respVoPageInfo.setList(lists);
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        Map<Long, CsBusinessTypeRespDto> typeMap = this.inventoryOtherHelper.getTypeIdMap("other_in");
        List list = respVoPageInfo.getList().stream().map(o -> {
            OtherInVO vo = new OtherInVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getStorageOrderNo());
            vo.setRelationBussinessOrderNo(o.getPreOrderNo());
            if (o.getBusinessType() != null) {
                vo.setBussinessOrderType(ParamConverter.convertToString((Object)o.getBusinessType()));
                CsBusinessTypeRespDto typeRespDto = (CsBusinessTypeRespDto)typeMap.get(o.getBusinessType());
                if (typeRespDto != null) {
                    vo.setBussinessOrderTypeName(typeRespDto.getBusinessTypeName());
                }
            }
            vo.setBussinessOrderStatus(ParamConverter.convertToString((Object)o.getOrderStatus()));
            vo.setSource(o.getOrderSrc());
            LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
            logicalWarehouseVO.setWarehouseName(o.getWarehouseName());
            logicalWarehouseVO.setWarehouseCode(o.getWarehouseCode());
            vo.setLogicalWarehouse(logicalWarehouseVO);
            vo.setCargoRightName(o.getOrganization());
            vo.setCargoRightId(ParamConverter.convertToString((Object)o.getOrganizationId()));
            vo.setExternalOrderNo(o.getExternalOrderNo());
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> otherInStorageOrderStatusCount(@Valid GetOtherInListBody getOtherInListBody) {
        EsOtherStorageOrderListPageParams queryDto = new EsOtherStorageOrderListPageParams();
        BeanUtils.copyProperties((Object)getOtherInListBody, (Object)queryDto);
        queryDto.setStorageOrderNo(getOtherInListBody.getBussinessOrderNo());
        queryDto.setBusinessType(getOtherInListBody.getBussinessOrderType());
        queryDto.setPreOrderNo(ObjectUtil.isNotEmpty((Object)getOtherInListBody.getPreOrderNo()) ? getOtherInListBody.getPreOrderNo() : getOtherInListBody.getRelationBussinessOrderNo());
        queryDto.setExternalOrderNo(getOtherInListBody.getExternalOrderNo());
        queryDto.setOrganization(getOtherInListBody.getCargoRightName());
        queryDto.setOrderStatus(getOtherInListBody.getBussinessOrderStatus());
        queryDto.setWarehouseName(getOtherInListBody.getLogicalWarehouseName());
        queryDto.setCreateBeginTime(getOtherInListBody.getCreateStartTime());
        queryDto.setCreateEndTime(getOtherInListBody.getCreateEndTime());
        queryDto.setOrderSrc(getOtherInListBody.getSource() != null ? OrderSrcEnum.getDescByCode(getOtherInListBody.getSource()) : null);
        queryDto.setType(BusinessTypeEnum.OTHER_IN.getCode());
        return this.inventoryEsReportQueryApi.otherStorageOrderStatusCount(queryDto);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetOtherInListBody params = new GetOtherInListBody();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOtherInListBody)JSON.parseObject((String)commonReqDto.getFilter(), GetOtherInListBody.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getOtherInList((GetOtherInListBody)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportOtherInVO vo = new ExportOtherInVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return o.getBussinessOrderStatus();
                }).orElse(""));
                vo.setWarehouseName(o.getLogicalWarehouse().getWarehouseName());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportOtherInVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetOtherInListBody params = new GetOtherInListBody();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOtherInListBody)JSON.parseObject((String)commonReqDto.getFilter(), GetOtherInListBody.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getOtherInList(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> submitOtherIn(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.submitById(Long.valueOf(id))));
    }

    @Override
    public RestResponse<Object> updateOtherIn(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherInBody submitOtherInBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsOtherStorageOrderComboReqDto reqDto = new CsOtherStorageOrderComboReqDto();
        submitOtherInBody.setId(Long.valueOf(id));
        this.getOtherIn(submitOtherInBody, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.modifyCsOtherStorageOrder(reqDto)));
    }
}

