/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.OrderCustomerPriorityRuleImportVo;
import com.dtyunxi.cis.pms.biz.model.OrderCustomerPriorityRuleMsgVo;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.center.source.api.IOrderCustomerPriorityRuleApi;
import com.dtyunxi.cube.center.source.api.dto.request.OrderCustomerPriorityRuleReqDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_order_priority_customer_import")
public class OrderCustomerPriorityRuleImportImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(OrderCustomerPriorityRuleImportImpl.class);
    @Resource
    private IPCPCustomerQueryApi ipcpCustomerQueryApi;
    @Resource
    private IOrderCustomerPriorityRuleApi iOrderCustomerPriorityRuleApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), OrderCustomerPriorityRuleImportVo.class);
        log.info("\u8ba2\u5355\u4f18\u5148\u7ea7\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        Map<String, PCPCustomerRespDto> respDtoMap = this.getcodesMap(list);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            OrderCustomerPriorityRuleMsgVo msgDto = new OrderCustomerPriorityRuleMsgVo();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)i, (String[])new String[0]);
            this.checkCode((OrderCustomerPriorityRuleImportVo)((Object)i), respDtoMap, msgDto);
            this.checkRepeatData(i.getUniqueKey(), checkRepeatData, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u8ba2\u5355\u4f18\u5148\u7ea7\u5bfc\u5165\u96c6\u5408\uff0csaveList\uff1a{}", (Object)JSON.toJSONString((Object)saveList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            log.info("===\u5ba2\u6237\u8d44\u6599\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            Map<String, List<OrderCustomerPriorityRuleImportVo>> importMap = saveList.stream().collect(Collectors.groupingBy(OrderCustomerPriorityRuleImportVo::getCode));
            ArrayList dtoList = Lists.newArrayList();
            for (OrderCustomerPriorityRuleImportVo vo : saveList) {
                OrderCustomerPriorityRuleReqDto customerReqExtDto = new OrderCustomerPriorityRuleReqDto();
                customerReqExtDto.setCustomerCode(vo.getCode());
                customerReqExtDto.setCustomerName(Optional.ofNullable(vo.getName()).orElse(""));
                dtoList.add(customerReqExtDto);
            }
            dtoList.forEach(i -> {
                block2: {
                    try {
                        this.iOrderCustomerPriorityRuleApi.saveOrderCustomerPriorityRule(i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s", i.getCustomerCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, OrderCustomerPriorityRuleMsgVo.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List checkMsgList = (List)msgObj;
            msgList.addAll(checkMsgList);
        }
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u5ba2\u6237\u8d44\u6599\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, OrderCustomerPriorityRuleMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, PCPCustomerRespDto> getcodesMap(List<OrderCustomerPriorityRuleImportVo> list) {
        Map<Object, Object> codesMap = Maps.newHashMap();
        List codes = list.stream().map(OrderCustomerPriorityRuleImportVo::getCode).distinct().collect(Collectors.toList());
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetailByCodes(codes));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            codesMap = warehouses.stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        }
        return codesMap;
    }

    private void checkCode(OrderCustomerPriorityRuleImportVo i, Map<String, PCPCustomerRespDto> codesMap, OrderCustomerPriorityRuleMsgVo msgDto) {
        PCPCustomerRespDto pcpCustomerRespDto = codesMap.get(i.getCode());
        if (ObjectUtils.isEmpty((Object)pcpCustomerRespDto)) {
            msgDto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
        } else {
            i.setName(pcpCustomerRespDto.getCustomerName());
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, OrderCustomerPriorityRuleMsgVo msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(OrderCustomerPriorityRuleMsgVo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }
}

