/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddOutSourceOrderParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOutSourceOrderVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetOutSourceOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutSourceOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryOutSourceOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.InPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.InPlannedOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_out_source_order")
public class FinishedGoodsInventoryOutSourceOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryOutSourceOrderService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource
    private ICsInPlannedOrderQueryApi csInPlannedOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public RestResponse<Object> addOutSourceOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddOutSourceOrderParams addOutSourceOrderParams) {
        CsInPlannedOrderGenerateReqDto reqDto = new CsInPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addOutSourceOrderParams, (Object)reqDto);
        this.getAddOutSourceOrder(addOutSourceOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.generatePlannedOrder(reqDto)));
    }

    private void getAddOutSourceOrder(AddOutSourceOrderParams addOutSourceOrderParams, CsInPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addOutSourceOrderParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setOrderType(CsPlannedOrderTypeEnum.OUTSOURCE.getCode());
        reqDto.setBusinessType(CsPlannedOrderTypeEnum.OUTSOURCE.getCode());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        reqDto.setWarehouseCode(addOutSourceOrderParams.getReceiveLogicalWarehouseCode());
        reqDto.setWarehouseName(addOutSourceOrderParams.getReceiveLogicalWarehouseName());
        reqDto.setRemark(addOutSourceOrderParams.getRemark());
        reqDto.setEstimatedTime(StringUtils.isNotBlank((CharSequence)addOutSourceOrderParams.getArrivalTime()) ? DateUtil.parse((String)addOutSourceOrderParams.getArrivalTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        List<FinishedGoodsInventoryGoodsVO> goodsList = addOutSourceOrderParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsInPlannedOrderGenerateDetailReqDto dto = new CsInPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoCode(o.getGoodsCode());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<OutSourceOrderVO> getOutSourceOrderDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        List relOrderInfoList;
        CsInPlannedOrderDetailQueryInfoRespDto respDto = (CsInPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        OutSourceOrderVO vo = new OutSourceOrderVO();
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getOrderType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setReceiveLogicalWarehouseCode(respDto.getReceiveWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getReceiveWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (respDto.getEstimatedTime() != null) {
            vo.setArrivalTime(DateUtil.format((Date)respDto.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                if (o.getCreateTime() != null) {
                    associatedDocumentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                Collections.sort(list, (o2, o1) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
            }
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<OutSourceOrderVO>> getOutSourceOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOutSourceOrderListPageParams getOutSourceOrderListPageParams) {
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        if (!this.esQuery.booleanValue()) {
            GetPurchaseOrderListPageParams req = new GetPurchaseOrderListPageParams();
            BeanUtils.copyProperties((Object)getOutSourceOrderListPageParams, (Object)req);
            req.setOrderType(CsPlannedOrderTypeEnum.OUTSOURCE.getCode());
            PageInfo purchaseOrderVOPageInfo = (PageInfo)this.inventoryEsReportQueryApi.getPurchaseOrderListPage(req).getData();
            if (CollectionUtils.isEmpty((Collection)purchaseOrderVOPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)purchaseOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, (Collection)purchaseOrderVOPageInfo.getList(), InPlannedOrderVO.class);
            respDtoPageInfo.setList((List)list);
        } else {
            InPlannedOrderPageParams params = new InPlannedOrderPageParams();
            BeanUtils.copyProperties((Object)getOutSourceOrderListPageParams, (Object)params);
            params.setOrderNo(getOutSourceOrderListPageParams.getBussinessOrderNo());
            params.setOrdeType(CsPlannedOrderTypeEnum.OUTSOURCE.getCode());
            params.setWarehouseCode(getOutSourceOrderListPageParams.getReceiveLogicalWarehouseCode());
            params.setWarehouseName(getOutSourceOrderListPageParams.getReceiveLogicalWarehouseName());
            params.setOrderStatus(getOutSourceOrderListPageParams.getBussinessOrderStatus());
            respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esPlannedOrderQueryApi.queryInPlannedOrderPage(params));
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            OutSourceOrderVO vo = new OutSourceOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getOrderType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(o.getTotalQuantity() != null ? o.getTotalQuantity().intValue() : 0);
            vo.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> outSourceOrderStatusCount(@Valid GetOutSourceOrderListPageParams getOutSourceOrderListPageParams) {
        GetPurchaseOrderListPageParams req = new GetPurchaseOrderListPageParams();
        BeanUtils.copyProperties((Object)getOutSourceOrderListPageParams, (Object)req);
        req.setOrderType(CsPlannedOrderTypeEnum.OUTSOURCE.getCode());
        return this.inventoryEsReportQueryApi.inPlannedOrderStatusCount(req);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetOutSourceOrderListPageParams params = new GetOutSourceOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOutSourceOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetOutSourceOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getOutSourceOrderListPage((GetOutSourceOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportOutSourceOrderVO vo = new ExportOutSourceOrderVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(item.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return item.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u59d4\u5916\u6210\u54c1");
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportOutSourceOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetOutSourceOrderListPageParams params = new GetOutSourceOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOutSourceOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetOutSourceOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getOutSourceOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateOutSourceOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddOutSourceOrderParams addOutSourceOrderParams) {
        CsInPlannedOrderGenerateReqDto reqDto = new CsInPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addOutSourceOrderParams, (Object)reqDto);
        reqDto.setOrderNo(addOutSourceOrderParams.getBussinessOrderNo());
        this.getAddOutSourceOrder(addOutSourceOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.editPlannedOrder(reqDto)));
    }
}

