/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.CompanyVO;
import com.dtyunxi.cis.pms.biz.model.ContactVO;
import com.dtyunxi.cis.pms.biz.model.CustomerCustomAreaVO;
import com.dtyunxi.cis.pms.biz.model.CustomerLevelVO;
import com.dtyunxi.cis.pms.biz.model.CustomerStatusVO;
import com.dtyunxi.cis.pms.biz.model.CustomerTypeVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.ExportCustomerDataManageVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetCustomerListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutVO;
import com.dtyunxi.cis.pms.biz.model.SalesmanVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCustomerService;
import com.dtyunxi.cis.pms.biz.service.helper.meta.InventoryOtherMetaVo;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PCPCustomerLevelReqDto;
import com.dtyunxi.tcbj.api.dto.request.PCPCustomerSalesmanReqDto;
import com.dtyunxi.tcbj.api.dto.request.PCPCustomerStatusReqDto;
import com.dtyunxi.tcbj.api.dto.request.PCPCustomerTypeReqDto;
import com.dtyunxi.tcbj.api.dto.request.PcpCustomerAreaListReqDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IPCPCustomerAreaQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerLevelQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerSalesmanQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerStatusQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerTypeQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_customer_data_manage")
public class BasedataCenterCustomerServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements BasedataCenterCustomerService {
    private static Logger logger = LoggerFactory.getLogger(BasedataCenterCustomerServiceServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IPCPCustomerQueryApi pcpCustomerQueryApi;
    @Resource
    private IPCPCustomerLevelQueryApi pcpCustomerLevelQueryApi;
    @Resource
    private IPCPCustomerTypeQueryApi pcpCustomerTypeQueryApi;
    @Resource
    private IPCPCustomerStatusQueryApi pcpCustomerStatusQueryApi;
    @Resource
    private IPCPCustomerSalesmanQueryApi pcpCustomerSalesmanQueryApi;
    @Resource
    private IPCPCustomerAreaQueryApi pcpCustomerAreaQueryApi;

    @Override
    public RestResponse<PageInfo<CustomerCustomAreaVO>> getCustomerCustomAreaList(@ApiParam(value="") @Valid @RequestParam(value="pageSize", required=false) String pageSize, @ApiParam(value="") @Valid @RequestParam(value="pageNum", required=false) String pageNum, @ApiParam(value="") @Valid @RequestParam(value="keyWords", required=false) String keyWords) {
        PcpCustomerAreaListReqDto pcpCustomerAreaListReqDto = new PcpCustomerAreaListReqDto();
        pcpCustomerAreaListReqDto.setName(keyWords);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerAreaQueryApi.queryByPage(JSON.toJSONString((Object)pcpCustomerAreaListReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List customerCustomAreaVOs = pageInfo.getList().stream().map(customerAreaRespDto -> {
                CustomerCustomAreaVO customerCustomAreaVO = new CustomerCustomAreaVO();
                customerCustomAreaVO.setCustomerCustomAreaCode(customerAreaRespDto.getAreaCode());
                customerCustomAreaVO.setCustomerCustomAreaName(customerAreaRespDto.getName());
                customerCustomAreaVO.setCustomerCustomAreaId(String.valueOf(customerAreaRespDto.getId()));
                customerCustomAreaVO.setCustomerCustomAreaLevel(new BigDecimal(customerAreaRespDto.getLevel()));
                return customerCustomAreaVO;
            }).collect(Collectors.toList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(customerCustomAreaVOs);
            return new RestResponse((Object)voPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<CustomerVO> getCustomerDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u5ba2\u6237\u8be6\u60c5\u53c2\u6570\u6709\u8bef");
        }
        long startTime = System.currentTimeMillis();
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}", (Object)id);
        PCPCustomerRespDto pcpCustomerRespDto = (PCPCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.pcpCustomerQueryApi.queryPCPCustomerDetailById(Long.valueOf(id)));
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)pcpCustomerRespDto));
        long endTime = System.currentTimeMillis();
        logger.info("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a{}ms", (Object)(endTime - startTime));
        CustomerVO customerVO = this.PCPCustomerToVo(pcpCustomerRespDto);
        return new RestResponse((Object)customerVO);
    }

    @Override
    public RestResponse<PageInfo<CustomerLevelVO>> getCustomerLevelList(@ApiParam(value="") @Valid @RequestParam(value="pageSize", required=false) String pageSize, @ApiParam(value="") @Valid @RequestParam(value="pageNum", required=false) String pageNum) {
        if (!StringUtils.isNumeric((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageNum)) {
            throw new BizException("\u5206\u9875\u6570\u636e\u4e0d\u4e3a\u7a7a");
        }
        PCPCustomerLevelReqDto pcpCustomerLevelReqDto = new PCPCustomerLevelReqDto();
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerLevelQueryApi.queryByPage(JSON.toJSONString((Object)pcpCustomerLevelReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List customerLevelVOs = pageInfo.getList().stream().map(pcpCustomerLevelRespDto -> {
                CustomerLevelVO customerLevelVO = new CustomerLevelVO();
                customerLevelVO.setCustomerLevelId(ParamConverter.convertToString((Object)pcpCustomerLevelRespDto.getId()));
                customerLevelVO.setCustomerLevelName(pcpCustomerLevelRespDto.getName());
                return customerLevelVO;
            }).collect(Collectors.toList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(customerLevelVOs);
            return new RestResponse((Object)voPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<CustomerVO>> getCustomerListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetCustomerListPageParams getCustomerListPageParams) {
        PCPCustomerSearchReqDto searchReqDto = this.queryParams(getCustomerListPageParams);
        long startTime = System.currentTimeMillis();
        logger.info("\u5ba2\u6237\u5217\u8868\u8c03\u7528\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)searchReqDto));
        PageInfo pcpCustomerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerQueryApi.queryPCPCustomerDetailByPage(searchReqDto));
        long endTime = System.currentTimeMillis();
        logger.info("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a{}ms", (Object)(endTime - startTime));
        if (CollectionUtils.isEmpty((Collection)pcpCustomerRespDtoPageInfo.getList())) {
            return new RestResponse();
        }
        List customerVOS = pcpCustomerRespDtoPageInfo.getList().stream().map(this::PCPCustomerToVo).filter(Objects::nonNull).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pcpCustomerRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList(customerVOS);
        logger.info("\u5ba2\u6237\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)pcpCustomerRespDtoPageInfo));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<CustomerStatusVO>> getCustomerStatusList(@ApiParam(value="") @Valid @RequestParam(value="pageSize", required=false) String pageSize, @ApiParam(value="") @Valid @RequestParam(value="pageNum", required=false) String pageNum) {
        if (!StringUtils.isNumeric((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageNum)) {
            throw new BizException("\u5206\u9875\u6570\u636e\u4e0d\u4e3a\u7a7a");
        }
        PCPCustomerStatusReqDto pcpCustomerStatusReqDto = new PCPCustomerStatusReqDto();
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerStatusQueryApi.queryByPage(JSON.toJSONString((Object)pcpCustomerStatusReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List customerStatusVOs = pageInfo.getList().stream().map(pcpCustomerStatusRespDto -> {
                CustomerStatusVO customerStatusVO = new CustomerStatusVO();
                customerStatusVO.setCustomerStatusId(ParamConverter.convertToString((Object)pcpCustomerStatusRespDto.getId()));
                customerStatusVO.setCustomerStatusName(pcpCustomerStatusRespDto.getName());
                customerStatusVO.setCustomerStatusCode(pcpCustomerStatusRespDto.getCode());
                return customerStatusVO;
            }).collect(Collectors.toList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(customerStatusVOs);
            return new RestResponse((Object)voPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<CustomerTypeVO>> getCustomerTypeList(@ApiParam(value="") @Valid @RequestParam(value="pageNum", required=false) String pageNum, @ApiParam(value="") @Valid @RequestParam(value="pageSize", required=false) String pageSize) {
        if (!StringUtils.isNumeric((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageNum)) {
            throw new BizException("\u5206\u9875\u6570\u636e\u4e0d\u4e3a\u7a7a");
        }
        PCPCustomerTypeReqDto pcpCustomerTypeReqDto = new PCPCustomerTypeReqDto();
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerTypeQueryApi.queryByPage(JSON.toJSONString((Object)pcpCustomerTypeReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List customerTypeVOs = pageInfo.getList().stream().map(pcpCustomerTypeRespDto -> {
                CustomerTypeVO customerTypeVO = new CustomerTypeVO();
                customerTypeVO.setCustomerTypeId(ParamConverter.convertToString((Object)pcpCustomerTypeRespDto.getId()));
                customerTypeVO.setId(pcpCustomerTypeRespDto.getId());
                customerTypeVO.setCustomerTypeName(pcpCustomerTypeRespDto.getName());
                customerTypeVO.setCustomerTypeSort(ParamConverter.convertToString((Object)pcpCustomerTypeRespDto.getSort()));
                return customerTypeVO;
            }).collect(Collectors.toList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(customerTypeVOs);
            return new RestResponse((Object)voPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<SalesmanVO>> getSalesmanList(@ApiParam(value="") @Valid @RequestParam(value="pageSize", required=false) String pageSize, @ApiParam(value="") @Valid @RequestParam(value="pageNum", required=false) String pageNum) {
        if (!StringUtils.isNumeric((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageNum)) {
            throw new BizException("\u5206\u9875\u6570\u636e\u4e0d\u4e3a\u7a7a");
        }
        PCPCustomerSalesmanReqDto pcpCustomerSalesmanReqDto = new PCPCustomerSalesmanReqDto();
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpCustomerSalesmanQueryApi.queryByPage(JSON.toJSONString((Object)pcpCustomerSalesmanReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List customerSalesmanVOs = pageInfo.getList().stream().map(pcpCustomerSalesmanRespDto -> {
                SalesmanVO customerSalesmanVO = new SalesmanVO();
                customerSalesmanVO.setSalesmanId(String.valueOf(pcpCustomerSalesmanRespDto.getId()));
                customerSalesmanVO.setSalesmanName(pcpCustomerSalesmanRespDto.getName());
                return customerSalesmanVO;
            }).collect(Collectors.toList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(customerSalesmanVOs);
            return new RestResponse((Object)voPageInfo);
        }
        return new RestResponse();
    }

    private PCPCustomerSearchReqDto queryParams(GetCustomerListPageParams getCustomerListPageParams) {
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        BeanUtils.copyProperties((Object)getCustomerListPageParams, (Object)searchReqDto);
        searchReqDto.setName(getCustomerListPageParams.getCustomerName());
        searchReqDto.setCode(getCustomerListPageParams.getCustomerCode());
        searchReqDto.setCompanyName(getCustomerListPageParams.getCompanyName());
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getCustomerStatus())) {
            searchReqDto.setStatusId(Long.valueOf(getCustomerListPageParams.getCustomerStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getCustomerShortName())) {
            searchReqDto.setName(getCustomerListPageParams.getCustomerShortName());
        }
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getSalesman())) {
            searchReqDto.setSalesmanId(Long.valueOf(getCustomerListPageParams.getSalesman()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getCustomerCustomArea())) {
            searchReqDto.setRegionIds(Arrays.stream(StringUtils.split((String)getCustomerListPageParams.getCustomerCustomArea(), (String)",")).map(Long::new).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getCustomerType())) {
            searchReqDto.setCustomerTypeIds(Arrays.stream(StringUtils.split((String)getCustomerListPageParams.getCustomerType(), (String)",")).map(Long::new).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getCustomerListPageParams.getCustomerLevel())) {
            searchReqDto.setLevelId(Long.valueOf(getCustomerListPageParams.getCustomerLevel()));
        }
        if (CollectionUtils.isNotEmpty(getCustomerListPageParams.getOption())) {
            searchReqDto.setOption(getCustomerListPageParams.getOption());
        }
        if (Objects.nonNull(getCustomerListPageParams.getExtraMaterial())) {
            searchReqDto.setExtraMaterial(getCustomerListPageParams.getExtraMaterial());
        }
        if (Objects.nonNull(getCustomerListPageParams.getFinancialPrint())) {
            searchReqDto.setFinancialPrint(getCustomerListPageParams.getFinancialPrint());
        }
        if (Objects.nonNull(getCustomerListPageParams.getReportsPrint())) {
            searchReqDto.setReportsPrint(getCustomerListPageParams.getReportsPrint());
        }
        if (Objects.nonNull(getCustomerListPageParams.getShipmentEnterprise())) {
            searchReqDto.setShipmentEnterprise(getCustomerListPageParams.getShipmentEnterprise());
        }
        searchReqDto.setKeyword(getCustomerListPageParams.getKeyWords());
        searchReqDto.setPageNum(getCustomerListPageParams.getPageNum());
        searchReqDto.setPageSize(getCustomerListPageParams.getPageSize());
        return searchReqDto;
    }

    private CustomerVO PCPCustomerToVo(PCPCustomerRespDto pcpCustomer) {
        CustomerVO customerVO = (CustomerVO)BeanUtil.copyProperties((Object)pcpCustomer, CustomerVO.class, (String[])new String[0]);
        if (pcpCustomer.getUpdateTime() != null) {
            customerVO.setUpdateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)pcpCustomer.getUpdateTime()));
        }
        if (Objects.nonNull(pcpCustomer.getCustomerCustomArea())) {
            CustomerCustomAreaVO customerCustomAreaVO = new CustomerCustomAreaVO();
            customerCustomAreaVO.setCustomerCustomAreaId(ParamConverter.convertToString((Object)pcpCustomer.getCustomerCustomArea().getId()));
            customerCustomAreaVO.setCustomerCustomAreaCode(pcpCustomer.getCustomerCustomArea().getCode());
            customerCustomAreaVO.setCustomerCustomAreaName(pcpCustomer.getCustomerCustomArea().getName());
            if (Objects.nonNull(pcpCustomer.getCustomerCustomArea().getLevel())) {
                customerCustomAreaVO.setCustomerCustomAreaLevel(new BigDecimal(pcpCustomer.getCustomerCustomArea().getLevel()));
            }
            customerCustomAreaVO.setCustomerCustomAreaParentCode(pcpCustomer.getCustomerCustomArea().getParentCode());
            CubeBeanUtils.copyProperties((Object)customerCustomAreaVO, (Object)pcpCustomer.getCustomerCustomArea(), (String[])new String[0]);
            customerVO.setCustomerCustomArea(customerCustomAreaVO);
        }
        if (pcpCustomer.getFinancialPrint() != null) {
            customerVO.setFinancialPrint(pcpCustomer.getFinancialPrint());
        }
        if (pcpCustomer.getReportsPrint() != null) {
            customerVO.setReportsPrint(pcpCustomer.getReportsPrint());
        }
        if (pcpCustomer.getExtraMaterial() != null) {
            customerVO.setExtraMaterial(pcpCustomer.getExtraMaterial());
        }
        if (pcpCustomer.getShipmentEnterprise() != null) {
            customerVO.setShipmentEnterprise(pcpCustomer.getShipmentEnterprise());
        }
        if (StringUtils.isNotBlank((CharSequence)pcpCustomer.getInformationRemarks())) {
            customerVO.setInformationRemarks(pcpCustomer.getInformationRemarks());
        }
        if (pcpCustomer.getOrgInfoId() != null) {
            customerVO.setOrgInfoId(pcpCustomer.getOrgInfoId());
        }
        customerVO.setOrgName(pcpCustomer.getOrgName());
        customerVO.setThirdParentPartyId(pcpCustomer.getThirdParentPartyId());
        if (Objects.nonNull(pcpCustomer.getCustomerArea())) {
            AddressVO customerArea = new AddressVO();
            CubeBeanUtils.copyProperties((Object)customerArea, (Object)pcpCustomer.getCustomerArea(), (String[])new String[0]);
            customerVO.setCustomerArea(customerArea);
        }
        if (CollectionUtils.isNotEmpty((Collection)pcpCustomer.getSalesmans())) {
            List<SalesmanVO> salesmanVOs = pcpCustomer.getSalesmans().stream().map(salesmanRespDto -> {
                SalesmanVO salesmanVO = new SalesmanVO();
                salesmanVO.setSalesmanName(salesmanRespDto.getName());
                salesmanVO.setSalesmanId(ParamConverter.convertToString((Object)salesmanRespDto.getId()));
                salesmanVO.setId(salesmanRespDto.getId());
                return salesmanVO;
            }).collect(Collectors.toList());
            customerVO.setSalesmans(salesmanVOs);
        }
        if (Objects.nonNull(pcpCustomer.getCustomerCompanyInfo())) {
            CompanyVO customerCompanyInfo = new CompanyVO();
            CubeBeanUtils.copyProperties((Object)customerCompanyInfo, (Object)pcpCustomer.getCustomerCompanyInfo(), (String[])new String[0]);
            if (Objects.nonNull(pcpCustomer.getCustomerCompanyInfo().getArea())) {
                AddressVO area = new AddressVO();
                CubeBeanUtils.copyProperties((Object)area, (Object)pcpCustomer.getCustomerCompanyInfo().getArea(), (String[])new String[0]);
                customerCompanyInfo.setArea(area);
            }
            customerVO.setCustomerCompanyInfo(customerCompanyInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)pcpCustomer.getContactsInfoList())) {
            ArrayList contactsInfoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)contactsInfoList, (Collection)pcpCustomer.getContactsInfoList(), ContactVO.class);
            customerVO.setContactsInfoList(contactsInfoList);
        }
        if (Objects.nonNull(pcpCustomer.getCustomerStatus())) {
            CustomerStatusVO customerStatusVO = new CustomerStatusVO();
            customerStatusVO.setCustomerStatusId(ParamConverter.convertToString((Object)pcpCustomer.getCustomerStatus().getId()));
            customerStatusVO.setCustomerStatusName(pcpCustomer.getCustomerStatus().getName());
            customerVO.setCustomerStatus(customerStatusVO);
        }
        if (Objects.nonNull(pcpCustomer.getCustomerType())) {
            CustomerTypeVO customerTypeVO = new CustomerTypeVO();
            customerTypeVO.setCustomerTypeId(ParamConverter.convertToString((Object)pcpCustomer.getCustomerType().getId()));
            customerTypeVO.setCustomerTypeName(pcpCustomer.getCustomerType().getName());
            customerTypeVO.setCustomerTypeSort(ParamConverter.convertToString((Object)pcpCustomer.getCustomerType().getSort()));
            customerVO.setCustomerType(customerTypeVO);
        }
        if (Objects.nonNull(pcpCustomer.getCustomerLevel())) {
            CustomerLevelVO customerLevelVO = new CustomerLevelVO();
            customerLevelVO.setCustomerLevelId(ParamConverter.convertToString((Object)pcpCustomer.getCustomerLevel().getId()));
            customerLevelVO.setCustomerLevelName(pcpCustomer.getCustomerLevel().getName());
            customerVO.setCustomerLevel(customerLevelVO);
        }
        return customerVO;
    }

    private CustomerVO initData() {
        CustomerVO customerVO = new CustomerVO();
        customerVO.setCustomerName("11");
        customerVO.setCustomerCode("KH2022224999422");
        customerVO.setCustomerShortName("\u7b80\u79f0");
        CustomerCustomAreaVO customerCustomArea = new CustomerCustomAreaVO();
        customerCustomArea.setCustomerCustomAreaId("1288906712156359345");
        customerCustomArea.setCustomerCustomAreaCode("000000007bca6511017bcd8cbc9a3aad");
        customerCustomArea.setCustomerCustomAreaLevel(new BigDecimal(1));
        customerCustomArea.setCustomerCustomAreaName("\u5927\u8fde\u5e02");
        customerVO.setCustomerCustomArea(customerCustomArea);
        AddressVO customerArea = new AddressVO();
        customerArea.setId(1289014719487819025L);
        customerArea.setProvince("\u4e2d\u56fd\u53f0\u6e7e");
        customerArea.setProvinceCode("710000");
        customerArea.setCity("\u53f0\u5317\u5e02");
        customerArea.setCityCode("710100");
        customerArea.setDistrict("\u5317\u6295\u533a");
        customerArea.setDistrictCode("710101");
        customerArea.setStreetCode("710101-10");
        customerArea.setDetailAddress("\u79d1\u6c47\u91d1\u8c37");
        customerVO.setCustomerArea(customerArea);
        customerVO.setParentCustomerId("1288863869498968071");
        customerVO.setParentCustomerName("\u5927\u8fde\u4e9a\u5b89\u5927\u836f\u623f\u8fde\u9501\u6709\u9650\u516c\u53f8");
        ArrayList salesmans = Lists.newArrayList();
        SalesmanVO salesmanVO = new SalesmanVO();
        salesmanVO.setSalesmanName("13082201166");
        salesmanVO.setSalesmanId("1290566623633291266");
        salesmans.add(salesmanVO);
        customerVO.setSalesmans(salesmans);
        customerVO.setWmsUnitType("1");
        customerVO.setOrgType("1");
        customerVO.setTargetWareHouse("\u76ee\u6807\u4ed3\u5e93");
        CompanyVO customerCompanyInfo = new CompanyVO();
        customerCompanyInfo.setCreditCode("92340827MA2Q0F8KX7");
        customerCompanyInfo.setOrgName("\u671b\u6c5f\u53bf\u65b9\u8d85\u751f\u6001\u6e14\u9986");
        customerCompanyInfo.setTermBeginTime("2017-10-01 00:00:00");
        customerCompanyInfo.setTermEndTime("2026-11-29 00:00:00");
        customerCompanyInfo.setLegalName("\u767d\u661f");
        customerCompanyInfo.setLegalCardType("1");
        customerCompanyInfo.setLegalCardNum("110108196504090011");
        customerCompanyInfo.setCardEffectBeginTime("2021-10-01 00:00:00");
        customerCompanyInfo.setCardEffectEndTime("2021-10-24 00:00:00");
        customerCompanyInfo.setIdCardFront("https://tcbj-uat.oss-cn-shenzhen.aliyuncs.com/cube/yRSteKmpeGeh2RM.jpg");
        customerCompanyInfo.setIdCardBack("https://tcbj-uat.oss-cn-shenzhen.aliyuncs.com/cube/NYr3BFiRtHkNaew.png");
        customerCompanyInfo.setBussinessLicenseUrl("https://tcbj-uat.oss-cn-shenzhen.aliyuncs.com/cube/JdzZRAx2cK4p2sR.jpg");
        customerVO.setCustomerCompanyInfo(customerCompanyInfo);
        ArrayList<ContactVO> contactsInfoList = new ArrayList<ContactVO>();
        ContactVO contactVO = new ContactVO();
        contactVO.setContactName("\u674e\u4e9a\u4e9a");
        contactVO.setContactPosition("\u5f00\u53d1");
        contactVO.setContactPhone("15890002000");
        contactVO.setContactTel("020-88889999");
        contactVO.setContactEmail("langzi@qq.com");
        contactVO.setContactId("1290262665048971316");
        contactsInfoList.add(contactVO);
        customerVO.setContactsInfoList(contactsInfoList);
        CustomerStatusVO customerStatus = new CustomerStatusVO();
        customerStatus.setCustomerStatusCode("enabled");
        customerStatus.setCustomerStatusAccountStatus("1");
        customerStatus.setCustomerStatusRecordStatus("1");
        customerStatus.setCustomerStatusName("\u542f\u7528");
        customerStatus.setCustomerStatusId("1256288005151458333");
        customerVO.setCustomerStatus(customerStatus);
        CustomerTypeVO customerType = new CustomerTypeVO();
        customerType.setCustomerTypeName("\u5206\u9500\u5546");
        customerType.setCustomerTypeType("2");
        customerType.setCustomerTypeSort("10");
        customerType.setCustomerTypeId("1288300994979034135");
        customerVO.setCustomerType(customerType);
        CustomerLevelVO customerLevel = new CustomerLevelVO();
        customerType.setCustomerTypeName("\u4e8c\u7ea7\u7ecf\u9500\u5546");
        customerType.setCustomerTypeId("1288019229790064693");
        customerVO.setCustomerLevel(customerLevel);
        customerVO.setCustomerId("1300608686348449795");
        return customerVO;
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportCustomerDataManageVO.class);
        return this.executorImport(list, this.getInventoryOtherMetaVo(list));
    }

    private InventoryOtherMetaVo getInventoryOtherMetaVo(List<ImportCustomerDataManageVO> list) {
        HashSet whCodes = Sets.newHashSet();
        HashSet itemCodes = Sets.newHashSet();
        HashSet customerCodes = Sets.newHashSet();
        HashSet costCenterCodes = Sets.newHashSet();
        return null;
    }

    private TwoTuple<List<CustomerReqDto>, List<ImportOtherOutVO>> executorImport(List<ImportCustomerDataManageVO> list, InventoryOtherMetaVo inventoryOtherMetaVo) {
        ArrayList saveList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        return null;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        return null;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetCustomerListPageParams getCustomerListPageParams = (GetCustomerListPageParams)JSONObject.parseObject((String)commonReqDto.getFilter(), GetCustomerListPageParams.class);
        getCustomerListPageParams.setPageSize(1);
        getCustomerListPageParams.setPageNum(1);
        RestResponse<PageInfo<CustomerVO>> pageInfoRestResponse = this.getCustomerListPage(getCustomerListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        ArrayList list = Lists.newArrayList();
        long total = respDtoPageInfo.getTotal();
        Integer pageSize = 1000;
        Integer pageNum = (int)(total / (long)pageSize.intValue()) + 1;
        for (int i = 1; i <= pageNum; ++i) {
            getCustomerListPageParams = (GetCustomerListPageParams)JSONObject.parseObject((String)commonReqDto.getFilter(), GetCustomerListPageParams.class);
            getCustomerListPageParams.setPageSize(pageSize);
            getCustomerListPageParams.setPageNum(i);
            pageInfoRestResponse = this.getCustomerListPage(getCustomerListPageParams);
            respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            if (!CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) continue;
            list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                ExportCustomerDataManageVO vo = new ExportCustomerDataManageVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setCustomerCode(o.getCustomerCode());
                vo.setCustomerName(o.getCustomerName());
                if (o.getFinancialPrint() != null) {
                    vo.setFinancialPrint(YesOrNoEnum.isYes(o.getFinancialPrint()) != false ? "\u662f" : "\u5426");
                }
                if (o.getReportsPrint() != null) {
                    vo.setReportsPrint(YesOrNoEnum.isYes(o.getReportsPrint()) != false ? "\u662f" : "\u5426");
                }
                if (o.getExtraMaterial() != null) {
                    vo.setExtraMaterial(YesOrNoEnum.isYes(o.getExtraMaterial()) != false ? "\u662f" : "\u5426");
                }
                if (o.getCustomerStatus() != null) {
                    vo.setCustomerStatusName(o.getCustomerStatus().getCustomerStatusName());
                }
                if (o.getShipmentEnterprise() != null) {
                    vo.setShipmentEnterprise(YesOrNoEnum.isYes(o.getShipmentEnterprise()) != false ? "\u662f" : "\u5426");
                }
                return vo;
            }).collect(Collectors.toList()));
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetCustomerListPageParams getCustomerListPageParams = (GetCustomerListPageParams)JSONObject.parseObject((String)commonReqDto.getFilter(), GetCustomerListPageParams.class);
        getCustomerListPageParams.setPageSize(1);
        getCustomerListPageParams.setPageNum(1);
        RestResponse<PageInfo<CustomerVO>> pageInfoRestResponse = this.getCustomerListPage(getCustomerListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

