/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalDispatchEasService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutEasApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASGeneralSubBillFlagEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASInventoryAllotDetailResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderBaseResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.InventoryReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.MoveIssueBill;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.MoveIssueBillEntry;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DispatchEasInventoryAllotImpl
implements ExternalDispatchEasService {
    private static final Logger logger = LoggerFactory.getLogger(DispatchEasInventoryAllotImpl.class);
    public static final String ADD = "add";
    public static final String REDUCE = "reduce";
    @Resource
    private IExternalOutEasApi externalOutEasApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;

    @Override
    public String getApiCode() {
        return ExternalDispatchBaseEnum.API_EAS013.apiCode;
    }

    @Override
    public Object execute(Object object) {
        logger.info("eas\u5e93\u5b58\u8c03\u62e8\u5355\u8c03\u5ea6\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)object));
        InventoryReqDto reqDto = new InventoryReqDto();
        BeanUtil.copyProperties((Object)object, (Object)reqDto, (String[])new String[0]);
        return this.externalOutEasApi.inventoryInbound(reqDto);
    }

    public void create(String no, CsTransferOrderRespDto dto) {
        logger.info("\u63a8\u9001EAS\u8c03\u62e8\u5355\u521b\u5efa\uff1a{}", (Object)no);
        List detailDto = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryListByTransferOrderNo(dto.getTransferOrderNo()));
        AssertUtil.assertNotCollection(detailDto, "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5546\u54c1\u4fe1\u606f");
        InventoryReqDto inventoryReqDto = new InventoryReqDto();
        inventoryReqDto.setAutoSubmit(Boolean.valueOf(true));
        inventoryReqDto.setAutoAudit(Boolean.valueOf(true));
        MoveIssueBill moveIssueBill = new MoveIssueBill();
        moveIssueBill.setSeq(dto.getTransferOrderNo());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        moveIssueBill.setBizDate(format.format(dto.getCreateTime()));
        moveIssueBill.setDescription(dto.getRemark());
        moveIssueBill.setIssueStorageOrgUnit(this.getOrgCodeByWarehouseCode(dto.getOutLogicWarehouseCode()));
        moveIssueBill.setReceiptStorageOrgUnit(this.getOrgCodeByWarehouseCode(dto.getInLogicWarehouseCode()));
        ArrayList entries = new ArrayList();
        detailDto.forEach(detail -> {
            MoveIssueBillEntry entry = new MoveIssueBillEntry();
            entry.setExtSeq(detail.getId().toString());
            entry.setQty(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? "0" : detail.getQuantity().toString());
            entry.setBaseQty(entry.getQty());
            entry.setMaterial(detail.getLongCode());
            entry.setIssueWarehouse(dto.getOutLogicWarehouseCode());
            entry.setReceiptWarehouse(dto.getInLogicWarehouseCode());
            entry.setIssuePlanDate(ObjectUtil.isNotEmpty((Object)dto.getPlanInTime()) ? format.format(dto.getPlanInTime()) : format.format(new Date()));
            entry.setReceiptPlanDate(ObjectUtil.isNotEmpty((Object)dto.getPlanOutTime()) ? format.format(dto.getPlanOutTime()) : format.format(new Date()));
            entry.setLot(detail.getBatch());
            entries.add(entry);
        });
        moveIssueBill.setEntrys(entries);
        inventoryReqDto.setStocktransferorders((List)Lists.newArrayList((Object[])new MoveIssueBill[]{moveIssueBill}));
        EASOrderBaseResult easOrderBaseResult = (EASOrderBaseResult)RestResponseHelper.extractData((RestResponse)this.externalOutEasApi.inventoryAllot(inventoryReqDto));
        logger.info("EAS\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)easOrderBaseResult));
        if (ObjectUtil.isEmpty((Object)easOrderBaseResult) || StringUtils.isBlank((CharSequence)easOrderBaseResult.getOrderNum()) || CollectionUtil.isEmpty((Collection)easOrderBaseResult.getItemList())) {
            throw new BizException("-1", "EAS\u8c03\u62e8\u5355\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.updateExtension(dto, detailDto, easOrderBaseResult);
    }

    public void create(String no, EASGeneralSubBillFlagEnum flagEnum, CsDeliveryReceiveResultRespDto resultDto, boolean saveResponse) {
        logger.info("\u63a8\u9001EAS\u8c03\u62e8\u5355\u5e76\u521b\u5efa\u5b50\u5355\uff1a{}\uff0c{}", (Object)no, (Object)flagEnum.value);
        AssertUtil.assertNotBlank(no, "\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsTransferOrderRespDto dto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(no));
        AssertUtil.assertEmpty(no, "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u4fe1\u606f");
        List detailDto = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryListByTransferOrderNo(dto.getTransferOrderNo()));
        AssertUtil.assertNotCollection(detailDto, "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5546\u54c1\u4fe1\u606f");
        InventoryReqDto inventoryReqDto = new InventoryReqDto();
        inventoryReqDto.setAutoSubmit(Boolean.valueOf(true));
        inventoryReqDto.setAutoAudit(Boolean.valueOf(true));
        inventoryReqDto.setAutoCreateSubBill(Boolean.valueOf(true));
        Object resultMap = null;
        MoveIssueBill moveIssueBill = new MoveIssueBill();
        moveIssueBill.setSeq(dto.getTransferOrderNo());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        moveIssueBill.setBizDate(format.format(dto.getCreateTime()));
        moveIssueBill.setDescription(dto.getRemark());
        moveIssueBill.setIssueStorageOrgUnit(this.getOrgCodeByWarehouseCode(dto.getOutLogicWarehouseCode()));
        moveIssueBill.setReceiptStorageOrgUnit(this.getOrgCodeByWarehouseCode(dto.getInLogicWarehouseCode()));
        moveIssueBill.setGeneralSubBillFlag(flagEnum.code);
        ArrayList entries = new ArrayList();
        resultDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
            MoveIssueBillEntry entry = new MoveIssueBillEntry();
            entry.setExtSeq(detail.getId().toString());
            entry.setQty(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? "0" : detail.getQuantity().toString());
            entry.setBaseQty(entry.getQty());
            entry.setMaterial(detail.getLongCode());
            entry.setIssueWarehouse(dto.getOutLogicWarehouseCode());
            entry.setReceiptWarehouse(dto.getInLogicWarehouseCode());
            entry.setIssuePlanDate(format.format(new Date()));
            entry.setReceiptPlanDate(entry.getIssuePlanDate());
            entry.setLot(detail.getBatch());
            entry.setExp(ObjectUtil.isNotEmpty((Object)detail.getExpireTime()) ? format.format(detail.getExpireTime()) : null);
            entry.setMfg(ObjectUtil.isNotEmpty((Object)detail.getProduceTime()) ? format.format(detail.getProduceTime()) : null);
            entries.add(entry);
        });
        moveIssueBill.setEntrys(entries);
        inventoryReqDto.setStocktransferorders((List)Lists.newArrayList((Object[])new MoveIssueBill[]{moveIssueBill}));
        EASOrderBaseResult easOrderBaseResult = (EASOrderBaseResult)RestResponseHelper.extractData((RestResponse)this.externalOutEasApi.inventoryAllot(inventoryReqDto));
        logger.info("EAS\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)easOrderBaseResult));
        if (ObjectUtil.isEmpty((Object)easOrderBaseResult) || StringUtils.isBlank((CharSequence)easOrderBaseResult.getOrderNum()) || CollectionUtil.isEmpty((Collection)easOrderBaseResult.getItemList())) {
            throw new BizException("-1", "EAS\u8c03\u62e8\u5355\u521b\u5efa\u5931\u8d25\uff01");
        }
        if (saveResponse) {
            logger.info("\u4fdd\u5b58eas\u8c03\u62e8\u5355\u53f7\u53ca\u5206\u5f55\u7f16\u53f7");
            this.updateExtension(dto, detailDto, easOrderBaseResult);
        }
    }

    public void create(AdjustmentInventoryRespDto adjustment, CsTransferOrderRespDto transferOrder, EASGeneralSubBillFlagEnum flagEnum, String type, CsOutResultOrderRespDto csOutResultOrderRespDto) {
        logger.info("eas\u521b\u5efa\u8c03\u62e8\u5355\u5e76\u521b\u5efa\u5b57\u5355\uff1a{},{},{},{}", new Object[]{flagEnum.value, type, JSON.toJSONString((Object)adjustment), JSON.toJSONString((Object)transferOrder)});
        InventoryReqDto inventoryReqDto = new InventoryReqDto();
        inventoryReqDto.setAutoSubmit(Boolean.valueOf(true));
        inventoryReqDto.setAutoAudit(Boolean.valueOf(true));
        inventoryReqDto.setAutoCreateSubBill(Boolean.valueOf(true));
        MoveIssueBill moveIssueBill = new MoveIssueBill();
        moveIssueBill.setSeq(adjustment.getAdjustmentNo());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        moveIssueBill.setBizDate(format.format(adjustment.getCreateTime()));
        moveIssueBill.setDescription(adjustment.getAdjustmentRemark());
        String outWarehouseCode = "";
        String inWarehouseCode = "";
        if (type.equals(ADD)) {
            outWarehouseCode = ObjectUtil.isNotEmpty((Object)csOutResultOrderRespDto) ? csOutResultOrderRespDto.getOutLogicWarehouseCode() : transferOrder.getOutLogicWarehouseCode();
            inWarehouseCode = adjustment.getWarehouseCode();
        } else {
            outWarehouseCode = adjustment.getWarehouseCode();
            inWarehouseCode = ObjectUtil.isNotEmpty((Object)csOutResultOrderRespDto) ? csOutResultOrderRespDto.getInLogicWarehouseCode() : transferOrder.getInLogicWarehouseCode();
        }
        moveIssueBill.setIssueStorageOrgUnit(this.getOrgCodeByWarehouseCode(outWarehouseCode));
        moveIssueBill.setReceiptStorageOrgUnit(this.getOrgCodeByWarehouseCode(inWarehouseCode));
        moveIssueBill.setGeneralSubBillFlag(flagEnum.code);
        ArrayList entries = new ArrayList();
        String finalOutWarehouseCode = outWarehouseCode;
        String finalInWarehouseCode = inWarehouseCode;
        adjustment.getDetailRespDtoList().forEach(detail -> {
            MoveIssueBillEntry entry = new MoveIssueBillEntry();
            entry.setExtSeq(detail.getId().toString());
            entry.setQty(ObjectUtil.isEmpty((Object)detail.getChangeQuantity()) ? "0" : detail.getChangeQuantity().toString());
            entry.setBaseQty(entry.getQty());
            entry.setMaterial(detail.getLongCode());
            entry.setIssueWarehouse(finalOutWarehouseCode);
            entry.setReceiptWarehouse(finalInWarehouseCode);
            entry.setIssuePlanDate(ObjectUtil.isNotEmpty((Object)transferOrder.getPlanInTime()) ? format.format(transferOrder.getPlanInTime()) : format.format(new Date()));
            entry.setReceiptPlanDate(ObjectUtil.isNotEmpty((Object)transferOrder.getPlanOutTime()) ? format.format(transferOrder.getPlanOutTime()) : format.format(new Date()));
            entry.setLot(detail.getBatch());
            CsLogicInventoryRespDto logicInventory = this.queryOtherDate(detail.getLongCode(), entry.getIssueWarehouse(), detail.getBatch());
            if (null != logicInventory) {
                entry.setExp(ObjectUtil.isNotEmpty((Object)logicInventory.getExpireTime()) ? format.format(logicInventory.getExpireTime()) : null);
                entry.setMfg(ObjectUtil.isNotEmpty((Object)logicInventory.getProduceTime()) ? format.format(logicInventory.getProduceTime()) : null);
            }
            entries.add(entry);
        });
        moveIssueBill.setEntrys(entries);
        inventoryReqDto.setStocktransferorders((List)Lists.newArrayList((Object[])new MoveIssueBill[]{moveIssueBill}));
        RestResponseHelper.extractData((RestResponse)this.externalOutEasApi.inventoryAllot(inventoryReqDto));
    }

    private void updateExtension(CsTransferOrderRespDto dto, List<CsTransferOrderDetailRespDto> detailDto, EASOrderBaseResult result) {
        logger.info("\u4fdd\u5b58eas\u8c03\u62e8\u5355\u53f7\u53ca\u5206\u5f55\u7f16\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        logger.info(JSON.toJSONString(detailDto));
        logger.info(JSON.toJSONString((Object)result));
        CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
        csTransferOrderReqDto.setId(dto.getId());
        csTransferOrderReqDto.setPreOrderNo(result.getOrderNum());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(EASExtendKeyEnum.SOURCE_NUM.code, result.getOrderNum());
        map.put(EASExtendKeyEnum.SOURCE_ID.code, result.getOrderId());
        csTransferOrderReqDto.setExtension(JSON.toJSONString(map));
        Map resultMap = result.getItemList().stream().collect(Collectors.toMap(EASInventoryAllotDetailResult::getOutId, Function.identity(), (k1, k2) -> k1));
        ArrayList list = new ArrayList();
        detailDto.forEach(detail -> {
            EASInventoryAllotDetailResult detailResultMap = (EASInventoryAllotDetailResult)resultMap.get(detail.getId().toString());
            if (ObjectUtil.isEmpty((Object)detailResultMap)) {
                throw new BizException("-1", "EAS\u8fd4\u56de\u660e\u7ec6\u5f02\u5e38");
            }
            HashMap<String, String> detailMap = new HashMap<String, String>();
            detailMap.put(EASExtendKeyEnum.ENTRY_ID.code, detailResultMap.getId());
            CsTransferOrderDetailReqDto reqDto = new CsTransferOrderDetailReqDto();
            reqDto.setId(detail.getId());
            reqDto.setExtension(JSON.toJSONString(detailMap));
            list.add(reqDto);
        });
        this.csTransferOrderApi.modifyCsTransferOrderExtension(csTransferOrderReqDto);
        this.csTransferOrderDetailApi.modifyCsTransferOrderDetailExtension(list);
    }

    private String getOrgCodeByWarehouseCode(String warehouseCode) {
        logger.info("\u83b7\u53d6\u5e93\u5b58\u7ec4\u7ec7getOrgCodeByWarehouseCode\uff1a{}", (Object)warehouseCode);
        AssertUtil.assertNotBlank(warehouseCode, "\u4ed3\u5e93\u7f16\u53f7\u4e3a\u7a7a");
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setWarehouseCode(warehouseCode);
        queryDto.setWarehouseStatus(CsLogicWarehouseStatusEnum.ENABLE.getCode());
        List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryByParam(queryDto));
        AssertUtil.assertNotCollection(warehouseRespDtoList, "\u627e\u4e0d\u5230\u5e93\u5b58\u7ec4\u7ec7\u7f16\u53f7");
        return ((CsLogicWarehouseRespDto)warehouseRespDtoList.get(0)).getCargoEscheatageId();
    }

    private CsLogicInventoryRespDto queryOtherDate(String longCode, String warehouseCode, String batch) {
        logger.info("\u83b7\u53d6\u8d27\u54c1\u751f\u4ea7\uff0c\u8fc7\u671f\u65e5\u671f\uff1a{},{},{}", new Object[]{longCode, warehouseCode, batch});
        CsLogicInventoryQueryDto params = new CsLogicInventoryQueryDto();
        params.setLongCode(longCode);
        params.setWarehouseCode(warehouseCode);
        params.setBatch(batch);
        List select = (List)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryInfoList(params));
        if (CollectionUtil.isNotEmpty((Collection)select)) {
            return (CsLogicInventoryRespDto)select.get(0);
        }
        return null;
    }
}

