/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.service.ISchedulerService;
import com.dtyunxi.cis.pms.biz.service.scheduler.config.InstanceInfo;
import com.dtyunxi.cis.pms.biz.service.scheduler.config.SchedulerTaskProperties;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.IAppBizApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="MySchedulerServiceImpl")
public class SchedulerServiceImpl
implements ISchedulerService {
    private static Logger logger = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    @Autowired
    private ITaskApi taskApi;
    @Autowired
    private ITaskQueryApi taskQueryApi;
    @Autowired
    private IAppBizApi appBizApi;
    @Autowired
    private IAppBizQueryApi appBizQueryApi;
    @Autowired
    private SchedulerTaskProperties schedulerTaskProperties;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    @Override
    public void initScheduler() {
        logger.info("=========>\u5f00\u59cb\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u521d\u59cb\u5316");
        List<InstanceInfo> instanceList = this.schedulerTaskProperties.getInstanceList();
        if (CollectionUtils.isEmpty(instanceList)) {
            logger.info("=========>\u672a\u68c0\u6d4b\u5230\u8c03\u5ea6\u4efb\u52a1\u914d\u7f6e");
            return;
        }
        List<TaskAndBizCreateReqDto> taskAndBizList = this.schedulerTaskProperties.getTaskList();
        if (CollectionUtils.isEmpty(taskAndBizList)) {
            logger.info("=========>\u672a\u68c0\u6d4b\u5230\u8c03\u5ea6\u5b9e\u4f8b\u914d\u7f6e");
            return;
        }
        logger.info("\u8c03\u5ea6\u914d\u7f6e\u5b9e\u4f8b{}", (Object)ObjectHelper.bean2Json(this.schedulerTaskProperties.getInstanceList()));
        logger.info("\u914d\u7f6e\u4efb\u52a1\u5217\u8868{}", (Object)ObjectHelper.bean2Json(this.schedulerTaskProperties.getTaskList()));
        ArrayList successList = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        for (InstanceInfo instanceInfo : instanceList) {
            for (TaskAndBizCreateReqDto taskAndBizCreateReqDto : taskAndBizList) {
                AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
                appBizQueryReqDto.setAppCode(this.appCode);
                appBizQueryReqDto.setBizCode(taskAndBizCreateReqDto.getBizCode());
                String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
                PageInfo pageInfo = (PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData();
                if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    try {
                        this.createTaskAndBiz(taskAndBizCreateReqDto, instanceInfo);
                        successList.add(taskAndBizCreateReqDto.getBizName());
                    }
                    catch (Exception ex) {
                        failList.add(taskAndBizCreateReqDto.getBizName());
                        logger.error("\u3010\u3011\u521b\u5efa\u5931\u8d25", (Object)taskAndBizCreateReqDto.getBizName(), (Object)ex);
                    }
                    continue;
                }
                try {
                    AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)pageInfo.getList().get(0);
                    this.modifyTaskAndBiz(taskAndBizCreateReqDto, origAppBiz, instanceInfo);
                    successList.add(taskAndBizCreateReqDto.getBizName());
                }
                catch (Exception ex) {
                    failList.add(taskAndBizCreateReqDto.getBizName());
                    logger.error("\u3010\u3011\u4fee\u6539\u5931\u8d25", (Object)taskAndBizCreateReqDto.getBizName(), (Object)ex);
                }
            }
        }
        successList.forEach(taskName -> logger.info("=========>\u3010[{}]\u4efb\u52a1\u8fdb\u884c\u4e2d\u3002\u3002\u3002\u3011", taskName));
        failList.forEach(taskName -> logger.info("=========>\u3010[{}]\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25\u3011", taskName));
    }

    private Long createTaskAndBiz(TaskAndBizCreateReqDto task, InstanceInfo instanceInfo) {
        Long taskId = null;
        task.setAppCode(this.appCode);
        task.setTaskName(task.getBizName());
        task.setShardType("SINGLE");
        String params = ObjectHelper.bean2Json((Object)instanceInfo);
        task.setParams(params);
        task.setInstanceId(instanceInfo.getInstanceId());
        task.setTenantId(instanceInfo.getTenantId());
        RestResponse restResponse = this.taskApi.addWithBiz(task);
        taskId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        RequestDto enableParam = new RequestDto();
        enableParam.setInstanceId(instanceInfo.getInstanceId());
        enableParam.setTenantId(instanceInfo.getTenantId());
        String filter = ObjectHelper.bean2Json((Object)enableParam);
        RestResponse enableResponse = this.taskApi.enableById(taskId, filter);
        RestResponseHelper.checkOrThrow((RestResponse)enableResponse);
        return taskId;
    }

    private void modifyTaskAndBiz(TaskAndBizCreateReqDto task, AppBizQueryRespDto origAppBiz, InstanceInfo instanceInfo) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u3011\u4efb\u52a1\u4e0d\u5b58\u5728", origAppBiz.getBizName());
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        if (!origTask.getScheduleExpression().equals(task.getScheduleExpression()) || !origTask.getTaskName().equals(task.getBizName())) {
            AppBizUpdateReqDto appBiz = new AppBizUpdateReqDto();
            appBiz.setBizName(task.getBizName());
            appBiz.setInstanceId(instanceInfo.getInstanceId());
            appBiz.setTenantId(instanceInfo.getTenantId());
            this.appBizApi.modifyById(origAppBiz.getId(), appBiz);
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            RestResponseHelper.checkOrThrow((RestResponse)disableResponse);
            TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
            taskUpate.setScheduleExpression(task.getScheduleExpression());
            taskUpate.setTaskName(task.getBizName());
            taskUpate.setInstanceId(instanceInfo.getInstanceId());
            taskUpate.setTenantId(instanceInfo.getTenantId());
            String params = ObjectHelper.bean2Json((Object)instanceInfo);
            taskUpate.setParams(params);
            this.taskApi.modifyById(origTask.getId(), taskUpate);
            RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
            RestResponseHelper.checkOrThrow((RestResponse)enbaleResponse);
        }
    }

    public String getCron(Date date) {
        return DateUtil.getDateFormat((Date)date, (String)"ss mm HH dd MM ? yyyy");
    }
}

