/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.AgainCalculateParams;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportListVO;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportMergePageParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportMergeReportVO;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportUpdateBillingPageParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportUpdateBillingReportVO;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticsExportDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticsReportDto;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsFreightLogisticsFreightReportListService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.DateTimeUtils;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportEditReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportQueryListDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOperateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticsReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.query.IFinLogisticsReportQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_logistic_report_other_statement")
public class ReportCenterLogisticsFreightLogisticsFreightReportListServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterLogisticsFreightLogisticsFreightReportListService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterLogisticsFreightLogisticsFreightReportListServiceServiceImpl.class);
    @Resource
    private IFinLogisticsReportApi finLogisticsReportApi;
    @Resource
    private IFinLogisticsReportQueryApi finLogisticsReportQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IPCPCustomerQueryApi ipcpCustomerQueryApi;
    @Resource
    private BasedataCenterAreaService centerAreaService;
    private static final List<String> CARRIER_MODE = Lists.newArrayList();
    private static final List<String> CHARGE_MODE = Lists.newArrayList();
    public static Map<Integer, ChargeModeEnum> CHARGE_MODE_TYPE = new HashMap<Integer, ChargeModeEnum>();

    @Override
    public RestResponse<Long> billforAllSaveLogisticsFreightReportList(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightReportParams params) {
        LogisticOperateReqDto logisticOperateReqDto = new LogisticOperateReqDto();
        logisticOperateReqDto.setId(params.getId());
        logisticOperateReqDto.setDetailIds(params.getDetailIds());
        return this.finLogisticsReportApi.pooledData(logisticOperateReqDto);
    }

    @Override
    public RestResponse<Void> deleteLogisticsFreightReportList(@PathVariable(value="ids") String ids) {
        return this.finLogisticsReportApi.del(ids);
    }

    @Override
    public RestResponse<PageInfo<LogisticsFreightReportListVO>> getLogisticsFreightReportListPage(LogisticsFreightReportListPageParams pageParams) {
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5206\u9875\u5217\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        FinLogisticReportReqDto reqDto = this.getLogisticsFreightReportTransform(pageParams);
        reqDto.setPageNum(pageParams.getPageNum());
        reqDto.setPageSize(pageParams.getPageSize());
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByPageForDailyDeliveryReport(reqDto));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            dtoPageInfo.setList(new ArrayList());
            return new RestResponse((Object)dtoPageInfo);
        }
        logger.info("\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        List resultList = pageInfo.getList().stream().map(m -> {
            LogisticsFreightReportListVO reportVO = (LogisticsFreightReportListVO)BeanUtil.copyProperties((Object)m, LogisticsFreightReportListVO.class, (String[])new String[0]);
            reportVO.setId(m.getId());
            reportVO.setBusinessOrderType(m.getType());
            reportVO.setMergeCode(m.getMergeCode());
            reportVO.setBookkeepingDate(m.getBookkeepingDate());
            reportVO.setBillingDate(m.getBillingDate());
            if (m.getOutboundTime() != null) {
                reportVO.setOutWarehouseTime(DateTimeUtils.getDateTimeStr(m.getOutboundTime(), DateTimeUtils.DATE_FORMATTER));
            }
            reportVO.setEasNo(m.getEasNo());
            reportVO.setLogisticsNo(m.getTransportNo());
            reportVO.setWmsMergeDocumentNo(m.getWmsMergeDocumentNo());
            reportVO.setDocumentNo(m.getOutResultCode());
            reportVO.setOutDocumentNo(m.getOutNoticeCode());
            reportVO.setWarehouseName(m.getWarehouseName());
            reportVO.setOutPhysicsWarehouseName(m.getWarehouseName());
            reportVO.setWmSDocumentNo(m.getWmsOutboundCode());
            reportVO.setBusinessType(m.getBusinessType());
            reportVO.setBusinessOrderNo(m.getBusinessCode());
            reportVO.setLogisticsCompany(m.getLogisticCompany());
            reportVO.setLogisticsType(m.getTransportType());
            reportVO.setShippingNo(m.getTransportCode());
            reportVO.setBottlesNumber(ObjectUtils.isEmpty((Object)m.getBottle()) ? null : String.valueOf(m.getBottle().setScale(0, 4)));
            reportVO.setBoxNum(ObjectUtils.isEmpty((Object)m.getBox()) ? null : String.valueOf(m.getBox().setScale(0, 4)));
            reportVO.setVolume(ObjectUtils.isEmpty((Object)m.getVolume()) ? null : m.getVolume().toString());
            reportVO.setWeight(ObjectUtils.isEmpty((Object)m.getWeight()) ? null : m.getWeight().toString());
            reportVO.setAllBoxNum(ObjectUtils.isEmpty((Object)m.getTotalBox()) ? null : String.valueOf(m.getTotalBox().setScale(0, 4)));
            reportVO.setAllVolume(ObjectUtils.isEmpty((Object)m.getTotalVolume()) ? null : m.getTotalVolume().toString());
            reportVO.setAllWeight(ObjectUtils.isEmpty((Object)m.getTotalWeight()) ? null : m.getTotalWeight().toString());
            reportVO.setLogisticsTemplateArea(m.getProvince() + m.getCity());
            reportVO.setProvince(m.getProvince());
            reportVO.setAddressInfo(m.getCity());
            reportVO.setArea(m.getArea());
            reportVO.setCity(m.getCity());
            reportVO.setCityLevel(m.getCityLevel());
            reportVO.setCustomerName(m.getCustomerName());
            reportVO.setReceiverAddress(m.getHarvestAddress());
            reportVO.setConsignee(m.getHarvestPeople());
            reportVO.setTransferIOutWarehouse(m.getWarehouseOut());
            reportVO.setOutCargoRightName(m.getOrganizationOut());
            reportVO.setTransferIIntoWarehouse(m.getWarehouseEnter());
            reportVO.setInCargoRightName(m.getOrganizationEnter());
            reportVO.setCostAttribution(m.getAmountAttribution());
            reportVO.setBillingMethod(m.getChargeMode());
            reportVO.setContractOilPrice(m.getContractOilPrice());
            reportVO.setLinkOilPrice(m.getLinkOilPrice());
            reportVO.setRangeOilPrice(m.getRangeOilPrice());
            reportVO.setAdjustOilPrice(m.getAdjustOilPrice());
            reportVO.setDeliveryFee(ObjectUtils.isEmpty((Object)m.getDeliveryAmount()) ? null : m.getDeliveryAmount().stripTrailingZeros().toPlainString());
            reportVO.setUnloadingFee(ObjectUtils.isEmpty((Object)m.getUnloadAmount()) ? null : m.getUnloadAmount().stripTrailingZeros().toPlainString());
            reportVO.setOilPriceLinkage(ObjectUtils.isEmpty((Object)m.getOilPrice()) ? null : m.getOilPrice().stripTrailingZeros().toPlainString());
            reportVO.setSpecialExpenseType(m.getSpecialType());
            reportVO.setRemark(m.getRemark());
            reportVO.setUpdateTime(DateTimeUtils.getDateTimeStr(m.getUpdateTime(), DateTimeUtils.DATETIME_FORMATTER));
            reportVO.setAbnormal(m.getStatus().toString());
            reportVO.setAbnormalCauses(m.getAbnormalCauses());
            reportVO.setShopName(m.getShopName());
            if (m.getShareAmount() != null) {
                reportVO.setCostSharing(m.getShareAmount().stripTrailingZeros().toPlainString());
            }
            if (m.getStatus() == 1) {
                if (reportVO.getFreightAmount() == null) {
                    reportVO.setFreightAmount("-");
                }
                if (reportVO.getFreightPrice() == null) {
                    reportVO.setFreightPrice("-");
                }
                reportVO.setTotalFreight("-");
            }
            if (StringUtils.isNotBlank((CharSequence)m.getChargeMode())) {
                try {
                    ChargeModeEnum chargeModeEnum = ChargeModeEnum.getChargeMode((Integer)Integer.valueOf(m.getChargeMode()));
                    if (null != chargeModeEnum) {
                        reportVO.setBillingMethodName(chargeModeEnum.getName());
                    }
                }
                catch (Exception e) {
                    reportVO.setBillingMethodName(m.getChargeMode());
                }
            }
            if (m.getTransportPrice() != null) {
                reportVO.setFreightPrice(m.getTransportPrice().toString());
            }
            if (m.getTransportAmount() != null) {
                reportVO.setFreightAmount(m.getTransportAmount().stripTrailingZeros().toPlainString());
            }
            if (m.getMinCharge() != null) {
                reportVO.setMinimumCharge(m.getMinCharge().stripTrailingZeros().toPlainString());
            }
            if (m.getSpecialAmount() != null) {
                reportVO.setSpecialExpense(String.format("%.2f", m.getSpecialAmount()));
            }
            if (m.getTotalTransportAmount() != null) {
                reportVO.setTotalFreight(m.getTotalTransportAmount().stripTrailingZeros().toPlainString());
            }
            logger.info("\u5f53\u524d\u5355\u636e\u4e3a" + (Objects.equals(Integer.parseInt(m.getType()), LogisticDocumentTypeEnum.MERGE_CHILD.getCode()) ? "\u5b50" : "\u4e3b\u5355"));
            logger.info(JSON.toJSONString((Object)m.getMasterDetailRespDto()));
            if (Objects.equals(Integer.parseInt(m.getType()), LogisticDocumentTypeEnum.MERGE_CHILD.getCode()) && ObjectUtils.isNotEmpty((Object)m.getMasterDetailRespDto())) {
                FinLogisticDetailRespDto masterDto = m.getMasterDetailRespDto();
                reportVO.setAllBoxNum(ObjectUtils.isEmpty((Object)masterDto.getTotalBox()) ? null : masterDto.getTotalBox().toString());
                reportVO.setAllVolume(ObjectUtils.isEmpty((Object)masterDto.getTotalVolume()) ? null : masterDto.getTotalVolume().toString());
                reportVO.setAllWeight(ObjectUtils.isEmpty((Object)masterDto.getTotalWeight()) ? null : masterDto.getTotalWeight().toString());
                reportVO.setFreightPrice(ObjectUtils.isEmpty((Object)masterDto.getTransportPrice()) ? null : masterDto.getTransportPrice().toString());
                reportVO.setFreightAmount(ObjectUtils.isEmpty((Object)masterDto.getTransportAmount()) ? null : masterDto.getTransportAmount().stripTrailingZeros().toPlainString());
                reportVO.setMinimumCharge(ObjectUtils.isEmpty((Object)masterDto.getMinCharge()) ? null : masterDto.getMinCharge().stripTrailingZeros().toPlainString());
                reportVO.setDeliveryFee(ObjectUtils.isEmpty((Object)masterDto.getDeliveryAmount()) ? null : masterDto.getDeliveryAmount().stripTrailingZeros().toPlainString());
                reportVO.setUnloadingFee(ObjectUtils.isEmpty((Object)masterDto.getUnloadAmount()) ? null : masterDto.getUnloadAmount().stripTrailingZeros().toPlainString());
                reportVO.setContractOilPrice(masterDto.getContractOilPrice());
                reportVO.setLinkOilPrice(masterDto.getLinkOilPrice());
                reportVO.setRangeOilPrice(masterDto.getRangeOilPrice());
                reportVO.setAdjustOilPrice(masterDto.getAdjustOilPrice());
                reportVO.setOilPriceLinkage(ObjectUtils.isEmpty((Object)masterDto.getOilPrice()) ? null : masterDto.getOilPrice().stripTrailingZeros().toPlainString());
                reportVO.setSpecialExpenseType(masterDto.getSpecialType());
                reportVO.setSpecialExpense(ObjectUtils.isEmpty((Object)masterDto.getSpecialAmount()) ? null : String.format("%.2f", masterDto.getSpecialAmount()));
                reportVO.setTotalFreight(ObjectUtils.isEmpty((Object)masterDto.getTotalTransportAmount()) ? null : masterDto.getTotalTransportAmount().stripTrailingZeros().toPlainString());
                reportVO.setAbnormal(masterDto.getStatus().toString());
                reportVO.setAbnormalCauses(masterDto.getAbnormalCauses());
                reportVO.setShopName(masterDto.getShopName());
                reportVO.setCostAttribution(masterDto.getAmountAttribution());
                reportVO.setCalUnitName(masterDto.getCalUnitName());
                if (StringUtils.isNotBlank((CharSequence)masterDto.getChargeMode())) {
                    try {
                        ChargeModeEnum chargeModeEnum = ChargeModeEnum.getChargeMode((Integer)Integer.valueOf(masterDto.getChargeMode()));
                        if (null != chargeModeEnum) {
                            reportVO.setBillingMethodName(chargeModeEnum.getName());
                        }
                    }
                    catch (Exception e) {
                        reportVO.setBillingMethodName(masterDto.getChargeMode());
                    }
                }
            }
            return reportVO;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(resultList);
        return new RestResponse((Object)dtoPageInfo);
    }

    private FinLogisticReportReqDto getLogisticsFreightReportTransform(LogisticsFreightReportListPageParams pageParams) {
        FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
        BeanUtils.copyProperties((Object)pageParams, (Object)reqDto);
        Optional.ofNullable(pageParams.getLogisticsCompanyId()).ifPresent(p -> reqDto.setLogisticCompanyCode(p));
        Optional.ofNullable(pageParams.getCityCode()).ifPresent(p -> reqDto.setCityCode(p));
        Optional.ofNullable(pageParams.getDistrictCode()).ifPresent(p -> reqDto.setAreaCode(p));
        Optional.ofNullable(pageParams.getLogisticsType()).ifPresent(p -> reqDto.setTransportType(p));
        Optional.ofNullable(pageParams.getOutCargoRightCode()).ifPresent(p -> reqDto.setOrganizationOut(p));
        Optional.ofNullable(pageParams.getCostAttribution()).ifPresent(p -> reqDto.setAmountAttribution(p));
        Optional.ofNullable(pageParams.getInCargoRightCode()).ifPresent(p -> reqDto.setOrganizationEnter(p));
        Optional.ofNullable(pageParams.getOutWarehouseCode()).ifPresent(p -> reqDto.setWarehouseOutCode(p));
        Optional.ofNullable(pageParams.getInWarehouseCode()).ifPresent(p -> reqDto.setWarehouseEnterCode(p));
        Optional.ofNullable(pageParams.getBusinessType()).ifPresent(p -> reqDto.setBusinessType(p));
        Optional.ofNullable(pageParams.getLogisticsTypeList()).ifPresent(p -> reqDto.setTransportTypeList(p));
        Optional.ofNullable(pageParams.getOrganizationOutList()).ifPresent(p -> reqDto.setOrganizationOutList(p));
        Optional.ofNullable(pageParams.getCostAttributionList()).ifPresent(p -> reqDto.setAmountAttributionList(p));
        Optional.ofNullable(pageParams.getOrganizationEnterList()).ifPresent(p -> reqDto.setOrganizationEnterList(p));
        Optional.ofNullable(pageParams.getWarehouseOutCodeList()).ifPresent(p -> reqDto.setWarehouseOutCodeList(p));
        Optional.ofNullable(pageParams.getWarehouseEnterCodeList()).ifPresent(p -> reqDto.setWarehouseEnterCodeList(p));
        Optional.ofNullable(pageParams.getBusinessTypeList()).ifPresent(p -> reqDto.setBusinessTypeList(p));
        Optional.ofNullable(pageParams.getOutPhysicsWarehouseNameList()).ifPresent(p -> reqDto.setWarehouseNameList(p));
        Optional.ofNullable(pageParams.getBusinessOrderType()).ifPresent(p -> reqDto.setType(Integer.valueOf(p)));
        Optional.ofNullable(pageParams.getBookkeepingDate()).ifPresent(p -> reqDto.setBookkeepingDate(p));
        Optional.ofNullable(pageParams.getCityLevel()).ifPresent(p -> reqDto.setCityLevel(p));
        Optional.ofNullable(pageParams.getCityLevel()).ifPresent(p -> reqDto.setCityLevel(p));
        Optional.ofNullable(pageParams.getEasNo()).ifPresent(p -> reqDto.setEasNo(p));
        Optional.ofNullable(pageParams.getOrganizationEnter()).ifPresent(p -> reqDto.setOrganizationEnter(p));
        Optional.ofNullable(pageParams.getDocumentNo()).ifPresent(p -> reqDto.setOutboundCode(p));
        Optional.ofNullable(pageParams.getWmSDocumentNo()).ifPresent(p -> reqDto.setWmsOutboundCode(p));
        Optional.ofNullable(pageParams.getLogisticsId()).ifPresent(p -> reqDto.setTransportType(p));
        Optional.ofNullable(pageParams.getBusinessOrderNo()).ifPresent(p -> reqDto.setBusinessCode(p));
        Optional.ofNullable(pageParams.getShippingNo()).ifPresent(p -> reqDto.setTransportCode(p));
        Optional.ofNullable(pageParams.getTransferIOutWarehouse()).ifPresent(p -> reqDto.setWarehouseOut(p));
        Optional.ofNullable(pageParams.getOutCargoRightName()).ifPresent(p -> reqDto.setOrganizationOut(p));
        Optional.ofNullable(pageParams.getTransferIIntoWarehouse()).ifPresent(p -> reqDto.setWarehouseEnter(p));
        Optional.ofNullable(pageParams.getInCargoRightName()).ifPresent(p -> reqDto.setOrganizationEnter(p));
        Optional.ofNullable(pageParams.getProvince()).ifPresent(p -> reqDto.setProvince(p));
        Optional.ofNullable(pageParams.getAddressInfo()).ifPresent(p -> reqDto.setCity(p));
        Optional.ofNullable(pageParams.getAbnormal()).ifPresent(p -> reqDto.setStatus(Integer.valueOf(p)));
        Optional.ofNullable(pageParams.getBusinessType()).ifPresent(p -> reqDto.setBusinessType(p));
        Optional.ofNullable(pageParams.getProvinceCode()).ifPresent(p -> reqDto.setProvinceCode(p));
        Optional.ofNullable(pageParams.getCity()).ifPresent(p -> reqDto.setCity(p));
        Optional.ofNullable(pageParams.getArea()).ifPresent(p -> reqDto.setArea(p));
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeStart()) && StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeEnd())) {
            reqDto.setOutboundStartTime(String.format("%s %s", pageParams.getOutWarehouseTimeStart(), "00:00:00"));
            reqDto.setOutboundTimeEndTime(String.format("%s %s", pageParams.getOutWarehouseTimeEnd(), "23:59:59"));
        }
        reqDto.setLogisticCompanyCodeList(pageParams.getLogisticCompanyCodeList());
        logger.info("\u7269\u6d41\u5217\u8868\u8fc7\u6ee4\u6761\u4ef6\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return reqDto;
    }

    @Override
    public RestResponse<ReInsuranceBillCountDto> queryLogisticsCount(LogisticsFreightReportListPageParams pageParams) {
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5dee\u5f02\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        FinLogisticReportReqDto reqDto = this.getLogisticsFreightReportTransform(pageParams);
        return this.finLogisticsReportQueryApi.queryLogisticsAbnormalCountForDailyDeliveryReport(reqDto);
    }

    @Override
    public RestResponse<ReInsuranceBillCountDto> queryLogisticsCostCount(LogisticsFreightReportListPageParams pageParams) {
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u8d39\u7528\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        FinLogisticReportReqDto reqDto = this.getLogisticsFreightReportTransform(pageParams);
        return this.finLogisticsReportQueryApi.queryLogisticsCountForDailyDeliveryReport(reqDto);
    }

    @Override
    public RestResponse<PageInfo<LogisticsFreightReportMergeReportVO>> getLogisticsFreightReportMergePage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightReportMergePageParams pageParams) {
        FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeStart()) && StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeEnd())) {
            reqDto.setOutboundStartTime(pageParams.getOutWarehouseTimeStart());
            reqDto.setOutboundTimeEndTime(String.format("%s %s", pageParams.getOutWarehouseTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getProvinceCode())) {
            reqDto.setProvinceCode(pageParams.getProvinceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getCityCode())) {
            reqDto.setCityCode(pageParams.getCityCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getAreaCode())) {
            reqDto.setAreaCode(pageParams.getAreaCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsCompanyId())) {
            reqDto.setLogisticCompanyCode(pageParams.getLogisticsCompanyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsId())) {
            reqDto.setTransportType(pageParams.getLogisticsId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBillingMethodId())) {
            reqDto.setChargeMode(pageParams.getBillingMethodId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getShippingNo())) {
            reqDto.setTransportCode(pageParams.getShippingNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getWarehouseCode())) {
            reqDto.setWarehouseId(pageParams.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBusinessType())) {
            reqDto.setBusinessType(pageParams.getBusinessType());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getProvince())) {
            reqDto.setProvince(pageParams.getProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getCity())) {
            reqDto.setCity(pageParams.getCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getArea())) {
            reqDto.setArea(pageParams.getArea());
        }
        reqDto.setPageNum(pageParams.getPageNum());
        reqDto.setPageSize(pageParams.getPageSize());
        RestResponse restResponse = this.finLogisticsReportQueryApi.queryByPage(reqDto);
        if ("0".equals(restResponse.getResultCode())) {
            PageInfo pageInfo = (PageInfo)restResponse.getData();
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList<LogisticsFreightReportMergeReportVO> reportListVOS = new ArrayList<LogisticsFreightReportMergeReportVO>();
                for (FinLogisticsReportRespDto respDto : pageInfo.getList()) {
                    LogisticsFreightReportMergeReportVO reportListVO = new LogisticsFreightReportMergeReportVO();
                    BeanUtils.copyProperties((Object)respDto, (Object)reportListVO);
                    reportListVO.setOutWarehouseTime(DateTimeUtils.getDateTimeStr(respDto.getOutboundTime(), DateTimeUtils.DATE_FORMATTER));
                    reportListVO.setParentId(respDto.getParentId());
                    reportListVO.setWarehouseName(respDto.getWarehouseName());
                    reportListVO.setLogisticsCompanyId(respDto.getLogisticId());
                    reportListVO.setLogisticsCompany(respDto.getLogisticCompany());
                    reportListVO.setLogisticsType(respDto.getTransportType());
                    reportListVO.setShippingNo(respDto.getTransportCode());
                    reportListVO.setBillingMethod(respDto.getChargeMode());
                    reportListVO.setProvince(respDto.getProvince());
                    reportListVO.setAddressInfo(respDto.getArea());
                    reportListVO.setReceiverAddress(respDto.getHarvestAddress());
                    reportListVO.setCreateTime(DateTimeUtils.getDateTimeStr(respDto.getCreateTime()));
                    reportListVO.setCreatePerson(respDto.getCreatePerson());
                    reportListVO.setUpdateTime(DateTimeUtils.getDateTimeStr(respDto.getUpdateTime()));
                    reportListVO.setUpdatePerson(respDto.getUpdatePerson());
                    reportListVOS.add(reportListVO);
                }
                if (CollectionUtils.isNotEmpty(reportListVOS)) {
                    dtoPageInfo.setList(reportListVOS);
                }
            }
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogisticsFreightReportUpdateBillingReportVO>> getLogisticsFreightReportUpdateBillingPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightReportUpdateBillingPageParams pageParams) {
        FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsCompanyId())) {
            reqDto.setLogisticCompany(pageParams.getLogisticsCompanyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsId())) {
            reqDto.setTransportType(pageParams.getLogisticsId());
        }
        reqDto.setPageNum(pageParams.getPageNum());
        reqDto.setPageSize(pageParams.getPageSize());
        RestResponse restResponse = this.finLogisticsReportQueryApi.queryByPage(reqDto);
        if ("0".equals(restResponse.getResultCode())) {
            PageInfo pageInfo = (PageInfo)restResponse.getData();
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList<LogisticsFreightReportUpdateBillingReportVO> reportListVOS = new ArrayList<LogisticsFreightReportUpdateBillingReportVO>();
                for (FinLogisticsReportRespDto respDto : pageInfo.getList()) {
                    LogisticsFreightReportUpdateBillingReportVO reportListVO = new LogisticsFreightReportUpdateBillingReportVO();
                    BeanUtils.copyProperties((Object)respDto, (Object)reportListVO);
                    reportListVO.setParentId(respDto.getParentId());
                    reportListVO.setWarehouseName(respDto.getWarehouseName());
                    reportListVO.setLogisticsCompanyId(respDto.getLogisticId());
                    reportListVO.setLogisticsCompany(respDto.getLogisticCompany());
                    reportListVO.setLogisticsType(respDto.getTransportType());
                    reportListVO.setBillingMethod(respDto.getChargeMode());
                    reportListVO.setStatus(respDto.getStatus().toString());
                    reportListVO.setCreateTime(DateTimeUtils.getDateTimeStr(respDto.getCreateTime()));
                    reportListVO.setCreatePerson(respDto.getCreatePerson());
                    reportListVO.setUpdateTime(DateTimeUtils.getDateTimeStr(respDto.getUpdateTime()));
                    reportListVO.setUpdatePerson(respDto.getUpdatePerson());
                    reportListVOS.add(reportListVO);
                }
                if (CollectionUtils.isNotEmpty(reportListVOS)) {
                    dtoPageInfo.setList(reportListVOS);
                }
            }
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> splitLogisticsFreightReportList(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightReportParams params) {
        LogisticOperateReqDto logisticOperateReqDto = new LogisticOperateReqDto();
        logisticOperateReqDto.setId(params.getId());
        logisticOperateReqDto.setDetailIds(params.getDetailIds());
        RestResponse response = this.finLogisticsReportApi.resolutionData(logisticOperateReqDto);
        if ("0".equals(response.getResultCode())) {
            return new RestResponse(response.getData());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> updateSaveLogisticsFreightReportListUpdateSave(AgainCalculateParams params) {
        AgainCalculateReqDto reqDto = new AgainCalculateReqDto();
        reqDto.setAbnormal(params.getAbnormal());
        reqDto.setContractId(params.getContractId());
        reqDto.setStartDate(params.getStartDate());
        reqDto.setEndDate(params.getEndDate());
        return this.finLogisticsReportApi.againCalculate(reqDto);
    }

    @Override
    public RestResponse<Void> edit(FinLogisticsReportEditReqDto editReqDto) {
        return this.finLogisticsReportApi.edit(editReqDto);
    }

    @Override
    public RestResponse<Void> editAddress(FinLogisticsReportEditReqDto editReqDto) {
        return this.finLogisticsReportApi.editAddress(editReqDto);
    }

    @Override
    public RestResponse<Void> generateForDailyDeliveryReport(LogisticStatisticReqDto reqDto) {
        return this.finLogisticsReportApi.generateLogisticStatisticDataForDailyDeliveryReport(reqDto);
    }

    @Override
    public RestResponse<Void> updateSpecial(FinLogisticsDetailReqDto reqDto) {
        return this.finLogisticsReportApi.updateSpecial(reqDto);
    }

    @Override
    public RestResponse<Void> delByIds(List<Long> ids) {
        return this.finLogisticsReportApi.delByIds(ids);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateLogisticsReportDto.class);
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5355\u636e\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashMap dataMap = Maps.newHashMap();
        HashSet codeSet = Sets.newHashSet();
        HashSet outNoticeCodes = Sets.newHashSet();
        HashSet warehouseCodes = Sets.newHashSet();
        HashSet customerCodes = Sets.newHashSet();
        list.forEach(i -> {
            String code = String.format("%s", i.getOutNoticeCode());
            if (dataMap.containsKey(code)) {
                codeSet.add(code);
            } else {
                dataMap.put(code, i);
            }
            outNoticeCodes.add(i.getOutNoticeCode());
            warehouseCodes.add(i.getWarehouseEnterCode());
            warehouseCodes.add(i.getWarehouseOutCode());
            customerCodes.add(i.getCustomerCode());
        });
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat(com.dtyunxi.constant.enums.DatePattern.DATE_PATTERN.getPattern());
        FinLogisticsReportQueryListDto finLogisticsReportQueryListDto = new FinLogisticsReportQueryListDto();
        finLogisticsReportQueryListDto.setOutNoticeCodeList((List)Lists.newArrayList((Iterable)outNoticeCodes));
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByList(finLogisticsReportQueryListDto));
        Map dtoMap = respDtos.stream().collect(Collectors.toMap(FinLogisticsReportRespDto::getOutNoticeCode, Function.identity(), (k1, k3) -> k1));
        Map<String, String> physicalWareshouseNames = this.queryPhysicalWareshouseName();
        Map<String, CsShipmenetEnterpriseRespDto> shipmenetEnterprise = this.getShipmenetEnterprise();
        Map<String, LogicWarehouseRespDto> logicWarehouseMap = this.getLogicWarehouseMap(warehouseCodes);
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        searchReqDto.setCodeInList(new ArrayList(customerCodes));
        List customerList = (List)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetail(searchReqDto));
        Map customerMap = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerList)) {
            customerMap = customerList.stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        }
        Map finalCustomerMap = customerMap;
        Map areaMap = this.centerAreaService.getAreaList().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
        list.stream().forEach(i -> {
            TemplateLogisticsReportDto msgDto = new TemplateLogisticsReportDto();
            BeanUtils.copyProperties((Object)i, (Object)((Object)msgDto));
            String code = String.format("%s", i.getOutNoticeCode());
            i.setOutboundCode(code);
            if (codeSet.contains(code)) {
                msgDto.setMsg("\u6570\u636e\u91cd\u590d");
            }
            this.checkDateFormat((TemplateLogisticsReportDto)((Object)i), msgDto, sdf);
            if (dtoMap.containsKey(i.getOutNoticeCode())) {
                this.setMsg(msgDto, "\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u5df2\u5b58\u5728\u62a5\u8868\u6570\u636e");
            }
            this.checkPhysicalWareshouse(physicalWareshouseNames, (TemplateLogisticsReportDto)((Object)i), msgDto);
            this.checkShipmenetEnterprise(shipmenetEnterprise, (TemplateLogisticsReportDto)((Object)i), msgDto);
            this.checkCarrierMode(CARRIER_MODE, (TemplateLogisticsReportDto)((Object)i), msgDto);
            this.checkChargeMode(CHARGE_MODE, (TemplateLogisticsReportDto)((Object)i), msgDto, CHARGE_MODE_TYPE);
            this.checkWarehouse((LogicWarehouseRespDto)logicWarehouseMap.get(i.getWarehouseOutCode()), msgDto, (TemplateLogisticsReportDto)((Object)i), 1);
            this.checkWarehouse((LogicWarehouseRespDto)logicWarehouseMap.get(i.getWarehouseEnterCode()), msgDto, (TemplateLogisticsReportDto)((Object)i), 2);
            this.checkCustomerCode(finalCustomerMap, (TemplateLogisticsReportDto)((Object)i), msgDto);
            this.checkArea(areaMap, (TemplateLogisticsReportDto)((Object)i), msgDto);
            this.checkSpecialType((TemplateLogisticsReportDto)((Object)i), msgDto);
            FinLogisticsReportDto saveDto = new FinLogisticsReportDto();
            BeanUtils.copyProperties((Object)i, (Object)saveDto);
            this.importBuildFinLogisticsReportDto((TemplateLogisticsReportDto)((Object)i), saveDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                if (StringUtils.isNotBlank((CharSequence)i.getOutboundTimeExt())) {
                    msgDto.setOutboundTime(i.getOutboundTimeExt());
                }
                msgList.add(msgDto);
            } else {
                if (StringUtils.isNotBlank((CharSequence)i.getOutboundTime())) {
                    DateTime time = DateUtil.parse((CharSequence)i.getOutboundTime());
                    saveDto.setOutboundTime((Date)time);
                    if (StrUtil.isNotBlank((CharSequence)i.getVolume())) {
                        saveDto.setVolume(new BigDecimal(i.getVolume()));
                    } else {
                        saveDto.setVolume(BigDecimal.ZERO);
                    }
                    if (StrUtil.isNotBlank((CharSequence)i.getWeight())) {
                        saveDto.setWeight(new BigDecimal(i.getWeight()));
                    } else {
                        saveDto.setWeight(BigDecimal.ZERO);
                    }
                    saveDto.setStatus(Integer.valueOf(0));
                    if (ObjectUtils.isNotEmpty((Object)saveDto.getOutboundTime())) {
                        saveDto.setBillingDate(com.dtyunxi.util.DateUtil.format((Date)saveDto.getOutboundTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                        saveDto.setBookkeepingDate(com.dtyunxi.util.DateUtil.format((Date)saveDto.getOutboundTime(), (String)DatePattern.MONTH_PATTERN.getPattern()));
                    }
                }
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private void importBuildFinLogisticsReportDto(TemplateLogisticsReportDto importDto, FinLogisticsReportDto reportDto) {
        reportDto.setType("3");
        if (StringUtils.isNotBlank((CharSequence)importDto.getBottle())) {
            reportDto.setBottle(new BigDecimal(importDto.getBottle()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getBox())) {
            reportDto.setBox(new BigDecimal(importDto.getBox()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getTransportPrice())) {
            reportDto.setTransportPrice(new BigDecimal(importDto.getTransportPrice()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getTransportAmount())) {
            reportDto.setTransportAmount(new BigDecimal(importDto.getTransportAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getMinCharge())) {
            reportDto.setMinCharge(new BigDecimal(importDto.getMinCharge()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getDeliveryAmount())) {
            reportDto.setDeliveryAmount(new BigDecimal(importDto.getDeliveryAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getUnloadAmount())) {
            reportDto.setUnloadAmount(new BigDecimal(importDto.getUnloadAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getOilPrice())) {
            reportDto.setOilPrice(new BigDecimal(importDto.getOilPrice()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getTotalTransportAmount())) {
            reportDto.setTotalTransportAmount(new BigDecimal(importDto.getTotalTransportAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getSpecialAmount())) {
            reportDto.setSpecialAmount(new BigDecimal(importDto.getSpecialAmount()));
        }
    }

    private void checkSpecialType(TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (StringUtils.isBlank((CharSequence)i.getSpecialType())) {
            return;
        }
        String adjustType = i.getSpecialType();
        if (!Objects.equals("\u589e\u52a0", adjustType) && !Objects.equals("\u51cf\u5c11", adjustType)) {
            this.setMsg(msgDto, "\u7279\u6b8a\u7c7b\u578b\u9519\u8bef");
            return;
        }
        if (adjustType.equals("\u589e\u52a0")) {
            // empty if block
        }
        if (adjustType.equals("\u51cf\u5c11")) {
            // empty if block
        }
        i.setSpecialType(adjustType);
    }

    private void checkCustomerCode(Map<String, PCPCustomerRespDto> customerMap, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (StringUtils.isNotBlank((CharSequence)i.getCustomerCode())) {
            if (CollectionUtil.isEmpty(customerMap) || !customerMap.containsKey(i.getCustomerCode())) {
                this.setMsg(msgDto, "\u5ba2\u6237\u7f16\u7801\u4e0d\u6b63\u786e");
                return;
            }
            PCPCustomerRespDto pcpCustomerRespDto = customerMap.get(i.getCustomerCode());
            i.setCustomerName(pcpCustomerRespDto.getCustomerName());
        }
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByCode((List)Lists.newArrayList(warehouseCodes)));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }

    private void checkWarehouse(LogicWarehouseRespDto warehouse, TemplateLogisticsReportDto msgDto, TemplateLogisticsReportDto i, int type) {
        if (warehouse == null) {
            this.setMsg(msgDto, String.format("%s\u4ed3\u5e93\u7f16\u7801\u4e0d\u6b63\u786e", type == 1 ? "\u8c03\u51fa\u4ed3" : "\u8c03\u5165\u4ed3"));
        } else {
            if (type == 1) {
                i.setWarehouseOut(warehouse.getWarehouseName());
                i.setOrganizationOut(warehouse.getOrganizationName());
            }
            if (type == 2) {
                i.setWarehouseEnter(warehouse.getWarehouseName());
                i.setOrganizationEnter(warehouse.getOrganizationName());
            }
        }
    }

    private void checkCarrierMode(List<String> carrierMode, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (StringUtils.isNotBlank((CharSequence)i.getTransportType()) && !carrierMode.contains(i.getTransportType())) {
            this.setMsg(msgDto, "\u627f\u8fd0\u65b9\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    private void checkChargeMode(List<String> chargeMode, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto, Map<Integer, ChargeModeEnum> CHARGE_MODE_TYPE) {
        if (StringUtils.isNotBlank((CharSequence)i.getTransportType())) {
            if (!chargeMode.contains(i.getChargeMode())) {
                this.setMsg(msgDto, "\u8ba1\u8d39\u65b9\u5f0f\u4e0d\u6b63\u786e");
                return;
            }
            CHARGE_MODE_TYPE.forEach((k, v) -> {
                if (Objects.equals(v.getName(), i.getChargeMode())) {
                    i.setChargeMode(String.valueOf(k));
                }
            });
        }
    }

    private void checkPhysicalWareshouse(Map<String, String> physicalWareshouseNames, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (StringUtils.isNotBlank((CharSequence)i.getWarehouseName())) {
            if (!physicalWareshouseNames.values().contains(i.getWarehouseName())) {
                this.setMsg(msgDto, "\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            } else {
                String warehouseId = physicalWareshouseNames.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(i.getWarehouseName())).map(Map.Entry::getKey).findFirst().orElse(null);
                i.setWarehouseId(warehouseId);
            }
        }
    }

    private void checkShipmenetEnterprise(Map<String, CsShipmenetEnterpriseRespDto> shipmenetEnterprise, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (StringUtils.isNotBlank((CharSequence)i.getWarehouseName())) {
            CsShipmenetEnterpriseRespDto dto = shipmenetEnterprise.get(i.getLogisticCompany());
            if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isBlank((CharSequence)dto.getShipmentEnterpriseCode())) {
                this.setMsg(msgDto, "\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728");
            } else {
                i.setLogisticId(dto.getShipmentEnterpriseCode());
            }
        }
    }

    private Map<String, CsShipmenetEnterpriseRespDto> getShipmenetEnterprise() {
        CsShipmenetEnterpriseQueryDto queryDto = new CsShipmenetEnterpriseQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(100));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(queryDto));
        return respDtoPageInfo.getList().stream().collect(Collectors.toMap(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseName, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, String> queryPhysicalWareshouseName() {
        CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto = new CsPhysicsWarehousePageQueryDto();
        csPhysicsWarehousePageQueryDto.setPageSize(Integer.valueOf(100));
        csPhysicsWarehousePageQueryDto.setPageNum(Integer.valueOf(1));
        RestResponse pageInfo = this.csPhysicsWarehouseExposedQueryApi.queryPageInfo(csPhysicsWarehousePageQueryDto);
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfo);
        return page.getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, CsPhysicsWarehousePageRespDto::getWarehouseName));
    }

    private void checkDateFormat(TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto, SimpleDateFormat sdf) {
        String outboundTime = i.getOutboundTime();
        if (StringUtils.isNotBlank((CharSequence)outboundTime)) {
            try {
                DateTime time = DateUtil.parse((CharSequence)outboundTime);
                if (time == null) {
                    this.setMsg(msgDto, "\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                } else {
                    i.setOutboundTimeExt(DateUtils.format((Date)time));
                }
            }
            catch (Exception e) {
                this.setMsg(msgDto, "\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5355\u636e\u5bfc\u5165\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)map));
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            logger.info("\u7269\u6d41\u8fd0\u8d39\u5355\u636e\u5bfc\u5165\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saveList));
            this.finLogisticsReportApi.insertBatch(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u7269\u6d41\u8fd0\u8d39\u5355\u636e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, TemplateLogisticsReportDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("FinLogisticsReport \u5bfc\u51fa\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\uff1a{}", (Object)JSON.toJSONString((Object)commonReqDto.getFilter()));
        LogisticsFreightReportListPageParams pageParams = new LogisticsFreightReportListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            pageParams = (LogisticsFreightReportListPageParams)JSONObject.parseObject((String)commonReqDto.getFilter(), LogisticsFreightReportListPageParams.class);
        }
        pageParams.setPageNum(1);
        pageParams.setPageSize(1);
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)pageParams));
        PageInfo pageInfo = null;
        try {
            pageParams.setPageSize(1);
            pageParams.setPageNum(1);
            pageInfo = (PageInfo)RestResponseHelper.extractData(this.getLogisticsFreightReportListPage(pageParams));
        }
        catch (Exception e) {
            logger.info("FinLogisticsReportPageError :{}", pageInfo);
            e.printStackTrace();
        }
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u51fa\u53c2:{}", (Object)JSONObject.toJSONString(pageInfo));
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)pageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("FinLogisticsReport \u6267\u884c\u5bfc\u51fa\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5165\u53c2 filter\uff1a{}", (Object)JSON.toJSONString((Object)commonReqDto.getFilter()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LogisticsFreightReportListPageParams pageParams = new LogisticsFreightReportListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            pageParams = (LogisticsFreightReportListPageParams)JSONObject.parseObject((String)commonReqDto.getFilter(), LogisticsFreightReportListPageParams.class);
        }
        Integer dtoPageSize = commonReqDto.getPageSize();
        Integer dtoPageNum = commonReqDto.getPageNum();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < dtoPageNum; ++i) {
            Integer pageSize = 10000;
            Integer pageNum = 0 + i * 5;
            if (dtoPageSize <= pageSize) {
                pageNum = 1 + i * 5;
                pageSize = dtoPageSize;
            } else {
                pageNum = dtoPageSize % pageSize > 0 ? Integer.valueOf(dtoPageSize / pageSize + 1 + i * 5) : Integer.valueOf(dtoPageSize / pageSize + i * 5);
            }
            for (int j = 1 + i * 5; j < pageNum + 1; ++j) {
                pageParams.setPageNum(j);
                pageParams.setPageSize(pageSize);
                logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)pageParams));
                PageInfo logisticsFreightReportListVOPageInfo = null;
                try {
                    logisticsFreightReportListVOPageInfo = (PageInfo)RestResponseHelper.extractData(this.getLogisticsFreightReportListPage(pageParams));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u51fa\u53c2:{}", (Object)logisticsFreightReportListVOPageInfo.getTotal());
                if (!CollectionUtils.isNotEmpty((Collection)logisticsFreightReportListVOPageInfo.getList())) continue;
                logger.info("\u83b7\u53d6\u7b2c\u4e00\u6761\u6570\u636e\u8f93\u51fa\u5230\u6d4b\u8bd5\u65e5\u5fd7-\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(logisticsFreightReportListVOPageInfo.getList().get(0)));
                logisticsFreightReportListVOPageInfo.getList().forEach(o -> {
                    TemplateLogisticsExportDto vo = new TemplateLogisticsExportDto();
                    vo.setId(o.getId());
                    vo.setMergeCode(o.getMergeCode());
                    vo.setBookkeepingDate(o.getBookkeepingDate());
                    vo.setBillingDate(o.getBillingDate());
                    vo.setOutboundTime(o.getOutWarehouseTime());
                    vo.setEasNo(o.getEasNo());
                    vo.setTransportCode(o.getShippingNo());
                    vo.setTransportNo(o.getLogisticsNo());
                    vo.setOutboundCode(o.getDocumentNo());
                    vo.setOutDocumentNo(o.getOutDocumentNo());
                    vo.setOutPhysicsWarehouseName(o.getOutPhysicsWarehouseName());
                    vo.setWmsOutboundCode(o.getWmSDocumentNo());
                    vo.setWmsMergeDocumentNo(o.getWmsMergeDocumentNo());
                    vo.setBusinessType(StringUtils.isNotEmpty((CharSequence)o.getBusinessType()) ? ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()) : "");
                    vo.setBusinessCode(o.getBusinessOrderNo());
                    vo.setWarehouseName(o.getWarehouseName());
                    vo.setLogisticCompany(o.getLogisticsCompany());
                    vo.setTransportType(o.getLogisticsType());
                    vo.setBottle(StringUtils.isNotEmpty((CharSequence)o.getBottlesNumber()) ? new BigDecimal(o.getBottlesNumber()) : null);
                    vo.setBox(StringUtils.isNotEmpty((CharSequence)o.getBoxNum()) ? new BigDecimal(o.getBoxNum()) : null);
                    vo.setVolume(StringUtils.isNotEmpty((CharSequence)o.getVolume()) ? new BigDecimal(o.getVolume()) : null);
                    vo.setWeight(StringUtils.isNotEmpty((CharSequence)o.getWeight()) ? new BigDecimal(o.getWeight()) : null);
                    vo.setTotalBox(StringUtils.isNotEmpty((CharSequence)o.getAllBoxNum()) ? new BigDecimal(o.getAllBoxNum()) : null);
                    vo.setTotalVolume(StringUtils.isNotEmpty((CharSequence)o.getAllVolume()) ? new BigDecimal(o.getAllVolume()) : null);
                    vo.setTotalWeight(StringUtils.isNotEmpty((CharSequence)o.getAllWeight()) ? new BigDecimal(o.getAllWeight()) : null);
                    vo.setChargeMode(o.getBillingMethodName());
                    vo.setCalUnitName(o.getCalUnitName());
                    vo.setTransportPrice(StringUtils.isNotEmpty((CharSequence)o.getFreightPrice()) && !"-".equals(o.getFreightPrice()) ? new BigDecimal(o.getFreightPrice()) : null);
                    vo.setTransportAmount(StringUtils.isNotEmpty((CharSequence)o.getFreightAmount()) && !"-".equals(o.getFreightAmount()) ? new BigDecimal(o.getFreightAmount()) : null);
                    vo.setMinCharge(StringUtils.isNotEmpty((CharSequence)o.getMinimumCharge()) ? new BigDecimal(o.getMinimumCharge()) : null);
                    vo.setDeliveryAmount(StringUtils.isNotEmpty((CharSequence)o.getDeliveryFee()) ? new BigDecimal(o.getDeliveryFee()) : null);
                    vo.setUnloadAmount(StringUtils.isNotEmpty((CharSequence)o.getUnloadingFee()) ? new BigDecimal(o.getUnloadingFee()) : null);
                    vo.setContractOilPrice(o.getContractOilPrice());
                    vo.setLinkOilPrice(o.getLinkOilPrice());
                    vo.setRangeOilPrice(o.getRangeOilPrice());
                    vo.setAdjustOilPrice(o.getAdjustOilPrice());
                    vo.setOilPrice(StringUtils.isNotEmpty((CharSequence)o.getOilPriceLinkage()) ? new BigDecimal(o.getOilPriceLinkage()) : null);
                    vo.setSpecialType(o.getSpecialExpenseType());
                    vo.setSpecialAmount(StringUtils.isNotEmpty((CharSequence)o.getSpecialExpense()) ? new BigDecimal(o.getSpecialExpense()) : null);
                    vo.setTotalTransportAmount(StringUtils.isNotEmpty((CharSequence)o.getTotalFreight()) && !"-".equals(o.getTotalFreight()) ? new BigDecimal(o.getTotalFreight()) : null);
                    vo.setWarehouseOut(o.getTransferIOutWarehouse());
                    vo.setOrganizationOut(o.getOutCargoRightName());
                    vo.setWarehouseEnter(o.getTransferIIntoWarehouse());
                    vo.setOrganizationEnter(o.getInCargoRightName());
                    vo.setAmountAttribution(o.getCostAttribution());
                    vo.setHarvestPeople(o.getConsignee());
                    vo.setProvince(o.getProvince());
                    vo.setCity(o.getAddressInfo());
                    vo.setArea(o.getArea());
                    vo.setCityLevel(o.getCityLevel());
                    vo.setCustomerName(o.getCustomerName());
                    vo.setHarvestAddress(o.getReceiverAddress());
                    vo.setLogisticsTemplateArea(o.getLogisticsTemplateArea());
                    vo.setRemark(o.getRemark());
                    vo.setUpdatePerson(o.getUpdatePerson());
                    vo.setShopName(o.getShopName());
                    try {
                        vo.setUpdateTime(simpleDateFormat.parse(o.getUpdateTime()));
                    }
                    catch (ParseException e) {
                        logger.info("\u66f4\u65b0\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u65f6\u95f4");
                        vo.setUpdateTime(new Date());
                    }
                    vo.setStatus(o.getAbnormal().equals("1") ? "\u5f02\u5e38" : "\u6b63\u5e38");
                    vo.setAbnormalCauses(o.getAbnormalCauses());
                    list.add(vo);
                });
                logger.info("\u83b7\u53d6\u7b2c\u4e00\u6761\u6570\u636e\u8f93\u51fa\u5230\u6d4b\u8bd5\u65e5\u5fd7-\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(list.get(0)));
            }
        }
        this.mergeOrder(list);
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    private void mergeOrder(List<TemplateLogisticsExportDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        ArrayList alreadyMergeCodeList = new ArrayList();
        list.forEach(dto -> {
            if (StringUtils.isNotBlank((CharSequence)dto.getMergeCode()) && !alreadyMergeCodeList.contains(dto.getMergeCode())) {
                logger.info("\u5408\u5e76\u5355\u636e\u7b2c\u4e00\u884c\uff1a{}", (Object)dto.getMergeCode());
                alreadyMergeCodeList.add(dto.getMergeCode());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getMergeCode()) && alreadyMergeCodeList.contains(dto.getMergeCode())) {
                dto.setTotalBox(null);
                dto.setTotalVolume(null);
                dto.setTotalWeight(null);
                dto.setTransportAmount(null);
                dto.setDeliveryAmount(null);
                dto.setUnloadAmount(null);
                dto.setOilPrice(null);
                dto.setSpecialAmount(null);
                dto.setTotalTransportAmount(null);
            }
        });
    }

    private void convertParams(FinLogisticReportReqDto reqDto, LogisticsFreightReportListPageParams pageParams) {
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsCompanyId())) {
            reqDto.setLogisticCompanyCode(pageParams.getLogisticsCompanyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBookkeepingDate())) {
            reqDto.setBookkeepingDate(pageParams.getBookkeepingDate());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getProvinceCode())) {
            reqDto.setProvinceCode(pageParams.getProvinceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getCityCode())) {
            reqDto.setCityCode(pageParams.getCityCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getAreaCode())) {
            reqDto.setAreaCode(pageParams.getAreaCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getLogisticsType())) {
            reqDto.setTransportType(pageParams.getLogisticsType());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getOutCargoRightCode())) {
            reqDto.setOrganizationOut(pageParams.getOutCargoRightCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getCostAttribution())) {
            reqDto.setAmountAttribution(pageParams.getCostAttribution());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getInCargoRightCode())) {
            reqDto.setOrganizationEnter(pageParams.getInCargoRightCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getOutWarehouseCode())) {
            reqDto.setWarehouseOutCode(pageParams.getOutWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getInWarehouseCode())) {
            reqDto.setWarehouseEnterCode(pageParams.getOutWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBusinessOrderType())) {
            reqDto.setType(Integer.valueOf(pageParams.getBusinessOrderType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeStart()) && StringUtils.isNotEmpty((CharSequence)pageParams.getOutWarehouseTimeEnd())) {
            reqDto.setOutboundStartTime(String.format("%s %s", pageParams.getOutWarehouseTimeStart(), "00:00:00"));
            reqDto.setOutboundTimeEndTime(String.format("%s %s", pageParams.getOutWarehouseTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getDocumentNo())) {
            reqDto.setOutboundCode(pageParams.getDocumentNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getWmSDocumentNo())) {
            reqDto.setWmsOutboundCode(pageParams.getWmSDocumentNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBusinessOrderNo())) {
            reqDto.setBusinessCode(pageParams.getBusinessOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getLogisticsId())) {
            reqDto.setTransportType(pageParams.getLogisticsId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getShippingNo())) {
            reqDto.setTransportCode(pageParams.getShippingNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getTransferIOutWarehouse())) {
            reqDto.setWarehouseOut(pageParams.getTransferIOutWarehouse());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutCargoRightName())) {
            reqDto.setOrganizationOut(pageParams.getOutCargoRightName());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getTransferIIntoWarehouse())) {
            reqDto.setWarehouseEnter(pageParams.getTransferIIntoWarehouse());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getInCargoRightName())) {
            reqDto.setOrganizationEnter(pageParams.getInCargoRightName());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getProvince())) {
            reqDto.setProvince(pageParams.getProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getAddressInfo())) {
            reqDto.setCity(pageParams.getAddressInfo());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getAbnormal())) {
            reqDto.setStatus(Integer.valueOf(pageParams.getAbnormal()));
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getBusinessType())) {
            reqDto.setBusinessType(pageParams.getBusinessType());
        }
    }

    private void setMsg(TemplateLogisticsReportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private void checkArea(Map<String, BaseAreaVO> areaMap, TemplateLogisticsReportDto i, TemplateLogisticsReportDto msgDto) {
        if (!areaMap.containsKey(msgDto.getProvince())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                msgDto.setMsg("\u7701\u540d\u79f0\u4e0d\u6b63\u786e");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u7701\u540d\u79f0\u4e0d\u6b63\u786e"));
            }
            return;
        }
        String provinceCode = areaMap.get(msgDto.getProvince()).getCode();
        i.setProvinceCode(provinceCode);
        if (StringUtils.isNotBlank((CharSequence)msgDto.getArea()) && StringUtils.isBlank((CharSequence)msgDto.getCity())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                msgDto.setMsg("\u82e5\u586b\u5199\u4e86\u533a/\u53bf\u5219\u7701\u3001\u5e02\u5fc5\u987b\u586b\u5199");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u82e5\u586b\u5199\u4e86\u533a/\u53bf\u5219\u7701\u3001\u5e02\u5fc5\u987b\u586b\u5199"));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msgDto.getCity())) {
            if (CollectionUtil.isNotEmpty(areaMap.get(msgDto.getProvince()).getChildren())) {
                Map cityMap = areaMap.get(msgDto.getProvince()).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                if (!cityMap.containsKey(msgDto.getCity())) {
                    if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                        msgDto.setMsg("\u5e02\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u540d\u79f0\u4e0d\u5339\u914d");
                    } else {
                        msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u5e02\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u540d\u79f0\u4e0d\u5339\u914d"));
                    }
                    return;
                }
                String cityCode = ((BaseAreaVO)cityMap.get(msgDto.getCity())).getCode();
                i.setCityCode(cityCode);
                if (StringUtils.isNotBlank((CharSequence)msgDto.getArea())) {
                    if (((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren() != null) {
                        Map districtMap = ((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                        if (!districtMap.containsKey(msgDto.getArea())) {
                            if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                                msgDto.setMsg("\u533a/\u53bf\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u533a/\u53bf\u4e0d\u5339\u914d");
                            } else {
                                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u533a/\u53bf\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u533a/\u53bf\u4e0d\u5339\u914d"));
                            }
                        } else {
                            String areaCode = ((BaseAreaVO)districtMap.get(msgDto.getArea())).getCode();
                            i.setAreaCode(areaCode);
                        }
                    } else if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                        msgDto.setMsg("\u6ca1\u627e\u5230\u76f8\u5173\u7684\u533a/\u53bf\u4fe1\u606f");
                    } else {
                        msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u6ca1\u627e\u5230\u76f8\u5173\u7684\u533a/\u53bf\u4fe1\u606f"));
                    }
                    return;
                }
            } else if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                msgDto.setMsg("\u6ca1\u627e\u5230\u76f8\u5173\u7684\u5e02\u4fe1\u606f");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), "\u6ca1\u627e\u5230\u76f8\u5173\u5e02\u4fe1\u606f"));
            }
            return;
        }
    }

    static {
        CARRIER_MODE.add("\u96f6\u62c5");
        CARRIER_MODE.add("\u6d77\u8fd0");
        CARRIER_MODE.add("\u6574\u8f66");
        CARRIER_MODE.add("TC\u7269\u6d41");
        CHARGE_MODE.add("\u6309\u4ef6\u4f53\u79ef");
        CHARGE_MODE.add("\u6309\u4f53\u79ef\u8ba1\u8d39");
        CHARGE_MODE.add("\u6309\u91cd\u91cf\u8ba1\u8d39");
        CHARGE_MODE.add("\u6309\u6700\u4f4e\u6536\u8d39");
        CHARGE_MODE_TYPE = ChargeModeEnum.CHARGE_MODE_TYPE_MAP;
    }
}

