/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportProductRepairReportVo;
import com.dtyunxi.cis.pms.biz.model.GetProductOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ProductOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryProductRepairService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_product_repair_report")
public class ExportProductRepairReportServiceImol
extends HandlerFileOperationCommonServiceImpl {
    @Resource
    FinishedGoodsInventoryProductRepairService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetProductOrderListPageParams params = new GetProductOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetProductOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetProductOrderListPageParams.class);
        }
        params.setPageSize(commonReqDto.getPageSize());
        params.setPageNum(commonReqDto.getPageNum());
        RestResponse<PageInfo<ProductOrderVO>> pageInfoRestResponse = this.service.getProductRepairListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(p -> {
                ExportProductRepairReportVo vo = new ExportProductRepairReportVo();
                CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)p, (String[])new String[0]);
                vo.setBussinessOrderStatus(Optional.ofNullable(p.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return p.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u751f\u4ea7\u8fd4\u4fee");
                vo.setPlanQuantity(Optional.ofNullable(p.getPlanQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setDoneOutQuantity(Optional.ofNullable(p.getDoneQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setWaitQuantity(Optional.ofNullable(p.getWaitQuantity()).orElse(BigDecimal.ZERO).intValue());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetProductOrderListPageParams params = new GetProductOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetProductOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetProductOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.service.getProductRepairListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

