/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportAdjustmentOrderMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportAdjustmentOrderVo;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportTransferOrderMsgVo;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsAdjustmentChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_cs_adjustment_order")
public class ImportAdjustmentOrderAssistServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportAdjustmentOrderAssistServiceImpl.class);
    @Resource
    private ICsInventoryExposedQueryApi csInventoryExposedQueryApi;
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportAdjustmentOrderVo.class);
        log.info("\u76d8\u70b9\u5355\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        HashSet warehouseCodes = Sets.newHashSet();
        this.assembleQueryParams(list, warehouseCodes);
        Map<String, LogicWarehouseRespDto> logicWarehouseMap = this.getLogicWarehouseMap(warehouseCodes);
        log.info("logicWarehouseMap=={}", (Object)JSON.toJSONString(logicWarehouseMap));
        log.info("list=={}", (Object)JSON.toJSONString((Object)list));
        Map<String, CsInventoryBasicsQueryRespDto> inventoryMap = this.getInventoryMap(list);
        log.info("inventoryMap=={}", (Object)JSON.toJSONString(inventoryMap));
        Map<String, String> cargoMap = this.getCargoMap(list);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        Map<String, CsInventoryBasicsQueryRespDto> inventoryWarehouseCodeMap = this.getStringCsInventoryBasicsQueryRespDtoMap(list);
        log.info("inventoryWarehouseCodeMap,\u903b\u8f91\u4ed3\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString(inventoryWarehouseCodeMap));
        list.forEach(i -> {
            ImportAdjustmentOrderMsgVo msgDto = new ImportAdjustmentOrderMsgVo();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)i, (String[])new String[0]);
            String codes = i.getWarehouseCode();
            if (inventoryWarehouseCodeMap.containsKey(codes)) {
                i.setWarehouseName(((CsInventoryBasicsQueryRespDto)inventoryWarehouseCodeMap.get(codes)).getWarehouseName());
            }
            this.checkCargo((ImportAdjustmentOrderVo)((Object)i), cargoMap, msgDto);
            this.checkWarehouseCode((ImportAdjustmentOrderVo)((Object)i), logicWarehouseMap, msgDto);
            this.checkParam((ImportAdjustmentOrderVo)((Object)i), msgDto);
            this.checkRepeatData(i.getUniqueKey(), checkRepeatData, msgDto);
            this.checkItemAndBatchAndQuantity((CsInventoryBasicsQueryRespDto)inventoryMap.get(i.getItemCodeAndBatchKey()), msgDto, (ImportAdjustmentOrderVo)((Object)i));
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u76d8\u70b9\u5355\u5bfc\u5165\u96c6\u5408\uff0csaveList\uff1a{}", (Object)JSON.toJSONString((Object)saveList));
        return map;
    }

    private Map<String, CsInventoryBasicsQueryRespDto> getStringCsInventoryBasicsQueryRespDtoMap(List<ImportAdjustmentOrderVo> list) {
        List warehouseCodeList = list.stream().map(ImportAdjustmentOrderVo::getWarehouseCode).distinct().collect(Collectors.toList());
        CsInventoryBasicsQueryReqDto basicsQueryReqDto = new CsInventoryBasicsQueryReqDto();
        basicsQueryReqDto.setWarehouseCodeList(warehouseCodeList);
        basicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List inventoryBasicsQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(basicsQueryReqDto));
        log.info("\u5546\u54c1\u5e93\u5b58\u6570\u636e\uff0c\u7ed3\u679c========={}", (Object)JSON.toJSONString((Object)inventoryBasicsQueryRespDtoList));
        HashMap inventoryMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)inventoryBasicsQueryRespDtoList)) {
            for (CsInventoryBasicsQueryRespDto inv : inventoryBasicsQueryRespDtoList) {
                inventoryMap.put(inv.getWarehouseCode(), inv);
            }
        }
        return inventoryMap;
    }

    private void checkCargo(ImportAdjustmentOrderVo i, Map<String, String> cargoMap, ImportAdjustmentOrderMsgVo msgDto) {
        String cargoName = cargoMap.get(i.getLongCode());
        if (StringUtils.isBlank((CharSequence)cargoName)) {
            msgDto.setErrorMsg("\u8d27\u54c1\u4e0d\u5b58\u5728");
        }
        i.setItemName(cargoName);
    }

    private void checkWarehouseCode(ImportAdjustmentOrderVo i, Map<String, LogicWarehouseRespDto> logicWarehouseMap, ImportAdjustmentOrderMsgVo msgDto) {
        LogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseMap.get(i.getWarehouseCode());
        if (ObjectUtils.isEmpty((Object)logicWarehouseRespDto)) {
            msgDto.setErrorMsg("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
            return;
        }
        i.setWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        if (StringUtils.isNotBlank((CharSequence)logicWarehouseRespDto.getWarehouseName()) && StringUtils.isBlank((CharSequence)i.getWarehouseName())) {
            i.setWarehouseName(logicWarehouseRespDto.getWarehouseName());
        }
    }

    private Map<String, String> getCargoMap(List<ImportAdjustmentOrderVo> list) {
        Map<String, String> cargoMap = new HashMap<String, String>();
        List longCodeList = list.stream().map(ImportAdjustmentOrderVo::getLongCode).distinct().collect(Collectors.toList());
        List pcpItemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodeList));
        if (CollectionUtil.isNotEmpty((Collection)pcpItemRespDtoList)) {
            cargoMap = pcpItemRespDtoList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, PcpItemRespDto::getName, (key1, key2) -> key2));
        }
        return cargoMap;
    }

    private void checkParam(ImportAdjustmentOrderVo i, ImportAdjustmentOrderMsgVo msgDto) {
        if (!CsAdjustmentChangeTypeEnum.INCREASE.getDesc().equals(i.getChangeType()) && !CsAdjustmentChangeTypeEnum.DECREASE.getDesc().equals(i.getChangeType())) {
            msgDto.setErrorMsg("\u8c03\u6574\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        i.setChangeType(CsAdjustmentChangeTypeEnum.INCREASE.getDesc().equals(i.getChangeType()) ? CsAdjustmentChangeTypeEnum.INCREASE.getCode() : CsAdjustmentChangeTypeEnum.DECREASE.getCode());
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            log.info("===\u76d8\u70b9\u5355\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            Map<String, List<ImportAdjustmentOrderVo>> importMap = saveList.stream().collect(Collectors.groupingBy(ImportAdjustmentOrderVo::getWarehouseCode));
            List<AdjustmentInventoryReqDto> adjustmentAddList = this.convertData(saveList, importMap);
            log.info("===\u76d8\u70b9\u5355\u5bfc\u5165\u6570\u636e===adjustmentAddList:{}", (Object)JSON.toJSONString(adjustmentAddList));
            adjustmentAddList.forEach(i -> {
                block2: {
                    try {
                        this.createAdjustmentInventory((AdjustmentInventoryReqDto)i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s;%s", i.getWarehouseCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, ImportTransferOrderMsgVo.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List checkMsgList = (List)msgObj;
            msgList.addAll(checkMsgList);
        }
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u76d8\u70b9\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportAdjustmentOrderMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private List<CargoInventoryReqDto> assembleQueryParams(List<ImportAdjustmentOrderVo> list) {
        ArrayList queryList = Lists.newArrayList();
        list.stream().forEach(i -> {
            CargoInventoryReqDto reqDto = new CargoInventoryReqDto();
            reqDto.setWarehouseCode(i.getWarehouseCode());
            reqDto.setCargoCode(i.getLongCode());
            reqDto.setBatch(i.getBatch());
            queryList.add(reqDto);
        });
        return queryList;
    }

    private void assembleQueryParams(List<ImportAdjustmentOrderVo> list, Set<String> warehouseCodes) {
        list.forEach(i -> warehouseCodes.add(i.getWarehouseCode()));
    }

    private Map<String, CsInventoryBasicsQueryRespDto> getInventoryMap(List<ImportAdjustmentOrderVo> list) {
        CsInventoryBasicsQueryReqDto basicsQueryReqDto = new CsInventoryBasicsQueryReqDto();
        List warehouseCodeList = list.stream().map(ImportAdjustmentOrderVo::getWarehouseCode).distinct().collect(Collectors.toList());
        List longCodeList = list.stream().map(ImportAdjustmentOrderVo::getLongCode).distinct().collect(Collectors.toList());
        List batchList = list.stream().map(ImportAdjustmentOrderVo::getBatch).distinct().collect(Collectors.toList());
        basicsQueryReqDto.setWarehouseCodeList(warehouseCodeList);
        basicsQueryReqDto.setLongCodeList(longCodeList);
        basicsQueryReqDto.setBatchList(batchList);
        basicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        log.info("\u5546\u54c1\u5e93\u5b58\u6570\u636e,\u67e5\u8be2========={}", (Object)JSON.toJSONString((Object)basicsQueryReqDto));
        List inventoryBasicsQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(basicsQueryReqDto));
        log.info("\u5546\u54c1\u5e93\u5b58\u6570\u636e\uff0c\u7ed3\u679c========={}", (Object)JSON.toJSONString((Object)inventoryBasicsQueryRespDtoList));
        HashMap inventoryMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)inventoryBasicsQueryRespDtoList)) {
            for (CsInventoryBasicsQueryRespDto inv : inventoryBasicsQueryRespDtoList) {
                inventoryMap.put(String.format("%s%s%s", inv.getWarehouseCode(), inv.getLongCode(), inv.getBatch()), inv);
            }
        }
        return inventoryMap;
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByCode((List)Lists.newArrayList(warehouseCodes)));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }

    private void createAdjustmentInventory(AdjustmentInventoryReqDto addBaseDto) {
        this.adjustmentInventoryApi.addAdjustmentInventory(addBaseDto);
    }

    private List<AdjustmentInventoryReqDto> convertData(List<ImportAdjustmentOrderVo> saveList, Map<String, List<ImportAdjustmentOrderVo>> map) {
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            AdjustmentInventoryReqDto dto = new AdjustmentInventoryReqDto();
            ImportAdjustmentOrderVo importDto = (ImportAdjustmentOrderVo)((Object)((Object)value.get(0)));
            dto.setWarehouseCode(importDto.getWarehouseCode());
            dto.setWarehouseName(importDto.getWarehouseName());
            dto.setAdjustmentRemark(importDto.getRemark());
            List detailReqDtoList = value.stream().map(i -> {
                AdjustmentInventoryDetailReqDto addDto = new AdjustmentInventoryDetailReqDto();
                addDto.setLongCode(i.getLongCode());
                addDto.setCargoCode(i.getLongCode());
                addDto.setBatch(i.getBatch());
                addDto.setChangeType(i.getChangeType());
                addDto.setChangeQuantity(new BigDecimal(i.getQuantity()));
                addDto.setCargoName(i.getItemName());
                addDto.setExpireTime(i.getExpireTime());
                addDto.setProduceTime(i.getProduceTime());
                addDto.setRemark(i.getRemark());
                return addDto;
            }).collect(Collectors.toList());
            dto.setDetailReqDtoList(detailReqDtoList);
            list.add(dto);
        });
        return list;
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportAdjustmentOrderMsgVo msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(ImportAdjustmentOrderMsgVo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private void checkItemAndBatchAndQuantity(CsInventoryBasicsQueryRespDto logicInventoryRespDto, ImportAdjustmentOrderMsgVo msgDto, ImportAdjustmentOrderVo importDto) {
        if (CsAdjustmentChangeTypeEnum.INCREASE.getCode().equals(importDto.getChangeType())) {
            if (logicInventoryRespDto == null && (null == importDto.getProduceTime() || null == importDto.getExpireTime())) {
                msgDto.setErrorMsg("\u65b0\u54c1\u5165\u5e93\uff0c\u6709\u6548\u671f\u5fc5\u586b");
            }
            return;
        }
    }
}

