/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportVirtualInventoryVO;
import com.dtyunxi.cis.pms.biz.model.GetVirtualInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.VirtualInventoryVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterInquiryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_virtual_total_inventory_query")
public class ExportVirtualTotalInventoryServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Resource
    private InventoryCenterInquiryService inventoryCenterInquiryService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetVirtualInventoryListPageParams params = new GetVirtualInventoryListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetVirtualInventoryListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetVirtualInventoryListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.inventoryCenterInquiryService.getVirtualInventoryListPage((GetVirtualInventoryListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportVirtualInventoryVO vo = new ExportVirtualInventoryVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setGoodsLongCode(item.getGoodsSku());
                vo.setGoodsName(item.getGoodsName());
                vo.setVirtualWarehouseCode(item.getVirtualWarehouseCode());
                vo.setVirtualWarehouseName(item.getVirtualWarehouseName());
                vo.setAvailableInventory(Optional.ofNullable(item.getAvailableInventory()).orElse(BigDecimal.ZERO).intValue());
                vo.setPreoccupyInventory(Optional.ofNullable(item.getPreoccupyInventory()).orElse(BigDecimal.ZERO).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportVirtualInventoryVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetVirtualInventoryListPageParams params = new GetVirtualInventoryListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetVirtualInventoryListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetVirtualInventoryListPageParams.class);
        }
        params.setPageSize(1);
        params.setPageNum(1);
        RestResponse<PageInfo<VirtualInventoryVO>> pageInfoRestResponse = this.inventoryCenterInquiryService.getVirtualInventoryListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (null == respDtoPageInfo || CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

