/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateConverterUtil {
    private static final List<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>(){
        {
            this.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            this.add(new SimpleDateFormat("yyyy-MM-dd HH:mm"));
            this.add(new SimpleDateFormat("yyyy-MM-dd"));
            this.add(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
            this.add(new SimpleDateFormat("yyyy/MM/dd HH:mm"));
            this.add(new SimpleDateFormat("yyyy/MM/dd"));
            this.add(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH));
            this.add(new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.ENGLISH));
            this.add(new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH));
        }
    };

    public static Date convertToStandardFormat(String dateString) throws ParseException {
        if (dateString == null || dateString.trim().isEmpty()) {
            throw new BizException("-1", "\u89e3\u6790\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff0c\u89e3\u6790\u6570\u636e\u4e3a\u7a7a");
        }
        for (SimpleDateFormat format : dateFormats) {
            try {
                format.setLenient(false);
                return format.parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw new BizException("-1", "\u89e3\u6790\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
    }
}

