/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.dto.request.RegenerateTasksInvokeMsgDto;
import com.dtyunxi.cis.pms.biz.dto.request.RegenerateTasksReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.RegenerateTasksRespDto;
import com.dtyunxi.cis.pms.biz.service.IRegenerateTasksService;
import com.dtyunxi.cis.pms.biz.utils.TasksUtils;
import com.dtyunxi.cis.pms.dao.das.RegenerateTasksDas;
import com.dtyunxi.cis.pms.dao.eo.RegenerateTasksEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegenerateTasksServiceImpl
implements IRegenerateTasksService {
    private static final Logger log = LoggerFactory.getLogger(RegenerateTasksServiceImpl.class);
    @Resource
    private RegenerateTasksDas regenerateTasksDas;

    @Override
    public Long addRegenerateTasks(RegenerateTasksReqDto addReqDto) {
        RegenerateTasksEo regenerateTasksEo = new RegenerateTasksEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)regenerateTasksEo);
        this.regenerateTasksDas.insert((BaseEo)regenerateTasksEo);
        return regenerateTasksEo.getId();
    }

    @Override
    public void modifyRegenerateTasks(RegenerateTasksReqDto modifyReqDto) {
        RegenerateTasksEo regenerateTasksEo = new RegenerateTasksEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)regenerateTasksEo);
        this.regenerateTasksDas.updateSelective((BaseEo)regenerateTasksEo);
    }

    @Override
    public void modify(String id, String regenerateMonth, String feeModule, String menuModule) {
        if (!NumberUtil.isNumber((CharSequence)id)) {
            return;
        }
        RegenerateTasksEo eo = new RegenerateTasksEo();
        eo.setId(Long.valueOf(id));
        eo.setRegenerateMonth(regenerateMonth);
        eo.setFeeModule(feeModule);
        eo.setMenuModule(menuModule);
        eo.setStatus(Integer.valueOf(1));
        this.regenerateTasksDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void successModify(String id) {
        if (!NumberUtil.isNumber((CharSequence)id)) {
            return;
        }
        this.regenerateTasksDas.updateStatusToSuccess(Long.valueOf(id));
    }

    @Override
    public void errorModify(Long id, String errorMsg) {
        if (Objects.isNull(id)) {
            return;
        }
        RegenerateTasksEo eo = new RegenerateTasksEo();
        eo.setId(id);
        eo.setStatus(Integer.valueOf(2));
        eo.setFailureReason(errorMsg);
        this.regenerateTasksDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void errorModify(String id, String errorMsg) {
        if (!NumberUtil.isNumber((CharSequence)id)) {
            return;
        }
        this.errorModify(Long.valueOf(id), errorMsg);
    }

    @Override
    public void retryByIds(List<Long> ids) {
        List eos = this.regenerateTasksDas.selectByIds(ids);
        this.retryByEos(eos, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> retryByEos(List<RegenerateTasksEo> tasksEos, boolean isThrow) {
        if (CollUtil.isEmpty(tasksEos)) {
            return null;
        }
        ArrayList ids = Lists.newArrayList();
        for (RegenerateTasksEo tasksEo : tasksEos) {
            String param;
            String className;
            Long tasksId = tasksEo.getId();
            Integer status = tasksEo.getStatus();
            if (!Objects.equals(status, 2)) {
                log.info("\u4efb\u52a1\u72b6\u6001\u975e\u5931\u8d25\u72b6\u6001\uff0c\u4e0d\u6267\u884c\u91cd\u8bd5\u64cd\u4f5c\uff0c\u4efb\u52a1ID\uff1a{}", (Object)tasksId);
                if (!isThrow) continue;
                throw new Exception("\u4efb\u52a1\u975e\u5931\u8d25\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            }
            String sign = tasksEo.getSign();
            if (StringUtils.isBlank((CharSequence)sign) || StringUtils.isBlank((CharSequence)(className = tasksEo.getClassName())) || StringUtils.isBlank((CharSequence)(param = tasksEo.getRequestParam()))) continue;
            try {
                TasksUtils.setTasksId(tasksId);
                this.invokeByMethod(sign, param, className);
                ids.add(tasksId);
            }
            catch (Exception e) {
                this.regenerateTasksDas.updateStatusToExecutionFailed(tasksId, null);
                if (isThrow) {
                    throw e;
                }
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38 methodName:{}", (Object)sign);
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
            finally {
                TasksUtils.removeTasksId();
            }
        }
        return ids;
    }

    private void invokeByMethod(String methodName, String param, String className) {
        Class<?> clazz = Class.forName(className);
        List dtos = JSON.parseArray((String)param, String.class);
        String[] argsCopy = new String[dtos.size()];
        for (int i = 0; i < dtos.size(); ++i) {
            argsCopy[i] = (String)dtos.get(i);
        }
        ApplicationContext applicationContext = SpringBeanUtil.getApplicationContext();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!StrUtil.equals((CharSequence)method.getName(), (CharSequence)methodName)) continue;
            Object[] args = TasksUtils.convertArguments(method, argsCopy);
            method.invoke(applicationContext.getBean(clazz), args);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRegenerateTasks(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.regenerateTasksDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RegenerateTasksRespDto queryById(Long id) {
        RegenerateTasksEo regenerateTasksEo = (RegenerateTasksEo)this.regenerateTasksDas.selectByPrimaryKey(id);
        RegenerateTasksRespDto regenerateTasksRespDto = new RegenerateTasksRespDto();
        DtoHelper.eo2Dto((BaseEo)regenerateTasksEo, (BaseVo)regenerateTasksRespDto);
        return regenerateTasksRespDto;
    }

    @Override
    public void tasksInvoke(RegenerateTasksInvokeMsgDto invokeMsgDto) {
        if (Objects.isNull((Object)invokeMsgDto)) {
            log.info("\u56de\u8c03\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
            return;
        }
        String taskId = invokeMsgDto.getTaskId();
        if (!NumberUtil.isNumber((CharSequence)taskId)) {
            return;
        }
        RegenerateTasksEo regenerateTasksEo = new RegenerateTasksEo();
        DtoHelper.dto2Eo((BaseVo)invokeMsgDto, (BaseEo)regenerateTasksEo);
        regenerateTasksEo.setId(Long.valueOf(taskId));
        this.regenerateTasksDas.updateSelective((BaseEo)regenerateTasksEo);
    }

    @Override
    public PageInfo<RegenerateTasksRespDto> queryByPage(RegenerateTasksReqDto filter, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ExtQueryChainWrapper wrapper = this.regenerateTasksDas.filter();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getRegenerateMonth()), (Object)"regenerate_month", (Object)filter.getRegenerateMonth());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getMenuModule()), (Object)"menu_module", (Object)filter.getMenuModule());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getFeeModule()), (Object)"fee_module", (Object)filter.getFeeModule());
        wrapper.eq(Objects.nonNull(filter.getStatus()), (Object)"status", (Object)filter.getStatus());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getPhysicsWarehouseName()), (Object)"physics_warehouse_name", (Object)filter.getPhysicsWarehouseName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getLogisticsCompanyName()), (Object)"logistics_company_name", (Object)filter.getLogisticsCompanyName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getCarrierName()), (Object)"carrier_name", (Object)filter.getCarrierName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getCreatedByName()), (Object)"create_person", (Object)filter.getCreatedByName());
        wrapper.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = new PageInfo(wrapper.list());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RegenerateTasksRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

