/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.model;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.TransferOrderStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.MaiyouOutSaleTransferReportVo;
import com.dtyunxi.cis.pms.biz.service.SaleTransferService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_maiyou_sale_transfer")
public class ExportMaiyouSaleTransferServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExportMaiyouSaleTransferServiceImpl.class);
    @Resource
    private SaleTransferService saleTransferService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        SaleTransferReportReqDto params = new SaleTransferReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SaleTransferReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SaleTransferReportReqDto.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.saleTransferService.querySaleTransferPage((SaleTransferReportReqDto)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                MaiyouOutSaleTransferReportVo vo = new MaiyouOutSaleTransferReportVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                try {
                    vo.setCenterTransferOrderStatus(TransferOrderStatusEnum.getDescByCode(o.getCenterTransferOrderStatus()));
                }
                catch (Exception e) {
                    vo.setCenterTransferOrderStatus(o.getCenterTransferOrderStatus());
                }
                vo.setOrderNeedQuantity(Optional.ofNullable(o.getOrderNeedQuantity().intValue()).orElse(0));
                vo.setOrderLackQuantity(Optional.ofNullable(o.getOrderLackQuantity().intValue()).orElse(0));
                vo.setTransferQuantity(Optional.ofNullable(o.getTransferQuantity().intValue()).orElse(0));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, MaiyouOutSaleTransferReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

