/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportDailyDeliveryReportVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterDailyDeliveryReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsNoticeWmsStatusReqDto;
import com.dtyunxi.tcbj.api.query.IDeliveryNoticeOrderQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report_export")
public class ExportDailyDeliveryReportImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ExportDailyDeliveryReportImpl.class);
    @Resource
    private IDeliveryNoticeOrderQueryApi iDeliveryNoticeOrderQueryApi;
    @Resource
    private IDailyDeliveryReportApi iDailyDeliveryReportApi;
    @Resource
    private ReportCenterDailyDeliveryReportService reportCenterDailyDeliveryReportService;
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        DailyDeliveryReportListQueryDto queryDto = new DailyDeliveryReportListQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            queryDto = (DailyDeliveryReportListQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), DailyDeliveryReportListQueryDto.class);
        }
        log.info("===\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5bfc\u51fa\u6570\u636e===");
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)re));
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.reportCenterDailyDeliveryReportService.queryByPage((DailyDeliveryReportListQueryDto)re, re.getPageNum(), re.getPageSize()));
            PageInfo pageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    ExportDailyDeliveryReportVO vo = new ExportDailyDeliveryReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    if (null != o.getOrderCreateTime()) {
                        vo.setOrderCreateTime(DATE_FORMATTER.format(o.getOrderCreateTime()));
                    }
                    if (null != o.getOrderShippingTime()) {
                        vo.setOrderShippingTime(DATE_FORMATTER.format(o.getOrderShippingTime()));
                    }
                    if (null != o.getUpdateTime()) {
                        vo.setUpdateTime(DATE_FORMATTER.format(o.getUpdateTime()));
                    }
                    if (null != o.getDifferentFlag()) {
                        vo.setDifferentFlag(this.YesOrNo(o.getDifferentFlag()));
                    }
                    if (null != o.getCommercialOrderFlag()) {
                        vo.setCommercialOrderFlag(this.YesOrNo(o.getCommercialOrderFlag()));
                    }
                    if (null != o.getTotalQuantity()) {
                        vo.setTotalQuantity(o.getTotalQuantity().toString());
                    }
                    if (null != o.getTotalCartons()) {
                        vo.setTotalCartons(o.getTotalCartons().toString());
                    }
                    if (null != o.getTotalVolume()) {
                        vo.setTotalVolume(o.getTotalVolume().toString());
                    }
                    if (null != o.getTotalWeight()) {
                        vo.setTotalWeight(o.getTotalWeight().toString());
                    }
                    if (null != o.getBillingCartons()) {
                        vo.setBillingCartons(o.getBillingCartons().toString());
                    }
                    if (null != o.getBillingVolume()) {
                        vo.setBillingVolume(o.getBillingVolume().toString());
                    }
                    if (null != o.getBillingWeight()) {
                        vo.setBillingWeight(o.getBillingWeight().toString());
                    }
                    if (null != o.getIfGeneral()) {
                        vo.setIfGeneralStr(o.getIfGeneral() == 1 ? "\u662f" : "\u5426");
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
            pageInfo.setList((List)list);
            log.info("===\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5bfc\u51fa\u6570\u636e===pageInfo:{}", (Object)pageInfo);
            return pageInfo;
        }, queryDto, ExportDailyDeliveryReportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        CsNoticeWmsStatusReqDto getLogicalInventoryListPageParams = new CsNoticeWmsStatusReqDto();
        getLogicalInventoryListPageParams = (CsNoticeWmsStatusReqDto)JSON.parseObject((String)commonReqDto.getFilter(), CsNoticeWmsStatusReqDto.class);
        getLogicalInventoryListPageParams.setPageSize(Integer.valueOf(1));
        getLogicalInventoryListPageParams.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.iDeliveryNoticeOrderQueryApi.queryNoticeWmsPage(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private String formatDate(Date date) {
        return Optional.ofNullable(date).map(DATE_FORMATTER::format).orElse(null);
    }

    private String YesOrNo(Integer i) {
        if (i == null) {
            return null;
        }
        if (i == 1) {
            return "\u662f";
        }
        return "\u5426";
    }
}

