/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.operation.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.dto.request.CheckResultVo;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.export.ExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.operation.AbstractFileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.FileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportReqDto;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class FileOperationCommonServiceImpl
implements FileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(FileOperationCommonService.class);
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;
    private static final String MAP_SERVICE_NAME = "abstractFileOperationCommonService";
    @Autowired
    private Map<String, AbstractFileOperationCommonService> mapService;
    @Resource
    private ExportExcelHelper exportExcelHelper;

    @Override
    public CheckResultVo importCheck(ImportFileOperationCommonReqDto commonReqDto) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public RestResponse<String> importFileOperationCommon(ImportFileOperationCommonReqDto commonReqDto) {
        if (StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.requestId"))) {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        }
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        long importStartTime = System.currentTimeMillis();
        BdImportExportTaskEo taskEo = (BdImportExportTaskEo)((ExtQueryChainWrapper)this.bdImportExportTaskDas.filter().eq((Object)"task_code", (Object)commonReqDto.getTaskCode())).one();
        String taskCode = commonReqDto.getTaskCode();
        try {
            AbstractFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
            ImportFileOperationCommonRespDto respDto = new ImportFileOperationCommonRespDto();
            long startTime = System.currentTimeMillis();
            logger.info("\u89e3\u6790\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)startTime);
            ExcelImportResult<ImportBaseModeDto> result = commonService.parseExcelDataResult(commonReqDto, respDto);
            long endTime = System.currentTimeMillis();
            logger.info("\u89e3\u6790\u65f6\u95f4\uff1a{}", (Object)(endTime - startTime));
            commonReqDto.setOperator(taskEo.getCreatePerson());
            ServiceContext.getContext().setAttachment("yes.req.userCode", taskEo.getCreatePerson());
            Object object = commonService.verifyImportFileOperationCommon(result, commonReqDto, respDto);
            String errorMsgUrl = commonService.executeImportFileOperationCommon(result, commonReqDto, respDto, object);
            if (StringUtils.isNotBlank((CharSequence)errorMsgUrl)) {
                taskEo.setStatus(ImportExportStatusEnum.PART_SUCCESS.getCode());
                taskEo.setErrorMsgUrl(errorMsgUrl);
                taskEo.setCompleteTime(new Date());
            } else {
                taskEo.setCompleteTime(new Date());
                taskEo.setStatus(ImportExportStatusEnum.SUCCESS.getCode());
            }
            this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
            taskEo.setStatus(ImportExportStatusEnum.FAIL.getCode());
            taskEo.setErrorMsg(e.toString());
            this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
        }
        finally {
            ServiceContext.removeContext();
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u5bfc\u5165\u65f6\u6240\u7528\u65f6\u95f4\uff1a{}", (Object)(endTime - importStartTime));
        return new RestResponse((Object)taskCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse<ExportFileOperationCommonRespDto> exportFileOperationCommon(Long taskId) {
        ExportFileOperationCommonRespDto commonRespDto;
        BdImportExportTaskEo taskEo = (BdImportExportTaskEo)this.bdImportExportTaskDas.selectByPrimaryKey(taskId);
        logger.info("\u6267\u884c\u5bfc\u51fa\u4efb\u52a1=\u300b{}", (Object)JSON.toJSONString((Object)taskEo));
        AbstractFileOperationCommonService commonService = this.getCommonService(taskEo.getModuleKey());
        ExportFileOperationCommonReqDto commonReqDto = new ExportFileOperationCommonReqDto();
        commonReqDto.setKey(taskEo.getModuleKey());
        commonReqDto.setFilter(taskEo.getParam());
        String extension = taskEo.getExtension();
        JSONObject map = JSONObject.parseObject((String)extension);
        Integer pageSize = map.getInteger("pageSize");
        Integer pageNum = map.getInteger("pageNum");
        boolean sapFlagSet = this.exportExcelHelper.setSapFlagByExportKey(commonReqDto.getKey());
        try {
            map.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, String.valueOf(v)));
            commonReqDto.setPageNum(pageNum);
            commonReqDto.setPageSize(pageSize);
            commonReqDto.setFileName(taskEo.getFileName());
            commonReqDto.setTaskEo(taskEo);
            String path = null;
            if (sapFlagSet) {
                logger.info("\u5bfc\u51fakey {} \u5df2\u8bbe\u7f6eSAP\u6807\u8bc6\uff0c\u5f00\u59cb\u6267\u884c\u5bfc\u51fa", (Object)commonReqDto.getKey());
            } else {
                logger.info("\u5bfc\u51fakey {} \u672a\u8bbe\u7f6eSAP\u6807\u8bc6\uff0c\u6267\u884c\u666e\u901a\u5bfc\u51fa", (Object)commonReqDto.getKey());
            }
            try {
                path = commonService.exportFileOperationCommon(commonReqDto);
                taskEo.setStatus(ImportExportStatusEnum.SUCCESS.getCode());
                taskEo.setFileUrl(path);
                taskEo.setCompleteTime(new Date());
                try {
                    taskEo.setSize(ExcelUtils.getFileSize(ExcelUtils.getInputStream(path)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5931\u8d25\uff0c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                taskEo.setStatus(ImportExportStatusEnum.FAIL.getCode());
                taskEo.setErrorMsg(e.getMessage());
            }
            this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
            commonRespDto = new ExportFileOperationCommonRespDto();
            commonRespDto.setPath(path);
        }
        finally {
            ServiceContext.removeContext();
            if (sapFlagSet) {
                this.exportExcelHelper.removeAttachment("sap-flag");
                logger.debug("\u6e05\u7406sap-flag: {}", (Object)commonReqDto.getKey());
            }
        }
        return new RestResponse((Object)commonRespDto);
    }

    @Override
    public RestResponse<Integer> exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("exportTotal\u65b9\u6cd5\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        Class<LogisticsInReportReqDto> clazz = LogisticsInReportReqDto.class;
        AbstractFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        Integer exportTotal = commonService.exportTotal(commonReqDto);
        logger.info("exportTotal:{}", (Object)exportTotal);
        return new RestResponse((Object)exportTotal);
    }

    private void checkExportFileOperationCommonParam(ExportFileOperationCommonReqDto commonReqDto) {
        if (Objects.isNull((Object)commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkImportFileOperationCommonParam(ImportFileOperationCommonReqDto commonReqDto) {
        if (Objects.isNull((Object)commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getUrl())) {
            throw new BizException("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getTaskCode())) {
            throw new BizException("\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AbstractFileOperationCommonService getCommonService(String module) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(module);
        AbstractFileOperationCommonService commonService = this.mapService.get(String.format("%s_%s", MAP_SERVICE_NAME, anEnum.getModeTypeCode()));
        logger.info("-----------key:{}", (Object)String.format("%s_%s", MAP_SERVICE_NAME, anEnum.getModeTypeCode()));
        Set<Map.Entry<String, AbstractFileOperationCommonService>> entries = this.mapService.entrySet();
        logger.info("\u83b7\u53d6\u5230\u7684commonService:{}", (Object)commonService);
        if (Objects.isNull(commonService)) {
            commonService = this.mapService.get(MAP_SERVICE_NAME);
        }
        return commonService;
    }
}

