/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportFinishedInventoryVo;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FinishedInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryRespDto;
import com.dtyunxi.tcbj.api.query.IFinishedInventoryQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_finished_goods_inventory_report")
public class ExportFinishedInventoryReport
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Resource
    private IFinishedInventoryQueryApi iFinishedInventoryQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        FinishedInventoryReqDto getLogicalInventoryListPageParams = new FinishedInventoryReqDto();
        getLogicalInventoryListPageParams = (FinishedInventoryReqDto)JSON.parseObject((String)commonReqDto.getFilter(), FinishedInventoryReqDto.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse pageInfoRestResponse = this.iFinishedInventoryQueryApi.queryByPage(re);
            List data = (List)this.iFinishedInventoryQueryApi.queryChannelInventoryByCount(re).getData();
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                FinishedInventoryRespDto finishedInventoryRespDto = (FinishedInventoryRespDto)respDtoPageInfo.getList().get(0);
                finishedInventoryRespDto.setFinishedInventoryCountRespDtos(data);
            }
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)im);
            ArrayList list = Lists.newArrayList();
            ArrayList finisheList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    FinishedInventoryCountRespDto dto;
                    ExportFinishedInventoryVo vo = new ExportFinishedInventoryVo();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    if (CollectionUtils.isNotEmpty((Collection)o.getFinishedInventoryCountRespDtos()) && ObjectUtils.isNotEmpty((Object)(dto = (FinishedInventoryCountRespDto)o.getFinishedInventoryCountRespDtos().get(0)))) {
                        if (dto.getTotalBalance() != null) {
                            vo.setSumTotalBalance(dto.getTotalBalance());
                        }
                        if (dto.getInThreeBalance() != null) {
                            vo.setSumInThreeBalance(dto.getInThreeBalance());
                        }
                        if (dto.getOverThreeBalance() != null) {
                            vo.setSumOverThreeBalance(dto.getOverThreeBalance());
                        }
                        if (dto.getSurplusInNineBalance() != null) {
                            vo.setSumSurplusInNineBalance(dto.getSurplusInNineBalance());
                        }
                    }
                    vo.setOverNineRatio(BigDecimalUtils.check((BigDecimal)o.getOverNineRatio()));
                    vo.setOverThreeRatio(BigDecimalUtils.check((BigDecimal)o.getOverThreeRatio()));
                    if (o.getStatisticalTime() != null) {
                        String statisticalTime = new SimpleDateFormat("yyyy-MM-dd").format(o.getStatisticalTime());
                        vo.setStatisticalTime(statisticalTime);
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, getLogicalInventoryListPageParams, ExportFinishedInventoryVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        FinishedInventoryReqDto getLogicalInventoryListPageParams = new FinishedInventoryReqDto();
        getLogicalInventoryListPageParams = (FinishedInventoryReqDto)JSON.parseObject((String)commonReqDto.getFilter(), FinishedInventoryReqDto.class);
        getLogicalInventoryListPageParams.setPageSize(Integer.valueOf(1));
        getLogicalInventoryListPageParams.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.iFinishedInventoryQueryApi.queryByPage(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

