/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.enums.DeriveTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ConsignmentDeliveryOrderVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderDeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderDetailedRespDto;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderDispatcherInfoVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderLogisticsInfoVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderLogisticsVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderVo;
import com.dtyunxi.cis.pms.biz.model.ConsignmentRelevanceOrderVo;
import com.dtyunxi.cis.pms.biz.service.ConsignmentOrderService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderLogisticsRespDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentDeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IConsignmentOrderQueryApi;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsignmentOrderServiceImpl
implements ConsignmentOrderService {
    @Resource
    private IConsignmentOrderQueryApi iConsignmentOrderQueryApi;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;

    @Override
    public RestResponse<ConsignmentOrderDetailedRespDto> queryWaybillListDetailed(String consignmentNo) {
        ConsignmentOrderLogisticsRespDto orderLogisticsRespDto;
        List respDtos;
        ConsignmentOrderRespDto orderRespDto;
        List consignmentOrderDispatcherInfoRespDtos;
        ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto;
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)consignmentNo), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ConsignmentOrderRespDto consignmentOrderRespDto = (ConsignmentOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryByConsignmentNo(consignmentNo));
        ConsignmentOrderDetailedRespDto dto = new ConsignmentOrderDetailedRespDto();
        BeanUtils.copyProperties((Object)consignmentOrderRespDto, (Object)((Object)dto));
        if (ObjectUtils.isEmpty((Object)((Object)dto))) {
            return new RestResponse((Object)dto);
        }
        ConsignmentDeliveryOrderRespDto respDto = (ConsignmentDeliveryOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryDeliveryConsignmentNo(consignmentNo));
        if (ObjectUtils.isNotEmpty((Object)respDto)) {
            ConsignmentDeliveryOrderVo vo = new ConsignmentDeliveryOrderVo();
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
            vo.setBusinessTypeName(Optional.ofNullable(respDto.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                if (ObjectUtils.isNotEmpty((Object)DeriveTypeEnum.getMsgByCode(respDto.getBusinessType()))) {
                    return String.valueOf(DeriveTypeEnum.getMsgByCode(respDto.getBusinessType()));
                }
                return respDto.getBusinessType();
            }).orElse(""));
            dto.setConsignmentDeliveryOrderVo(vo);
        }
        if (ObjectUtils.isNotEmpty((Object)(consignmentOrderDeliveryInfoRespDto = (ConsignmentOrderDeliveryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryWaybillDeliveryConsignmentNo(consignmentNo))))) {
            ConsignmentOrderDeliveryInfoVo vo = new ConsignmentOrderDeliveryInfoVo();
            BeanUtils.copyProperties((Object)consignmentOrderDeliveryInfoRespDto, (Object)vo);
            dto.setConsignmentOrderDeliveryInfoVo(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(consignmentOrderDispatcherInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryWaybillDispatcherConsignmentNo(consignmentNo))))) {
            List<ConsignmentOrderDispatcherInfoVo> vos = consignmentOrderDispatcherInfoRespDtos.stream().map(o -> {
                ConsignmentOrderDispatcherInfoVo vo = new ConsignmentOrderDispatcherInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                return vo;
            }).collect(Collectors.toList());
            dto.setConsignmentOrderDispatcherInfoVo(vos);
        }
        if (ObjectUtils.isNotEmpty((Object)(orderRespDto = (ConsignmentOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryWaybillTransportConsignmentNo(consignmentNo))))) {
            ConsignmentOrderVo vo = new ConsignmentOrderVo();
            BeanUtils.copyProperties((Object)orderRespDto, (Object)vo);
            dto.setConsignmentOrderVo(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iConsignmentOrderQueryApi.queryWaybillRelevanceConsignmentNo(consignmentNo))))) {
            List<ConsignmentRelevanceOrderVo> vos = respDtos.stream().map(o -> {
                ConsignmentRelevanceOrderVo vo = new ConsignmentRelevanceOrderVo();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                return vo;
            }).collect(Collectors.toList());
            dto.setConsignmentRelevanceOrderVos(vos);
        }
        if (ObjectUtils.isNotEmpty((Object)(orderLogisticsRespDto = (ConsignmentOrderLogisticsRespDto)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryConsignmentLogisticsInfoReqDto(consignmentNo))))) {
            ConsignmentOrderLogisticsVo orderLogisticsVo = new ConsignmentOrderLogisticsVo();
            BeanUtils.copyProperties((Object)orderLogisticsRespDto, (Object)orderLogisticsVo);
            if (CollectionUtils.isNotEmpty((Collection)orderLogisticsRespDto.getConsignmentOrderLogisticsInfoRespDtoList())) {
                List<ConsignmentOrderLogisticsInfoVo> voList = orderLogisticsRespDto.getConsignmentOrderLogisticsInfoRespDtoList().stream().map(o -> {
                    ConsignmentOrderLogisticsInfoVo vo = new ConsignmentOrderLogisticsInfoVo();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    return vo;
                }).collect(Collectors.toList());
                orderLogisticsVo.setConsignmentOrderLogisticsInfoVos(voList);
            }
            dto.setConsignmentOrderLogisticsVos(orderLogisticsVo);
        }
        return new RestResponse((Object)dto);
    }
}

