/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cis.pms.biz.service.IInspectionReleaseService;
import com.dtyunxi.cis.pms.dao.eo.InspectionRemarkTagEo;
import com.dtyunxi.cis.pms.dao.mapper.InspectionRemarkTagMapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseLogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryListReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.ProductOrderLisReq;
import com.dtyunxi.tcbj.api.dto.response.InspectionHasReleaseTransferRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.ProductOrderVO;
import com.dtyunxi.tcbj.api.query.IInspectionReleaseOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionNotReleaseApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InspectionReleaseServiceImpl
implements IInspectionReleaseService {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseServiceImpl.class);
    @Autowired
    ILogicInventoryQueryApi logicInventoryQueryApi;
    @Autowired
    InspectionRemarkTagMapper inspectionRemarkTagMapper;
    @Autowired
    IInspectionReleaseOrderQueryApi inspectionReleaseOrderQueryApi;
    @Autowired
    IInspectionNotReleaseApi inspectionNotReleaseApi;
    @Autowired
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public PageInfo<InspectionReleaseLogicInventoryRespDto> queryInspectionReleaseInventoryPage(InspectionReleaseLogicInventoryReqDto reqDto) {
        PageInfo inspectionReleaseLogicInventoryRespPageInfo;
        List logicInventoryRespPageInfoList;
        List inspectionRemarkTagEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getTag()) || StringUtils.isNotBlank((CharSequence)reqDto.getRemark())) {
            inspectionRemarkTagEos = this.inspectionRemarkTagMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionRemarkTagEo.class).in(CollectionUtils.isNotEmpty((Collection)reqDto.getTag()), InspectionRemarkTagEo::getTagColour, (Collection)reqDto.getTag())).like(StringUtils.isNotBlank((CharSequence)reqDto.getRemark()), InspectionRemarkTagEo::getRemark, (Object)reqDto.getRemark())).like(StringUtils.isNotBlank((CharSequence)reqDto.getCargoCode()), InspectionRemarkTagEo::getSkuCode, (Object)reqDto.getCargoCode())).like(StringUtils.isNotBlank((CharSequence)reqDto.getBatch()), InspectionRemarkTagEo::getBatchNo, (Object)reqDto.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)inspectionRemarkTagEos)) {
                return new PageInfo();
            }
            List skuCodes = inspectionRemarkTagEos.stream().map(InspectionRemarkTagEo::getSkuCode).distinct().collect(Collectors.toList());
            List batches = inspectionRemarkTagEos.stream().map(InspectionRemarkTagEo::getBatchNo).distinct().collect(Collectors.toList());
            reqDto.setBatches(batches);
            reqDto.setCargoCodes(skuCodes);
        }
        if (CollectionUtils.isEmpty((Collection)(logicInventoryRespPageInfoList = (inspectionReleaseLogicInventoryRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryInspectionReleaseInventory(reqDto))).getList()))) {
            return inspectionReleaseLogicInventoryRespPageInfo;
        }
        if (CollectionUtils.isEmpty((Collection)inspectionRemarkTagEos)) {
            List skuCodes = logicInventoryRespPageInfoList.stream().map(InspectionReleaseLogicInventoryRespDto::getCargoCode).distinct().collect(Collectors.toList());
            List batches = logicInventoryRespPageInfoList.stream().map(InspectionReleaseLogicInventoryRespDto::getBatch).distinct().collect(Collectors.toList());
            inspectionRemarkTagEos = this.inspectionRemarkTagMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionRemarkTagEo.class).in(InspectionRemarkTagEo::getSkuCode, skuCodes)).in(InspectionRemarkTagEo::getBatchNo, batches));
        }
        Map productOrderMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryRespPageInfoList)) {
            List skuCodes = logicInventoryRespPageInfoList.stream().map(InspectionReleaseLogicInventoryRespDto::getCargoCode).distinct().collect(Collectors.toList());
            List batches = logicInventoryRespPageInfoList.stream().map(InspectionReleaseLogicInventoryRespDto::getBatch).distinct().collect(Collectors.toList());
            ProductOrderLisReq req = new ProductOrderLisReq();
            req.setLongCodesList(skuCodes);
            req.setBatchList(batches);
            req.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION.getCode());
            List productOrderVOList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryProductOrderByLongCodeAndBatchNewest(req));
            productOrderMap = Optional.ofNullable(productOrderVOList).map(list -> productOrderVOList.stream().collect(Collectors.groupingBy(g -> g.getCargoCode() + g.getBatch()))).orElse(new HashMap());
        }
        for (InspectionReleaseLogicInventoryRespDto inspectionReleaseLogicInventoryRespDto : logicInventoryRespPageInfoList) {
            inspectionRemarkTagEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)inspectionReleaseLogicInventoryRespDto.getCargoCode()) && StringUtils.equals((CharSequence)o.getBatchNo(), (CharSequence)inspectionReleaseLogicInventoryRespDto.getBatch())).findFirst().ifPresent(inspectionRemarkTagEo -> {
                inspectionReleaseLogicInventoryRespDto.setRemark(inspectionRemarkTagEo.getRemark());
                inspectionReleaseLogicInventoryRespDto.setTag(inspectionRemarkTagEo.getTagColour());
                inspectionReleaseLogicInventoryRespDto.setColourId(inspectionRemarkTagEo.getId());
            });
            List productOrderVOList = (List)productOrderMap.get(inspectionReleaseLogicInventoryRespDto.getCargoCode() + inspectionReleaseLogicInventoryRespDto.getBatch());
            if (!CollectionUtils.isNotEmpty((Collection)productOrderVOList)) continue;
            ProductOrderVO productOrderVO = (ProductOrderVO)productOrderVOList.get(0);
            inspectionReleaseLogicInventoryRespDto.setProductOrderNo(productOrderVO.getOrderNo());
            inspectionReleaseLogicInventoryRespDto.setClosedFlag(productOrderVO.getClosedFlag());
            inspectionReleaseLogicInventoryRespDto.setClosedTime(productOrderVO.getClosedTime());
        }
        inspectionReleaseLogicInventoryRespPageInfo.setList(logicInventoryRespPageInfoList);
        return inspectionReleaseLogicInventoryRespPageInfo;
    }

    @Override
    public InspectionReleaseLogicInventoryCountRespDto queryInspectionReleaseInventoryPageCount(@RequestBody InspectionReleaseLogicInventoryReqDto reqDto) {
        return (InspectionReleaseLogicInventoryCountRespDto)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryInspectionReleaseInventoryCount(reqDto));
    }

    @Override
    public List<LogicInventoryRespDto> queryInspectionInventory(InspectionReleaseLogicInventoryReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getCargoCode())) {
            throw new CsInventoryException("\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getBatch())) {
            throw new CsInventoryException("\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        LogicInventoryListReqDto logicInventoryListReqDto = new LogicInventoryListReqDto();
        logicInventoryListReqDto.setLongCode(reqDto.getCargoCode());
        logicInventoryListReqDto.setBatch(reqDto.getBatch());
        logicInventoryListReqDto.setLogicWarehouseQuality(CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
        logicInventoryListReqDto.setFilterZero(Boolean.valueOf(true));
        return (List)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryList(logicInventoryListReqDto));
    }

    @Override
    public List<InspectionHasReleaseTransferRespDto> queryHasReleaseTransferList(String longCode, String batch) {
        return (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderQueryApi.queryHasReleaseTransferList(longCode, batch));
    }

    @Override
    public void saveInspectionNotRelease(List<Long> preemptIds) {
        RestResponseHelper.extractData((RestResponse)this.inspectionNotReleaseApi.saveInspectionNotRelease(preemptIds));
    }

    @Override
    public void clearInspectionNotRelease(String longCode, String batch) {
        RestResponseHelper.extractData((RestResponse)this.inspectionNotReleaseApi.clearInspectionNotRelease(longCode, batch));
    }
}

