/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSortingCostReportVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportSortingExpenseAdjustDto;
import com.dtyunxi.cis.pms.biz.model.ImportSortingExpenseAdjustMsgDto;
import com.dtyunxi.cis.pms.biz.model.SortingBillReportListPageReqDtoNew;
import com.dtyunxi.cis.pms.biz.model.SortingCostReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.SortingCostReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSortingReportSortingCostReportService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SortingBillReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingExpenseQueryDto;
import com.dtyunxi.tcbj.api.dto.request.SortingExpenseReqDto;
import com.dtyunxi.tcbj.api.dto.request.TaskQueryParamsDro;
import com.dtyunxi.tcbj.api.dto.response.SortingBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.SortingCostReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SortingExpenseRespDto;
import com.dtyunxi.tcbj.api.query.ISortingBillQueryApi;
import com.dtyunxi.tcbj.api.query.ISortingExpenseQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sorting_expense_report")
public class ReportCenterSortingReportSortingCostReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSortingReportSortingCostReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterSortingReportSortingCostReportServiceServiceImpl.class);
    @Resource
    private ISortingExpenseQueryApi sortingExpenseQueryApi;
    @Resource
    private ISortingBillQueryApi sortingBillQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;

    @Override
    public RestResponse<PageInfo<SortingCostReportVO>> getSortingCostReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) SortingCostReportListPageParams sortingCostReportListPageParams) {
        SortingCostReportListPageReqDto dto = new SortingCostReportListPageReqDto();
        BeanUtils.copyProperties((Object)sortingCostReportListPageParams, (Object)dto);
        PageInfo sortingCostReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingCostReportListPage(dto));
        if (CollectionUtils.isEmpty((Collection)sortingCostReportRespDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)sortingCostReportRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = sortingCostReportRespDtoPageInfo.getList().stream().map(o -> {
            SortingCostReportVO vo = new SortingCostReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setConsignmentNo(o.getConsignmentNo());
            vo.setAbnormalCauses(o.getAbnormalCauses());
            if (StringUtils.isBlank((CharSequence)vo.getExternalOrderNo())) {
                vo.setExternalOrderNo(o.getRelevanceNo());
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Void> updateSave(Long contractId) {
        return this.sortingExpenseQueryApi.updateSave(contractId);
    }

    @Override
    public RestResponse<Void> edit(SortingExpenseReqDto reqDto) {
        Long id = reqDto.getId();
        SortingCostReportUpdateReqDto dto = new SortingCostReportUpdateReqDto();
        dto.setDocumentNo(reqDto.getDocumentNo());
        dto.setLongCode(reqDto.getLongCode());
        SortingExpenseRespDto respDto = (SortingExpenseRespDto)this.sortingExpenseQueryApi.getByGroup(dto).getData();
        if (null != respDto || ObjectUtil.isNotEmpty((Object)id)) {
            return this.sortingExpenseQueryApi.edit(reqDto);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<SortingBillCountDto> getSortingBillReportListPageCount(SortingBillReportListPageReqDtoNew reqDto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SortingBillReportListPageReqDto dto = new SortingBillReportListPageReqDto();
        Date date = null;
        if (null != reqDto.getTime()) {
            try {
                date = sdf.parse(reqDto.getTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            dto.setStatisticsYear(String.valueOf(calendar.get(1)));
            dto.setStatisticsMonth(String.valueOf(calendar.get(2) + 1));
        }
        BeanUtils.copyProperties((Object)((Object)reqDto), (Object)dto);
        return this.sortingBillQueryApi.getSortingBillReportListPageCount(dto);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        SortingCostReportListPageParams params = new SortingCostReportListPageParams();
        SortingCostReportListPageReqDto queryDto = new SortingCostReportListPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SortingCostReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), SortingCostReportListPageParams.class);
            BeanUtils.copyProperties((Object)params, (Object)queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u603b\u6570\u67e5\u8be2es\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo sortingCostReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingCostReportListPage(queryDto));
        logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u603b\u6570\u67e5\u8be2es\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)sortingCostReportRespDtoPageInfo));
        if (CollectionUtils.isEmpty((Collection)sortingCostReportRespDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)sortingCostReportRespDtoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        SortingCostReportListPageParams params = new SortingCostReportListPageParams();
        SortingCostReportListPageReqDto queryDto = new SortingCostReportListPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SortingCostReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), SortingCostReportListPageParams.class);
            BeanUtils.copyProperties((Object)params, (Object)queryDto);
        }
        Integer dtoPageSize = commonReqDto.getPageSize();
        Integer dtoPageNum = commonReqDto.getPageNum();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < dtoPageNum; ++i) {
            Integer pageSize = 50000;
            Integer pageNum = 0 + i * 5;
            if (dtoPageSize <= pageSize) {
                pageNum = 1 + i * 5;
                pageSize = dtoPageSize;
            } else {
                pageNum = dtoPageSize % pageSize > 0 ? Integer.valueOf(dtoPageSize / pageSize + 1 + i * 5) : Integer.valueOf(dtoPageSize / pageSize + i * 5);
            }
            for (int j = 1 + i * 5; j < pageNum + 1; ++j) {
                queryDto.setPageNum(Integer.valueOf(j));
                queryDto.setPageSize(pageSize);
                logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
                PageInfo sortingCostReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingCostReportListPage(queryDto));
                logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u51fa\u53c2:{}", (Object)sortingCostReportRespDtoPageInfo.getTotal());
                if (!CollectionUtils.isNotEmpty((Collection)sortingCostReportRespDtoPageInfo.getList())) continue;
                sortingCostReportRespDtoPageInfo.getList().forEach(o -> {
                    ExportSortingCostReportVO vo = new ExportSortingCostReportVO();
                    String businessType = o.getBusinessType();
                    CsPcpBusinessTypeEnum anEnum = CsPcpBusinessTypeEnum.getByCode((String)businessType);
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setWmsConsignmentNo(o.getConsignmentNo());
                    vo.setRelevanceNo(o.getRelevanceNo());
                    vo.setBillingFeeFlagName(Objects.equals(o.getBillingFeeFlag(), 1) ? "\u662f" : "\u5426");
                    if (null != o.getAdjustType()) {
                        vo.setAdjustType(o.getAdjustType().equals("1") ? "\u589e\u52a0" : "\u51cf\u5c11");
                    }
                    if (anEnum != null) {
                        vo.setBusinessType(anEnum.getDesc());
                    }
                    this.setNumberType(vo, (SortingCostReportRespDto)o);
                    list.add(vo);
                });
            }
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    private void setNumberType(ExportSortingCostReportVO vo, SortingCostReportRespDto o) {
        try {
            vo.setOutQuantity(Long.valueOf(o.getOutQuantity()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setPackageNum(Long.valueOf(o.getPackageNum()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setLargeBox(Long.valueOf(o.getLargeBox()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setSmallBox(Long.valueOf(o.getSmallBox()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setNumber(Long.valueOf(o.getNumber()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setSmallPackageNum(Long.valueOf(o.getSmallPackageNum()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setPlatformAdjustAmount(new BigDecimal(o.getPlatformAdjustAmount()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setTotalSortingFee(new BigDecimal(o.getTotalSortingFee()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportSortingExpenseAdjustDto.class);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat(DatePattern.DATE_PATTERN.getPattern());
        Set longCodes = list.stream().map(ImportSortingExpenseAdjustDto::getGoodsLongCode).collect(Collectors.toSet());
        ItemExtendReqDto rqItem = new ItemExtendReqDto();
        rqItem.setItemCodeList((List)Lists.newArrayList(longCodes));
        List queryLists = list.stream().map(i -> {
            SortingExpenseQueryDto dto = new SortingExpenseQueryDto();
            dto.setDocumentNo(i.getDocumentNo());
            dto.setGoodsLongCode(i.getGoodsLongCode());
            return dto;
        }).collect(Collectors.toList());
        Map sortingMap = ((List)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingExpenseByList(queryLists))).stream().collect(Collectors.toMap(SortingExpenseRespDto::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        list.forEach(item -> {
            BigDecimal sortingNum;
            ImportSortingExpenseAdjustMsgDto msgDto = new ImportSortingExpenseAdjustMsgDto();
            BeanUtils.copyProperties((Object)item, (Object)((Object)msgDto));
            String documentNo = item.getDocumentNo();
            SortingExpenseRespDto sortingExpenseRespDto = new SortingExpenseRespDto();
            if (!sortingMap.containsKey(item.getUniqueKey())) {
                this.setErrorMsg(msgDto, "\u8be5\u6761\u6570\u636e\u5728\u5206\u62e3\u62a5\u8868\u5217\u8868\u79cd\u627e\u4e0d\u5230");
            } else {
                sortingExpenseRespDto = (SortingExpenseRespDto)sortingMap.get(item.getUniqueKey());
                if (sortingExpenseRespDto.getPlacedFlag() != null && sortingExpenseRespDto.getPlacedFlag() == 1) {
                    this.setErrorMsg(msgDto, "\u66f4\u65b0\u5931\u8d25\uff1a\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
                }
            }
            String adjustType = item.getAdjustType();
            sortingExpenseRespDto.setAdjustRemarks(item.getRemark());
            if (!Objects.equals("\u589e\u52a0", adjustType) && !Objects.equals("\u51cf\u5c11", adjustType)) {
                this.setErrorMsg(msgDto, "\u8c03\u589e\u7c7b\u578b\u9519\u8bef");
            }
            BigDecimal adjustNum = new BigDecimal(item.getAdjustAmount());
            sortingExpenseRespDto.setAdjustNum(adjustNum);
            if (adjustType.equals("\u589e\u52a0")) {
                sortingExpenseRespDto.setAdjustType(Long.valueOf(1L));
            }
            BigDecimal bigDecimal = sortingNum = sortingExpenseRespDto.getSortingNum() == null ? BigDecimal.ZERO : sortingExpenseRespDto.getSortingNum();
            if (adjustType.equals("\u51cf\u5c11")) {
                sortingExpenseRespDto.setAdjustType(Long.valueOf(2L));
                if (sortingNum.compareTo(adjustNum) == -1) {
                    this.setErrorMsg(msgDto, "\u51cf\u5c11\u8d39\u7528\u8d39\u4e0d\u80fd\u5927\u4e8e\u5408\u8ba1\u5206\u62e3\u8d39");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
            } else {
                SortingExpenseReqDto dto = new SortingExpenseReqDto();
                BeanUtils.copyProperties((Object)sortingExpenseRespDto, (Object)dto);
                dto.setImportUpdatePerson(commonReqDto.getOperator());
                saveList.add(dto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private void setErrorMsg(ImportSortingExpenseAdjustMsgDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.sortingExpenseQueryApi.bathImportUpdate(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List msgList = (List)msgObj;
            logger.info("\u9519\u8bef\u4fe1\u606f\u662ferrorList\uff1a{}", (Object)JSON.toJSONString((Object)msgList));
            if (CollectionUtil.isNotEmpty((Collection)msgList)) {
                String excelName = String.format("%s%s", "\u8c03\u6574\u8d39\u7528\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
                errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportSortingExpenseAdjustMsgDto.class, null, excelName);
            }
        }
        return errorMsgUrl;
    }

    @Override
    public RestResponse<Void> generateSortingExpense(String generateDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        YearMonth yearMonthObject = YearMonth.parse(generateDate);
        LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
        LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
        Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        String startDateStr = sdf.format(startDate);
        String endDateStr = sdf.format(endDate);
        TaskQueryParamsDro dro = new TaskQueryParamsDro();
        dro.setStartDateStr(startDateStr);
        dro.setEndDateStr(endDateStr);
        return this.sortingExpenseQueryApi.executeJob(dro);
    }
}

