/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportModifyLogicInventorySnapVo;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ILogicInventorySnapApi;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapCondition;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapRespDto;
import com.dtyunxi.tcbj.api.query.ILogicInventorySnapQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_modify_logic_inventory_snap")
public class LogicInventorySnapServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(LogicInventorySnapServiceImpl.class);
    private static final String BALANCE_MSG = "\u8ba1\u8d39\u5e93\u5b58\u683c\u5f0f\u9519\u8bef\uff08\u8981\u6c42\u6b63\u6574\u6570\uff09";
    private static final String TRAYNUM_MSG = "\u7801\u6258\u6570\u683c\u5f0f\u9519\u8bef\uff08\u8981\u6c42\u6b63\u6574\u6570\uff09";
    private static final String BIGBOX_MSG = "\u88c5\u7bb1\u6570\u683c\u5f0f\u9519\u8bef\uff08\u8981\u6c42\u6b63\u6574\u6570\uff09";
    private static final String DATE_FORMAT_MSG = "\u7edf\u8ba1\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u683c\u5f0f\uff1ayyyy-MM-dd";
    private static final String DATA_NOT_EXIST_MSG = "\u7edf\u8ba1\u65e5\u671f+\u5546\u54c1\u957f\u7f16\u7801+\u6279\u6b21+\u903b\u8f91\u4ed3\u7f16\u7801\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e";
    @Autowired
    private ILogicInventorySnapApi logicInventorySnapApi;
    @Autowired
    private ILogicInventorySnapQueryApi logicInventorySnapQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportModifyLogicInventorySnapVo.class);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        Map<String, LogicInventorySnapRespDto> snapRespDtoMap = this.getSnapRespDtoMap(list);
        logger.info("\u5bfc\u5165\u5e93\u5b58\u5feb\u7167\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)list));
        logger.info("\u6570\u636e\u5e93\u5e93\u5b58\u5feb\u7167\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(snapRespDtoMap));
        for (ImportModifyLogicInventorySnapVo vo : list) {
            this.checkDateFormat(vo);
            this.checkNumber(vo, vo.getBalance(), BALANCE_MSG);
            this.checkNumber(vo, vo.getTrayNum(), TRAYNUM_MSG);
            this.checkNumber(vo, vo.getBigBox(), BIGBOX_MSG);
            String mapKey = this.buildKey(vo.getStatisticalTime(), vo.getLongCode(), vo.getBatch(), vo.getWarehouseCode());
            LogicInventorySnapRespDto logicInventorySnapRespDto = snapRespDtoMap.get(mapKey);
            if (ObjectUtil.isEmpty((Object)logicInventorySnapRespDto)) {
                this.buildErrorMsg(vo, DATA_NOT_EXIST_MSG);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getMsg())) {
                msgList.add(vo);
                continue;
            }
            LogicInventorySnapReqDto reqDto = new LogicInventorySnapReqDto();
            reqDto.setId(logicInventorySnapRespDto.getId());
            reqDto.setStatisticalTime(vo.getStatisticalTime());
            reqDto.setLongCode(vo.getLongCode());
            reqDto.setBatch(vo.getBatch());
            reqDto.setWarehouseCode(vo.getWarehouseCode());
            reqDto.setBalance(new BigDecimal(vo.getBalance()));
            reqDto.setTrayNum(Long.valueOf(vo.getTrayNum()));
            reqDto.setBigBox(Integer.valueOf(vo.getBigBox()));
            saveList.add(reqDto);
        }
        HashMap returnMap = Maps.newHashMap();
        returnMap.put("saveList", saveList);
        returnMap.put("msgList", msgList);
        return returnMap;
    }

    private Map<String, LogicInventorySnapRespDto> getSnapRespDtoMap(List<ImportModifyLogicInventorySnapVo> list) {
        ArrayList storageTimes = Lists.newArrayList();
        ArrayList logicWarehouseCodes = Lists.newArrayList();
        ArrayList longCodes = Lists.newArrayList();
        ArrayList batchs = Lists.newArrayList();
        for (ImportModifyLogicInventorySnapVo importVo : list) {
            if (!storageTimes.contains(importVo.getStatisticalTime())) {
                storageTimes.add(importVo.getStatisticalTime());
            }
            if (!logicWarehouseCodes.contains(importVo.getWarehouseCode())) {
                logicWarehouseCodes.add(importVo.getWarehouseCode());
            }
            if (!longCodes.contains(importVo.getLongCode())) {
                longCodes.add(importVo.getLongCode());
            }
            if (batchs.contains(importVo.getBatch())) continue;
            batchs.add(importVo.getBatch());
        }
        LogicInventorySnapCondition condition = new LogicInventorySnapCondition();
        condition.setStorageTime((List)storageTimes);
        condition.setLogicWarehouseCodes((List)logicWarehouseCodes);
        condition.setLongCodes((List)longCodes);
        condition.setBatchs((List)batchs);
        List snapRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicInventorySnapQueryApi.queryByCondition(condition));
        Map<String, LogicInventorySnapRespDto> snapRespDtoMap = snapRespDtos.stream().collect(Collectors.toMap(e -> this.buildKey(DateUtils.format((Date)e.getStatisticalTime(), (String)"yyyy-MM-dd"), e.getLongCode(), e.getBatch(), e.getWarehouseCode()), e -> e, (e1, e2) -> e1));
        return snapRespDtoMap;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            RestResponseHelper.extractData((RestResponse)this.logicInventorySnapApi.importModifyLogicInventorySnap(saveList));
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5bfc\u5165\u4fee\u6539\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportModifyLogicInventorySnapVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private String buildKey(String statisticalTime, String longCode, String batch, String warehouseCode) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(statisticalTime).append('_').append(longCode).append('_').append(batch).append('_').append(warehouseCode);
        return sb.toString();
    }

    private void checkNumber(ImportModifyLogicInventorySnapVo vo, String numberStr, String msg) {
        if (StringUtils.isBlank((CharSequence)numberStr)) {
            this.buildErrorMsg(vo, msg);
            return;
        }
        if (!StringUtils.isNumeric((CharSequence)numberStr)) {
            this.buildErrorMsg(vo, msg);
            return;
        }
    }

    private void checkDateFormat(ImportModifyLogicInventorySnapVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getStatisticalTime())) {
            this.buildErrorMsg(vo, DATE_FORMAT_MSG);
            return;
        }
        try {
            Date date = DateUtils.parseDate((String)vo.getStatisticalTime(), (String)"yyyy-MM-dd");
            if (date == null) {
                this.buildErrorMsg(vo, DATE_FORMAT_MSG);
            }
        }
        catch (ParseException e) {
            this.buildErrorMsg(vo, DATE_FORMAT_MSG);
        }
    }

    public void buildErrorMsg(ImportModifyLogicInventorySnapVo vo, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)vo.getMsg())) {
            vo.setMsg(errorMsg);
        } else {
            vo.setMsg(String.format("%s\u3001%s", vo.getMsg(), errorMsg));
        }
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167\u5bfc\u51fa\u603b\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        return 1;
    }
}

