/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInsurancePremiumChargingVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.InsurancePremiumChargingReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IReInsurancePremiumChargingApi;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumChargingRespDto;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insurance_premium_charging_place_export")
public class InsurancePremiumChargingReportPlaceExportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(InsurancePremiumChargingReportPlaceExportServiceImpl.class);
    @Resource
    private IReInsurancePremiumChargingApi reInsurancePremiumChargingApi;
    @Resource
    private InsurancePremiumChargingReportService insurancePremiumChargingReportService;

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        ReInsurancePremiumChargingReqDto params = new ReInsurancePremiumChargingReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (ReInsurancePremiumChargingReqDto)JSON.parseObject((String)commonReqDto.getFilter(), ReInsurancePremiumChargingReqDto.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.insurancePremiumChargingReportService.queryByPage(params));
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)pageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        this.getDate(commonReqDto);
        ReInsurancePremiumChargingReqDto insurancePageParams = new ReInsurancePremiumChargingReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            insurancePageParams = (ReInsurancePremiumChargingReqDto)JSON.parseObject((String)commonReqDto.getFilter(), ReInsurancePremiumChargingReqDto.class);
        }
        insurancePageParams.setPageSize(null);
        insurancePageParams.setPageNum(null);
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                log.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)re));
                RestResponse<PageInfo<ReInsurancePremiumChargingRespDto>> pageInfoRestResponse = this.insurancePremiumChargingReportService.queryByPage((ReInsurancePremiumChargingReqDto)re);
                PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List<Object> list = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    list = respDtoPageInfo.getList().stream().map(o -> {
                        ExportInsurancePremiumChargingVO vo = new ExportInsurancePremiumChargingVO();
                        BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                        return vo;
                    }).collect(Collectors.toList());
                    waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(ReInsurancePremiumChargingRespDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList((List)list);
                log.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
                return pageInfo;
            }, insurancePageParams, ExportInsurancePremiumChargingVO.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            log.error("\u4fdd\u8d39\u660e\u7ec6\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            throw new BizException(e.getMessage());
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.reInsurancePremiumChargingApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        if (StringUtils.isBlank((CharSequence)commonReqDto.getFilter())) {
            return;
        }
        Map filterMap = (Map)JSON.parseObject((String)commonReqDto.getFilter(), Map.class);
        Object params = filterMap.get("params");
        if (ObjectUtil.isNotEmpty(params)) {
            Map paramsMap = (Map)JSON.parseObject((String)params.toString(), Map.class);
            filterMap.putAll(paramsMap);
        }
        commonReqDto.setFilter(JSON.toJSONString((Object)filterMap));
    }
}

