/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.helper.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.InspectionToRegularVO;
import com.dtyunxi.cis.pms.biz.service.IInspectionRegularService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryOtherHelper;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.helper.TransferAddBaseDto;
import com.dtyunxi.cis.pms.biz.service.helper.TransferAddBo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryTransferHelperImpl
implements InventoryTransferHelper {
    private static final Logger log = LoggerFactory.getLogger(InventoryTransferHelperImpl.class);
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private ICsTransferOrderApi transferOrderApi;
    @Resource
    private InventoryOtherHelper inventoryOtherHelper;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IInspectionRegularService iInspectionRegularService;
    @Resource
    private ICsTransferOrderApi transferOrderQueryApi;

    @Override
    public String doAddTransfer(TransferAddBaseDto transferAddBaseDto) {
        if (!transferAddBaseDto.isAutoComplete() && transferAddBaseDto.isAutoAudit()) {
            return this.addCommonTransfer(transferAddBaseDto);
        }
        return this.adAutoCompleteTransfer(transferAddBaseDto);
    }

    private String addCommonTransfer(TransferAddBaseDto transferAddBaseDto) {
        LogicInventoryRespDto logicInventoryRespDto = transferAddBaseDto.getInventoryList().get(0);
        EasTransferOrderReqDto transferOrder = new EasTransferOrderReqDto();
        transferOrder.setOutWarehouseCode(transferAddBaseDto.getSourceWarehouse());
        transferOrder.setSupplierCode(transferAddBaseDto.getWare().getOrganizationCode());
        if (StringUtils.isNotBlank((CharSequence)transferAddBaseDto.getPreOrderNo())) {
            transferOrder.setPlatformOrderNo(transferAddBaseDto.getPreOrderNo());
        } else {
            transferOrder.setPlatformOrderNo(this.inventoryOtherHelper.codeGenerate(Optional.ofNullable(transferAddBaseDto.getPrefixNo()).filter(StringUtils::isNotBlank).orElse("DBDJ")));
        }
        transferOrder.setfOwner("TCBJ");
        transferOrder.setSourceSystem("PCP");
        transferOrder.setAutoAudit(Boolean.valueOf(transferAddBaseDto.isAutoAudit()));
        transferOrder.setfPhyWarehs(logicInventoryRespDto.getPhysicsWarehouseCode());
        transferOrder.setAllotType(transferAddBaseDto.getType());
        transferOrder.setInWarehouseCode(transferAddBaseDto.getWare().getWarehouseCode());
        transferOrder.setItemDetailList(transferAddBaseDto.getInventoryList().stream().map(item -> {
            EasTransferOrderDetailReqDto dto = (EasTransferOrderDetailReqDto)BeanUtil.copyProperties((Object)item, EasTransferOrderDetailReqDto.class, (String[])new String[0]);
            dto.setLongCode(item.getItemLongCode());
            dto.setQuantity(item.getAvailable());
            dto.setBatch(item.getBatch());
            dto.setOutWarehouseCode(transferAddBaseDto.getSourceWarehouse());
            dto.setInWarehouseCode(transferAddBaseDto.getWare().getWarehouseCode());
            return dto;
        }).collect(Collectors.toList()));
        transferOrder.setRemark(this.getRemark(transferAddBaseDto));
        log.info("Eas\u65b0\u589e\u8c03\u62e8\u5355\u8868==>{}", (Object)JSON.toJSONString((Object)transferOrder));
        RestResponseHelper.checkOrThrow((RestResponse)this.transferOrderApi.easAddTransferOrder(transferOrder));
        return transferOrder.getPlatformOrderNo();
    }

    private String adAutoCompleteTransfer(TransferAddBaseDto transferAddBaseDto) {
        CsTransferOrderComboReqDto reqDto = new CsTransferOrderComboReqDto();
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        reqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
        transferOrderReqDto.setPreOrderNo(transferAddBaseDto.getProOrderNo());
        String db = this.inventoryOtherHelper.codeGenerate(Optional.ofNullable(transferAddBaseDto.getPrefixNo()).filter(StringUtils::isNotEmpty).orElse("DBIN"));
        transferOrderReqDto.setTransferOrderNo(db);
        transferOrderReqDto.setType(transferAddBaseDto.getType());
        transferOrderReqDto.setIsEnd(Boolean.valueOf(transferAddBaseDto.isAutoComplete()));
        transferOrderReqDto.setOutLogicWarehouseCode(transferAddBaseDto.getSourceWarehouse());
        transferOrderReqDto.setInLogicWarehouseCode(transferAddBaseDto.getWare().getWarehouseCode());
        transferOrderReqDto.setPlanInTime(new Date());
        transferOrderReqDto.setPlanOutTime(new Date());
        transferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        if (StringUtils.isNotBlank((CharSequence)transferAddBaseDto.getShipmentEnterpriseCode()) || StringUtils.isNotBlank((CharSequence)transferAddBaseDto.getShipmentEnterpriseName())) {
            JSONObject extension = new JSONObject();
            extension.put("shipmentEnterpriseName", (Object)transferAddBaseDto.getShipmentEnterpriseName());
            extension.put("applyclaimFile", (Object)transferAddBaseDto.getApplyclaimFile());
            extension.put("expressNo", (Object)transferAddBaseDto.getExpressNo());
            extension.put("shipmentEnterpriseCode", (Object)transferAddBaseDto.getShipmentEnterpriseCode());
            transferOrderReqDto.setExtension(extension.toJSONString());
            log.info("\u8bbe\u7f6e\u8c03\u62e8\u5355\u7269\u6d41\u5546\u4fe1\u606f\uff0c\u7f16\u7801\uff1a{}\uff0c\u540d\u79f0\uff1a{}\uff0c\u7269\u6d41\u5355\u53f7\uff1a{}", new Object[]{transferAddBaseDto.getShipmentEnterpriseCode(), transferAddBaseDto.getShipmentEnterpriseName(), transferAddBaseDto.getExpressNo()});
        }
        ArrayList detailList = Lists.newArrayList();
        for (LogicInventoryRespDto i : transferAddBaseDto.getInventoryList()) {
            CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
            detailReqDto.setCargoCode(i.getItemLongCode());
            detailReqDto.setLongCode(i.getItemLongCode());
            detailReqDto.setBatch(i.getBatch());
            detailReqDto.setCargoName(i.getItemName());
            detailReqDto.setQuantity(i.getAvailable());
            detailReqDto.setTransferOrderNo(db);
            detailList.add(detailReqDto);
        }
        transferOrderReqDto.setRemark(this.getRemark(transferAddBaseDto));
        transferOrderReqDto.setBizDate(transferAddBaseDto.getBizDate());
        reqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
        reqDto.setDetailList((List)detailList);
        log.info("\u8c03\u62e8\u5355\u521b\u5efa\u5165\u53c2==========={}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.transferOrderApi.addTransferOrder(reqDto));
        return db;
    }

    private String getRemark(TransferAddBaseDto transferAddBaseDto) {
        return Optional.of(transferAddBaseDto.getInventoryList().stream().map(LogicInventoryRespDto::getRemark).filter(StringUtils::isNotBlank).collect(Collectors.joining())).map(r -> r.length() > 256 ? r.substring(0, 256) : r).orElse("");
    }

    @Override
    public LogicWarehouseRespDto getLogicWarehouseByCode(String warehouse) {
        return Optional.ofNullable(warehouse).filter(StringUtils::isNotBlank).map(ware -> {
            LogicWarehouseReqDto dto = new LogicWarehouseReqDto();
            dto.setWarehouseCode(warehouse);
            return Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryByPageByPost(dto))).getList()).filter(CollectionUtils::isNotEmpty).map(r -> (LogicWarehouseRespDto)r.get(0)).orElse(null);
        }).orElse(null);
    }

    @Override
    public LogicWarehouseRespDto getTransitWarehouse(Long warehouseId) {
        return Optional.ofNullable(warehouseId).map(id -> {
            LogicWarehouseReqDto dto = new LogicWarehouseReqDto();
            dto.setSubordinateLogicWarehouseId(warehouseId);
            return Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryByPageByPost(dto))).getList()).filter(CollectionUtils::isNotEmpty).map(r -> (LogicWarehouseRespDto)r.get(0)).orElse(null);
        }).orElse(null);
    }

    @Override
    public LogicWarehouseRespDto getLogicWarehouseById(Long warehouseId) {
        return Optional.ofNullable(warehouseId).map(id -> {
            LogicWarehouseReqDto dto = new LogicWarehouseReqDto();
            dto.setId(warehouseId);
            return Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryByPageByPost(dto))).getList()).filter(CollectionUtils::isNotEmpty).map(r -> (LogicWarehouseRespDto)r.get(0)).orElse(null);
        }).orElse(null);
    }

    @Override
    public String addTransfer(InspectionToRegularVO p, CsPcpBusinessTypeEnum type, boolean autoComplete, boolean autoAudit) {
        try {
            return this.addTransferInner(p, type, autoComplete, autoAudit);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u653e\u884c\u589e\u52a0\u5355\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
            return "";
        }
    }

    @Override
    public String addTransferThrow(InspectionToRegularVO p, CsPcpBusinessTypeEnum type, boolean autoComplete, boolean autoAudit) throws Exception {
        return this.addTransferInner(p, type, autoComplete, autoAudit);
    }

    private String addTransferInner(InspectionToRegularVO p, CsPcpBusinessTypeEnum type, boolean autoComplete, boolean autoAudit) throws Exception {
        TransferAddBo transferAddBo = new TransferAddBo(p.getLogicalWarehouseCode(), (List<LogicInventoryRespDto>)Lists.newArrayList((Object[])new LogicInventoryRespDto[]{this.trarnInventory(p)}), p.getInWarehouseCode(), type.getCode(), p.getTransferOrderNo());
        transferAddBo.setAutoAudit(autoAudit);
        transferAddBo.setAutoComplete(autoComplete);
        String s = this.doAddTransfer(transferAddBo);
        p.setTransferOrderNo(s);
        this.iInspectionRegularService.removeByIds(Lists.newArrayList((Object[])new Long[]{p.getId()}));
        this.iInspectionRegularService.removeUpdateByIds(Lists.newArrayList((Object[])new Long[]{p.getId()}));
        return s;
    }

    private LogicInventoryRespDto trarnInventory(InspectionToRegularVO p) {
        LogicInventoryRespDto inventoryRespDto = new LogicInventoryRespDto();
        inventoryRespDto.setBatch(p.getBatchNo());
        inventoryRespDto.setAvailable(BigDecimal.valueOf(p.getPlanQuantity().intValue()));
        inventoryRespDto.setItemLongCode(p.getGoodsLongCode());
        inventoryRespDto.setItemName(p.getGoodsName());
        inventoryRespDto.setItemLongCode(p.getGoodsLongCode());
        inventoryRespDto.setBatch(p.getBatchNo());
        return inventoryRespDto;
    }

    @Override
    public CsOutResultOrderRespDto getCsOutResultOrder(String documentNo) {
        CsOutResultOrderRespDto csOutResultOrderRespDto = (CsOutResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByDocumentNo(documentNo));
        CsOutResultOrderQueryDto resultOrderQueryDto = new CsOutResultOrderQueryDto();
        resultOrderQueryDto.setDocumentNo(csOutResultOrderRespDto.getDocumentNo());
        FetchDataService fetchDataService = req -> (PageInfo)this.csOutResultOrderQueryApi.queryDetailByPage(req).getData();
        csOutResultOrderRespDto.setDetailRespDtoList(fetchDataService.fetchAll(resultOrderQueryDto));
        return csOutResultOrderRespDto;
    }

    @Override
    public CsTransferOrderRespDto getTransferByNo(String relevanceNo) {
        return Optional.ofNullable(relevanceNo).filter(StringUtils::isNotBlank).map(r -> (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.transferOrderQueryApi.queryByTransferOrderNo(r))).orElse(null);
    }
}

