/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetReceiveNoticeOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ReceiveNoticeOrderVO;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillReceiveNoticeOrderService;
import com.dtyunxi.cis.search.api.dto.request.EsReceiveNoticeOrderReqParams;
import com.dtyunxi.cis.search.api.query.delivery.EsReceiveNoticeOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderRespDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillReceiveNoticeOrderServiceServiceImpl
implements InventoryCenterBillReceiveNoticeOrderService {
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private EsReceiveNoticeOrderQueryApi esReceiveNoticeOrderQueryApi;
    @Resource
    private ICsReceiveNoticeOrderQueryApi csReceiveNoticeOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;
    @Resource
    private IDeliveryNoticeOrderQueryApi deliveryNoticeOrderQueryApi;

    @Override
    public RestResponse<ReceiveNoticeOrderVO> getReceiveNoticeOrderDetail(@ApiParam(value="\u6536\u8d27\u901a\u77e5\u5355\u53f7") @Valid @RequestParam(value="receiveNoticeNo", required=false) String receiveNoticeNo) {
        List relOrderInfoList;
        List respDtos;
        if (StringUtils.isBlank((CharSequence)receiveNoticeNo)) {
            throw new BizException("\u6536\u8d27\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsReceiveNoticeOrderRespDto respDto = (CsReceiveNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csReceiveNoticeOrderQueryApi.queryVersionSecondByDocumentNo(receiveNoticeNo));
        ReceiveNoticeOrderVO vo = new ReceiveNoticeOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setDocumentNo(respDto.getDocumentNo());
        vo.setBusinessType(respDto.getBusinessType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryPhysicalWarehouseName(respDto.getDeliveryPhysicsWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getDeliveryPhysicsWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setDeliveryLogicalWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setReceiveLogicalWarehouseCode(respDto.getWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getReceivePhysicsWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getReceivePhysicsWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryTakeDeliveryInformation(receiveNoticeNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(saleRefundAddrRespDto.getProvince() + saleRefundAddrRespDto.getCity() + saleRefundAddrRespDto.getCounty() + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(orderAddrRespDto.getProvince() + orderAddrRespDto.getCity() + orderAddrRespDto.getCounty() + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<ReceiveNoticeOrderVO>> getReceiveNoticeOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetReceiveNoticeOrderListPageParams getReceiveNoticeOrderListPageParams) {
        if (!this.esQuery.booleanValue()) {
            PageInfo respDtoPageInfo = new PageInfo();
            PageInfo pageInfo = new PageInfo();
            DeliveryNoticeOrderReqDto reqDto = new DeliveryNoticeOrderReqDto();
            BeanUtils.copyProperties((Object)getReceiveNoticeOrderListPageParams, (Object)reqDto);
            reqDto.setBusinessType(getReceiveNoticeOrderListPageParams.getBusinessType());
            reqDto.setOrderNo(getReceiveNoticeOrderListPageParams.getDocumentNo());
            reqDto.setOrderStatus(getReceiveNoticeOrderListPageParams.getDocumentStatus());
            reqDto.setWarehouseName(getReceiveNoticeOrderListPageParams.getDeliveryLogicalWarehouseName());
            reqDto.setReceiveWarehouseName(getReceiveNoticeOrderListPageParams.getReceiveLogicalWarehouseName());
            if (StringUtils.isNotBlank((CharSequence)getReceiveNoticeOrderListPageParams.getStartTime()) && StringUtils.isNotBlank((CharSequence)getReceiveNoticeOrderListPageParams.getEndTime())) {
                reqDto.setCreateBeginTime((Date)DateUtil.parse((CharSequence)(getReceiveNoticeOrderListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                reqDto.setCreateEndTime((Date)DateUtil.parse((CharSequence)(getReceiveNoticeOrderListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            reqDto.setOrderType("receive");
            respDtoPageInfo = (PageInfo)this.deliveryNoticeOrderQueryApi.queryByPage(reqDto).getData();
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList deliveryNoticeOrderVOS = new ArrayList(respDtoPageInfo.getList().size());
            respDtoPageInfo.getList().forEach(o -> {
                ReceiveNoticeOrderVO deliveryNoticeOrderVO = DtoExchangeUtils.createDtoBySource(o, ReceiveNoticeOrderVO.class);
                if (Objects.nonNull(o.getCreateTime())) {
                    deliveryNoticeOrderVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                deliveryNoticeOrderVO.setDocumentStatus(o.getOrderStatus());
                deliveryNoticeOrderVO.setBusinessOrderNo(o.getRelevanceNo());
                deliveryNoticeOrderVO.setExternalOrderNo(o.getExternalOrderNo());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseCode(o.getWarehouseCode());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseName(o.getWarehouseName());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
                if (ObjectUtil.isNotEmpty((Object)o.getTotalSku())) {
                    deliveryNoticeOrderVO.setTotalSku(new BigDecimal(String.valueOf(o.getTotalSku())));
                }
                deliveryNoticeOrderVOS.add(deliveryNoticeOrderVO);
            });
            pageInfo.setList(deliveryNoticeOrderVOS);
            return new RestResponse((Object)pageInfo);
        }
        EsReceiveNoticeOrderReqParams pageQueryDto = new EsReceiveNoticeOrderReqParams();
        BeanUtils.copyProperties((Object)getReceiveNoticeOrderListPageParams, (Object)pageQueryDto);
        pageQueryDto.setOrderNo(getReceiveNoticeOrderListPageParams.getDocumentNo());
        pageQueryDto.setOrderStatus(getReceiveNoticeOrderListPageParams.getDocumentStatus());
        pageQueryDto.setCreateBeginTime(getReceiveNoticeOrderListPageParams.getStartTime());
        pageQueryDto.setCreateEndTime(getReceiveNoticeOrderListPageParams.getEndTime());
        PageInfo esReceiveNoticeOrderRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esReceiveNoticeOrderQueryApi.queryReceiveNoticeOrderPage(pageQueryDto));
        if (CollectionUtils.isEmpty((Collection)esReceiveNoticeOrderRespVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)esReceiveNoticeOrderRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = esReceiveNoticeOrderRespVoPageInfo.getList().stream().map(p -> {
            ReceiveNoticeOrderVO vo = new ReceiveNoticeOrderVO();
            BeanUtils.copyProperties((Object)p, (Object)vo);
            if (p.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setBusinessOrderNo(p.getRelevanceNo());
            vo.setDocumentStatus(p.getOrderStatus());
            vo.setDeliveryLogicalWarehouseCode(p.getDeliveryLogicWarehouseCode());
            vo.setDeliveryLogicalWarehouseName(p.getDeliveryLogicWarehouseName());
            vo.setReceiveLogicalWarehouseCode(p.getReceiveLogicWarehouseCode());
            vo.setReceiveLogicalWarehouseName(p.getReceiveLogicWarehouseName());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

