/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateSpecialChargesDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateSpecialChargesMsgDto;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticsReportRespDto;
import com.dtyunxi.tcbj.api.query.IFinLogisticsReportQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistics_special_charges_import")
public class LogisticsSpecialChargesImportServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsSpecialChargesImportServiceImpl.class);
    @Resource
    private IFinLogisticsReportQueryApi finLogisticsReportQueryApi;
    @Resource
    private IFinLogisticsReportApi finLogisticsReportApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateSpecialChargesDto.class);
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u7279\u6b8a\u8d39\u7528\u5bfc\u5165\uff1a{}", (Object)JSON.toJSONString((Object)list));
        List transportCodeList = list.stream().map(TemplateSpecialChargesDto::getTransportCode).collect(Collectors.toList());
        List logisticsNoList = list.stream().map(TemplateSpecialChargesDto::getLogisticsNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(10000));
        reqDto.setTransportCodeList(transportCodeList);
        reqDto.setTransportNoList(logisticsNoList);
        logger.info("\u67e5\u8be2\u5339\u914d\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByPage(reqDto));
        logger.info("\u67e5\u8be2\u5339\u914d\u5355\u636e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        Map transportCodeMap = Optional.ofNullable(pageInfo.getList()).map(m -> pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getTransportCode())).collect(Collectors.groupingBy(FinLogisticsReportRespDto::getTransportCode))).orElse(new HashMap());
        Map transportNoMap = Optional.ofNullable(pageInfo.getList()).map(m -> pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getTransportCode()) && StringUtils.isNotBlank((CharSequence)f.getTransportNo())).collect(Collectors.groupingBy(f -> f.getTransportCode() + f.getTransportNo()))).orElse(new HashMap());
        list.forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getTransportCode()) && StringUtils.isNotBlank((CharSequence)dto.getLogisticsNo())) {
                if (transportNoMap.containsKey(dto.getTransportCode() + dto.getLogisticsNo())) {
                    dto.setIds(((List)transportNoMap.get(dto.getTransportCode() + dto.getLogisticsNo())).stream().map(FinLogisticsReportRespDto::getId).collect(Collectors.toList()));
                } else {
                    dto.setErrorMsg("\u5339\u914d\u4e0d\u5230\u5355\u636e");
                }
            } else if (transportCodeMap.containsKey(dto.getTransportCode())) {
                dto.setIds(((List)transportCodeMap.get(dto.getTransportCode())).stream().map(FinLogisticsReportRespDto::getId).collect(Collectors.toList()));
            } else {
                dto.setErrorMsg("\u5339\u914d\u4e0d\u5230\u5355\u636e");
            }
        });
        return list;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List list = (List)obj;
        logger.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u7279\u6b8a\u8d39\u7528\u5bfc\u5165\uff0c\u6821\u9a8c\u540e\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)list));
        list.forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getErrorMsg())) {
                try {
                    FinLogisticsDetailReqDto reqDto = new FinLogisticsDetailReqDto();
                    reqDto.setIds(dto.getIds());
                    reqDto.setSpecialType(dto.getSpecialType());
                    reqDto.setSpecialAmount(dto.getSpecialAmount());
                    RestResponseHelper.extractData((RestResponse)this.finLogisticsReportApi.updateSpecial(reqDto));
                }
                catch (Exception e) {
                    dto.setErrorMsg("\u8bf7\u6c42\u5931\u8d25\uff1a" + (e.getMessage().contains("\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c") ? "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c" : e.getMessage()));
                    logger.error("\u66f4\u65b0\u7279\u6b8a\u8d39\u7528\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)dto), (Object)e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            List msgDtoList = BeanUtil.copyToList(errorList, TemplateSpecialChargesMsgDto.class);
            String excelName = String.format("%s%s", "\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u7279\u6b8a\u8d39\u7528\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgDtoList, TemplateSpecialChargesMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

