/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateVolumeTwoDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateVolumeTwoMsgDto;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.pms.biz.utils.ImportCheckUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.ILogisticApi;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaReqDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistic_appoint_area_off_peak_volume_two")
public class AppointAreaOffPeakVolumeTwoServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AppointAreaOffPeakVolumeTwoServiceImpl.class);
    @Resource
    private ILogisticApi logisticApi;
    @Resource
    private BasedataCenterAreaService centerAreaService;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateVolumeTwoDto.class);
        log.info("\u6307\u5b9a\u533a\u57df\u901a\u7528\u6309\u4ef6/\u4f53\u79ef\u5bfc\u5165={}", (Object)list.size());
        List failList = result.getFailList();
        Map<Integer, String> failMap = null;
        if (CollectionUtil.isNotEmpty((Collection)failList)) {
            failMap = failList.stream().collect(Collectors.toMap(i -> i.getRowNum(), j -> j.getErrorMsg(), (k1, k2) -> k1));
        }
        Map<Integer, String> finalFailMap = failMap;
        Map bizMap = commonReqDto.getExtFields();
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        Map areaMap = this.centerAreaService.getAreaList().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
        HashSet checkUnique = Sets.newHashSet();
        list.forEach(i -> {
            AppointAreaReqDto saveDto = new AppointAreaReqDto();
            TemplateVolumeTwoMsgDto msgDto = new TemplateVolumeTwoMsgDto();
            BeanUtils.copyProperties((Object)i, (Object)saveDto);
            BeanUtils.copyProperties((Object)i, (Object)msgDto);
            int rowNum = i.getRowNum();
            if (CollectionUtil.isNotEmpty((Map)finalFailMap) && finalFailMap.containsKey(rowNum)) {
                msgDto.setMsg((String)finalFailMap.get(rowNum));
            }
            if (checkUnique.contains(i.getUniqueKey())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u6570\u636e\u91cd\u590d");
                } else {
                    msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u6570\u636e\u91cd\u590d"));
                }
            } else {
                checkUnique.add(i.getUniqueKey());
            }
            this.checkNumMatches(msgDto);
            this.checkArea(areaMap, msgDto);
            if (null != bizMap.get("configId")) {
                saveDto.setTemplateId(bizMap.get("configId").toString());
            }
            saveDto.setDay(Integer.valueOf(i.getDay()));
            saveDto.setType(SeasonTypeEnum.OFF_OR_PEAK.getType());
            saveDto.setChargeType(ChargeModeEnum.VOLUME_TWO.getType());
            TemplateVolumeTwoDto volumeDto = new TemplateVolumeTwoDto();
            volumeDto.setPeak(i.getExcelPeak().get(0));
            volumeDto.setOff(i.getExcelOff().get(0));
            saveDto.setParams(JSONObject.toJSONString((Object)((Object)volumeDto)));
            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                saveList.add(saveDto);
            } else {
                msgList.add(msgDto);
            }
        });
        log.info("saveList\u5927\u5c0f={}", (Object)saveList.size());
        log.info("msgList\u5927\u5c0f={}", (Object)msgList.size());
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.logisticApi.saveAppointArea(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u6307\u5b9a\u533a\u57df\u6de1\u65fa\u5b63\u6309\u4ef6/\u4f53\u79ef\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, TemplateVolumeTwoMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private void checkArea(Map<String, BaseAreaVO> areaMap, TemplateVolumeTwoMsgDto msgDto) {
        if (!areaMap.containsKey(msgDto.getProvince())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                msgDto.setMsg("\u7701\u540d\u79f0\u4e0d\u6b63\u786e");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u7701\u540d\u79f0\u4e0d\u6b63\u786e"));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msgDto.getArea()) && StringUtils.isBlank((CharSequence)msgDto.getCity())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                msgDto.setMsg("\u82e5\u586b\u5199\u4e86\u533a/\u53bf\u5219\u7701\u3001\u5e02\u5fc5\u987b\u586b\u5199");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u82e5\u586b\u5199\u4e86\u533a/\u53bf\u5219\u7701\u3001\u5e02\u5fc5\u987b\u586b\u5199"));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msgDto.getCity())) {
            if (CollectionUtil.isNotEmpty(areaMap.get(msgDto.getProvince()).getChildren())) {
                Map cityMap = areaMap.get(msgDto.getProvince()).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                if (!cityMap.containsKey(msgDto.getCity())) {
                    if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                        msgDto.setMsg("\u5e02\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u540d\u79f0\u4e0d\u5339\u914d");
                    } else {
                        msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u5e02\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u540d\u79f0\u4e0d\u5339\u914d"));
                    }
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)msgDto.getArea())) {
                    if (((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren() != null) {
                        Map districtMap = ((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                        if (!districtMap.containsKey(msgDto.getArea())) {
                            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                                msgDto.setMsg("\u533a/\u53bf\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u533a/\u53bf\u4e0d\u5339\u914d");
                            } else {
                                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u533a/\u53bf\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u533a/\u53bf\u4e0d\u5339\u914d"));
                            }
                        }
                    } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                        msgDto.setMsg("\u6ca1\u627e\u5230\u76f8\u5173\u7684\u533a/\u53bf\u4fe1\u606f");
                    } else {
                        msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u6ca1\u627e\u5230\u76f8\u5173\u7684\u533a/\u53bf\u4fe1\u606f"));
                    }
                    return;
                }
            } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                msgDto.setMsg("\u6ca1\u627e\u5230\u76f8\u5173\u7684\u5e02\u4fe1\u606f");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u6ca1\u627e\u5230\u76f8\u5173\u5e02\u4fe1\u606f"));
            }
            return;
        }
    }

    private void checkNumMatches(TemplateVolumeTwoMsgDto msgDto) {
        if (StringUtils.isEmpty((CharSequence)msgDto.getDay())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                msgDto.setMsg("\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        } else if (!ImportCheckUtils.checkNum(msgDto.getDay())) {
            if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                msgDto.setMsg("\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
            } else {
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u8f93\u5165\u683c\u5f0f\u9519\u8bef"));
            }
        }
        if (CollectionUtils.isEmpty(msgDto.getExcelPeak())) {
            msgDto.setMsg(StringUtils.isBlank((CharSequence)msgDto.getMsg()) ? "\u65fa\u5b63\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a" : String.format("%s\u3001%s", msgDto.getMsg(), "\u65fa\u5b63\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            this.checkCollection(msgDto, msgDto.getExcelPeak());
        }
        if (CollectionUtils.isEmpty(msgDto.getExcelOff())) {
            msgDto.setMsg(StringUtils.isBlank((CharSequence)msgDto.getMsg()) ? "\u6de1\u5b63\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a" : String.format("%s\u3001%s", msgDto.getMsg(), "\u6de1\u5b63\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            this.checkCollection(msgDto, msgDto.getExcelOff());
        }
    }

    private void checkCollection(TemplateVolumeTwoMsgDto msgDto, List<TemplateVolumeTwoDto.TemplateVolumeTwoSeasonVolumeTwoDto> list) {
        list.forEach(e -> {
            if (StringUtils.isEmpty((CharSequence)e.getBox())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("N-N\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "N-N\u7bb1\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            } else if (!this.checkDecimal(e.getBox())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("N-N\u7bb1\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                } else {
                    msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "N-N\u7bb1\u8f93\u5165\u683c\u5f0f\u9519\u8bef"));
                }
            }
            if (StringUtils.isEmpty((CharSequence)e.getVolume01())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg(">N\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), ">N\u7bb1\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            } else if (!this.checkDecimal(e.getVolume01())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg(">N\u7bb1\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                } else {
                    msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), ">N\u7bb1\u8f93\u5165\u683c\u5f0f\u9519\u8bef"));
                }
            }
        });
    }

    private boolean checkDecimal(String price) {
        return ImportCheckUtils.checkAmount(price);
    }
}

