/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.trade;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpSaleRefundApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.SaleRefundReqDto;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="ORDER_REFUND_ADD_PROCESS")
public class AddSaleRefundOrderProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(AddSaleRefundOrderProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private IPcpSaleRefundApi pcpSaleRefundApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        String msgStr = JSON.toJSONString(message);
        log.info("\u63a5\u6536\u65b0\u589e\u9500\u552e\u9000\u8d27\u8ba2\u5355\uff1a{}", (Object)msgStr);
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse<Long> response = this.addSaleRefund(message, msgStr);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9500\u552e\u9000\u8d27\u8ba2\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<Long> addSaleRefund(Map<String, Object> message, String msgStr) {
        SaleRefundReqDto refundReqDto = new SaleRefundReqDto();
        BeanUtil.copyProperties(message, (Object)refundReqDto, (String[])new String[0]);
        refundReqDto.setPlatformRefundCreateTime(refundReqDto.getPlatformRefundApplyTime());
        SaleRefundAddrReqDto orderAddrDto = new SaleRefundAddrReqDto();
        Object addrReqDto = message.get("saleRefundAddrReqDto");
        BeanUtil.copyProperties((Object)addrReqDto, (Object)orderAddrDto, (String[])new String[0]);
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"saleRefundOrderItemReqDtoList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            SaleRefundItemReqDto dto = new SaleRefundItemReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            if (items.containsKey("saleUnitPrice") && Objects.nonNull(items.containsKey("saleUnitPrice"))) {
                BigDecimal saleUnitPrice = new BigDecimal(items.get("saleUnitPrice").toString());
                dto.setPrice(saleUnitPrice);
            }
            return dto;
        }).collect(Collectors.toList());
        refundReqDto.setSnapshot(msgStr);
        refundReqDto.setSaleRefundAddrReqDto(orderAddrDto);
        refundReqDto.setSaleRefundOrderItemReqDtoList(itemList);
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("subdivisionplatform", message.get("subdivisionplatform"));
        extFields.put("marketChannel", message.get("marketChannel"));
        extFields.put("remark", message.get("remark"));
        extFields.put("office", message.get("office"));
        extFields.put("province", message.get("province"));
        extFields.put("city", message.get("city"));
        extFields.put("contactPersonName", message.get("contactPersonName"));
        extFields.put("contactPhone", message.get("contactPhone"));
        extFields.put("description", message.get("description"));
        refundReqDto.setExtFields(extFields);
        log.info("\u65b0\u589e\u9500\u552e\u9000\u8d27\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)refundReqDto));
        return this.pcpSaleRefundApi.addSaleRefund(refundReqDto);
    }
}

