/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.IStrategyAutoCheckRuleApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.NextOptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTradeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IStrategyAutoCheckRuleQueryApi;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="DELAY_AUTO_CHECK")
public class SaleOrderAutoCheckProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderAutoCheckProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private IStrategyAutoCheckRuleQueryApi strategyAutoCheckRuleQueryApi;
    @Resource
    private IStrategyAutoCheckRuleApi strategyAutoCheckRuleApi;
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (messageData instanceof SaleTradeMessageVo) {
            try {
                SaleTradeMessageVo tradeMessageVo = (SaleTradeMessageVo)messageData;
                if (Objects.equals(tradeMessageVo.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(tradeMessageVo.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode())) {
                    LOGGER.info("\u9500\u552e\u5355\u62c6\u5355\u6210\u529f\u914d\u8d27\u8282\u70b9:{}", (Object)tradeMessageVo.getOrderNo());
                    this.orderCenterSaleOrderService.autoDisPatch(tradeMessageVo.getOrderId());
                } else {
                    NextOptTypeEnum nextOptTypeEnum;
                    List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{tradeMessageVo.getOrderId()})));
                    if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)saleOrderRespDtos.get(0);
                        if (!SaleOrderStatusEnum.WAIT_CHECK.getCode().equals(saleOrderRespDto.getOrderStatus())) {
                            LOGGER.info("\u5df2\u786e\u8ba4\u72b6\u6001\u8ba2\u5355\u4e0d\u518d\u91cd\u590d\u786e\u8ba4\u64cd\u4f5c:{}", (Object)saleOrderRespDto.getSaleOrderNo());
                            return MessageResponse.SUCCESS;
                        }
                    }
                    if (NextOptTypeEnum.SALE_ORDER_CHECK.equals((Object)(nextOptTypeEnum = NextOptTypeEnum.enumOf((String)tradeMessageVo.getNextOptType())))) {
                        RestResponse restResponse = this.saleOrderOptApi.checkOrder(tradeMessageVo.getOrderId());
                        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                        this.orderCenterSaleOrderService.sendAutoDisPatchMsg(tradeMessageVo.getOrderId());
                    } else if (NextOptTypeEnum.AUTO_CHECK.equals((Object)nextOptTypeEnum)) {
                        RestResponse restResponse = this.strategyAutoCheckRuleApi.checkOrderCanAutoCheck(tradeMessageVo.getOrderNo());
                        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                    }
                }
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

