/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferExtApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferExtUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="INTRANSIT_PREEMPT_LESS")
public class SaleTransferExtUpdateProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleTransferExtUpdateProcessor.class);
    @Resource
    private ISaleTransferExtApi saleTransferExtApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u9884\u5360\u903b\u8f91\u4ed3\u66f4\u65b0\u9500\u552e\u5355\u5728\u9014\u6570={}", message.getData());
        try {
            List maps = JSONArray.parseArray((String)message.getData().toString(), Map.class);
            String sourceNo = ((Map)maps.get(0)).get("sourceNo").toString();
            if (StringUtil.isBlank((CharSequence)sourceNo)) {
                LOGGER.info("\u5355\u53f7\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setSaleOrderNo(sourceNo);
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
                LOGGER.info("\u9500\u552e\u5355\u53f7\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f={}", (Object)sourceNo);
                return MessageResponse.SUCCESS;
            }
            Long orderId = ((SaleOrderRespDto)saleOrderRespDtos.get(0)).getId();
            ArrayList list = Lists.newArrayList();
            for (Map map : maps) {
                SaleTransferExtUpdateReqDto dto = new SaleTransferExtUpdateReqDto();
                dto.setOrderId(orderId);
                dto.setSkuCode(map.get("skuCode").toString());
                dto.setNum(new BigDecimal(map.get("lessNum").toString()));
                list.add(dto);
            }
            this.saleTransferExtApi.updateSaleTransferNum((List)list);
        }
        catch (Exception e) {
            LOGGER.info("\u9884\u5360\u903b\u8f91\u4ed3\u66f4\u65b0\u9500\u552e\u5355\u5728\u9014\u6570\u5f02\u5e38={}", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

