/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IOutNoticeOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderMergeReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="ORDER_MERGE_TAG")
public class OrderMergeToWmsProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(OrderMergeToWmsProcessor.class);
    @Resource
    private IOutNoticeOrderQueryApi outNoticeOrderQueryApi;
    @Resource
    private IExternalWmsApi externalWmsApi;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        ServiceContext.getContext().setAttachment("yes.req.requestId", RequestId.createReqId());
        try {
            this.doExternal(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MessageResponse.SUCCESS;
    }

    public void doExternal(MessageVo message) {
        String data = (String)message.getData();
        Integer orderNum = (Integer)message.getExtValue1();
        String warehouseCode = (String)message.getExtValue2();
        WmsOrderMergeReqDto mergeReqDto = new WmsOrderMergeReqDto();
        mergeReqDto.setMergeOrderNum(Long.valueOf(orderNum.intValue()));
        mergeReqDto.setOrderCode(data);
        mergeReqDto.setWarehouseCode(warehouseCode);
        try {
            RestResponseHelper.checkOrThrow((RestResponse)this.externalWmsApi.orderMerge(mergeReqDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u5355\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        try {
            RestResponseHelper.checkOrThrow((RestResponse)this.externalWmsApi.orderMergeToWms(mergeReqDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5947\u95e8\u5408\u5355\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

