/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICsLogisticsInfoApi;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_OUT_COMPLETE")
public class TransferOutCompleteProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TransferOutCompleteProcessor.class);
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private ICsLogisticsInfoApi csLogisticsInfoApi;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        this.inTransitAdjustAudit(message);
        CsOutResultOrderRespDto csOutResultOrder = this.inventoryTransferHelper.getCsOutResultOrder((String)message.getData());
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(csOutResultOrder.getBusinessType())) {
            CsLogisticsInfoReqDto dataInfo = new CsLogisticsInfoReqDto();
            dataInfo.setType(Integer.valueOf(1));
            dataInfo.setConsignmentNo(csOutResultOrder.getShippingCode());
            dataInfo.setCspNo(csOutResultOrder.getExternalOrderNo());
            dataInfo.setStatus("3");
            dataInfo.setShipTime(new Date());
            dataInfo.setDeliveStartTime(new Date());
            this.csLogisticsInfoApi.addCsLogisticsInfo(dataInfo);
        } else if ("claim_allot".equals(csOutResultOrder.getBusinessType())) {
            // empty if block
        }
        return MessageResponse.SUCCESS;
    }

    private void inTransitAdjustAudit(MessageVo message) {
        log.info("\u5728\u9014\u8c03\u6574\u5355\u81ea\u52a8\u5ba1\u6838\u903b\u8f91:" + message.getData());
        this.doProcess((String)message.getData());
    }

    private void doProcess(String documentNo) {
        AdjustmentInventoryReqDto adjustmentInventoryReqDto = new AdjustmentInventoryReqDto();
        adjustmentInventoryReqDto.setPreOrderNo(documentNo);
        adjustmentInventoryReqDto.setAdjustmentType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode());
        Optional.ofNullable(this.adjustmentInventoryApi.queryByPage(JSONObject.toJSONString((Object)adjustmentInventoryReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData()).filter(page -> CollectionUtils.isNotEmpty((Collection)page.getList())).map(r -> (AdjustmentInventoryRespDto)r.getList().get(0)).ifPresent(adjust -> {
            AdjustmentInventoryAuditRespDto auditRespDto = new AdjustmentInventoryAuditRespDto();
            auditRespDto.setAdjustmentNo(adjust.getAdjustmentNo());
            auditRespDto.setAuditIds((List)Lists.newArrayList((Object[])new Long[]{adjust.getId()}));
            auditRespDto.setAuditStatus("pass");
            auditRespDto.setAuditRemark("\u51fa\u5165\u5e93\u81ea\u52a8\u5ba1\u6838");
            RestResponseHelper.checkOrThrow((RestResponse)this.adjustmentInventoryApi.auditAdjustmentInventory(auditRespDto));
        });
    }
}

