/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.trade;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.dto.request.YyjOrderReqDto;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cis.pms.biz.service.impl.DispatchEasSaleOrderImpl;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="YYJ_ORDER_ADD_PROCESS")
public class AddYyjSaleOrderProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(AddYyjSaleOrderProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private IPcpOrderApi pcpOrderApi;
    @Autowired
    private DispatchEasSaleOrderImpl dispatchEasSaleOrderImpl;
    @Autowired
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Value(value="${yundt.com.default.warehouseCode:true}")
    private Boolean isDefaultShareWarehouseCode;

    public MessageResponse process(String message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u5230\u65b0\u589e\u9500\u552e\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)message));
        try {
            List yyjOrderReqDtos = JSON.parseArray((String)message, YyjOrderReqDto.class);
            this.addYyjPcpOrderProcess(yyjOrderReqDtos);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9500\u552e\u8ba2\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    public void addYyjPcpOrderProcess(List<YyjOrderReqDto> yyjOrderReqDtos) {
        List organizationDtoList;
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        List<String> customerCodes = yyjOrderReqDtos.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getEasCustomerCode())).map(order -> order.getEasCustomerCode()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            customerRespDtoMap = this.checkCustomer(customerCodes);
        }
        Map<Object, Object> orgInfoMap = new HashMap();
        List easOrgIdList = yyjOrderReqDtos.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getEasOrgId())).map(order -> order.getEasOrgId()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(easOrgIdList) && CollectionUtils.isNotEmpty((Collection)(organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByThirdCode(easOrgIdList))))) {
            orgInfoMap = organizationDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList pcpOrderReqDtos = Lists.newArrayList();
        for (YyjOrderReqDto orderReqDto : yyjOrderReqDtos) {
            if (StringUtils.isBlank((CharSequence)orderReqDto.getThirdOrgId())) {
                orderReqDto.setThirdOrgId(orderReqDto.getEasOrgId());
            }
            PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
            BeanUtil.copyProperties((Object)orderReqDto, (Object)pcpOrderReqDto, (String[])new String[0]);
            if (this.isYyjParentOrder(pcpOrderReqDto)) {
                pcpOrderReqDto.setPlatformOrderStatus(PlatformOrderStatusEnum.SUBMIT.getCode());
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(orderReqDto.getEasCustomerCode());
            OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)orgInfoMap.get(orderReqDto.getEasOrgId());
            log.info("\u3010\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3011organizationDto={}", (Object)JSON.toJSONString((Object)orgAdvDetailRespDto));
            if (Objects.nonNull(orgAdvDetailRespDto)) {
                pcpOrderReqDto.setOrganizationId(orgAdvDetailRespDto.getId());
                pcpOrderReqDto.setOrganizationCode(orgAdvDetailRespDto.getCode());
                pcpOrderReqDto.setOrganizationName(orgAdvDetailRespDto.getName());
            }
            pcpOrderReqDto.setCustomerId(customerRespDto.getId());
            pcpOrderReqDto.setThirdOrgID(orderReqDto.getThirdOrgId());
            pcpOrderReqDto.setEasOrgId(orderReqDto.getEasOrgId());
            pcpOrderReqDto.setThirdPartyId(orderReqDto.getCustomerCode());
            pcpOrderReqDto.setCustomerCode(customerRespDto.getCode());
            pcpOrderReqDto.setCustomerName(customerRespDto.getName());
            String msgStr = JSON.toJSONString((Object)orderReqDto);
            PlatformOrderPcpExtendReqDto orderExt = new PlatformOrderPcpExtendReqDto();
            BeanUtil.copyProperties((Object)orderReqDto, (Object)orderExt, (String[])new String[0]);
            orderExt.setCspExtendJson(msgStr);
            PlatformOrderAddrReqDto orderAddrDto = orderReqDto.getPlatformOrderAddrReqDto();
            List itemList = orderReqDto.getItemReqDtoList().stream().map(items -> {
                PlatformOrderItemReqDto dto = new PlatformOrderItemReqDto();
                BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
                dto.setCspItemExtendJson(JSON.toJSONString((Object)items));
                if (Objects.isNull(dto.getPrice())) {
                    dto.setPrice(dto.getSaleUnitPrice());
                }
                return dto;
            }).collect(Collectors.toList());
            pcpOrderReqDto.setPlatformOrderPcpExtendReqDto(orderExt);
            pcpOrderReqDto.setPlatformOrderAddrReqDto(orderAddrDto);
            pcpOrderReqDto.setItemReqDtoList(itemList);
            if (orderReqDto.getChildOrderNum() != null) {
                pcpOrderReqDto.getExtFields().put("childOrderNum", orderReqDto.getChildOrderNum());
            }
            if (this.isDefaultShareWarehouseCode.booleanValue() && StringUtils.isNotBlank((CharSequence)orderReqDto.getEasOrgId()) && StringUtils.equals((CharSequence)"011001", (CharSequence)orderReqDto.getEasOrgId())) {
                pcpOrderReqDto.setStoragePlace("G-ZH-YY008");
            }
            pcpOrderReqDtos.add(pcpOrderReqDto);
        }
        RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.addPcpYyjOrderProcess((List)pcpOrderReqDtos));
    }

    private Map<String, CustomerRespDto> checkCustomer(List<String> thirdPartyId) {
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(thirdPartyId));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230" + thirdPartyId + "\u7684\u5ba2\u6237\u4fe1\u606f"});
        }
        Map<String, CustomerRespDto> customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity()));
        for (String customerCode : thirdPartyId) {
            CustomerRespDto customerRespDto = customerRespDtoMap.get(customerCode);
            log.info("\u3010\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f\u3011customerRespDto={}", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        return customerRespDtoMap;
    }

    private boolean isYyjParentOrder(PcpOrderReqDto pcpOrderReqDto) {
        return StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformParentOrderNo());
    }
}

