/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.QualityInspectionConvertReqDto;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IQualityInspectionDataApi;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.query.IQualityInspectionDataQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOrderReqDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="QUALITY_INSPECTION_DATA_SYNC_EXT", topic="${OP_EXTERNAL_TOPIC:OP_EXTERNAL_TOPIC}")
public class QualityInspectionDataSyncProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(QualityInspectionDataSyncProcess.class);
    @Autowired
    IQualityInspectionDataApi qualityInspectionDataApi;
    @Autowired
    IInspectionReleaseOrderApi inspectionReleaseOrderApi;
    @Autowired
    IQualityInspectionDataQueryApi qualityInspectionDataQueryApi;

    public MessageResponse process(String message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\uff0cmessage\uff1a{}", (Object)message);
        List dtoList = JSON.parseArray((String)message, QualityInspectionConvertReqDto.class);
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f,dtoList\uff1a{}", (Object)JSON.toJSONString((Object)dtoList));
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)dtoList, QualityInspectionDataReqDto.class);
        log.info("\u8d28\u68c0\u62a5\u544a\u6279\u91cf\u62a5\u5b58\u5165\u53c2,list\uff1a{}", (Object)JSON.toJSONString((Object)list));
        try {
            RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataApi.batchSave((List)list));
        }
        catch (Exception e) {
            log.error("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            return MessageResponse.ERROR;
        }
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684LIMS\u8d28\u68c0\u4fe1\u606f\u5b8c\u6bd5");
        try {
            ArrayList queryDtoList = Lists.newArrayList();
            for (QualityInspectionDataReqDto qualityInspectionDataReqDto : list) {
                QualityInspectionDataReqDto queryDto = new QualityInspectionDataReqDto();
                queryDto.setLongCode(qualityInspectionDataReqDto.getLongCode());
                queryDto.setBatch(qualityInspectionDataReqDto.getBatch());
                queryDtoList.add(queryDto);
            }
            List qualityInspectionDataRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataQueryApi.queryByList((List)queryDtoList));
            ArrayList inspectionReleaseOrderReqDtoList = Lists.newArrayList();
            for (QualityInspectionDataRespDto qualityInspectionDataRespDto : qualityInspectionDataRespDtoList) {
                InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = new InspectionReleaseOrderReqDto();
                inspectionReleaseOrderReqDto.setSkuCode(qualityInspectionDataRespDto.getLongCode());
                inspectionReleaseOrderReqDto.setBatch(qualityInspectionDataRespDto.getBatch());
                inspectionReleaseOrderReqDto.setReportResult(qualityInspectionDataRespDto.getReportResult());
                inspectionReleaseOrderReqDto.setQualityInspectionNo(qualityInspectionDataRespDto.getExternalId());
                inspectionReleaseOrderReqDto.setQualityInspectionDate((Date)DateUtil.parse((CharSequence)qualityInspectionDataRespDto.getReportTime()));
                inspectionReleaseOrderReqDtoList.add(inspectionReleaseOrderReqDto);
            }
            RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderApi.receiveInspectionReport((List)inspectionReleaseOrderReqDtoList));
        }
        catch (Exception e) {
            log.error("\u8d28\u68c0\u62a5\u544a\u89e6\u53d1\u653e\u884c\u5355\u653e\u884c\u5931\u8d25\u5931\u8d25\uff1a", (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

