/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.csp;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalCspApi;
import com.dtyunxi.tcbj.center.openapi.common.csp.constant.CspClaimOrderStatusEnum;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPCargoLossAllotOrderApprovalReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspClaimOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="UPDATE_CSP_CLAIM_ORDER_STATUS")
public class UpdateCspClaimOrderStatusProcessor
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCspClaimOrderStatusProcessor.class);
    @Resource
    private IExternalCspApi externalCspApi;

    public MessageResponse process(String messageVo) {
        logger.info("\u76d1\u542c\u66f4\u65b0csp\u7d22\u8d54\u8ba2\u5355\u72b6\u6001MQ");
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u66f4\u65b0csp\u7d22\u8d54\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)messageVo);
        MessageVo vo = (MessageVo)JSON.parseObject((String)messageVo, MessageVo.class);
        CSPUpdateCspClaimOrderReqDto cspUpdateCspClaimOrderReqDto = (CSPUpdateCspClaimOrderReqDto)JSON.parseObject((String)vo.getData().toString(), CSPUpdateCspClaimOrderReqDto.class);
        try {
            if (StringUtils.equals((CharSequence)SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), (CharSequence)cspUpdateCspClaimOrderReqDto.getOrderType()) || StringUtils.equals((CharSequence)SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), (CharSequence)cspUpdateCspClaimOrderReqDto.getOrderType())) {
                RestResponseHelper.extractData((RestResponse)this.externalCspApi.updateCspClaimOrderStatus(cspUpdateCspClaimOrderReqDto));
            }
        }
        catch (Exception exception) {
            logger.error("\u66f4\u65b0csp\u7d22\u8d54\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
            logger.error(exception.getMessage(), (Throwable)exception);
        }
        try {
            CSPCargoLossAllotOrderApprovalReqDto cspCargoLossAllotOrderApprovalReqDto = new CSPCargoLossAllotOrderApprovalReqDto();
            cspCargoLossAllotOrderApprovalReqDto.setOrderNo(cspUpdateCspClaimOrderReqDto.getOaSheetNo());
            cspCargoLossAllotOrderApprovalReqDto.setApprover(cspUpdateCspClaimOrderReqDto.getApprover());
            cspCargoLossAllotOrderApprovalReqDto.setRemark(cspUpdateCspClaimOrderReqDto.getApprovalRemark());
            cspCargoLossAllotOrderApprovalReqDto.setSapOrderNo(cspUpdateCspClaimOrderReqDto.getSapOrderNo());
            if (StringUtils.equals((CharSequence)CspClaimOrderStatusEnum.WAREHOUSE_APPROVE.getType(), (CharSequence)cspUpdateCspClaimOrderReqDto.getStatus())) {
                cspCargoLossAllotOrderApprovalReqDto.setEvent("warehouseApprovedPass");
            } else if (StringUtils.equals((CharSequence)CspClaimOrderStatusEnum.DENIED.getType(), (CharSequence)cspUpdateCspClaimOrderReqDto.getStatus())) {
                cspCargoLossAllotOrderApprovalReqDto.setEvent("warehouseApprovedNoPass");
            } else if (StringUtils.equals((CharSequence)CspClaimOrderStatusEnum.WAIT_BUSINESS_REVIEW.getType(), (CharSequence)cspUpdateCspClaimOrderReqDto.getStatus())) {
                cspCargoLossAllotOrderApprovalReqDto.setEvent("orderUnApprove");
            }
            if (Objects.equals(SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType(), cspUpdateCspClaimOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType(), cspUpdateCspClaimOrderReqDto.getOrderType())) {
                RestResponseHelper.extractData((RestResponse)this.externalCspApi.cargoLossAllotOrderApproval(cspCargoLossAllotOrderApprovalReqDto));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("\u66f4\u65b0csp\u7d22\u8d54\u8ba2\u5355\u72b6\u6001\u5f02\u5e38:{}", (Object)exception.getMessage(), (Object)exception);
        }
        return MessageResponse.SUCCESS;
    }
}

