/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="REFUND_CANCEL")
public class RefundCancelProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(RefundCancelProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private ICsWmsApi wmsApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        String msgStr = JSON.toJSONString(message);
        log.info("\u63a5\u6536\u5230\u5e93\u5b58\u5355\u636e\u9000\u8d27\u53d6\u6d88\uff1a{}", (Object)msgStr);
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse<String> response = this.generatePlannedOrderExposed(message);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5355\u636e\u9000\u8d27\u53d6\u6d88\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<String> generatePlannedOrderExposed(Map<String, Object> message) {
        CsPlannedCancelReqDto plannedCancel = (CsPlannedCancelReqDto)BeanUtil.copyProperties(message, CsPlannedCancelReqDto.class, (String[])new String[0]);
        return this.wmsApi.retreatExposedCancel(plannedCancel);
    }
}

