/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_SALE_EXTERNAL_TOPIC", tag="SALE_ORDER_CARRY_TO_TAG")
public class SaleOrderCarryToProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderCarryToProcessor.class);
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ICacheService cacheService;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo messageVo) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u9500\u552e\u5355\u8d22\u52a1\u4e2d\u53f0\u8fc7\u8d26\u6d88\u606f\u76d1\u542c\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        SaleOrderReqDto saleOrderReqDto = (SaleOrderReqDto)JSON.parseObject((String)messageVo.getData().toString(), SaleOrderReqDto.class);
        try {
            this.externalPointService.updateSaleOrderSignToEas(saleOrderReqDto);
        }
        catch (Exception e) {
            logger.error("\u8fc7\u8d26\u5b8c\u6210\uff0c\u901a\u77e5EAS\u8fdb\u884c\u7b7e\u6536\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

