/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.customer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="SAVE_SUPPLIER_TAG")
public class SaveCustomerToWmsProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(SaveCustomerToWmsProcessor.class);
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    public MessageResponse process(MessageVo messageVo) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u4fe1\u606f\u540c\u6b65\u5947\u95e8\uff1a{}", messageVo.getData());
        try {
            WmsCustomerReqDto wmsCustomerReqDto = (WmsCustomerReqDto)JSONObject.parseObject((String)messageVo.getData().toString(), WmsCustomerReqDto.class);
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByCode(wmsCustomerReqDto.getCode()));
            if (Objects.isNull(customerRespDto)) {
                log.info("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
                return MessageResponse.SUCCESS;
            }
            WmsCustomerReqDto wmsCustomerReqDtoNew = new WmsCustomerReqDto();
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDtoNew, (Object)customerRespDto, (String[])new String[0]);
            DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "PUSH_CUSTOMER_DATA", "PUSH_CUSTOMER_DATA_TO_QM").getData();
            Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
            map.keySet().forEach(n -> {
                wmsCustomerReqDtoNew.setWarehouseCode(n);
                wmsCustomerReqDtoNew.setCustomerId(String.valueOf(map.get(n)));
                try {
                    RestResponseHelper.extractData((RestResponse)this.externalWmsApi.supplierSynchronize(wmsCustomerReqDtoNew));
                }
                catch (Exception e) {
                    log.info("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u5931\u8d25", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("\u63a5\u6536\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u5931\u8d25", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

