/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalCspApi;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="UPDATE_CSP_ORDER_STATUS")
public class UpdateCspOrderStatusProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(UpdateCspOrderStatusProcessor.class);
    @Resource
    private IExternalCspApi externalCspApi;
    @Resource
    private ICacheService cacheService;
    ThreadLocal<String> msg = new ThreadLocal();

    public boolean isDuplicationMessage(String msgId, MessageVo messageVo) {
        this.msg.set(msgId);
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo messageVo) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("\u63a5\u6536\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001MQ\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        try {
            if (messageVo == null || messageVo.getData() == null) {
                log.warn("\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001MQ\u6d88\u606f\u5931\u8d25\uff0cmessageVo\u6216data\u4e3a\u7a7a");
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            CSPUpdateCspOrderReqDto reqDto = messageVo.getData() instanceof String ? (CSPUpdateCspOrderReqDto)JSON.parseObject((String)((String)messageVo.getData()), CSPUpdateCspOrderReqDto.class) : (CSPUpdateCspOrderReqDto)JSON.parseObject((String)JSON.toJSONString((Object)messageVo.getData()), CSPUpdateCspOrderReqDto.class);
            if (reqDto == null) {
                log.warn("\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001MQ\u6d88\u606f\u89e3\u6790\u5931\u8d25\uff0creqDto\u4e3a\u7a7a");
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            log.info("\u5904\u7406\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            this.externalCspApi.updateCspOrderStatus(reqDto);
            log.info("\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            this.cacheService.delCache(this.msg.get());
            log.error("\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001\u5904\u7406\u5f02\u5e38", (Throwable)e);
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.msg.remove();
        }
        return MessageResponse.SUCCESS;
    }
}

