/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferExtApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferExtAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferExtReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryPreemptionDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_ORDER_PREEMPT_SUCCESS")
public class TransferOrderPreemptSuccessProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderPreemptSuccessProcessor.class);
    @Autowired
    ICsTransferOrderApi csTransferOrderApi;
    @Autowired
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Autowired
    ISaleOrderQueryApi saleOrderQueryApi;
    @Autowired
    ISaleOrderOptApi saleOrderOptApi;
    @Autowired
    ISaleTransferExtApi saleTransferExtApi;

    public MessageResponse process(MessageVo message) {
        log.info("TRANSFER_ORDER_PREEMPT_SUCCESS:" + message.getData());
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        try {
            this.doProcess((String)message.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("TransferOrderPreemptSuccessProcessor \u5904\u7406\u5931\u8d25:{}", (Object)e.getMessage());
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private void doProcess(String jsonData) {
        List inventoryPreemptionDtoList = JSONArray.parseArray((String)jsonData, InventoryPreemptionDto.class);
        String transferOrderNo = ((InventoryPreemptionDto)inventoryPreemptionDtoList.get(0)).getSourceNo();
        CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(transferOrderNo));
        if (null == transferOrderRespDto) {
            return;
        }
        if (!CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(transferOrderRespDto.getType())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)transferOrderRespDto.getSaleOrderNo())) {
            return;
        }
        BizSaleOrderRespDto bizSaleOrderRespDto = null;
        try {
            bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(transferOrderRespDto.getSaleOrderNo()));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25:{}", (Object)e.getMessage());
        }
        if (null == bizSaleOrderRespDto) {
            return;
        }
        List lendInventoryPreemptionDtoList = inventoryPreemptionDtoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getLendWarehouseCode()) && BigDecimalUtils.gtZero((BigDecimal)o.getLessNum()) != false).collect(Collectors.toList());
        List warehouseCodes = lendInventoryPreemptionDtoList.stream().map(InventoryPreemptionDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List lendSkuCodes = lendInventoryPreemptionDtoList.stream().map(InventoryPreemptionDto::getSkuCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(warehouseCodes)) {
            return;
        }
        if (CollectionUtils.isEmpty(lendSkuCodes)) {
            return;
        }
        IntransitCargoQueryDto intransitCargoQueryDto = new IntransitCargoQueryDto();
        intransitCargoQueryDto.setLogicWarehouseCodes(warehouseCodes);
        intransitCargoQueryDto.setCargoCodes(lendSkuCodes);
        List intransitCargoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApi.queryIntransitCargoNum(intransitCargoQueryDto));
        if (CollectionUtils.isEmpty((Collection)intransitCargoRespDtos)) {
            return;
        }
        SaleTransferExtAddReqDto addReqDto = new SaleTransferExtAddReqDto();
        addReqDto.setOrderId(bizSaleOrderRespDto.getId());
        ArrayList addList = Lists.newArrayList();
        for (IntransitCargoRespDto intransitCargoRespDto : intransitCargoRespDtos) {
            SaleTransferExtReqDto saleTransferExtReqDto = new SaleTransferExtReqDto();
            saleTransferExtReqDto.setOrderId(bizSaleOrderRespDto.getId());
            saleTransferExtReqDto.setTransferOrderNo(intransitCargoRespDto.getTransferOrderNo());
            saleTransferExtReqDto.setSkuCode(intransitCargoRespDto.getCargoCode());
            saleTransferExtReqDto.setNum(intransitCargoRespDto.getNum());
            addList.add(saleTransferExtReqDto);
        }
        addReqDto.setAddList((List)addList);
        RestResponseHelper.extractData((RestResponse)this.saleTransferExtApi.batchSave(addReqDto));
        try {
            this.saleOrderOptApi.doPcpStatusLock(bizSaleOrderRespDto.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8ba2\u5355\u9501\u5b9a\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }
}

