/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.constant;

import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constant {
    private static final Logger logger = LoggerFactory.getLogger(Constant.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String INIT_DATE = "1970-1-1";
    public static final String STATUS_YES = "2";
    public static final String NEW_MEMBER_YES = "\u662f";
    public static final String NEW_MEMBER_NO = "\u5426";
    public static final String MAX = "99999999999";
    public static final String MIN = "0";
    private static final String INDICES_NAME_FORMATE = "%s_%s";
    public static final String END_FORMAT = " 23:59:59";

    public static String getWildCardString(String str) {
        if (str != null) {
            return "*".concat(str).concat("*");
        }
        return null;
    }

    public static SearchResultVo searchESData(String tableName, OSSearchVo osSearchVo, IOpenSearchService openSearchService, String indicesPrefix) {
        String indexName = String.format(INDICES_NAME_FORMATE, indicesPrefix, tableName);
        try {
            osSearchVo.setIndexName(indexName);
            osSearchVo.setTypeName(tableName);
            return openSearchService.search(osSearchVo);
        }
        catch (Exception e) {
            logger.error(tableName.concat("\u5217\u8868\u641c\u7d22\u5f02\u5e38\uff1a"), (Throwable)e);
            return null;
        }
    }
}

